/* # skkinput (Simple Kana-Kanji Input)
 * cstyle.c --- common routines with root/over-the-spot/off-the-spot.
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include "commondef.h"
#include "resrcs.h"
#include "buffers.h"
#include "skkbuf.h"
#include "config.h"
#include "skkkey.h"
#include "skkel.h"
#include "MyError.h"

/* 
 * ץȥ
 */
static int do_function_by_reading_character
( Widget gw, struct skkinputBuffer *buffer,
  struct SKKInputNode *node ) ;
static int skkinput_do_function
( Widget gw, struct skkinputBuffer *buffer, struct SKKInputNode *node,
  int textflag, int *ret_func_no ) ;
static int do_skkinputFunction_withtext
( Widget gw, struct skkinputBuffer *buffer,
  struct SKKInputNode *node, int func_no ) ;
static int do_skkinputFunction_withouttext
( Widget gw, struct skkinputBuffer *buffer, 
  struct SKKInputNode *node, int func_no ) ;

/* keymap.c */
extern int lookup_at_keymap
( struct keyBuffer *keybuf, struct SKKInputNode *node ) ;
extern void skkinput_initKeyBuffer
( struct keyBuffer *keybuf ) ;
extern void skkinput_closeKeyBuffer
( struct keyBuffer *keybuf ) ;
extern void skkinput_addKeyBuffer
( struct keyBuffer *keybuf, int chara ) ;

enum {
  SIW_DESTROYED = -1, SIW_PROCESSING = 0,
} ;

/*
 * Хѿ
 */
extern Boolean skkinput_autosave_key_dirty ;

/*
 * skkinput ΥХåեνԤؿ
 */
void skkinput_bufferInit( struct skkinputBuffer *buffer )
{
  struct SKKInputNode *node ;

  /* cutbuffer ν򤹤롣*/
  MYCHAR_SET_END_OF_STRING( buffer->cutbuffer[ 0 ] ) ;
  /* ϤξƤ*/
  skkinput_initKeyBuffer( &buffer->keybuf ) ;
  /* ԽѤΥХåեγݡ*/
  node = skkinput_AllocateMinibuffer() ;
  node->cur_exist = True ;
  buffer->topbuffer = buffer->lastbuffer = node ;
  /* ҥȥν򤹤롣*/
  buffer->hist_start = buffer->hist_end = 0 ;
  buffer->hist_cur = -1 ;
  buffer->historybuffer = buffer->histcurbackbuffer = NULL ;
  /* 괺̵Ƥ*/

  /* buffer->toggleShiftMode   = False ;
   * buffer->toggleControlMode = False ; */
  buffer->currentShiftStatus   = False ;
  buffer->currentControlStatus = False ;

  buffer->redraw = NULL ;
  return ;
}

#ifndef XK_Page_Up
#define XK_Page_Up XK_Prior
#endif
#ifndef XK_Page_Down
#define XK_Page_Down	XK_Next
#endif

/*
 * XKeyEvent Ϥ줿ʸȽǤؿ
 *----
 * Ū XLookupString η̤ѤƤĤȤäƤ¤
 * Ǥդ KeySym ФƵǽƤ뤳ȤϺʤΤĻ
 * ʤʡ
 */
static int skkinputLookupString
( struct skkinputBuffer *buffer )
{
  static KeySym misckeys[] = {
    XK_Home,	XK_Left,	XK_Up,		XK_Right,
    XK_Down,	XK_Page_Up,	XK_Page_Down,	XK_End,
    XK_Begin,	XK_Insert,	XK_Clear,	XK_Help,
    XK_Break,	XK_Henkan_Mode,			XK_Muhenkan,
    XK_F1,	XK_F2,		XK_F3,		XK_F4,
    XK_F5,	XK_F6,		XK_F7,		XK_F8,
    XK_F9,	XK_F10,		XK_F11,		XK_F12,
    XK_VoidSymbol,
  } ;
  XKeyEvent *xkev = &( buffer->xevent.xkey ) ;
  int shiftStatus, controlStatus, chara, i ;
  char inpstr[ STRBUFSIZE ] ;
  KeySym key, *kptr ;

  shiftStatus   = buffer->currentShiftStatus ;
  controlStatus = buffer->currentControlStatus ;
  buffer->currentShiftStatus = buffer->currentControlStatus = False ;

  if( buffer->toggleShiftMode   && shiftStatus )
    xkev->state |= ShiftMask ;
  if( buffer->toggleControlMode && controlStatus )
    xkev->state |= ControlMask ;

  /* ʸХåեν*/
  inpstr[ 0 ] = '\0' ;
  /* ʸ*/
  XLookupString( xkev, inpstr, STRBUFSIZE, &key, NULL ) ;
  if( ( chara = inpstr[ 0 ] ) == '\0' ){
    switch( key ){
    case XK_space :
      if( xkev->state & ControlMask )
	chara = CHARA_CONTROL_SPACE ;
      break ;
    case XK_Shift_L :
    case XK_Shift_R :
      buffer->currentShiftStatus = ( shiftStatus )? False : True ;
      break ;
    case XK_Control_L :
    case XK_Control_R :
      buffer->currentControlStatus = ( controlStatus )? False : True ;
      break ;
    default :
      i    = 0 ;
      kptr = misckeys ;
      while( *kptr != XK_VoidSymbol ){
	if( key == *kptr ){
	  chara = CHARA_HOME + ( i << 1 ) + 
	    ( ( xkev->state & ControlMask )? 1 : 0 ) ;
	  break ;
	}
	kptr ++ ;
	i ++ ;
      }
      break ;
    }
  } else {
    if( chara == 0x20 && ( xkev->state & ShiftMask ) &&
	!( xkev->state & ( ~ShiftMask ) ) ){
      chara = CHARA_SHIFT_SPACE ;
    }
  }
  return chara ;
}

/*
 * ̤Υ٥Ƚؿ
 *----
 * ٥ȤνˡˤĤƤϡRoot/OverTheSpot/OffTheSpot Τ
 * Ʊ褦˽ǽǤ롣
 */
int commonKeyEventHandler
( Widget gw, XEvent *xevent, struct skkinputBuffer *buffer )
{
  struct SKKInputNode *node, *topbuffer ;
  int chara ;

  /* ٥Ȥ褿ΤǼư֤Ϥδ֤κǸ˼¹Ԥ뤳Ȥ
   * ̵Ȥ롣*/
  skkinput_autosave_key_dirty = True ;

  /* 줿ΤǤʤȴ롣*/
  if( xevent->type != KeyPress )
    return False ;

  /* ٥Ȥ򵭲Ƥ*/
  buffer->xevent = *xevent ;

  /* ߥ˥Хåե¸ߤƤΤʤСΰֺǸΤΤ򤹤롣*/
  topbuffer = buffer->topbuffer ;
  node      = buffer->lastbuffer ;
  if( !node->cur_exist )
    node = topbuffer ;

  if( ( chara = skkinputLookupString( buffer ) ) != '\0' ){
    if( chara == CHARA_SHIFT_SPACE ){
      XtDestroyWidget( gw ) ;
      return False ;
    } else if( chara == CHARA_CONTROL_SPACE ){
      chara = 0 ;
    }
    skkinput_addKeyBuffer( &buffer->keybuf, chara ) ;
    /* ߥ˥Хåե¸ߤѤƤν*/
    switch( do_function_by_reading_character( gw, buffer, node ) ){
    case SIW_DESTROYED :
      XtDestroyWidget( gw ) ;
      return False ;
    case SIW_PROCESSING :
      break ;
    default :
      break ;
    }
  } else {
    /* skkinput ǤǧǤʤ̣뤫⤷ʤ
     * ֤ɬפ롣*/ 
    if( IS_END_OF_STRING( topbuffer->textbuffer[ 0 ] ) &&
	topbuffer->minibuffer == NULL && 
	buffer->overthespot_like_input )
      j_sendback_keypress( gw, &( buffer->xevent ) ) ;
  }
  return True;
}

/*
 * Ϥ줿ʸ󤫤餽б뵡ǽ¹Ԥؿ
 */
static int do_function_by_reading_character
( Widget gw, struct skkinputBuffer *buffer, struct SKKInputNode *node )
{
  struct SKKInputNode *topbuffer ;
  struct keyBuffer    *keybuf ;
  int textflag, rest_pos, func_no, keycode, prev_kmode, ret ;

  topbuffer = buffer->topbuffer ;
  keybuf    = &( buffer->keybuf ) ;
  ret       = SIW_PROCESSING ;

  /* ʸäƤʤǤưȦʤ*/
  if( keybuf->usage <= 0 )
    return ret ;
  /* ˥ɥƤ뤫ɤȽǤ롣Ѵưʤ顢 *
   * Ǥư skkinput ôʤФʤʤʳ *
   * ۤȤɤΥ֤ȤˤʤΤǡ*/
  prev_kmode = topbuffer->j_kana_mode ;
  if( !IS_END_OF_STRING( topbuffer->textbuffer[ 0 ] ) ||
      topbuffer->minibuffer != NULL ||
      !buffer->overthespot_like_input ){
      textflag = True ;
  } else {
    textflag = False ;
  }
  keycode = keybuf->buffer[ keybuf->usage - 1 ] ;

  ret = skkinput_do_function( gw, buffer, node, textflag, &func_no ) ;

  /* Ϥ줿ʸѴ饤Ȥؤ٤ɤȽǤ롣*
   * over-the-spot like Ƥʤ³Ϥ *
   * פˤʤ롣 */
  if( !topbuffer->cur_exist ||
      topbuffer->minibuffer != NULL ||
      !IS_END_OF_STRING( topbuffer->mtextbuffer[ 0 ] ) ||
      !buffer->overthespot_like_input ||
      buffer->xevent.xany.window == None )
    return ret ;
  /*  topbuffer ˤʤäƤȤơ̾⡼ɤϤɤʤäƤ * 
   *  */
  if( IS_END_OF_STRING( topbuffer->textbuffer[ 0 ] ) ){
    if( topbuffer->j_kana_mode ||
	!prev_kmode || 
	func_no <= FUNCNO_J_SET_MARK_COMMAND ||
	func_no == FUNCNO_J_KEYBOARD_QUIT ||
	func_no == FUNCNO_J_DELETE_BACKWARD_CHAR )
      return ret ;
    /* äƤߤ롣*/
    j_sendback_keypress( gw, &( buffer->xevent ) ) ;
    buffer->xevent.xany.window = None ;
    return ret ;
  } else if( func_no == FUNCNO_SELF_INSERT_CHARACTER && !textflag &&
	     IS_ASCII_EQUAL( topbuffer->textbuffer[ 0 ], keycode ) ){
    /* XLookup String ̤ʸäƤʸƱġ*
     * äƤߤ롣*/
    j_sendback_keypress( gw, &( buffer->xevent ) ) ;
    j_delete_region( topbuffer, 0, 1 ) ;
    return ret ;
  }
  /* ̾⡼ɤǤäꡢѴǤäꤷˤϡΥƥ
     ƤƤޤ櫓ˤϤʤƬ鲿ޤ
     Ƥ褤ϡ줾ΥȰ֤Ƥ롣*/
  if( topbuffer->j_kana_mode ||
      topbuffer->j_henkan_mode ||
      topbuffer->j_henkan_on ||
      topbuffer->j_okurigana_mode ){
    rest_pos = topbuffer->cur_pos ;
    /* ̾⡼ɤǤä顢̾ϰ֤롣*/
    if( topbuffer->j_kana_mode &&
	topbuffer->j_kana_start_point < rest_pos )
      rest_pos = topbuffer->j_kana_start_point ;
    /* ѴʤѴϰ֤Ѵλ֤롣*/
    if( topbuffer->j_henkan_mode ||
	topbuffer->j_henkan_on ){
      int tmp_rest_pos = rest_pos + 1 ;
      if( topbuffer->j_henkan_start_point < tmp_rest_pos &&
	  topbuffer->j_henkan_start_point >= 0 )
	tmp_rest_pos = topbuffer->j_henkan_start_point ;
      if( topbuffer->j_henkan_end_point < tmp_rest_pos && 
	  topbuffer->j_henkan_end_point >= 0 )
	tmp_rest_pos = topbuffer->j_henkan_end_point ;
      rest_pos = tmp_rest_pos - 1 ;
    }
    /* 겾̾⡼ɤʤ겾̾ϰ֤롣*/
    if( topbuffer->j_okurigana_mode &&
	topbuffer->j_okurigana_start_point < rest_pos )
      rest_pos = topbuffer->j_okurigana_start_point ;
  } else {
    /* ǤʤƤоݤˤʤ롣*/
    rest_pos = myCharStrlen( topbuffer->textbuffer ) ;
  }
#ifdef DEBUG
  /* ǥХåΤˤ줾Υޡΰ֤λ֤ɽ롣*/
  fprintf
    ( stderr, "Send: cur_pos(%d), kana(%d), henkan(%d)-(%d), okuri(%d), rest_pos(%d)\n",
      node->cur_pos, topbuffer->j_kana_start_point, 
      topbuffer->j_henkan_start_point, topbuffer->j_henkan_end_point,
      topbuffer->j_okurigana_start_point, rest_pos ) ;
#endif
  /* ٤ʸ󤬲¸ߤʤäʲνפˤʤ롣*/
  if( rest_pos <= 0 )
    return ret ;
  /* ʸ롣*/
  myCharStrncpy( topbuffer->mtextbuffer, topbuffer->textbuffer, rest_pos ) ;
  MYCHAR_SET_END_OF_STRING( topbuffer->mtextbuffer[ rest_pos ] ) ;
#ifdef DEBUG
  fprintf( stderr, "(j-delete-region 0 %d)\n", rest_pos ) ;
  fprintf( stderr, "(text)\"" ) ;
  myCharFputstring( stderr, topbuffer->textbuffer ) ;
  fprintf( stderr, "\"\n" ) ;
#endif
  j_delete_region( topbuffer, 0, rest_pos ) ;
#ifdef DEBUG
  fprintf( stderr, "After (j-delete-region 0 %d)\n", rest_pos ) ;
  fprintf( stderr, "(text)\"" ) ;
  myCharFputstring( stderr, topbuffer->textbuffer ) ;
  fprintf( stderr, "\"\n" ) ;
#endif
  /* Ѵ饤ȤظϤƤʸ롣*/
  XtCallCallbacks
    ( gw, XtNfixNotify, ( XtPointer )topbuffer->mtextbuffer ) ;
  MYCHAR_SET_END_OF_STRING( topbuffer->mtextbuffer[ 0 ] ) ;

  /* Ϥˤäơ̾⡼ɤꤷƤޤäƤΤʤġ*/
  if( !prev_kmode || !IS_END_OF_STRING( topbuffer->textbuffer[ 0 ] ) ||
      topbuffer->j_kana_mode || topbuffer->j_henkan_mode )
    return ret ;
  /* Ϸ j-insert ۤۤξˤϡ¹Ԥʤ*/
  if( func_no <= FUNCNO_J_SET_MARK_COMMAND ||
      func_no == FUNCNO_J_KEYBOARD_QUIT ||
      func_no == FUNCNO_J_DELETE_BACKWARD_CHAR )
    return ret ;
  /* äƤߤ롣*/
  j_sendback_keypress( gw, &( buffer->xevent ) ) ;
  buffer->xevent.xany.window = None ;
  return ret ;
}

/*
 * ĤξνԤؿ
 */
static int skkinput_do_function
( Widget gw,
  struct skkinputBuffer *buffer, struct SKKInputNode *node,
  int textflag, int *ret_func_no )
{
  struct keyBuffer *keybuf ;
  int func_no ;

  keybuf  = &buffer->keybuf ;
  func_no = FUNCNO_NOFUNCTION ;

  /* Ѵθ⡼ɤʤΤǤ */
  if( node->j_henkan_show_candidate_mode ){
    /* ɤʥäϤͤȤäɡĤޤΥ⡼*
     * ɤФäƤ뤫פʡ */
    do_Function_jhenkanShowCandidateMode( gw, buffer, node ) ;
    goto do_function_by_onekey_exit ;
  } else if( node->j_input_by_code_or_menu_mode ){
    if( node->j_input_by_code_or_menu_mode == True ){
      do_function_j_input_by_code_or_menu_jump( gw, buffer, node ) ;
    } else {
      do_function_j_input_by_code_or_menu_1_jump( gw, buffer, node ) ;
    }
    goto do_function_by_onekey_exit ;
  }
  /* Ϥ줿ǽʸ򸫤ơĵǽʤǤäФ*/
  func_no = lookup_at_keymap( keybuf, node ) ;
  /* 
   * ¿ʬʳ skk-rom-kana-rule-list åʤȤ
   * ǤʤХȥ륳ɤǤ⤽줬ȤȤȤ
   * Ϥʤʤ顣
   */
  switch( func_no ){
  case FUNCNO_J_INSERT_A :
  case FUNCNO_J_INSERT_E :
  case FUNCNO_J_INSERT_I :
  case FUNCNO_J_INSERT_O :
  case FUNCNO_J_INSERT_U :
  case FUNCNO_J_KANA_INPUT :
  case FUNCNO_J_SET_HENKAN_POINT :
    break ;
  default :
    /* ̾Ϥäꤷˤϡ⤷   *
     * rom-kana-rule-list ˥ҥåȤꤹ뤫⤷ʤ*/
    if( node->j_kana_mode ){
      if( rom_kana_rule_list_check
	  ( node, keybuf->buffer[ keybuf->usage - 1 ] ) ){
	if( node->j_henkan_mode && !node->j_henkan_on &&
	    node->j_okurigana_mode )
	  j_set_okurigana
	    ( gw, buffer, node, node->j_okuri_chara ) ;
	/* ξ㤨Ȥ j-newline Ǥ¹ԤʤΤ̵롣*/
	func_no = FUNCNO_NOFUNCTION ;
	goto do_function_by_onekey_exit ;
      }
    }
    /*  oh Υå롣*/
    j_oh_check_with_controlcode
      ( node, ( ( func_no == FUNCNO_J_KEYBOARD_QUIT )? True : False ) ) ;
    break ;
  }
  *ret_func_no = func_no ;
  /* Ϳ줿ǽ¹פޤ*/
  if( textflag ){
    return do_skkinputFunction_withtext( gw, buffer, node, func_no ) ;
  } else {
    return do_skkinputFunction_withouttext( gw, buffer, node, func_no ) ;
  }
do_function_by_onekey_exit:
  *ret_func_no = func_no ;
  skkinput_closeKeyBuffer( keybuf ) ;
  return SIW_PROCESSING ;
}

/*
 * ơ֥򻲾Ȥ̤Υե󥯥ֹ˽äƽ¹Ԥ
 * ٤¾δؿƽФԤؿ
 *-----
 * skkinput ʸԽɬפ뤿ᡢĤΥȥ
 *  skkinput å褦ˤʤäƤ롣⤷Root ⡼ɤʤ顢ˤ
 * ⡼ɤˤʤ롣OverTheSpot ⡼ɤξˤϡΥ⡼ɤΤ
 * ưǤ롣
 */
static int do_skkinputFunction_withtext
( Widget gw, struct skkinputBuffer *buffer,
  struct SKKInputNode *node, int func_no )
{
  struct keyBuffer *keybuf ;
  int chara ;

  keybuf = &buffer->keybuf ;
  chara  = keybuf->buffer[ keybuf->usage - 1 ] ;

  /* ȡΥåХåե˽񤫤Ƥ *
   * Ͼä뤳ȤˤʤäƤ롩 */
  MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;

  /* 䴰ײλ뤫ɤ*/
  if( node->j_completion_mode ){
    if( func_no != FUNCNO_J_INSERT_PERIOD &&
	func_no != FUNCNO_J_INSERT_COMMA  &&
	func_no != FUNCNO_J_ABBREV_PERIOD &&
	func_no != FUNCNO_J_ABBREV_COMMA  &&
	func_no != FUNCNO_J_TRY_COMPLETION ){
      j_completion_close( node ) ;
    }
  }
  /* Ϳ줿̿ФԤ*/
  switch( func_no ){
  case FUNCNO_J_SENDBACK_KEY :
    j_sendback_keypress( gw, &( buffer->xevent ) ) ;
    buffer->xevent.xany.window = None ;
    break ;
  case FUNCNO_J_SENDBACK_NEXT_KEY :
    j_delete_kanaprefix( node ) ;
    return SIW_PROCESSING ;
  case FUNCNO_J_PREFIX_CHAR :
    j_delete_kanaprefix( node ) ;
    /* ֢ΥХåեʤСC- Ȥɽ롣*/
    if( node == buffer->topbuffer ){
      myCharCharStrcpy( node->mtextbuffer, charaToString( chara ) ) ;
      myCharCharStrcat( node->mtextbuffer, "-" ) ;
    }
    return SIW_PROCESSING ;
  case FUNCNO_SELF_INSERT_CHARACTER :
    j_insert_chara( node, node->cur_pos, chara ) ;
    break ;
  case FUNCNO_J_SELF_INSERT :
    j_self_insert
      ( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_SELF_ZENKAKU_INSERT :
    j_insert_zenkaku( node, node->cur_pos, chara ) ;
    break ;
  case FUNCNO_J_DISPLAY_CODE_FOR_CHAR_AT_POINT :
    j_display_code_for_char_at_point( node ) ;
    break ;
  case FUNCNO_J_SET_HENKAN_POINT :
    /* Ѵϰ֤ꤵ롣*/
    j_set_henkan_point( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_SET_HENKAN_POINT_SUBR :
    j_set_henkan_point_subr( gw, buffer, node, chara ) ;
    break ;
    /* 첻ϡ*/
  case FUNCNO_J_INSERT_A :
    j_insert_a( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_INSERT_E :
    j_insert_e( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_INSERT_I :
    j_insert_i( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_INSERT_O :
    j_insert_o( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_INSERT_U :
    j_insert_u( gw, buffer, node, chara ) ;
    break ;
    /* ̾Ϥγϥ( ҲǤ )*/
  case FUNCNO_J_KANA_INPUT :
    j_kana_input( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_START_HENKAN :
    j_start_henkan( gw, buffer, node ) ;
    break ;
  case FUNCNO_J_INSERT_COMMA :
    j_insert_comma( gw, buffer, node ) ;
    break ;
  case FUNCNO_J_INSERT_PERIOD :
    j_insert_period( gw, buffer, node ) ;
    break ;
  case FUNCNO_J_PURGE_FROM_JISYO :
    j_purge_from_jisyo( gw, buffer, node ) ;
    break ;
  case FUNCNO_J_INPUT_BY_CODE_OR_MENU :
    j_input_by_code_or_menu_start( gw, buffer, node ) ;
    break ;
  case FUNCNO_VC_TOGGLE_OVERTHESPOT_LIKE_INPUT :
    /* overthespot like Ϥˤ뤫ɤ򴹤롣*/
    buffer->overthespot_like_input =
      ( buffer->overthespot_like_input )? False : True ;
    break ;
  case FUNCNO_J_MODE_OFF :
    j_mode_off( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_MODE_OFF_AND_SELF_INSERT :
    j_mode_off_and_self_insert( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_TOGGLE_KANA :
    /* ̾⡼ɤҲ̾⡼ɤڤؤ*/
    j_toggle_kana( gw, buffer, node, False, chara ) ;
    break ;
  case FUNCNO_J_PREVIOUS_CANDIDATE :
    j_previous_candidate( gw, buffer, node ) ;
    break ;
  case FUNCNO_J_KAKUTEI :
    if( j_kakutei_kana_mode( gw, buffer, node, chara ) )
      break ;
    j_kakutei( gw, node ) ;
    break ;
  case FUNCNO_J_ABBREV_INPUT :
    j_abbrev_input( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_ABBREV_PERIOD :
    j_abbrev_period( gw, node ) ;
    break ;
  case FUNCNO_J_ABBREV_COMMA :
    j_abbrev_comma( gw, node ) ;
    break ;
  case FUNCNO_J_ZENKAKU_EIJI :
    /* (Ѥܸ)ѻϥ⡼ɤˤ롣*/
    j_zenkaku_eiji( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_ZENKAKU_HENKAN :
    j_zenkaku_henkan( gw, node ) ;
    break ;
  case FUNCNO_J_TODAY :
    /* դνϡ*/
    j_today( node ) ;
    break ;
  case FUNCNO_J_KANAINPUT_MODE_ON :
    j_kanainput_mode_on( gw, buffer, node ) ;
    break ;
  case FUNCNO_J_SET_MARK_COMMAND :
    j_set_mark_command( node ) ;
    break ;
  case FUNCNO_J_NEWLINE :
    j_newline( gw, buffer, node ) ;
    break ;
  case FUNCNO_J_FORWARD_CHAR :
    j_forward_char( node ) ;
    break ;
  case FUNCNO_J_BACKWARD_CHAR :
    j_backward_char( node ) ;
    break ;
  case FUNCNO_J_DELETE_CHAR :
    j_delete_char( node ) ;
    break ;
  case FUNCNO_J_DELETE_BACKWARD_CHAR :
    j_backward_delete_char( gw, buffer, node, True ) ;
    break ;
  case FUNCNO_J_TRY_COMPLETION :
    j_try_completion( gw, node ) ;
    break ;
  case FUNCNO_J_END_OF_LINE :
    j_end_of_line( node ) ;
    break ;
  case FUNCNO_J_BEGINNING_OF_LINE :
    j_beginning_of_line( node ) ;
    break ;
  case FUNCNO_J_KILL_LINE :
    j_kill_line( node, buffer->cutbuffer ) ;
    break ;
  case FUNCNO_J_KILL_REGION :
    j_kill_region( node, buffer->cutbuffer ) ;
    break ;
  case FUNCNO_J_KILL_RING_SAVE :
    j_kill_ring_save( node, buffer->cutbuffer ) ;
    break ;
  case FUNCNO_J_EXCHANGE_POINT_AND_MARK :
    j_exchange_point_and_mark( node ) ;
    break ;
  case FUNCNO_J_YANK :
    j_yank( node, buffer->cutbuffer ) ;
    break ;
  case FUNCNO_J_PREVIOUS_LINE :
    j_previous_line( gw, buffer, node ) ;
    break ;
  case FUNCNO_J_NEXT_LINE :
    j_next_line( gw, buffer, node ) ;
    break ;
  case FUNCNO_J_TRANSPOSE_CHARS :
    j_transpose_chars( node ) ;
    break ;
  case FUNCNO_J_REDRAW :
    /* öե褹롣ʬǤϤʤơ*/
    buffer->redraw( gw ) ;
    break ;
  case FUNCNO_J_KEYBOARD_QUIT :
    j_keyboard_quit( gw, buffer, node ) ;
    break ;
  case FUNCNO_SAVE_SKKINPUT_LOCAL_JISYO :
    j_delete_kanaprefix( node ) ;
    /* 񤬹Ƥ뤫ɤȽꤹ롣*/
    if( buffer->jisyo_dirty ){
#if 1
      myCharCharStrcpy( node->mtextbuffer, "Saving Jisyo..." ) ;
      buffer->redraw( gw ) ;
      XSafeFlush( XtDisplay( gw ) ) ;
#endif
      /* ι򤹤륳ХåƽФ*/
      skkinput_updateLocalJisyo() ;
      myCharCharStrcpy( node->mtextbuffer, "Saving Jisyo...done" ) ;
    } else {
      err_msg( node, "(No changes need to be saved)" ) ;
    }
    break ;
  case FUNCNO_CLOSE_SKKINPUT :
    return SIW_DESTROYED ;
  case FUNCNO_VC_TOGGLE_CHATMODE :
    j_delete_kanaprefix( node ) ;
    buffer->chat_adapter = ( buffer->chat_adapter )? False : True ;
    break ;
  case FUNCNO_VC_TOGGLE_EGGNL :
    j_delete_kanaprefix( node ) ;
    buffer->egg_like_newline =
      ( buffer->egg_like_newline )? False : True ;
    break ;
  case FUNCNO_NOT_MODIFIED :
    j_delete_kanaprefix( node ) ;
    /* ѹե饰õ롣*/
    j_clear_modified_flag() ;
    myCharCharStrcpy( node->mtextbuffer, "Modification-flag cleared" ) ;
    break ;
  case FUNCNO_J_FORWARD_WORD :
    j_forward_word( node ) ;
    break ;
  case FUNCNO_J_BACKWARD_WORD :
    j_backward_word( node ) ;
    break ;
  case FUNCNO_J_UPCASE_WORD :
    j_caseword( node, 'u' ) ;
    break ;
  case FUNCNO_J_DOWNCASE_WORD :
    j_caseword( node, 'd' ) ;
    break ;
  case FUNCNO_J_CAPITALIZE_WORD :
    j_caseword( node, 'c' ) ;
    break ;
  case FUNCNO_INVALID_CHAR :
  default :
#if 0
    XBell( XtDisplay( gw ), 2 ) ;
#endif
    break ;
  }
  skkinput_closeKeyBuffer( keybuf ) ;
  return SIW_PROCESSING ;
}

/*
 * ơ֥򻲾Ȥ̤Υե󥯥ֹ˽äƽ¹Ԥ
 * ٤¾δؿƽФԤؿ
 *----
 * Root ⡼ɤǤϷ褷ƸƤФ뤳Ȥ̵ؿǤ롣δؿ 
 * OverTheSpot ⡼ɤλԽʸ¸ߤʤ˸ƤФ롣
 * λɤ٤ޤǤΥ skkinput ѤΤĤȤȤ
 * Ȥ롣
 */
static int do_skkinputFunction_withouttext
( Widget gw, struct skkinputBuffer *buffer, 
  struct SKKInputNode *node, int func_no )
{
  struct keyBuffer *keybuf ;
  int chara ;

  keybuf = &buffer->keybuf ;
  chara  = keybuf->buffer[ keybuf->usage - 1 ] ;

  /* ȡΥåХåե˽񤫤Ƥ *
   * Ͼä뤳ȤˤʤäƤ롩 */
  MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;

  /* 褿ɬ completion Ͻλ뤳Ȥˤʤ롣*/
  if( node->j_completion_mode ){
    j_completion_close( node ) ;
  }
  /* Ϳ줿̿ФԤʸʳ̵뤹롣*/
  switch( func_no ){
  case FUNCNO_SELF_INSERT_CHARACTER :
    j_insert_chara( node, node->cur_pos, chara ) ;
    break ;
  case FUNCNO_J_SELF_INSERT :
    j_self_insert( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_SELF_ZENKAKU_INSERT :
    j_insert_zenkaku( node, node->cur_pos, chara ) ;
    break ;
  case FUNCNO_J_SET_HENKAN_POINT :
    /* Ѵϰ֤ꤵ롣*/
    j_set_henkan_point( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_SET_HENKAN_POINT_SUBR :
    j_set_henkan_point_subr( gw, buffer, node, chara ) ;
    break ;
    /* 첻ϡ*/
  case FUNCNO_J_INSERT_A :
    j_insert_a( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_INSERT_E :
    j_insert_e( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_INSERT_I :
    j_insert_i( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_INSERT_O :
    j_insert_o( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_INSERT_U :
    j_insert_u( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_PURGE_FROM_JISYO :
    break ;
    /* ̾Ϥγϥ( ҲǤ )*/
  case FUNCNO_J_KANA_INPUT :
    j_kana_input
      ( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_START_HENKAN :
    j_start_henkan( gw, buffer, node ) ;
    break ;
  case FUNCNO_J_INSERT_COMMA :
    j_insert_comma( gw, buffer, node ) ;
    break ;
  case FUNCNO_J_INSERT_PERIOD :
    j_insert_period( gw, buffer, node ) ;
    break ;
  case FUNCNO_J_INPUT_BY_CODE_OR_MENU :
    j_input_by_code_or_menu_start( gw, buffer, node ) ;
    break ;
  case FUNCNO_J_MODE_OFF :
    j_mode_off( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_MODE_OFF_AND_SELF_INSERT :
    j_mode_off_and_self_insert( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_TOGGLE_KANA :
    /* ̾⡼ɤҲ̾⡼ɤڤؤ*/
    j_toggle_kana( gw, buffer, node, False, chara ) ;
    break ;
  case FUNCNO_J_PREVIOUS_CANDIDATE :
    j_previous_candidate( gw, buffer, node ) ;
    break ;
  case FUNCNO_J_KAKUTEI :
    if( j_kakutei_kana_mode( gw, buffer, node, chara ) )
      break ;
    j_kakutei( gw, node ) ;
    break ;
  case FUNCNO_J_ABBREV_INPUT :
    j_abbrev_input( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_ABBREV_PERIOD :
    j_abbrev_period( gw, node ) ;
    break ;
  case FUNCNO_J_ABBREV_COMMA :
    j_abbrev_comma( gw, node ) ;
    break ;
  case FUNCNO_J_ZENKAKU_EIJI :
    /* ѻϥ⡼ɤˤ롣*/
    j_zenkaku_eiji( gw, buffer, node, chara ) ;
    break ;
  case FUNCNO_J_TODAY :
    /* դνϡ*/
    j_today( node ) ;
    break ;
  case FUNCNO_J_KANAINPUT_MODE_ON :
    j_kanainput_mode_on( gw, buffer, node ) ;
    break ;
  case FUNCNO_J_NEWLINE :
    j_newline( gw, buffer, node ) ;
    break ;
  case FUNCNO_CLOSE_SKKINPUT :
    return SIW_DESTROYED ;
  case FUNCNO_VC_TOGGLE_EGGNL :
    j_delete_kanaprefix( node ) ;
    buffer->egg_like_newline =
      ( buffer->egg_like_newline )? False : True ;
    break ;
  case FUNCNO_VC_TOGGLE_OVERTHESPOT_LIKE_INPUT :
    /* overthespot like Ϥˤ뤫ɤ򴹤롣*/
    buffer->overthespot_like_input =
      ( buffer->overthespot_like_input )? False : True ;
    break ;
  case FUNCNO_SAVE_SKKINPUT_LOCAL_JISYO :
    j_delete_kanaprefix( node ) ;
    /* 񤬹Ƥ뤫ɤȽꤹ롣*/
    if( buffer->jisyo_dirty ){
      myCharCharStrcpy( node->mtextbuffer, "Saving Jisyo..." ) ;
      buffer->redraw( gw ) ;
      XSafeFlush( XtDisplay( gw ) ) ;
      /* ι򤹤륳ХåƽФ*/
      skkinput_updateLocalJisyo() ;
      myCharCharStrcpy( node->mtextbuffer, "Saving Jisyo...done" ) ;
    } else {
      err_msg( node, "(No changes need to be saved)" ) ;
    }
    break ;
    /* prefix ʸäν*/
  case FUNCNO_J_PREFIX_CHAR :
    /* ξ祭֤ΤΡġ*/
    j_sendback_keypress( gw, &( buffer->xevent ) ) ;
    buffer->xevent.xany.window = None ;
    break ;
  case FUNCNO_J_SENDBACK_KEY :
  case FUNCNO_J_SENDBACK_NEXT_KEY :
  case FUNCNO_INVALID_CHAR :
  default :
    /* ϥ֤Ȥˤʤ롣*/
    j_sendback_keypress( gw, &( buffer->xevent ) ) ;
    buffer->xevent.xany.window = None ;
    break ;
  }
  /* Хåե򥯥ꥢ롣*/
  skkinput_closeKeyBuffer( keybuf ) ;
  return SIW_PROCESSING ;
}

/*
 * Ū \C-g (Quit) εǽ¹ԤƤޤؿ
 */
void force_keyboard_quit
( Widget gw, struct skkinputBuffer *buffer )
{
  struct SKKInputNode *node ;

  node = ( buffer->lastbuffer->cur_exist )?
    buffer->lastbuffer : buffer->topbuffer ;

  /* ⤷Ϥ줿ʸХåեˤޤäƤ顢ä
     롣*/
  skkinput_closeKeyBuffer( &buffer->keybuf ) ;
  skkinput_addKeyBuffer( &buffer->keybuf, 0x07 ) ;

  if( node->j_henkan_show_candidate_mode ){
    do_Function_jhenkanShowCandidateMode( gw, buffer, node ) ;
  } else if( node->j_input_by_code_or_menu_mode ){
    if( node->j_input_by_code_or_menu_mode == True ){
      do_function_j_input_by_code_or_menu_jump( gw, buffer, node ) ;
    } else {
      do_function_j_input_by_code_or_menu_1_jump( gw, buffer, node ) ;
    }
  } else if( buffer->topbuffer != buffer->lastbuffer ){
    j_keyboard_quit( gw, buffer, node ) ;
  } else {
    MYCHAR_SET_END_OF_STRING( node->mtextbuffer[ 0 ] ) ;
  }
  skkinput_closeKeyBuffer( &buffer->keybuf ) ;
  /* 褵롣*/
  buffer->redraw( gw ) ;
  return ;
}

