/* # skkinput (Simple Kana-Kanji Input)
 * skksvect.c --- 
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>

#include "commondef.h"
#include "buffers.h"
#include "skksvect.h"

/*
 * Хѿ
 */
static VectorIndex *vNodeHashTable[ VNODEHASHSIZE ] ;

/*
 * ץȥ
 */
static int isExistVectorIndexNode
( SkkinpSearchVector *sNode, int pos, int length ) ;
static int add_VectorHashTable
( SkkinpSearchVector *sNode, int pos, int length ) ;
static void clearVectorHashTable( void ) ;

int cmpCandidate
( SkkinpSearchVector *sNode1, int pos1, int len1,
  SkkinpSearchVector *sNode2, int pos2, int len2 ) ;

/*
 * ꥹȤޤ뤴Ȳؿ
 */
void free_SkkinpSearchVector( SkkinpSearchVector **top )
{
  SkkinpSearchVector *node, *nextNode ;
  if( top == NULL )
    return ;
  node = *top ;
  while( node != NULL ){
    nextNode = node->next ;
    free( node ) ;
    node     = nextNode ;
  }
  *top = NULL ;
  return ;
}

/*
 * ΡɤѤݤؿ
 */
SkkinpSearchVector *makeNewSkkinpSearchVectorNode( void )
{
  SkkinpSearchVector *node ;
  node = ( SkkinpSearchVector *)malloc( sizeof( SkkinpSearchVector ) ) ;
  if( node != NULL ){
    /* 򤹤롣*/
    node->used = 0 ;
    node->next = NULL ;
    MYCHAR_SET_END_OF_STRING( node->text[ 0 ] ) ;
  }
  return node ;
}

/*
 * Search Vector ˿Ρɤդäؿ
 */
SkkinpSearchVector *add_SkkinpSearchVector
( SkkinpSearchVector *topp,   struct myChar *str,
  SkkinpSearchVector **rnode, int *pos )
{
  SkkinpSearchVector *node ;
  int length, overlen ;

  /* Ƭ NULL äˤƬݤ롣*/
  if( topp == NULL ){
    topp = node = makeNewSkkinpSearchVectorNode() ;
  } else {
    node = topp ;
    /* ֺǸΥΡɤդ롣*/
    while( node->next != NULL )
      node = node->next ;
  }
  if( rnode != NULL )
    *rnode = node ;
  if( pos != NULL )
    *pos = node->used ;
  /* դäʸ󤬶ǤʤΤʤġ*/
  length = myCharStrlen( str ) ;
  while( length > 0 ){
    if( node->used < TEXTMAXLEN ){
      /* ХåեκǸդä롣*/
      myCharStrncpy
	( node->text + node->used, str, TEXTMAXLEN - node->used ) ;
    }
    /* ХåեʸȤƽü롣*/
    MYCHAR_SET_END_OF_STRING( node->text[ TEXTMAXLEN ] ) ;
    /* Хåեդ褦ʻ֤ȯΤɤǧ롣*/
    overlen = length - ( TEXTMAXLEN - node->used ) ;
    if( overlen > 0 ){
      /* copyˤʤʸγϰ֤򤺤餹ĥХŦ by sigoto */
      str       += TEXTMAXLEN - node->used ;
      /* ΥΡɤϺǸޤǻȤäȡ*/
      node->used = TEXTMAXLEN ;
      /* 줬ĤäƤʸȡ*/
      length     = overlen ;
      /* դƤΤʤ顢Хåեݤ롣*/
      if( ( node->next = makeNewSkkinpSearchVectorNode() ) == NULL )
	break ;
      /* ݤۤϻѤƤʤΤǡޤä顣*/
      node       = node->next ;
      node->used = 0 ;
    } else {
      /* դƤʤСʾʸäɬפʤΤǡ*
       * 롼פȴ롣*/
      node->used += length ;
      length     = 0 ;
      break ;
    }
  }
  return topp ;
}


/*
 * ѴΥǥåѤƤؿ
 */
void free_VectorIndex( VectorIndex **top )
{
  VectorIndex *node, *nextNode ;
  if( top == NULL )
    return ;
  node = *top ;
  while( node != NULL ){
    nextNode = node->next ;
    free( node ) ;
    node     = nextNode ;
  }
  *top = NULL ;
  return ;
}

/*
 * ΡɤѤݤؿ
 */
VectorIndex *alloc_NewVectorIndexNode( void )
{
  VectorIndex *node ;
  if( ( node = ( VectorIndex * )malloc( sizeof( VectorIndex ) ) ) != NULL ){
    node->next = NULL ;
  }
  return node ;
}

/*
 * ѴΥǥåؿ
 * ----
 * Ф֤äΤϤʸʤΤǡڤФƴɬ
 * 롣
 */
static VectorIndex *add_vectorIndexNode
( VectorIndex *vitop, SkkinpSearchVector *sNode,
  int pos, int length, int *number_of_candidates )
{
  VectorIndex *vNode, *vNodeNxt ;

#ifdef DEBUG
  myCharFputstrning( stderr, sNode->text + pos, length ) ;
#endif
  /* Ʊʸ¸ߤ뤫ɤȽꤹ롣*/
  if( isExistVectorIndexNode( sNode, pos, length ) ){
#ifdef DEBUG
    fprintf( stderr, " ha sudeni atta...\n" ) ;
    fflush( stderr ) ;
#endif
    /* ƱʸȤ¸ߤƤΤǡϼΤƤ롣*/
    return vitop ;
  }
  /* ϥå˲ä롣*/
  add_VectorHashTable( sNode, pos, length ) ;

  /* ΡɤΰƬ뤫̵򸫤롣*/
  if( vitop == NULL ){
    /* ΡɤΰƬ̵ä硣*/
    vitop = vNode = alloc_NewVectorIndexNode() ;
    vNode->prev = NULL ;
    vNode->next = NULL ;
  } else {
    vNode = vitop ;
    /* ǤʤäˤϡꥹȤΰֺǸܤ*/
    while( vNode->next != NULL )
      vNode = vNode->next ;
    /* ֺǸΥΡɤդˤϡ */
    vNodeNxt       = alloc_NewVectorIndexNode() ;
    vNodeNxt->next = NULL ;
    vNodeNxt->prev = vNode ;
    vNode->next    = vNodeNxt ;
    vNode          = vNodeNxt ;
  }
  /* ȤƤ SkkInputVector*/
  vNode->node     = sNode ;
  vNode->next     = NULL ;
  /* ȤƤʸĹ*/
  vNode->length   = length ;
  /* SkkInputVector->text Ǥΰ֡*/
  vNode->position = pos ;
  /* ȯο1䤹*/
  ++ *number_of_candidates ;
  return vitop ;
}

/*
 * Search Vector ʸڤФѤؿ
 * ----
 * ѴθΤѤ롣
 */
VectorIndex *makeSearchVectorIndex
( SkkinpSearchVector *top, int *totalnum, int flag )
{
  int doubleQuoteCheck, slashCheck ;
  int pPos, pos, count, number_of_candidates ;
  SkkinpSearchVector *node, *pNode ;
  VectorIndex *vitop = NULL ;
  struct myChar *ptr ;

  /* ǥåνΤѤɽѿν*/
  pPos  = 1 ;
  pos   = 1 ;			/* ϰֺǽΰ֤ˤϡ뤿ᡣ*/
  pNode = node  = top ;
  ptr   = node->text + pos ;	/* ϰֺǽΰ֤ˤϡ뤿ᡣ*/
  count                = 0 ;	/* ǸĹ롣*/
  doubleQuoteCheck     = False ;
  slashCheck           = 0 ;
  number_of_candidates = 0 ;
  
  /* ǥå롣*/
  while( node != NULL ){
    if( pos >= node->used ){
      /* 줬̵ȥХäƤޤȻפ*/
      if( pPos == pos && pNode == node ){
	pPos  = 0 ;
	pNode = node->next ;
      }
      if( ( node = node->next ) == NULL )
	goto ex_makeindex ;
      pos   = 0 ;
      ptr   = node->text ;
    }
    /* ֥륯Ȥ̵뤹򤳤ǳǧ롣*/
    if( IS_ASCII_EQUAL( *ptr,  '\\' ) ){
      slashCheck = 2 ;
    }
    if( slashCheck <= 0 && IS_ASCII_CHARA( *ptr ) ){
      switch( ptr->chara ){
	/* Double Quote δ֤աХååμǤϤʤ
	 * 륯Ȥ˰Ϥޤ줿ʬϰĤʸ(ȤȤ
	 * ˤ slash äƤƤ̵뤹뤳Ȥˤ
	 * 롣*/  
      case 0x22:
	if( doubleQuoteCheck == False ){
	  /* ⤷֥륯ȤˤʤСĤʸ
	   * 󤬳ϤȤˤʤ롣*/
	  doubleQuoteCheck = True ;
	} else {
	  /* ⤷֥륯Ȥǥ֥륯Ȥդġ 
	   * ֥륯ȤȴȤˤʤ롣*/
	  doubleQuoteCheck = False ;
	}
	/* ֤ΰư*/
	ptr   ++ ;
	pos   ++ ;
	count ++ ;
	continue ;
	/* ϸȸδ֤ɬ¸ߤ롣*/
      case '/' :
	/* ֥륯Ȥо줷ΤǤСεǽ̵*/
	if( doubleQuoteCheck )
	  break ;
	/* ΰ֤ʸϽüäƹޤڤʳ
	 * ΩäƤʤΤ顣ʤ NUL ʸǤ⽽ʬ*/
	MYCHAR_SET_END_OF_STRING( *ptr ) ;
	/* ΡɤĲä롣*/
	if( count > 0 && ( pPos < pos || pNode != node ) ){
	  vitop = add_vectorIndexNode
	    ( vitop, pNode, pPos, count, &number_of_candidates ) ;
	}
	/* ڤӡݥ󥿤䤹*/
	ptr ++ ;
	pos ++ ;
	/* (Ĥޤ꺣ξ)"/" դ pPos ˵롣*/
	pPos  = pos ;
	/* ΥΡɤ򵭲Ƥ*/
	pNode = node ;
	count = 0 ;
	continue ;
	/* ʸνüդƤޤäν*/
      case '\n' :
      case '\r' :
      case '\0' :
	/* ˽üʸϥ֥륯Ȥ̵
	 * Ǥʤġ⤷֥륯Ȥо줷饨顼
	 * βԤǤʤ*/
	if( ( node = node->next ) == NULL ){
	  goto ex_makeindex ;
	}
	/* ʸХåեɤߤ˹Ԥ*/
	pos = 0 ;
	ptr = node->text ;
	continue ;
      default :
	break ;
      }
    }
    ptr   ++ ;
    pos   ++ ;
    count ++ ;
    if( slashCheck > 0 )
      slashCheck -- ;
  }
ex_makeindex:
  *totalnum = number_of_candidates ;
  /* ϥåϥꥢƤΡ */
  if( flag )
    /* Ѥϥåơ֥򥯥ꥢ롣*/
    clearVectorHashTable() ;
  return vitop ;
}

/*
 * Search Vector ʸڤФѤؿ
 * ----
 * ѴθΤѤ롣
 */
int copyCandidate
( struct myChar *dest, SkkinpSearchVector *sNode, int position, int length )
{
  struct myChar *sptr = sNode->text + position ;
  int count ;

#if 0
  /* ¿ʬΥɤ̵ˤʤȡconcat Ǥ뤷̵̤
   * 󤸤ʤʡ */
  /* concat ̵뤵פȤޤ*/
  if( IS_ASCII_EQUAL( *sptr,  0x22 ) )
    return 0 ;
#endif

  count = 0 ;
  /* ʳʤ麣ϤʤȤʤ褦Ǥޤ*/
  while( count < length ){
    if( position >= sNode->used ){
      if( ( sNode = sNode->next ) == NULL ){
	MYCHAR_SET_END_OF_STRING( *dest ) ;
	return count ;
      }
      sptr     = sNode->text ;
      position = 0 ;
      continue ;
    }
    if( IS_END_OF_STRING( *sptr ) )
      break ;
    *dest ++ = *sptr ++ ;
    count ++ ;
  }
  MYCHAR_SET_END_OF_STRING( *dest ) ;
  return count ;
}

/*
 * ϥåơ֥ؿưɬٸƤ֤ȡ
 */
void initVectorHashTable( void )
{
  int i ;
  /* ϥåơ֥ NULL ǽ롣*/
  for( i = 0 ; i < VNODEHASHSIZE ; i ++ )
    vNodeHashTable[ i ] = NULL ;
  return ;
}

static void clearVectorHashTableSub( VectorIndex *node )
{
  /* λҶƤġ*/
  if( node->prev != NULL ){
    clearVectorHashTableSub( node->prev ) ;
    node->prev = NULL ;
  }
  if( node->next != NULL ){
    clearVectorHashTableSub( node->next ) ;
    node->next = NULL ;
  }
  node->node     = NULL ;
  node->position = 0 ;
  node->length   = 0 ;
  /* ʬȤơĽλ롣*/
  free( node ) ;
  return ;
}

/*
 * ϥåơ֥öؿ
 *-----
 * Ѵλ٤˸ƤФɬפ뤬ġϷ빽ʥȤˤʤ
 * Ȼפ
 */
static void clearVectorHashTable( void )
{
  int i ;
  /* ϥåơ֥˸롣*/
  for( i = 0 ; i < VNODEHASHSIZE ; i ++ ){
    if( vNodeHashTable[ i ] == NULL )
      continue ;
    clearVectorHashTableSub( vNodeHashTable[ i ] ) ;
    vNodeHashTable[ i ] = NULL ;
  }
  return ;
}

/*
 * skkinpsearchvector ĤθӤؿ
 *----
 * strcmp  skkinpsearchvector ξˤΤΤȻפäƲ
 */
int cmpCandidate
( SkkinpSearchVector *sNode1, int pos1, int len1,
  SkkinpSearchVector *sNode2, int pos2, int len2 )
{
  int ret, len, lchara1, lchara2 ;
  struct myChar *ptr1, *ptr2 ;

  /* Ĺ⡢û롼פ뤳Ȥˤʤ롣Ĺ㤦ä * 
   * Ƥɬ̵ĤȤ줽 Tree Search ɬ  *
   * פʤΡ*/
  len = ( len1 < len2 )? len1 : len2 ;

  /* ӳϰ֡*/
  ptr1 = sNode1->text + pos1 ;
  ptr2 = sNode2->text + pos2 ;

  while( len > 0 ){
    /* ХåեκǸޤƤޤäˤϡΥΡɤ򸫤롣*/
    if( pos1 >= sNode1->used ){
      if( ( sNode1 = sNode1->next ) == NULL ){
	if( pos2 >= sNode2->used ){
	  if( ( sNode2 = sNode2->next ) == NULL )
	    return 0 ;
	}
	/* Хåեμ򸫤褦ˤ⡢⤦Ǥߤġȡ *
	 * ʸ¸ߤʤȤȤˤʤ롣ǡ̤Ф *
	 * ʤȤʤȡĤĤޤ i == len ˤʤäƤʤȤ *
	 * ϡϤޤޤ³ȤȤ顢֤ͤξ *
	 * */
	return (-1) ;
      }
      ptr1 = sNode1->text ;
    }
    if( pos2 >= sNode2->used ){
      /* ХåեκǸޤƤޤäˤϡΥΡɤ򸫤롣*/
      if( ( sNode2 = sNode2->next ) == NULL ){
	/* Хåեμ򸫤褦ˤ⡢⤦Ǥߤġȡ *
	 * ʸ¸ߤʤȤȤˤʤ롣ǡ̤Ф *
	 * ʤȤʤȡĤĤޤ i == len ˤʤäƤʤȤ *
	 * ϡϤޤޤ³ȤȤ顢֤ͤξ *
	 * */
	return 1 ;
      }
      ptr2 = sNode2->text ;
    }
    /* κ롣*/
    if( IS_ASCII_CHARA( *ptr1 ) ){
      lchara1 = ( ( ( unsigned long )CHARSET_ASCII ) << 16 ) | 
	( ( unsigned long )( ptr1->chara ) ) ;
    } else {
      lchara1 = ( ( ( unsigned long )ptr1->charset ) << 16 ) | 
	( ( unsigned long )( ptr1->chara ) ) ;
    }
    if( IS_ASCII_CHARA( *ptr2 ) ){
      lchara2 = ( ( ( unsigned long )CHARSET_ASCII ) << 16 ) | 
	( ( unsigned long )( ptr2->chara ) ) ;
    } else {
      lchara2 = ( ( ( unsigned long )ptr2->charset ) << 16 ) | 
	( ( unsigned long )( ptr2->chara ) ) ;
    }
    if( ( ret = lchara1 - lchara2 ) )
      return ret ;
    /* θܤ*/
    ptr1 ++ ; pos1 ++ ;
    ptr2 ++ ; pos2 ++ ;
    len  -- ;
  }
  /* ʬ꤬Ʊʸä顢ɤ͡*/
  if( len1 == len2 )
    return 0 ;
  /* ʬĹäƤȤϡʬ礭Ρ*/
  if( len1 > len2 )
    return 1 ;
  /* ʬûä顢ʬΡ*/
  return (-1) ;
}

/*
 * ϥåơ֥ʬڤ˸äؿ
 */
static int add_VectorHashTable
( SkkinpSearchVector *sNode, int pos, int length )
{
  VectorIndex *vNode ;
  int num ;
  num = VHASHFUNCTION( sNode, pos ) ;
  /* ʸ¸ߤʤä*/
  if( ( vNode = vNodeHashTable[ num ] ) == NULL ){
    /* ΡɤΰƬ̵ä硣*/
    vNodeHashTable[ num ] = vNode = alloc_NewVectorIndexNode() ;
  } else {
    /* ˲餫θ䤬¸ߤƤġ*/
    while( 1 ){
      num = cmpCandidate
	( vNode->node, vNode->position, vNode->length, sNode, pos, length ) ;
      /* ̤򸫤롣*/
      if( num == 0 ){
	return True ;
      } else if( num < 0 ){
	/* ϡλҶ򸫤ʤȤʤ*/
	if( vNode->next == NULL ){
	  /* λҶʤä顢زä롣*/
	  if( ( vNode->next = alloc_NewVectorIndexNode() ) == NULL ){
	    /* γݤ˼ԤƤʤСϥåϿ롣
	     * Թˤƥݤ˼Ԥǽ뤳Ȥ˺
	     * Ϥʤʤ*/ 
	    return False ;
	  }
	  vNode = vNode->next ;
	  break ;
	} else {
	  /* λҶ顢λҶĴ٤롣*/
	  vNode       = vNode->next ;
	}
      } else {
	/* ϡλҶ򸫤ʤȤʤ*/
	if( vNode->prev == NULL ){
	  /* λҶʤä顢زä롣*/
	  if( ( vNode->prev = alloc_NewVectorIndexNode() ) == NULL ){
	    /* γݤ˼ԤƤʤСϥåϿ롣
	     * Թˤƥݤ˼Ԥǽ뤳Ȥ˺
	     * Ϥʤʤ*/ 
	    return False ;
	  }
	  vNode = vNode->prev ;
	  break ;
	} else {
	  /* λҶ顢λҶĴ٤롣*/
	  vNode       = vNode->prev ;
	}
      }
    }
  }
  /* ɬդäѤˤäĤΤǡҶϤʤ*/
  vNode->next     = NULL ;
  vNode->prev     = NULL ;
  /* ¾ξղä롣*/
  vNode->node     = sNode ;
  vNode->position = pos ;
  vNode->length   = length ;
  return True ;
}

/*
 * ϥåơ֥Ĵ٤ơ˸䤬¸ߤƤ뤫ɤå
 * ؿ
 */
static int isExistVectorIndexNode
( SkkinpSearchVector *sNode, int pos, int length )
{
  int ret ;
  VectorIndex *vNode ;

  vNode = vNodeHashTable[ VHASHFUNCTION( sNode, pos ) ] ;
  /* ʸ¸ߤʤä*/
  if( vNode == NULL )
    return False ;
  /* ϥåؿˤ֤餵ꥹȤ򸡺롣*/
  while( vNode != NULL ){
    ret = cmpCandidate
      ( vNode->node, vNode->position, vNode->length, sNode, pos, length ) ;
    /* Ʊθ䤬¸ߤ*/
    if( ret == 0 )
      return True ;
    /* ʬڤˤʤäƤΤǡ̤򸫤ƻޤΤɤĴ٤롣*/
    if( ret < 0 ){
      /* 󸡺褦ȤƤϿƤ *
       * ʸɤ礭硣*/
      vNode = vNode->next ;
    } else {
      /* 󸡺褦ȤƤϿƤ *
       * ʸɤ硣*/
      vNode = vNode->prev ;
    }
  }
  return False ;
}

#ifdef DEBUG
void dump_skkinpSearchVector( SkkinpSearchVector *node )
{
  while( node != NULL ){
    printf( "%s\n", node->text ) ;
    node = node->next ;
  }
  return ;
}
#endif
