/*
   File     : initUI.c
   Author   : Lionel ULMER
   Creation : 04/12/96

   Virtual Reality ENGine

   Lecture des arguments de la ligne de commande, des fichiers de
   ressources, initialisation des widgets constituant l'application.
*/

#include "global.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/MenuButton.h>
#ifdef MOTIF
#include <Xm/XmAll.h>
#include "GLwMDrawA.h"
#else
#include "GLwDrawA.h"
#endif

#include "initfuncs.h"
#include "supportfuncs.h"
#include "widget.h"
#include "TextField.h"
#include "defaults.h"
#include "chat.h"
#include "menus.h"
#include "initui.h"


VRengResources resources;	/* Resources du programme */
XtAppContext appContext;	/* Application Context */
int width3D, height3D;		/* largeur de le representation 3D */
Widget threeDWidget;		/* widget 3D */
Widget displayText;		/* La widget qui affiche cette chane */
Widget statusLabel = NULL;	/* Widget for displaying  Warnings */
Widget topLevel,panedH,panedV,panedVB,panedMenu,enterText;
Widget labelSep,labelLeft,labelPlayer; /* labels on the left column */
int gl_quality;			/* display quality */
char *displaystring;		/* string displayed by displayText */

/* Translations "widget3D" */
static String trans3D = "<Btn3Down>:  Button13D(3)   \n\
                         <Btn1Up>:    Button13D(u)   \n\
                         <Btn1Down>:  Button13D(d)   \n\
                         <Enter>:     FocusWin3D(e)  \n\
                         <Leave>:     FocusWin3D(l)  \n\
                         <KeyDown>:   Key3D(d)       \n\
                         <KeyUp>:     Key3D(u)       \n";
/* Translations pour le Paned Vertical ( cause des touches...) */
static String transP = "<Enter>:     FocusWin3D(e) \n\
                        <Leave> :    FocusWin3D(l) \n";

/* Translations supplmentaires pour la zone texte */
static String transTF = "<Key>Up:   UpHistory()    \n\
                         <Key>Down: DownHistory()  \n";
static String transTL = "<Map>:       MapWin3D(m)  \n\
                         <Unmap>:     MapWin3D(u)  \n";

/* mapping string <-> function */
static XtActionsRec windowActions[] = {
  {"Button13D"   , button13D},
  {"FocusWin3D"  , focusWin3D},
  {"Key3D"       , key3D},
  {"UpHistory"   , upHistory},
  {"DownHistory" , downHistory},
  {"MapWin3D"    , mapWin3D}
};

void initResources(int argc, char *argv[])
{
  struct passwd *pwd;

  /* Les "resources" perso (pour la ligne de commande / fichier de config) */
  static XtResource vrengresources[] = {
    {XtNwidth3D, XtCWidth3D,XtRInt,sizeof(int),
       XtOffsetOf(VRengResources, width3D),XtRImmediate,(XtPointer) -1},
    {XtNheight3D, XtCHeight3D,XtRInt,sizeof(int),
       XtOffsetOf(VRengResources, height3D),XtRImmediate,(XtPointer) -1},
    {XtNmaxsimcon, XtCMaxSimCon,XtRInt,sizeof(int),
       XtOffsetOf(VRengResources, maxsimcon),XtRImmediate,(XtPointer) 16},
    {XtNhistlength, XtCHistLength,XtRInt,sizeof(int),
       XtOffsetOf(VRengResources, histlength),XtRImmediate,(XtPointer) 32},
    {XtNdebug, XtCDebug,XtRInt,sizeof(int),
       XtOffsetOf(VRengResources, debug),XtRImmediate,(XtPointer) 0},
    {XtNversion, XtCVersion, XtRString,sizeof(char *),
       XtOffsetOf(VRengResources, version), XtRString, NULL},
    {XtNquality, XtCQuality,XtRInt,sizeof(int),
       XtOffsetOf(VRengResources, quality),XtRImmediate, (XtPointer) 0 },
    {XtNmulticast, XtCMulticast,XtRString,sizeof(char *),
       XtOffsetOf(VRengResources, multicast), XtRString, DEF_CHANNEL},
    {XtNnick, XtCNick,XtRString,sizeof(char *),
       XtOffsetOf(VRengResources, nick),XtRString, NULL},
    {XtNworld, XtCWorld,XtRString,sizeof(char *),
       XtOffsetOf(VRengResources, world),XtRString, DEF_URL_CFG},
    {XtNskinf, XtCSkinf,XtRString,sizeof(char *),
       XtOffsetOf(VRengResources, skinf),XtRString, DEF_FRONT_GIF},
    {XtNskinb, XtCSkinb,XtRString,sizeof(char *),
       XtOffsetOf(VRengResources, skinb),XtRString, DEF_BACK_GIF}
  };
  
  /* arguments of command line */
  static XrmOptionDescRec clineoptions[] = {
    {"-width3D",   XtNwidth3D,    XrmoptionSepArg, NULL},
    {"-height3D",  XtNheight3D,   XrmoptionSepArg, NULL},
    {"-maxsimcon", XtNmaxsimcon,  XrmoptionSepArg, NULL},
    {"-history",   XtNhistlength, XrmoptionSepArg, NULL},
    {"-d",         XtNdebug,      XrmoptionSepArg, NULL},
    {"-quality",   XtNquality,    XrmoptionSepArg, NULL},
    {"-mc",        XtNmulticast,  XrmoptionSepArg, NULL},
    {"-nick",      XtNnick,       XrmoptionSepArg, NULL},
    {"-world",     XtNworld,      XrmoptionSepArg, NULL},
    {"-skinf",     XtNskinf,      XrmoptionSepArg, NULL},
    {"-skinb",     XtNskinb,      XrmoptionSepArg, NULL},
    {"-V",         XtNversion,    XrmoptionIsArg,  NULL},
    {"--version",  XtNversion,    XrmoptionIsArg,  NULL}
  };
  
  /* Les ressources par dfaut, s'il ne trouve rien dans .Xdefault */
  static char *fallbackresources[]={
    "Vreng*panedH.background:       Grey95",
    "Vreng*panedV.background:       Grey90",
    "Vreng*font:                    6x13",
    "Vreng*panedVB*showGrip:        False",
    "Vreng*panedVB*skipAdjust:      True",
    "Vreng*panedMenu*showGrip:      False",
    "Vreng*panedMenu*skipAdjust:    True",
    "Vreng*panedStatus*showGrip:    False",
    "Vreng*panedStatus*skipAdjust:  True",
    "Vreng*quit*background:         Grey95",
    "Vreng*pref*background:         Grey95",
    "Vreng*home*background:         Grey95",
    "Vreng*audio*background:        Grey95",
    "Vreng*video*background:        Grey95",
    "Vreng*whiteboard*background:   Grey95",
    "Vreng*members*background:      Grey95",
    "Vreng*contmembers*showGrip:    False",
    "Vreng*labelSep*background:     Grey90",
    "Vreng*labelLeft*background:    Grey90",
    "Vreng*labelLeft*foreground:    red",
    "Vreng*labelPlayer*background:  Grey90",
    "Vreng*statusLabel*background:  Grey90",
    "Vreng*statusLabel*showGrip:    False",
    "Vreng*threeDWidget*background: black",
    "Vreng*threeDWidget*foreground: blue",
    "Vreng*threeDWidget*showGrip:   True",
    "Vreng*threeDWidget*skipAdjust: True",
    "Vreng*displayText*showGrip:    False",
    "Vreng*displayText*background:  Grey90",
    "Vreng*enterText*skipAdjust:    True",
    "Vreng*enterText*background:    Grey95",
    NULL
  };


  displaystring = (char *) malloc(DISPLAYTEXTSIZE);
  strcpy(displaystring, WELCOMESTRING);
  
  /* topLevel = fentre principale */
  topLevel = XtVaAppInitialize(&appContext, "Vreng",
			     clineoptions, XtNumber(clineoptions), &argc, argv,
			     fallbackresources, NULL);
  XtAugmentTranslations(topLevel, XtParseTranslationTable(transTL));
  if (argc > 1) {
    fprintf(stderr, "%s\n", HELPSTRING);
    exit(-1);
  }
    
  /* find resources */
  XtVaGetApplicationResources(topLevel, (XtPointer) &resources,
			      vrengresources, XtNumber(vrengresources), NULL);
  
  if (resources.version) {
    printf("%s\n", VERSION);
    exit (0);
  }

  /* get args from command line and resource files */
  debug = resources.debug;
  history = resources.histlength;  
  gl_quality = resources.quality;
  
  /* 3D window size */
  width3D = resources.width3D;
  height3D = resources.height3D;
  if ((width3D == -1) && (height3D == -1)) {
    width3D = DEF_WIDTH3D;
    height3D = DEF_HEIGHT3D;
  } else {
    if (width3D != -1)
      height3D = (width3D * 3) / 4;
    else if (height3D != -1)
      width3D = (height3D * 4) / 3; 
  }

  /* do not accept a too small 3D window */
  if (height3D < 50 || width3D < 50) {
    width3D = DEF_WIDTH3D;
    height3D = DEF_HEIGHT3D;
  }

  if (resources.nick == NULL) {
    pwd = getpwuid(getuid());
    resources.nick = pwd->pw_name;
  }
}

void initPaned()
{
  Widget statusMenu;

  /* Ncessaire pour appeler le callback de positionnement des menus */
#ifndef MOTIF
  XawSimpleMenuAddGlobalActions(appContext);
  XtRegisterGrabAction(button13D,True, (ButtonPressMask|ButtonReleaseMask),
		            GrabModeAsync, GrabModeAsync);
#endif
  
  /* Initialisation du Paned vertical */
#ifdef MOTIF
  panedV = XmCreateRowColumn(topLevel, "panedV", NULL, 0);
  XtManageChild(panedV);
  XtVaSetValues(panedV, XmNorientation, XmVERTICAL, NULL);
#else
  panedV = XtVaCreateManagedWidget("panedV", panedWidgetClass, topLevel,
			    XtNorientation, XtorientVertical, NULL);
#endif

  /* Paned horizontal pour y placer les boutons de menu. */
#ifdef MOTIF
  panedMenu = XmCreateMenuBar(panedV, "panedMenu", NULL, 0);
  XtManageChild(panedMenu);
#else
  panedMenu = XtVaCreateManagedWidget("panedMenu", panedWidgetClass, panedV,
			    XtNorientation, XtorientHorizontal,
			    NULL);
#endif

  /* Paned horizontal pour y placer le statusLabel */
#ifdef MOTIF
  statusMenu = XmCreateFrame(panedV, "panedStatus", NULL, 0);
  XtManageChild(statusMenu);
#else
  statusMenu = XtVaCreateManagedWidget("panedStatus", panedWidgetClass, panedV,
			    XtNorientation, XtorientHorizontal, NULL);
#endif
  
  /* Barre de status (pour warning) */
#ifdef MOTIF
  statusLabel= XmCreateLabel(statusMenu, "statusLabel", NULL, 0);
  XtManageChild(statusLabel);
#else
  statusLabel= XtVaCreateManagedWidget("statusLabel", labelWidgetClass,
			    statusMenu, XtNlabel, "Status Label", NULL);
#endif
  
  /* Initialisation du Paned horizontal pour 3D et boutons */
#ifdef MOTIF
  panedH = XmCreateForm(panedV, "panedH", NULL, 0);
  XtVaSetValues(panedH, XmNorientation, XmHORIZONTAL, NULL);
  XtManageChild(panedH);
#else
  panedH = XtVaCreateManagedWidget("panedH", panedWidgetClass, panedV,
			    XtNorientation, XtorientHorizontal, NULL);
#endif

  /* Initialisation du Paned pour les boutons dynamiques */
#ifdef MOTIF
  panedVB = XmCreateRowColumn(panedH, "panedVB", NULL, 0);
  XtVaSetValues(panedVB, XmNorientation, XmVERTICAL,
			 XtNtranslations, XtParseTranslationTable(transP),
			 NULL);
  XtManageChild(panedVB);
#else
  panedVB = XtVaCreateManagedWidget("panedVB", panedWidgetClass, panedH,
			    XtNorientation, XtorientVertical,
			    XtNtranslations, XtParseTranslationTable(transP),
			    NULL);
#endif
 
  /* Initialise la barre des boutons */
  initMenuBar();
  initButtonBar();
  userLogging(resources.nick);

#ifdef MOTIF
  threeDWidget = XtVaCreateManagedWidget("threeDWidget",
					 glwMDrawingAreaWidgetClass, panedH,
					 XtNtranslations,
					 XtParseTranslationTable(trans3D),
					 GLwNvisualInfo,glvisual,
					 XtNcolormap,cmap,
					 XtNwidth, width3D,
					 XtNheight, height3D,
					 GLwNallocateOtherColors, TRUE,
					 GLwNallocateBackground, TRUE,
					 GLwNinstallColormap, TRUE,
					 NULL);
#else
  threeDWidget = XtVaCreateManagedWidget("threeDWidget",
					 glwDrawingAreaWidgetClass, panedH,
					 XtNtranslations,
					 XtParseTranslationTable(trans3D),
					 GLwNvisualInfo,glvisual,
					 XtNcolormap,cmap,
					 XtNwidth, width3D,
					 XtNheight, height3D,
					 GLwNallocateOtherColors, TRUE,
					 GLwNallocateBackground, TRUE,
					 GLwNinstallColormap, TRUE,
					 NULL);
#endif

  XtAddCallback(threeDWidget, GLwNginitCallback, init3D, NULL);
  XtAddCallback(threeDWidget, GLwNexposeCallback, expose3D, NULL);
  XtAddCallback(threeDWidget, GLwNresizeCallback, resize3D, NULL);
  
  XtSetKeyboardFocus(panedVB, threeDWidget);

  /* Initialisation des fentres textes */
#ifdef MOTIF
  displayText = XmCreateScrolledText(panedV, "displayText", NULL, 0);
  XtManageChild(displayText);
  XtVaSetValues(displayText,
			    XtNheight,104,
			    XtNeditType,XawtextRead,
			    XtNscrollVertical,XawtextScrollWhenNeeded,
			    XtNwrap,XawtextWrapWord,
			    XtNtype,XawAsciiString,
			    XtNstring,displaystring,
			    XtNdisplayCaret,False,
			    XtNuseStringInPlace,True,
			    NULL);
#else
  displayText = XtVaCreateManagedWidget("displayText", asciiTextWidgetClass,
			    panedV,
			    XtNheight,104,
			    XtNeditType,XawtextRead,
			    XtNscrollVertical,XawtextScrollWhenNeeded,
			    XtNwrap,XawtextWrapWord,
			    XtNtype,XawAsciiString,
			    XtNstring,displaystring,
			    XtNdisplayCaret,False,
			    XtNuseStringInPlace,True,
			    NULL);
#endif

#ifdef MOTIF
  enterText = XmCreateTextField(panedV, "enterText", NULL, 0);
  XtManageChild(enterText);
  XtVaSetValues(enterText, XtNlength, MESS_LEN, NULL);
#else
  enterText = XtVaCreateManagedWidget("enterText", textfieldWidgetClass,
			    panedV, XtNlength, MESS_LEN, NULL);
#endif

  XtSetKeyboardFocus(displayText, enterText);
  XtAddCallback(enterText, XtNactivateCallback, newPlayerText, NULL);
  XtOverrideTranslations(enterText, XtParseTranslationTable(transTF));
  
  /* Rajoute les actions dans la table */
  XtAppAddActions(appContext, windowActions, XtNumber(windowActions));
  
  /* Affiche la fentre */
  XtRealizeWidget(topLevel);
} 

