/*
   File     : members.c
   Author   : Philippe Dax
   Creation : 07/02/98

*/


/* Fichier des variables globales du module Interface */
#include "global.h"
#include "menus.h"
#include "supportfuncs.h"
#include "log.h"
#include "rtpsess.h"
#include "members.h"


PlayerList *plist;	/* players list */
MemberList *mlist;	/* present members list */


void updateMemberWorld(char *membername, char *world)
{
  int i = 0;
  MemberList *ml;

  /* for (ml = mlist; ml && i<100; ml = ml->next, i++) { */
  for (ml = mlist; ml && ml->next; ml = ml->next)
    ;
  for (; ml && i<100; ml = ml->prev, i++) {
    if (strcmp(membername, ml->name) == 0) {
      free(ml->worldname);
      if (world == NULL)
        ml->worldname = strdup(worldname);
      else
        ml->worldname = strdup(world);
      trace(DBG_WIN, "updatememberworld: ml->worldname=%s", ml->worldname);
      break;
    }
  }
  if (i == 100) {
    warning("updatememberworld: loop i=%d", i);
  }
#ifndef WANT_TCL
  updateMembers();
#endif
}

Public
void memberJoining(char *membername)
{
  MemberList *ml;

  notice("Avatar %s joins VREng", membername);

  /* Mets  jour la liste chaine */
  ml = (MemberList *) malloc(sizeof(MemberList));
  ml->name = strdup(membername);
  ml->netname = strdup(AvatarName());
  ml->worldname = strdup(worldname);
  ml->next = mlist;
  ml->prev = NULL;
  if (mlist != NULL)
    mlist->prev = ml;
  mlist = ml;
#ifndef WANT_TCL
  updateMembers();
#endif
}

Public
void memberQuitting(void *handle)
{
  MemberList *ml;

  if (handle == NULL)
    return;
  ml = (MemberList *) handle;

  notice("Avatar %s quits %s", ml->name, ml->worldname);
  warning("Avatar %s quits %s, ml=%x mlist=%x", ml->name, ml->worldname, ml, mlist);
  if (!strcmp(ml->name, "label"))	/* BUG ! to resolve */
    return;

  /* Update list */
  if (ml == mlist) {
    mlist = ml->next;
    mlist->prev = NULL;
  }
  else {
    trace(DBG_FORCE, "ml->name=%s ml=%x ml->prev=%x ml->next=%x ml->prev->next=%x", ml->name, ml, ml->prev, ml->next, ml->prev->next);
    if (ml->prev == NULL) {
      warning("ml=%x ml->prev=%x ml->next=%x ml->prev->next=%x", ml, ml->prev, ml->next, ml->prev->next);
      return;
    }
    ml->prev->next = ml->next;
    if (ml->next != NULL)
      ml->next->prev = ml->prev;
  }
  free(ml->name);
  free(ml->netname);
  free(ml->worldname);
  free(ml);
#ifndef WANT_TCL
  updateMembers();
#endif
}

/* userLogging: when a new user comes in */
Public
void * userLogging(char *membername)
{
  PlayerList *pl;

  notice("Avatar %s joins", membername);

  /* Change the label */
#ifndef WANT_TCL
  strcat(pllist, "\n");
  trace(DBG_WIN, "userLogging: %s", pllist);
#endif

  /* update list */
  pl = (PlayerList *) malloc(sizeof(PlayerList));
  pl->name = strdup(membername);
#ifndef WANT_TCL
  pl->w = NULL;
#endif
  pl->next = plist;
  pl->prev = NULL;
  if (plist != NULL)
    plist->prev = pl;
  plist = pl;
#ifndef WANT_TCL
  strcat(pllist, membername);
#endif

#ifndef WANT_TCL
  /* display list */
  updateButtonBar();
#endif
  return (void *) pl;
}

/* userLoggOut: when an user quits */
Public
void userLoggingOut(void *handle)
{
  PlayerList *pl;

  if (handle == NULL)
    return;
  pl = (PlayerList *) handle;
  notice("Avatar %s quits", pl->name);

  /* Update list */
  if (pl == plist) {
    plist = pl->next;
    plist->prev = NULL;
  }
  else {
    pl->prev->next = pl->next;
    if (pl->next != NULL)
      pl->next->prev = pl->prev;
  }
  free(pl->name);
  free(pl);

  /* rewrite pllist */
#ifndef WANT_TCL
  strcpy(pllist, "Members:");
  for (pl = plist; pl && pl->next; pl = pl->next)
    ;
  for (; pl != NULL; pl = pl->prev) {
    strcat(pllist, "\n");
    strcat(pllist, pl->name);
  }
  trace(DBG_WIN, "%s", pllist);
  updateButtonBar();
#endif
}

