#include "global.h"
#include "net_decls.h"
#include "net_shm.h"


Private
u_int16 RtpCreateSeq()
{
  u_int16 seq;
  time_t t;

  srand((u_int32) time(&t));
  seq = rand();
  trace(DBG_RTP, "RtpCreateSeq: seq=%x", seq);
  return seq;
}

Private
u_int32 RtpCreateSsrc(int value)
{
  u_int32 ssrc;
  time_t t;

  srand((u_int32) time(&t));
  ssrc = (u_int32) random32(value);
  trace(DBG_RTP, "RtpCreateSsrc: ssrc=%x", ssrc);
  return ssrc;
}

Public
char *
RtcpName()
{
  FILE *fp;
  char *p, buf[BUFSIZ];
  static char name[NAME_LEN];

  p = getenv("HOME");
  if (p == NULL || *p == '\0')
    return ((char *) NULL);
  sprintf(buf, "%s/.RTPdefaults", p);
  if ((fp = fopen(buf, "r"))) {
    while (fgets(buf, sizeof(buf), fp)) {
      buf[strlen(buf) -1] = '\0';
      if (strncmp(buf, "*rtpName:", 9) == 0) {
        p = strchr(buf, ':');
        p += 2;
        strcpy(name, p);
        fclose(fp);
        return (name);
      }
    }
    fclose(fp);
  }
  return ((char *) NULL);
}

Public
char *
RtcpEmail()
{
  struct passwd *pwd;
  struct hostent *hp;
  char host[64], hostname[16];
  static char email[EMAIL_LEN];

  pwd = getpwuid(getuid());
  gethostname(hostname, sizeof(hostname));
  hp = (struct hostent *) gethostbyname(hostname);
  memset(host, 0, sizeof(host));
  strncpy(host, hp->h_name, sizeof(host));
  sprintf(email, "%s@%s", pwd->pw_name, host);
  return (email);
}

Public
char *
AvatarName()
{
  char *p;
  static char avatarname[NAME_LEN];

  if ((p = RtcpName()) == NULL) {
    p = RtcpEmail();
  }
  strncpy(avatarname, p, NAME_LEN);
  return (avatarname);
}


Public
void RtpSendBye(Channel *pchannel)
{
  sendRTCPPacket(pchannel, pchannel->sa[SOCK_RTCP], RTCP_BYE);
}

Public
void RtpInitSeq(source *s, u_int16 seq)
{
  s->base_seq = seq - 1;
  s->max_seq = seq;
  s->bad_seq = RTP_SEQ_MOD + 1;
  s->cycles = 0;
  s->received = 0;
}

Private
source_info *
RtpCreateSinfo(Session *pse, u_int32 ssrc)
{
  source_info *psi;
  Channel *pchan = channels_list;

  if ((psi = (source_info *) malloc(sizeof(source_info))) == NULL)
    return((source_info *) NULL);
  memset(psi, 0, sizeof(source_info));
  psi->ssrc = ssrc;
  pse->sess_nbsources++;
  trace(DBG_RTP, "nbsources++ = %d", pse->sess_nbsources);
  return psi;
}

Public
void RtpDeleteSinfo(Session *pse, u_int32 ssrc)
{
  source_info *psi, *psilast;
  u_int8 found = 0;
  
  for (psilast = psi = pse->sess_sinfo; !found && psi; psi = psi->next) {
    if (psi->ssrc == ssrc) {
      found = 1;
      break;
    }
    psilast = psi;
  }
  if (found) {
    if (psilast == NULL) { /* no source found */
      pse->sess_sinfo = NULL;
    }
    else {
      psilast->next = psi->next;
    }
    sum_pkts_lost += psi->lost;
    pse->sess_nbsources--;
    trace(DBG_RTP, "nbsources = %d", pse->sess_nbsources);
    free(psi);
  }
}

Private
void RtpCreateSDES(Session *pse)
{
  sdes_item *scname, *sname, *semail, *stool, *sloc;

  trace(DBG_RTP, "CreateSDES pse: %x", pse);
  scname = (sdes_item *) malloc(sizeof(sdes_item));
  if (scname == NULL)
    return;
  pse->sess_sdes = scname;
  scname->type = RTCP_SDES_CNAME;
  scname->len = strlen(rtpemail);
  scname->content = rtpemail;
  
  sname = (sdes_item *) malloc(sizeof(sdes_item));
  if (sname == NULL) return;
  scname->next = sname;
  sname->type = RTCP_SDES_NAME;
  sname->len = strlen(rtpname);
  sname->content = rtpname;
  
  semail = (sdes_item *) malloc(sizeof(sdes_item));
  if (semail == NULL) return;
  sname->next = semail;
  semail->type = RTCP_SDES_EMAIL;
  semail->len = strlen(rtpemail);
  semail->content = rtpemail;
  
  sloc = (sdes_item *) malloc(sizeof(sdes_item));
  if (sloc == NULL) return;
  semail->next = sloc;
  sloc->type = RTCP_SDES_LOC;
  sloc->len = strlen(worldname);
  sloc->content = worldname;
  
  stool = (sdes_item *) malloc(sizeof(sdes_item));
  if (stool == NULL) return;
  sloc->next = stool;
  stool->type = RTCP_SDES_TOOL;
  stool->len = strlen(toolname);
  stool->content = toolname;

  stool->next = NULL;
  pse->sess_nbsdes = 5;
}

Private
void RtpFreeSDES(Session *pse)
{
  sdes_item *sitem, *tmp;

  trace(DBG_RTP, "FreeSDES: pse=%x", pse);
  if (pse == NULL)
    return;
  for (sitem = pse->sess_sdes; sitem != NULL; ) {
    tmp = sitem;
    sitem = sitem->next;
    free(tmp);
    pse->sess_nbsdes--;
  }
  pse->sess_sdes = NULL;
}
/*
 * Alloc a Session
 */
Public
Session *
RtpAllocSession()
{
  Session *pse;

  if ((pse = (Session *) malloc(sizeof(Session))) == NULL)
    return ((Session *) NULL);
  memset(pse, 0, sizeof(Session));
  if (sessions_list == (Session *) NULL) {
    sessions_list = pse;
    pse->next = NULL;
  }
  else {
    pse->next = sessions_list;
    sessions_list = pse;
  }
  trace(DBG_RTP, "RtpAllocSession: pse=%x", pse);
  return pse;
}

/*
 * Free a Session
 */
Public
void RtpFreeSession(Session *psession)
{
  Session *pse;

  trace(DBG_RTP, "RtpFreeSession: psession=%x", psession);
  if (psession == NULL) {
    trace(DBG_RTP, "RtpFreeSession: session already free");
    return;
  }
  for (pse = sessions_list; pse != NULL; pse = pse->next) {
    if (pse == psession) {
      sessions_list = pse->next;
      pse->next = NULL;
      if (pse == sessions_list)
        sessions_list = NULL;
      free(pse);
      return;
    }
  }
  sessions_list = NULL;
}

/** initialize variables for a session already allocated **/
Public
void RtpCreateSession(Session *pse, u_int32 group,
		       u_int16 rtp_port, u_int8 ttl)
{
  source_info *psi;

  trace(DBG_RTP, "RtpCreateSession");
  pse->sess_group = group;
  pse->sess_rtp_port = rtp_port;
  pse->sess_rtcp_port = rtp_port + 1;
  pse->sess_ttl = ttl;

  /* seq number initialization */
  pse->sess_rtp_seq = RtpCreateSeq();

  /* SSRC number initialization */
  my_ssrcid = RtpCreateSsrc(pse->sess_rtp_seq);
  pse->sess_rtp_hdr.ssrc = my_ssrcid;
  pse->sess_sr.ssrc = my_ssrcid;

  /* alloc source_info */
  psi = RtpCreateSinfo(pse, my_ssrcid);
  pse->sess_sinfo = psi;

  RtpInitSeq(&(psi->s), pse->sess_rtp_seq);

  RtpCreateSDES(pse);
}

Public
void RtpCloseSession(Session *pse)
{
  trace(DBG_RTP, "RtpCloseSession");
  RtpFreeSDES(pse);
  RtpDeleteSinfo(pse, my_ssrcid);
}

Public
source_info *
RtpGetSinfo(u_int32 ssrc)
{
  Channel *pchan = channels_list;

  /* find source by its ssrc else create sourec info */
  source_info *psi, *psilast, *pri;
  int found = 0;
  
  for (psilast = psi = pchan->session->sess_sinfo; !found && psi; psi = psi->next) {
    if (psi->ssrc == ssrc) {
      found = 1;
      pri = psi;
    }
    psilast = psi;
  }
  if (!found) { /* source not yet registered */
    if (psilast == NULL) { /* no source found */
      pchan->session->sess_sinfo = RtpCreateSinfo(pchan->session, ssrc);
      pri = pchan->session->sess_sinfo;
    }
    else {
      trace(DBG_RTP, "RtpGetSinfo: last->ssrc=%x ssrc=%x", psilast->ssrc,ssrc);
      psilast->next = RtpCreateSinfo(pchan->session, ssrc);
      pri = psilast->next;
    }
  }
  return pri;
}

Public
void RtpRefreshSDES(Session *pse)
{
  sdes_item *scname, *sname, *semail, *stool, *sloc;

  trace(DBG_RTP, "SDES: pse=%x", pse);
  if (pse == NULL)
    return;

  scname = pse->sess_sdes;
  if (scname == NULL) return;
  scname->type = RTCP_SDES_CNAME;
  scname->len = strlen(rtpemail);
  scname->content = rtpemail;
  trace(DBG_RTP, "scname: %x %s", scname, scname->content);

  sname = scname->next;
  if (sname == NULL) return;
  sname->type = RTCP_SDES_NAME;
  sname->len = strlen(rtpname);
  sname->content = rtpname;
  trace(DBG_RTP, "sname: %x %s", sname, sname->content);

  semail = sname->next;
  if (semail == NULL) return;
  semail->type = RTCP_SDES_EMAIL;
  semail->len = strlen(rtpemail);
  semail->content = rtpemail;

  sloc = semail->next;
  if (sloc == NULL) return;
  sloc->type = RTCP_SDES_LOC;
  sloc->len = strlen(worldname);
  sloc->content = worldname;
  trace(DBG_RTP, "sloc: %x %s", sloc, sloc->content);

  stool = sloc->next;
  if (stool == NULL) return;
  stool->type = RTCP_SDES_TOOL;
  stool->len = strlen(toolname);
  stool->content = toolname;
  trace(DBG_RTP, "stool: %x %s", stool, stool->content);
}

Public
void RtpCreateHeader(Session *pse, rtp_hdr_t *rtp_hdr)
{
  struct timeval ts;
  u_int8 *hdr = (u_int8 *) rtp_hdr;
  u_int16 *hdr16 = (u_int16 *) rtp_hdr;

  assert(pse);
  rtp_hdr->version = RTP_VERSION;
  rtp_hdr->p = 0;
  rtp_hdr->x = 0;
  rtp_hdr->cc = 0;
  rtp_hdr->m = 0;
  rtp_hdr->pt = PAYLOAD_TYPE;
  rtp_hdr->seq = htons(++pse->sess_rtp_seq);
  gettimeofday(&ts, NULL);
  rtp_hdr->ts = htonl(ts.tv_sec*1000 + ts.tv_usec/1000);
  rtp_hdr->ssrc = htonl(my_ssrcid);

#ifdef DEBUG
  trace(DBG_RTP, "RTP: %02x%02x%02x%02x %02x%02x%02x%02x %02x%02x%02x%02x",
        hdr[0], hdr[1], hdr[2], hdr[3], hdr[4], hdr[5], hdr[6], hdr[7], hdr[8], hdr[9], hdr[10], hdr[11]);
#endif
}

Public
int RtpUpdateSeq(source *s, u_int16 seq)
{
  u_int16 udelta = seq - s->max_seq;
  const int MAX_DROPOUT = 3000;
  const int MAX_MISORDER = 100;
  const int MIN_SEQUENTIAL = 2;

  /*
   * Source is not valid until MIN_SEQUENTIAL packets with
   * sequential sequence numbers have been received.
   */
  if (s->probation) {
    /* packet is in sequence */
    if (seq == s->max_seq + 1) {
      s->probation--;
      s->max_seq = seq;
      if (s->probation == 0) {
	RtpInitSeq(s, seq);
	s->received++;
	return 1;
      }
    } else {
      s->probation = MIN_SEQUENTIAL - 1;
      s->max_seq = seq;
    }
    return 0;
  } else if (udelta < MAX_DROPOUT) {
    /* in order, with permissible gap */
    if (seq < s->max_seq) {
      /*
       * Sequence number wrapped - count another 64K cycle.
       */
      s->cycles += RTP_SEQ_MOD;
    }
    s->max_seq = seq;
  } else if (udelta <= RTP_SEQ_MOD - MAX_MISORDER) {
    /* the sequence number made a very large jump */
    if (seq == s->bad_seq) {
      /*
       * Two sequential packets -- assume that the other side
       * restarted without telling us so just re-sync
       * (i.e., pretend this was the first packet).
       */
      RtpInitSeq(s, seq);
    }
    else {
      s->bad_seq = (seq + 1) & (RTP_SEQ_MOD-1);
      return 0;
    }
  } else {
    /* duplicate or reordered packet */
  }
  s->received++;
  return 1;
}

#ifdef SSRC_OLD
Public
void updateSSRC(u_int32 ssrc)
{
    NetObject *poh;

    /* ssrc = ntohl(rtp_hdr->ssrc); */
    if ((poh = getObjectBySSRC(ssrc)) == 0) {
      warning("getObjectBySSRC: object not found\n");
    }
    else {
      if (poh->s == NULL) {
        warning("recvPacket: not yet sourced");
        poh->s = (source *) malloc(sizeof(source));
        /* RtpInitSeq(poh->s, session.sess_rtp_seq); */
      }
      /* (poh->s->received)++; */
    }
}
#endif /* SSRC_OLD */

