#include "global.h"
#include "parse.h"
#include "browsers.h"


/* doc parser */
Private
void docParser(char *l, WObject *pdoc)
{
  char *w;

  w = parseFileLine(l);
  w = parsePosition(w, pdoc);
  strcpy(pdoc->ext.host.url, w); w = strtok(NULL, SEP);
  pdoc->soh = SolidParser(w);
}

/* doc initialization from a file */
Private
void createDocFromFile(Fileline l)
{
  WObject *pdoc;

  pdoc = (WObject*) malloc(sizeof(WObject));
  memset(pdoc, 0, sizeof(WObject));    
  pdoc->noh.type = DOCTYPE;
  docParser(l, pdoc);
  strcpy(pdoc->h_name, DOCNAME);

  updateObjectIn3D(pdoc);
  setOptionalBuffer(pdoc);
  updateBB(pdoc);
  stilllist = addObjectToList(pdoc, stilllist);
  insertObjectIntoGrid(pdoc);
} 

/* intersection: stop */
Private
void docIntersect(WObject *pwoh, WObject *pwohold, WObject *pdoc)
{
  copyPositionAndBB(pwohold, pwoh);
}

/* view */
Private
void docMethode0(WObject *pdoc, long sec, long usec)
{
#if defined(WITHWGET) & defined(WITHINTERPS)
  viewps(pdoc->ext.host.url);
#else
#if defined(WITHNETSCAPE) & defined(WITHINTERPS)
  trace(DBG_TOOL, "Wmgt: browser on %s", pdoc->ext.host.url);
  startbrowser(pdoc->ext.host.url);
#endif
#endif /* defined(WITHWGET) & defined(WITHINTERPS) */
}

/* print */
Private
void docMethode1(WObject *pdoc, long sec, long usec)
{
#if defined(WITHWGET) & defined(WITHA2PS)
  printps(pdoc->ext.host.url);
#else
#if defined(WITHNETSCAPE) & defined(WITHA2PS)
  trace(DBG_TOOL, "Wmgt: browser on %s", pdoc->ext.host.url);
  startbrowser(pdoc->ext.host.url);
#endif
#endif /* defined(WITHWGET) & defined(WITHA2PS) */
}

/* functions initialization */
Public
void initDocFuncList(void)
{
  generalFuncList[DOCTYPE].createFromFileline = createDocFromFile;
  generalFuncList[DOCTYPE].whenIntersect = docIntersect;
  
  propertiesnumber[DOCTYPE] = 0;

  strcpy(generalMethodList[0][DOCTYPE].name, "view");
  generalMethodList[0][DOCTYPE].method = docMethode0;
  strcpy(generalMethodList[1][DOCTYPE].name, "print");
  generalMethodList[1][DOCTYPE].method = docMethode1;
}
