#include "global.h"
#include "parse.h"
#include "move.h"
#include "audio.h"


#define M_2PI	6.28318530717958647692

/* angular variation modulo 2PI */
Private
float deltaAngle(float a1, float a2)
{
  float d;

  d = a1 - a2;
  d -= M_2PI * ((int)(d / M_2PI));
  return d;
}

/* door parser */
Private
void doorParser(char *l, WObject *pdoor)
{
  char *w;
  Fileline str;

  l = parseName(l, pdoor->ext.door.named, pdoor->ext.door.name);
  w = parseFileLine(l);
  /* hinge */
  pdoor->ext.door.center.v[0] = (float) atof(w); w = strtok(NULL, SEP);
  pdoor->ext.door.center.v[1] = (float) atof(w); w = strtok(NULL, SEP);
  pdoor->ext.door.center.v[2] = (float) atof(w); w = strtok(NULL, SEP);
  pdoor->a1 = (float) atof(w); w = strtok(NULL, SEP);
  pdoor->ext.door.aopen = (float) atof(w); w = strtok(NULL, SEP);
  pdoor->ext.door.aclose = (float) atof(w); w = strtok(NULL, SEP);
  pdoor->ext.door.aspeed = (float) atof(w);  w = strtok(NULL, SEP);
  pdoor->ext.door.size.v[0] = (float) atof(w);  w = strtok(NULL, SEP);
  strcpy(str, w);
  createNetObjectFromString(&(pdoor->noh), str, PERMANENT);
  w = strtok(NULL, SEP);
  pdoor->soh = SolidParser(w);  
  pdoor->x = pdoor->ext.door.center.v[0] +
             pdoor->ext.door.size.v[0] * (float) cos((double)pdoor->a1);
  pdoor->y = pdoor->ext.door.center.v[1] +
             pdoor->ext.door.size.v[0] * (float) sin((double)pdoor->a1);
  pdoor->z = pdoor->ext.door.center.v[2];
  if (pdoor->ext.door.aclose == pdoor->a1)
    pdoor->ext.door.status = DOORCLOSED;
  else
    pdoor->ext.door.status = DOOROPENED;
  if (pdoor->ext.door.named) {
    trace(DBG_FORCE, "doorname = %s", pdoor->ext.door.name);
    setWObjectName(pdoor, pdoor->ext.door.name);
  }
}

/* update times array */
Private
void doorUpdateTime(long sec, long usec, float *lasting, WObject *pdoor)
{
  if (pdoor->ext.door.move.deltaa.v[0] == pdoor->ext.door.aspeed)
    pdoor->ext.door.move.remaintime = MINI( ABSF(deltaAngle(pdoor->a1,
      pdoor->ext.door.aopen) / pdoor->ext.door.move.deltaa.v[0]),
      pdoor->ext.door.move.remaintime );
  else 
    pdoor->ext.door.move.remaintime = MINI( ABSF(deltaAngle(pdoor->a1,
      pdoor->ext.door.aclose) / pdoor->ext.door.move.deltaa.v[0]),
      pdoor->ext.door.move.remaintime );

  *lasting = (float) (sec - pdoor->ext.door.move.sec) +
    (float) (usec - pdoor->ext.door.move.usec) / MILLION;
  if (*lasting < pdoor->ext.door.move.remaintime) {
    pdoor->ext.door.move.remaintime -= *lasting;
    pdoor->ext.door.move.sec = sec;
    pdoor->ext.door.move.usec = usec;
  }
  else {
    *lasting = pdoor->ext.door.move.remaintime;
    pdoor->ext.door.move.remaintime = 0;
    pdoor->ext.door.move.sec = pdoor->ext.door.move.usec = 0;
  }
}

/* equations system handling imposed motions */
Private
void doorChangePosition(float lasting, WObject *pdoor)
{
  pdoor->a1 += lasting * pdoor->ext.door.move.deltaa.v[0];
  pdoor->x = pdoor->ext.door.center.v[0] +
             pdoor->ext.door.size.v[0] * (float) cos((double)pdoor->a1);
  pdoor->y = pdoor->ext.door.center.v[1] +
             pdoor->ext.door.size.v[0] * (float) sin((double)pdoor->a1);
  pdoor->z = pdoor->ext.door.center.v[2];
}

/* condition to do position modifications */
Private
int doorChange(WObject *pdoor)
{
  return (pdoor->ext.door.move.remaintime > 0.0005) ? TRUE : FALSE;
}

/* open */
Private
void doorMethode0(WObject *pdoor, long sec, long usec)
{
  if (pdoor->ext.door.status == DOOROPENED)
    return;
  if (pdoor->ext.door.status == DOORLOCKED)
    return;
  pdoor->ext.door.move.deltap.v[0] = 0;
  pdoor->ext.door.move.deltap.v[1] = 0;
  pdoor->ext.door.move.deltap.v[2] = 0;
  pdoor->ext.door.move.deltaa.v[0] = pdoor->ext.door.aspeed;
  pdoor->ext.door.move.deltaa.v[1] = 0;
  pdoor->ext.door.move.deltaa.v[2] = 0;
  pdoor->ext.door.move.sec = sec;
  pdoor->ext.door.move.usec = usec;
  pdoor->ext.door.move.remaintime = ABSF(deltaAngle(pdoor->a1,
      pdoor->ext.door.aopen) / pdoor->ext.door.move.deltaa.v[0]);
  playsound(DOOROPENSND);
  pdoor->ext.door.status = DOOROPENED;
}

/* close */
Private
void doorMethode1(WObject *pdoor, long sec, long usec)
{
  if (pdoor->ext.door.status == DOORCLOSED)
    return;
  pdoor->ext.door.move.deltap.v[0] = 0;
  pdoor->ext.door.move.deltap.v[1] = 0;
  pdoor->ext.door.move.deltap.v[2] = 0;
  pdoor->ext.door.move.deltaa.v[0] = -pdoor->ext.door.aspeed;
  pdoor->ext.door.move.deltaa.v[1] = 0;
  pdoor->ext.door.move.deltaa.v[2] = 0;
  pdoor->ext.door.move.sec = sec;
  pdoor->ext.door.move.usec = usec;
  pdoor->ext.door.move.remaintime = ABSF(deltaAngle(pdoor->a1,
      pdoor->ext.door.aclose) / pdoor->ext.door.move.deltaa.v[0]);
  playsound(DOORCLOSESND);
  pdoor->ext.door.status = DOORCLOSED;
}

/* unlock */
Private
void doorMethode2(WObject *pdoor, long sec, long usec)
{
  switch (pdoor->ext.door.status) {
  case DOORLOCKED:
    pdoor->ext.door.status = DOORUNLOCKED;
  default:
    break;
  }
}

/* lock */
Private
void doorMethode3(WObject *pdoor, long sec, long usec)
{
  switch (pdoor->ext.door.status) {
  case DOORUNLOCKED:
  case DOORCLOSED:
    pdoor->ext.door.status = DOORLOCKED;
  default:
    break;
  }
}

/* create a door from the network */
Private
void createDoorFromNetwork(WObject *pdoor, Payload *ppl)
{
  strcpy(pdoor->h_name, DOORNAME);
  pdoor->ext.door.move.remaintime = 0.0;
  pdoor->changeflag = FALSE;
  setOptionalBuffer(pdoor);
  updateObjectIn3D(pdoor);
  updateBB(pdoor);
  mobilelist = addObjectToList(pdoor, mobilelist);
  insertObjectIntoGrid(pdoor);
  setAllProperties((NetObject *) pdoor, ppl);
} 

/* door initialization from a file */
Private
void createDoorFromFile(Fileline l)
{
  WObject *pdoor;

  pdoor = (WObject*) malloc(sizeof(WObject));
  memset(pdoor, 0, sizeof(WObject));    
  pdoor->noh.type = DOORTYPE;
  doorParser(l, pdoor);
  strcpy(pdoor->h_name, DOORNAME);
  pdoor->ext.door.move.remaintime = 0.0;
  pdoor->changeflag = FALSE;
  updateObjectIn3D(pdoor);
  setOptionalBuffer(pdoor);
  updateBB(pdoor);
  mobilelist = addObjectToList(pdoor, mobilelist);
  insertObjectIntoGrid(pdoor);
} 

/* update a door towards the network */
Private
int updateDoorToNetwork(WObject *pdoor, WObject *polddoor)
{
  int change = FALSE;
  
  if ((pdoor->x != polddoor->x) || (pdoor->y != polddoor->y)) {
    declareDelta(&(pdoor->noh), DOORPROPXY);
    change = TRUE;
  }
  if (pdoor->a1 != polddoor->a1) {
    declareDelta(&(pdoor->noh), DOORPROPA1);
    change = TRUE;
  }
  return change;
}

/* intersect with an user: stop */
Private
void doorIntersect(WObject *pwoh, WObject *pwohold, WObject *pdoor)
{
  copyPositionAndBB(pwohold, pwoh);
}

/* functions initialization */
Public
void initDoorFuncList(void)
{
  generalFuncList[DOORTYPE].createFromFileline = createDoorFromFile;
  generalFuncList[DOORTYPE].createFromNetwork = createDoorFromNetwork;  
  generalFuncList[DOORTYPE].change = doorChange;
  generalFuncList[DOORTYPE].updateTime = doorUpdateTime;
  generalFuncList[DOORTYPE].changePosition = doorChangePosition;
  generalFuncList[DOORTYPE].updateToNetwork = updateDoorToNetwork;
  generalFuncList[DOORTYPE].whenIntersect = doorIntersect;

  propertiesnumber[DOORTYPE] = DOORPROPERTIES;

  setFuncList[DOORPROPXY][DOORTYPE].pf = set_xy;
  setFuncList[DOORPROPZ][DOORTYPE].pf = set_z;
  setFuncList[DOORPROPA1][DOORTYPE].pf = set_a1;
  setFuncList[DOORPROPHNAME][DOORTYPE].pf = set_hname;
  getFuncList[DOORPROPXY][DOORTYPE].pf = get_xy;
  getFuncList[DOORPROPZ][DOORTYPE].pf = get_z;
  getFuncList[DOORPROPA1][DOORTYPE].pf = get_a1;
  getFuncList[DOORPROPHNAME][DOORTYPE].pf = get_hname;

  strcpy(generalMethodList[0][DOORTYPE].name, "Open");
  generalMethodList[0][DOORTYPE].method = doorMethode0;
  strcpy(generalMethodList[1][DOORTYPE].name, "Close");
  generalMethodList[1][DOORTYPE].method = doorMethode1;
  strcpy(generalMethodList[2][DOORTYPE].name, "Unlock");
  generalMethodList[2][DOORTYPE].method = doorMethode2;
  strcpy(generalMethodList[3][DOORTYPE].name, "Lock");
  generalMethodList[3][DOORTYPE].method = doorMethode3;

  defmaxlasting[DOORTYPE] = DOORDEFMAXLAST;
}
