#include "global.h"
#include "parse.h"
#include "supportfuncs.h"
#include "audio.h"
#include "net_global.h"


extern void quitWorld();


/* gate parser */
Private
void gateParser(char *l, WObject *pgate)
{
  char *w;

  w = parseFileLine(l);
  w = parsePosition(w, pgate);
  strcpy(pgate->ext.gate.url, w); w = strtok(NULL, SEP);
  strcpy(pgate->ext.gate.chan_str, w); w = strtok(NULL, SEP);
  pgate->soh = SolidParser(w);
}

/* create a gate from a fileline */
Private
void createGateFromFile(Fileline l)
{
  WObject *pgate;

  pgate = (WObject*) malloc(sizeof(WObject));
  memset(pgate, 0, sizeof(WObject));    
  pgate->noh.type = GATETYPE;
  gateParser(l, pgate);
  strcpy(pgate->h_name, GATENAME);
  updateObjectIn3D(pgate);
  setOptionalBuffer(pgate);
  updateBB(pgate);
  stilllist = addObjectToList(pgate, stilllist);
#define GOTHROUGH
  insertObjectIntoGrid(pgate);
} 

/* go */
Private
void gateMethode0(WObject *pgate, long sec, long usec)
{
  char newurl[URL_LEN], newchan_str[CHAN_LEN];

  strncpy(newurl, pgate->ext.gate.url, sizeof(newurl));
  if (strcmp(newurl, urlinitial) == 0) {
    sprintf(pgate->ext.gate.chan_str, "%s/%u/%d",
            groupinitial, portinitial, ttlorigin);
    trace(DBG_IPMC, "world initial = %s", pgate->ext.gate.chan_str);
  }
  strncpy(newchan_str, pgate->ext.gate.chan_str, sizeof(newchan_str));
  trace(DBG_IPMC, "go %s@%s", newurl, newchan_str);
  quitWorld();
  quitChannel(channels_list);
  newChannel(newchan_str);
  newWorld(newurl);
#ifdef WITHAUDIO
  playsound(GATESND);
  if (audiobusy)
    startaudio(newchan_str);
#endif
}

/* when an intersection occurs */
Private
void gateIntersect(WObject *pwoh, WObject *pwohold, WObject *pgate)
{
#ifdef GOTHROUGH
  /* Removed because of crash... */
  if (pwoh->noh.type == USERTYPE)
    gateMethode0(pgate, 0, 0);
  else
    copyPositionAndBB(pwohold, pwoh);
#else
  copyPositionAndBB(pwohold, pwoh);
#endif
}

/* gate functions initialization */
Public
void initGateFuncList(void)
{
  generalFuncList[GATETYPE].createFromFileline = createGateFromFile;
  generalFuncList[GATETYPE].whenIntersect = gateIntersect;
  
  propertiesnumber[GATETYPE] = 0;

  strcpy(generalMethodList[0][GATETYPE].name, "Teleport");
  generalMethodList[0][GATETYPE].method = gateMethode0;
}
