#include "global.h"
#include "names.h"


struct hash_elt htable[HASH_SIZE];


unsigned int do_hash(char *pname)
{
  u_int32 ret;

  for (ret = 0; *pname != '\0'; pname++) {
    ret = ((ret << 8) + *pname) % HASH_SIZE;
  }
  return ret;
}

void initNaming()
{
  int i;
  
  for (i = 0; i < HASH_SIZE; i++)
    strcpy(htable[i].name, "");
}

Public
WObject *
getWObjectFromName(char *pname)
{
  u_int32 hval;

  hval = do_hash(pname);
  while (1) {
    if (*(htable[hval].name) == '\0')
      return NULL;
    if (!strcmp(htable[hval].name, pname))
      return htable[hval].obj;
    hval++;
  }
}

Public
void delWObject(char *pname)
{
  u_int32 hval;

  hval = do_hash(pname);
  while (1) {
    if (*(htable[hval].name) == '\0')
      return;
    if (!strcmp(htable[hval].name, pname)) {
      strcpy(htable[hval].name, DELETED);
      return;
    }
    hval++;
  }
}

Public
void setWObjectName(WObject *pobj, char *pname)
{
  u_int32 hval;

  hval = do_hash(pname);
  while (1) {
    if ((*(htable[hval].name) == '\0') ||
	(!strcmp(htable[hval].name, DELETED))) {
      strcpy(htable[hval].name, pname);
      htable[hval].obj = pobj;
      return;
    }
    hval++;
  }
}
