#ifndef OBJECTS_H
#define OBJECTS_H

#include "move.h"
#include "grid.h"

#include "user.h"	/* 1 */
#include "wall.h"	/* 2 */
#include "door.h"	/* 3 */
#include "caul.h"	/* 4 */
#include "ball.h"	/* 5 */
#include "step.h"	/* 6 */
#include "earth.h"	/* 7 */
#include "gate.h"	/* 8 */
#include "host.h"	/* 9 */
#include "board.h"	/* 10 */
#include "web.h"	/* 11 */
#include "vrml.h"	/* 12 */
#include "button.h"	/* 13 */
#include "animator.h"	/* 14 */
#include "lift.h"	/* 15 */
#include "rocket.h"	/* 16 */
#include "cell.h"	/* 17 */
#include "aoi.h"        /* 18 */
#include "doc.h"        /* 19 */
#include "walls.h"      /* 20 */
#include "entry.h"      /* 21 */


#define TYPESNUMBER     21      /* number of object types */

/* nature of object motion */
#define PERMANENT	1
#define VOLATILE	0


/* WObject structure */
typedef struct {
  NetObject noh;		/* reserved field for network */
  Solid soh;			/* reserved field for 3D */
  char h_name[HNAME_LEN];	/* understandable name of an object */
  float x;			/* x position */
  float y;			/* y position */
  float z;			/* z position */
  float a1;			/* angle plan xy axe z */
  float a2;			/* angle plan xz axe y */
  float a3;			/* angle plan yz axe x */
  V3 bb_center;			/* Bounding Box's position */
  V3 bb_size;			/* Bounding Box's center */
  long secs;			/* time in sec of last permanent movement */
  long usecs;			/* time in usec of last permanent movement */
  int changeflag;		/* flag */
  int ispointed;		/* flag */
  u_int8 entryflag;		/* entry flag */
  union {			/* spedific fields of each object */       
    User user;			/* 1 */
    Wall wall;            	/* 2 */
    Door door;			/* 3 */
    Cauldron cauldron;		/* 4 */
    Ball ball;			/* 5 */
    Step step;			/* 6 */
    Earth earth;		/* 7 */
    Gate gate;			/* 8 */
    Host host;			/* 9 */
    Board board;		/* 10 */
    Web web;			/* 11 */
    Vrml vrml;			/* 12 */
    Button button;		/* 13 */
    Animator animator;		/* 14 */
    Lift lift;			/* 15 */
    Rocket rocket;		/* 16 */
    Cell cell;			/* 17 */
    Aoi  aoi;                   /* 18 */
    Doc  doc;                   /* 19 */
  } ext;            
} WObject;

typedef struct _ObjectList {
  WObject *pobject;
  struct _ObjectList *next;
} *ObjectList;

typedef ObjectList Grid[GRIDL][GRIDW][GRIDH];

typedef struct {
  void (*pf) (WObject *, Payload *);
} FuncList[PROPSNUMBER][TYPESNUMBER];

typedef char Fileline[LINESIZE];

typedef struct {
  void (*createFromFileline) (char *);
  void (*createFromNetwork) (WObject *, Payload *);
  int  (*change) (WObject *);
  void (*updateTime) (long, long, float *, WObject *);
  void (*changePosition) (float, WObject *);
  int  (*updateToNetwork) (WObject *, WObject *);
  void (*whenIntersect) (WObject *, WObject *, WObject *);
  void (*changePermanent) (float, WObject *);
  void (*whenWallIntersect) (WObject *, WObject *, V3 *);
} GeneralFuncList[TYPESNUMBER];

typedef struct {
  char name[HNAME_LEN];
  int  type;
  void (*initfunc) (void);
} GeneralInitList;

typedef struct {
  char name[HNAME_LEN];
  void (*method) (WObject *, long, long);
} GeneralMethodList[BUTTONSNUMBER][TYPESNUMBER];


#endif /* OBJECTS_H */
