#include "global.h"
#include "move.h"


/* mise a jour des tableaux du temps */
Private
void rocketUpdateTime(long sec, long usec, float *lasting, WObject *procket)
{
  *lasting = (float)(sec - procket->ext.rocket.move.sec) +
    ((float)(usec - procket->ext.rocket.move.usec) / MILLION);

  if (*lasting < procket->ext.rocket.move.remaintime) {
    procket->ext.rocket.move.remaintime -= *lasting;
    procket->ext.rocket.move.sec = sec;
    procket->ext.rocket.move.usec = usec;
  }
  else {
    *lasting = procket->ext.rocket.move.remaintime;
    procket->ext.rocket.move.remaintime = 0;
    procket->ext.rocket.move.sec = procket->ext.rocket.move.usec = 0;

    /* The rocket has spent its movement => destroyed */
    ObjectDelete(procket);
  }
}

/* systeme d'equations regissant les mouvements imposes */
Private
void rocketChangePosition(float lasting, WObject *procket)
{
  procket->x += lasting * procket->ext.rocket.move.deltap.v[0];
  procket->y += lasting * procket->ext.rocket.move.deltap.v[1];
  procket->z += lasting * procket->ext.rocket.move.deltap.v[2];
  procket->a1 += lasting * procket->ext.rocket.move.deltaa.v[0];
  procket->a2 += lasting * procket->ext.rocket.move.deltaa.v[1];
}

/* condition pour entreprendre des modifications de position */
Private
int rocketChange(WObject *procket)
{
  return (procket->ext.rocket.move.remaintime > 0.0005) ? TRUE : FALSE;
}

Private
void rocketMethod(int methnum, WObject *puser, long sec, long usec)
{
  WObject *procket;
  char geometry[80];

  procket = (WObject*) malloc(sizeof(WObject));
  memset(procket, 0, sizeof(WObject));    
  procket->noh.type = ROCKETTYPE;
  strcpy(procket->h_name, ROCKETNAME);

  procket->ext.rocket.lspeed = ROCKETSPEED;
  procket->ext.rocket.remaint = ROCKETREMAINT;
  procket->ext.rocket.move.deltap.v[0] =
    (float)(cos((double)puser->a1))* procket->ext.rocket.lspeed;
  procket->ext.rocket.move.deltap.v[1] =
    (float)(sin((double)puser->a1))* procket->ext.rocket.lspeed;
  procket->ext.rocket.move.deltap.v[2] = 0;
  procket->ext.rocket.move.deltaa.v[0] = 0;
  procket->ext.rocket.move.deltaa.v[1] = 0;
  procket->ext.rocket.move.deltaa.v[2] = 0;
  procket->ext.rocket.move.sec = sec;
  procket->ext.rocket.move.usec = usec;
  procket->ext.rocket.move.remaintime = procket->ext.rocket.remaint;
  procket->x = puser->x + procket->ext.rocket.move.deltap.v[0] * 0.2;
  procket->y = puser->y + procket->ext.rocket.move.deltap.v[1] * 0.2;
  procket->z = puser->z;
  procket->a1 = puser->a1;
  procket->a2 = puser->a2;
  procket->a3 = puser->a3;

  if (methnum == DARTCREAT) {
    sprintf(geometry,"box,size=%s,diffuse=%s", DARTGEOMETRY, ROCKETCOLOR);
    procket->ext.rocket.type = DARTCREAT;
  }
  else {
    sprintf(geometry,"sphere,radius=%s,diffuse=%s", BULLETRADIUS, ROCKETCOLOR);
    procket->ext.rocket.type = BULLETCREAT;
  }
  procket->soh = SolidParser(geometry);  
  updateObjectIn3D(procket);
  setOptionalBuffer(procket);
  procket->secs = -1.0;
  procket->usecs = 0.0;

  updateBB(procket);
  mobilelist = addObjectToList(procket, mobilelist);
  insertObjectIntoGrid(procket);
  createNetObject((NetObject *) procket, VOLATILE);
  declareCreation(&(plocaluser->noh));
}

/* creation: this method is invisible, called by user */
Private
void rocketMethode0(WObject *puser, long sec, long usec)
{
  rocketMethod(BULLETCREAT, puser, sec, usec);
}

/* creation: this method is invisible, called by the user */
Private
void rocketMethode1(WObject *puser, long sec, long usec)
{
  rocketMethod(DARTCREAT, puser, sec, usec);
}

/* rocket creation from the network */
Private
void rockectCreateFromNetwork(WObject *procket, Payload *ppl)
{
  char geometry[80];

  strcpy(procket->h_name, ROCKETNAME);
  procket->ext.rocket.move.remaintime = 0.0;
  procket->changeflag = FALSE;

  if (procket->ext.rocket.type == DARTCREAT)
    sprintf(geometry,"box,size=%s,diffuse=%s", DARTGEOMETRY, ROCKETCOLOR);
  else
    sprintf(geometry, "sphere,radius=%s,diffuse=%s", BULLETRADIUS, ROCKETCOLOR);

  procket->soh = SolidParser(geometry);
  setOptionalBuffer(procket);
  updateObjectIn3D(procket);
  procket->ext.rocket.lspeed = ROCKETSPEED;
  procket->ext.rocket.remaint = ROCKETREMAINT;
  procket->secs = -1.0;
  updateBB(procket);
  mobilelist = addObjectToList(procket, mobilelist);
  insertObjectIntoGrid(procket);
  setAllProperties((NetObject *) procket, ppl);
} 

/* rocket update to the network */
Private
int updateRocketToNetwork(WObject *procket, WObject *poldrocket)
{
  int change = FALSE;
  
  if ((procket->x != poldrocket->x) || (procket->y != poldrocket->y)) {
    declareDelta(&(procket->noh), ROCKETPROPXY);
    change = TRUE;
  }
  if (ABSF(procket->z - poldrocket->z) > ROCKETDELTAZ) change = TRUE;
  if (procket->a1 != poldrocket->a1) change = TRUE;
  if (procket->a2 != poldrocket->a2) change = TRUE;
  return change;
}

/* intersection: nothing! */
Private
void rocketIntersect(WObject *pwoh, WObject *pwohold, WObject *procket)
{
  /* Just to prevent infinite loops.... */
  copyPositionAndBB(pwohold, pwoh);
  /* ObjectDelete(procket); */
}

Private
void rocketWallIntersect(WObject *procket, WObject *poldrocket, V3 *norm)
{
  float Dx, Dy, Dxn, Dyn;
  float Vx, Vy, n;
  float scalar;

  /* We do not change the position, we only change the deltas */
  copyPositionAndBB(poldrocket, procket);

  Vx = norm->v[0];
  Vy = norm->v[1];
  Dx = procket->ext.rocket.move.deltap.v[0];
  Dy = procket->ext.rocket.move.deltap.v[1];

  n = sqrt(Dx * Dx + Dy * Dy);
  Dxn = Dx / n;
  Dyn = Dy / n;
  scalar = Dxn * Vx + Dyn * Vy;
  if (scalar >= 0.0)
    return;
    
  procket->ext.rocket.move.deltap.v[0] = (Dxn - 2 * scalar * Vx) * n;
  procket->ext.rocket.move.deltap.v[1] = (Dyn - 2 * scalar * Vy) * n;
}

/* rocket functions initialization */
Public
void initRocketFuncList(void)
{
  generalFuncList[ROCKETTYPE].createFromNetwork = rockectCreateFromNetwork;  
  generalFuncList[ROCKETTYPE].change = rocketChange;
  generalFuncList[ROCKETTYPE].updateTime = rocketUpdateTime;
  generalFuncList[ROCKETTYPE].changePosition = rocketChangePosition;
  generalFuncList[ROCKETTYPE].updateToNetwork = updateRocketToNetwork;
  generalFuncList[ROCKETTYPE].whenIntersect = rocketIntersect;
  generalFuncList[ROCKETTYPE].whenWallIntersect = rocketWallIntersect;

  propertiesnumber[ROCKETTYPE] = ROCKETPROPERTIES;

  setFuncList[ROCKETPROPXY][ROCKETTYPE].pf = set_xy;
  setFuncList[ROCKETPROPZ][ROCKETTYPE].pf = set_z;
  setFuncList[ROCKETPROPA1][ROCKETTYPE].pf = set_a1;
  setFuncList[ROCKETPROPHNAME][ROCKETTYPE].pf = set_hname;
  setFuncList[ROCKETPROPA2][ROCKETTYPE].pf = set_a2;
  getFuncList[ROCKETPROPXY][ROCKETTYPE].pf = get_xy;
  getFuncList[ROCKETPROPZ][ROCKETTYPE].pf = get_z;
  getFuncList[ROCKETPROPA1][ROCKETTYPE].pf = get_a1;
  getFuncList[ROCKETPROPHNAME][ROCKETTYPE].pf = get_hname;
  getFuncList[ROCKETPROPA2][ROCKETTYPE].pf = get_a2;

  strcpy(generalMethodList[BULLETCREAT][ROCKETTYPE].name, "");
  generalMethodList[BULLETCREAT][ROCKETTYPE].method = rocketMethode0;
  strcpy(generalMethodList[DARTCREAT][ROCKETTYPE].name, "");
  generalMethodList[DARTCREAT][ROCKETTYPE].method = rocketMethode1;

  defmaxlasting[ROCKETTYPE] = ROCKETDEFMAXLAST;
}
