#include "global.h"
#include "parse.h"
#include "browsers.h"


/* vrml parser */
Private
void vrmlParser(char *l, WObject *pvrml)
{
  char *w;

  w = parseFileLine(l);
  w = parsePosition(w, pvrml);
  strcpy(pvrml->ext.host.url, w); w = strtok(NULL, SEP);
  pvrml->soh = SolidParser(w);
}

/* create from a fileline */
Private
void createVrmlFromFile(Fileline l)
{
  WObject *pvrml;

  pvrml = (WObject*) malloc(sizeof(WObject));
  memset(pvrml, 0, sizeof(WObject));    
  pvrml->noh.type = VRMLTYPE;
  vrmlParser(l, pvrml);
  strcpy(pvrml->h_name, VRMLNAME);
  updateObjectIn3D(pvrml);
  setOptionalBuffer(pvrml);
  updateBB(pvrml);
  stilllist = addObjectToList(pvrml, stilllist);
  insertObjectIntoGrid(pvrml);
} 

/* object intersects: stop */
Private
void vrmlIntersect(WObject *pwoh, WObject *pwohold, WObject *pvrml)
{
  copyPositionAndBB(pwohold, pwoh);
}

/* browser */
Private
void vrmlMethode0(WObject *pvrml, long sec, long usec)
{
  static char url[URL_LEN];

  strncpy(url, pvrml->ext.host.url, sizeof(url));
  /* quitbrowser(); */
#ifdef WITHVRML
  startvrml(url);
#endif
}

/* functions initialization */
Public
void initVrmlFuncList(void)
{
  generalFuncList[VRMLTYPE].createFromFileline = createVrmlFromFile;
  generalFuncList[VRMLTYPE].whenIntersect = vrmlIntersect;
  
  propertiesnumber[VRMLTYPE] = 0;

  strcpy(generalMethodList[0][VRMLTYPE].name, "open");
  generalMethodList[0][VRMLTYPE].method = vrmlMethode0;
}
