/*
 *  keys.h
 *
 *  This file is part of the WFA compression project
 *  Copyright (C) 1994-1998 Ullrich Hafner <hafner@bigfoot.de>,
 *                          department of computer science, chair II
 */

/*
 *  $Date: 1998/12/20 11:17:33 $
 *  $Author: hafner $
 *  $Revision: 1.6 $
 *  $State: Exp $
 */

#ifndef _KEYS_H
#define _KEYS_H

#include <gtk/gtk.h>
#include <proplist.h>

typedef struct key_widget
{
   GtkWidget	*control;
   GtkWidget	*meta;
   GtkWidget	*shift;
   GtkWidget	*keyname;
   GtkWidget	*combo;
   GtkWidget	*toggle;
   char		*keytext;
   void		*data;
   void		(*update) (const struct key_widget *);
} key_widget_t;

GtkWidget *
key_dialog (const char *keytext, GtkTooltips *tooltips, const char *infotext,
	    void (*update) (const key_widget_t *data), void *data);
void
update_keywidget (key_widget_t *kw, const char *keytext);

#endif /* not _KEYS_H */

