/*
 *  Copyright (C) 1998,9 by Marco G"otze.
 *
 *  This code is part of the wmpinboard source package, which is
 *  distributed under the terms of the GNU GPL2.
 */

#ifndef FEATURES_H_INCLUDED
#define FEATURES_H_INCLUDED

/******************** START OF USER-EDITABLE SECTION *************************/

/*
 * this defines the amount of idle time after which edit mode is terminated;
 * the value is interpreted as seconds and has to be greater than or equal to
 * 5, or else the default value of 60s will be used
 */
#define TIMEOUT 60

/*
 * #undef this to disable simulated wear & tear of notes
 */
#define CREASES

/*
 * #define one of these to build a version of wmpinboard that's optimized for
 * low color depths (palette modes)--but be warned: this won't look pretty;
 * implicitly #undef's CREASES (neither is recommended, let alone LOWESTCOLOR)
 */
#undef LOWCOLOR
#undef LOWESTCOLOR

/********************* END OF USER-EDITABLE SECTION **************************/

#if TIMEOUT < 5 && TIMEOUT != 0
#undef TIMEOUT
#define TIMEOUT 60
#endif

#ifdef LOWESTCOLOR
#define LOWCOLOR
#endif

#ifdef LOWCOLOR
#undef CREASES
#endif

#define DCLICK_LIMIT 500  /* ms */

#define FUNSTUFF

#endif  /* FEATURES_H_INCLUDED */

