#!/usr/bin/perl
#
# This a a config file parsing module for the xaw-wrapper package.
#
# When the package is loaded, all config files are read, and the info from 
# them is stored in $XawWrapper::incompat and $XawWrapper::wrapped and
# $XawWrapper::linkname
#
# GPL copyright by Joey Hess <joeyh@debian.org>.

package XawWrapper;

# When this module is loaded, all config files are automatically read.
sub import {
	ReadConfig("/usr/share/xaw-wrappers/config/");
	# Backwards compatability.
	if (-d "/usr/lib/xaw-wrappers/config") { 
		ReadConfig("/usr/lib/xaw-wrappers/config/");
	}
}

# Read in a configuration file.
#
# If the second parameter (optional) is true, then it is not fatal
# for the config file to not exist.
# 
# See README.packagers for config file format.
sub ReadConfigFile { ($fn,$notfatal)=@_;
	print "Reading config file $fn\n" if $ENV{XAW_WRAPPERS_DEBUG};
	open (CONFIG,"<$fn") || $notfatal || die "open $fn: $!\n";
	my %data={};
	while (<CONFIG>) {
		chomp;
		s/\s+/ /g;
		if (/^#/ eq undef) {
			if (/(.*?):\s?(.*)/) {
				$data{lc($1)}=$2;
			}
			else {
				foreach (split(/\s/, $data{incompat})) {
					s!/$!!;
					$incompat{$data{'link-name'}}{$_}=1;
				}
				print "$data{program} is wrapped by $data{wrapped}\n" if $ENV{XAW_WRAPPERS_DEBUG};
				$wrapped{$data{'link-name'}}=$data{wrapped};
				$program{$data{'link-name'}}=$data{program};
				%data={};
			}
		}
	}
	close CONFIG;

	foreach (split(/\s/, $data{incompat})) {
		s!/$!!;
		$incompat{$data{'link-name'}}{$_}=1;
	}
	print "$data{program} is wrapped by $data{wrapped}\n" if $ENV{XAW_WRAPPERS_DEBUG};
	$wrapped{$data{'link-name'}}=$data{wrapped};
	$program{$data{'link-name'}}=$data{program};
}

# Read in all config files in the passed config directory.
sub ReadConfig { my $config_dir=shift;
	opendir (CONFIGDIR,"$config_dir") || die "opendir $config_dir: $!\n";
	while ($fn=readdir(CONFIGDIR)) {
		if (!-d $config_dir.'/'.$fn) {
			ReadConfigFile($config_dir.'/'.$fn);
		}
	}
	closedir CONFIGDIR;
}

1
