/*
***************************************************************************

   X server for LibGGI - Default Keymap

   Copyright (C) 1999 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

***************************************************************************
*/

#ifndef _XGGI_KEYMAP_H
#define _XGGI_KEYMAP_H

/* XFree86 compability */
#define AltMask         Mod1Mask
#define NumLockMask     Mod2Mask
#define AltLangMask     Mod3Mask
#define KanaMask        Mod4Mask
#define ScrollLockMask  Mod5Mask


#define MIN_KEYCODE  8
#define MAX_KEYCODE  255
#define NUM_KEYCODES (MAX_KEYCODE - MIN_KEYCODE + 1)
#define GLYPHS_PER_KEY 4

static KeySym xggiKeymap[NUM_KEYCODES * GLYPHS_PER_KEY] = {
	XK_F1,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F2,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F3,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F4,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F5,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F6,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F7,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F8,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F9,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F10,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F11,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F12,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F13,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F14,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F15,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F16,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F17,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F18,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F19,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F20,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F21,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F22,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F23,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F24,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F25,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F26,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F27,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F28,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F29,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F30,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F31,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F32,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F33,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F34,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_F35,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_Caps_Lock,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Num_Lock,	XK_Pointer_EnableKeys,NoSymbol,	NoSymbol,
	XK_Scroll_Lock,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Multi_key,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Undo,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Redo,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Menu,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Cancel,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Print,	XK_Execute,	NoSymbol,	NoSymbol,
	XK_Execute,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Find,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Begin,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Clear,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Insert,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Select,	NoSymbol,	NoSymbol,	NoSymbol,
/*XK_Macro*/NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Help,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Execute,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Pause,	XK_Break,	NoSymbol,	NoSymbol,
	XK_Sys_Req,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Mode_switch,	XK_Multi_key,	NoSymbol,	NoSymbol,
	XK_Up,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_Down,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Left,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Right,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Prior,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Next,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Home,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_End,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_KP_Insert,	XK_KP_0,	NoSymbol,	NoSymbol,
	XK_KP_End,	XK_KP_1,	NoSymbol,	NoSymbol,
	XK_KP_Down,	XK_KP_2,	NoSymbol,	NoSymbol,
	XK_KP_Next,	XK_KP_3,	NoSymbol,	NoSymbol,
	XK_KP_Left,	XK_KP_4,	NoSymbol,	NoSymbol,
	XK_KP_Begin,	XK_KP_5,	NoSymbol,	NoSymbol,
	XK_KP_Right,	XK_KP_6,	NoSymbol,	NoSymbol,
	XK_KP_Home,	XK_KP_7,	NoSymbol,	NoSymbol,
	XK_KP_Up,	XK_KP_8,	NoSymbol,	NoSymbol,
	XK_KP_Prior,	XK_KP_9,	NoSymbol,	NoSymbol,
	XK_KP_F1,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_KP_F2,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_KP_F3,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_KP_F4,	NoSymbol,	NoSymbol,	NoSymbol,
	NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
	NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_KP_Add,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_KP_Subtract,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_KP_Multiply,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_KP_Divide,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_KP_Enter,	NoSymbol,	NoSymbol,	NoSymbol,
	NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
	NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
	NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
	NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
	NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
	NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
	NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_KP_Begin,	NoSymbol,	NoSymbol,	NoSymbol,
	NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_KP_Equal,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_KP_Delete,	XK_KP_Separator,NoSymbol,	NoSymbol,
	XK_KP_Delete,	XK_KP_Decimal,	NoSymbol,	NoSymbol,
	XK_KP_F1,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_KP_F2,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_KP_F3,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_KP_F4,	NoSymbol,	NoSymbol,	NoSymbol,
	NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
	NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
	NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
	NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
	NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Shift_L,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Shift_R,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Control_L,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Control_R,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Alt_L,	XK_Meta_L,	NoSymbol,	NoSymbol,
	XK_Alt_R,	XK_Meta_R,	NoSymbol,	NoSymbol,
	XK_Meta_L,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Meta_R,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Super_L,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Super_R,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Hyper_L,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Hyper_R,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Shift_Lock,	NoSymbol,	NoSymbol,	NoSymbol,
/*XK_Top_R*/NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
/*XK_Front_L*/NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,
/*XK_Front_R*/NoSymbol,	NoSymbol,	NoSymbol,	NoSymbol,

	XK_BackSpace,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Tab,		XK_ISO_Left_Tab,NoSymbol,	NoSymbol,
	XK_Linefeed,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Return,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Escape,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_Delete,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_space,	NoSymbol,	NoSymbol,	NoSymbol,

	XK_0,		XK_parenright,	NoSymbol,	NoSymbol,
	XK_1,		XK_exclam,	NoSymbol,	NoSymbol,
	XK_2,		XK_at,		NoSymbol,	NoSymbol,
	XK_3,		XK_numbersign,	NoSymbol,	NoSymbol,
	XK_4,		XK_dollar,	NoSymbol,	NoSymbol,
	XK_5,		XK_percent,	NoSymbol,	NoSymbol,
	XK_6,		XK_asciicircum,	NoSymbol,	NoSymbol,
	XK_7,		XK_ampersand,	NoSymbol,	NoSymbol,
	XK_8,		XK_asterisk,	NoSymbol,	NoSymbol,
	XK_9,		XK_parenleft,	NoSymbol,	NoSymbol,

	XK_a,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_b,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_c,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_d,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_e,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_f,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_g,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_h,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_i,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_j,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_k,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_l,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_m,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_n,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_o,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_p,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_q,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_r,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_s,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_t,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_u,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_v,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_w,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_x,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_y,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_z,		NoSymbol,	NoSymbol,	NoSymbol,

	XK_agrave,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_aacute,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_acircumflex,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_atilde,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_adiaeresis,	XK_Adiaeresis,	XK_dead_circumflex, XK_dead_caron,
	XK_aring,	XK_Aring,	XK_dead_diaeresis, XK_dead_abovering,
	XK_ae,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_ccedilla,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_egrave,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_eacute,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_ecircumflex,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_ediaeresis,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_igrave,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_iacute,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_icircumflex,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_idiaeresis,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_eth,		NoSymbol,	NoSymbol,	NoSymbol,
	XK_ntilde,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_ograve,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_oacute,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_ocircumflex,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_otilde,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_odiaeresis,	XK_Odiaeresis,	XK_dead_acute,	XK_dead_doubleacute,
	XK_multiply,	XK_division,	NoSymbol,	NoSymbol,
	XK_oslash,	XK_Ooblique,	NoSymbol,	NoSymbol,
	XK_ugrave,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_uacute,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_ucircumflex,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_udiaeresis,	XK_Udiaeresis,	XK_dead_diaeresis, NoSymbol,
	XK_yacute,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_thorn,	NoSymbol,	NoSymbol,	NoSymbol,
	XK_ssharp,	XK_question,	XK_backslash,   XK_questiondown,

	XK_grave,	XK_asciitilde,	NoSymbol,	NoSymbol,
	XK_minus,	XK_underscore,	NoSymbol,	NoSymbol,
	XK_equal,	XK_plus,	NoSymbol,	NoSymbol,
	XK_bracketleft,	XK_braceleft,	NoSymbol,	NoSymbol,
	XK_bracketright,XK_braceright,	NoSymbol,	NoSymbol,
	XK_semicolon,	XK_colon,	NoSymbol,	NoSymbol,
	XK_apostrophe,	XK_quotedbl,	NoSymbol,	NoSymbol,
	XK_backslash,	XK_bar,		NoSymbol,	NoSymbol,
	XK_less,	XK_greater,	XK_bar,		XK_brokenbar,
	XK_comma,	XK_less,	NoSymbol,	NoSymbol,
	XK_period,	XK_greater,	NoSymbol,	NoSymbol,
	XK_slash,	XK_question,	NoSymbol,	NoSymbol,

	XK_paragraph,	XK_onehalf,	XK_notsign,	NoSymbol,
	XK_plus,	XK_question,	XK_backslash,	XK_questiondown,
	XK_acute,	XK_grave,	XK_dead_cedilla,XK_dead_ogonek,
	XK_diaeresis,	XK_asciicircum,	XK_dead_tilde,	XK_dead_macron,
	XK_numbersign,	XK_asciitilde,	NoSymbol,	NoSymbol,
	XK_backslash,	XK_bar,		NoSymbol,	NoSymbol,
	XK_asciitilde,	XK_onehalf,	XK_notsign,	NoSymbol,
	XK_section,	XK_onehalf,	NoSymbol,	NoSymbol,
	XK_dead_acute,	XK_dead_grave,	XK_dead_cedilla,XK_dead_ogonek,
	XK_dead_diaeresis, XK_dead_circumflex, XK_dead_tilde, XK_dead_macron,
	XK_dead_circumflex, XK_degree,	XK_notsign,	NoSymbol,
	XK_dead_tilde,	XK_dead_circumflex, XK_asciitilde, XK_asciicircum,
	XK_dead_cedilla,XK_dead_diaeresis, XK_bracketright, NoSymbol,
	XK_dead_grave,	XK_dead_circumflex, XK_bracketleft, NoSymbol,

	XK_bar,		XK_section,	NoSymbol,	NoSymbol,
	XK_asciicircum,	XK_degree,	XK_notsign,	NoSymbol,
};

#endif /* _XGGI_KEYMAP_H */
