/*
	Disk IO and path parsing
*/


#ifndef DISK_H
#define DISK_H

extern int FILEHASEXTENSION(char *filename);
extern int ISPATHABSOLUTE(char *path);
extern int NUMDIRCONTENTS(char *path);

extern int COMPARE_PARENT_PATHS(char *path, char *parent);

extern int ISPATHDIR(char *path);
extern int ISLPATHDIR(char *path);
extern int ISPATHEXECUTABLE(char *path);

extern char *PathSubHome(char *path);
extern char **GetDirEntNames(char *parent);
extern char *ChangeDirRel(char *cpath, char *npath);
extern void StripAbsolutePath(char *path);
extern char *PrefixPaths(char *parent, char *child);
extern char *GetAllocLinkDest(char *link);
extern char *GetParentDir(char *path);

extern int FileCountLines(char *filename);
extern int DirHasSubDirs(char *path);
extern void SimplifyPath(char *path);

extern int CopyObject(
	char *target,
	char *source,
	int (*comferm_func)(char *, char *)
);


#ifdef __WIN32__
/*
 *	Windows path notation delimiters.
 */
# define PATH_SEP_CHAR	'\\'
# define PATH_SEP_STR	"\\"
# define CWD_STR	".\\"
#else
# define PATH_SEP_CHAR	'/'
# define PATH_SEP_STR	"/"
# define CWD_STR	"./"
#endif /* __WIN32__ */


#endif /* DISK_H */
