/*
 * Programm XBLAST V1.2.10 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * March 6th 1996
 * started August 1993
 *
 * File: xsetup.h 
 * header file for xsetup.c
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _XSETUP_H
#define _XSETUP_H

#ifdef _XSETUP_C
#define _EXTERN 
#else
#define _EXTERN extern
#endif

#ifdef __STDC__
_EXTERN void parse_commandline (int argc, char *argv[]);
_EXTERN int interactive_config (char *argv0);
_EXTERN void interactive_setup (int num_player);
_EXTERN void config_from_database (XBConfig *config);
_EXTERN void merge_default_databases (XBConfig *config);
_EXTERN void setup_from_database (XBSettings *setup);
_EXTERN void player_strings_from_database (PlayerStrings *st);
_EXTERN void save_setup (XBConfig *config, XBSettings *setup,
			 PlayerStrings *st);
_EXTERN void create_display_database (int disp);
_EXTERN int color_mode_from_database (int disp);
_EXTERN int override_from_database (int disp);
_EXTERN void get_font_resources (int disp, char **font_name);
_EXTERN void get_color_resources (int disp, DisplayColor *dc);
_EXTERN void get_player_color_resources (PlayerColor *pc);
#else
_EXTERN void parse_commandline ();
_EXTERN int interactive_config ();
_EXTERN void interactive_setup ();
_EXTERN void config_from_database ();
_EXTERN void merge_default_databases ();
_EXTERN void setup_from_database ();
_EXTERN void player_strings_from_database ();
_EXTERN void save_setup ();
_EXTERN void create_display_database ();
_EXTERN int color_mode_from_database ();
_EXTERN int override_from_database ();
_EXTERN void get_font_resources ();
_EXTERN void get_color_resources ();
_EXTERN void get_player_color_resources ();
#endif

#undef _EXTERN

#endif
/*
 * end of file xsetup.h
 */



