/*-
# X-BASED PANEX(tm)
#
#  PanexS.c
#
###
#
#  Copyright (c) 1996	David Albert Bagley, bagleyd@hertz.njit.edu
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Solver file for Panex */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include "PanexP.h"

static void
SolveHanoiMode(PanexWidget w)
{
	int         triangleTurn = TRUE;
	int         triangleDirection = (w->panex.tiles & 1) ? 2 : 1;
	int         triangleStack = 0;
	int         fromStack, toStack, temp1Stack, temp2Stack, temp1Loc,
	            temp2Loc;
	int         fromPosition;
	panexCallbackStruct cb;

	while (!CheckSolved(w)) {
		if (triangleTurn) {
			fromStack = triangleStack;
			toStack = (triangleStack + triangleDirection) % MAXSTACKS;
			triangleStack = toStack;
			triangleTurn = FALSE;
		} else {
			temp1Stack = (triangleStack + 1) % MAXSTACKS;
			temp2Stack = (triangleStack + 2) % MAXSTACKS;
			temp1Loc = TopOfStack(w, temp1Stack);
			temp2Loc = TopOfStack(w, temp2Stack);
			if (temp1Loc < 0 && temp2Loc < 0)
				return;
			else if (temp1Loc < 0) {
				fromStack = temp2Stack;
				toStack = temp1Stack;
			} else if (temp2Loc < 0) {
				fromStack = temp1Stack;
				toStack = temp2Stack;
			} else if (w->panex.tileOfPosition[temp1Stack][temp1Loc].loc <
			 w->panex.tileOfPosition[temp2Stack][temp2Loc].loc) {
				fromStack = temp1Stack;
				toStack = temp2Stack;
			} else {
				fromStack = temp2Stack;
				toStack = temp1Stack;
			}
			triangleTurn = TRUE;
		}
		if ((fromPosition = TopOfStack(w, fromStack)) < 0 ||
		    MovePanex(w, fromStack, fromPosition, toStack) < 0) {
			(void) printf(
					     "move from %d to %d can not be made.", fromStack, toStack);
			return;
		}
	}
	cb.reason = PANEX_COMPUTED;
	XtCallCallbacks((Widget) w, XtNselectCallback, &cb);
}

static void
SolvePanexMode(PanexWidget w)
{
	while (!CheckMiddle(w)) {
		(void) printf("Don't know ... investigating\n");
	}
}

void
SolveTiles(PanexWidget w)
{
	if (w->panex.mode == PANEX)
		SolvePanexMode(w);
	else
		SolveHanoiMode(w);
}
