
/*-
# X-BASED PANEX(tm)
#
#  xpanex.c
#
###
#
#  Copyright (c) 1996		David Albert Bagley, bagleyd@hertz.njit.edu
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/*-
  Version 5.3: 96/04/30 Xt
*/

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#define getlogin cuserid
#else
#ifndef apollo
#include <unistd.h>
#endif
#endif
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>
#include "Panex.h"
#include "panex.xbm"

#ifndef SCOREFILE
#define SCOREFILE "/usr/games/lib/panex.scores"
#endif

/* The following are in PanexP.h also */
#define MINTILES 1
#define HANOI 0
#define PANEX 1
#define MAXMODES 2

#define MAXTILES 10
#define MAXRECORD 65536
#define MAXPROGNAME 80
#define MAXNAME 256

static void Initialize(Widget w);
static void CallbackPanex(Widget w, caddr_t clientData, panexCallbackStruct * callData);

static void PrintRecord(int tiles, int mode, char *record);
static int  HandleSolved(int counter, int tiles, int mode);
static void PrintState(Widget w, char *prog, int tiles, int moves, char *record, char *message);
static void ReadRecords(void);
static void WriteRecords(void);

static Arg  arg[1];
static int  panexRecord[MAXMODES][MAXTILES - MINTILES + 1];
static int  movesDsp = 0;
static char progDsp[MAXMODES][64] =
{"xhanoi", "xpanex"};
static char recordDsp[16] = "INF";
static char messageDsp[128] = "Welcome";
static char titleDsp[256] = "";

static void 
Usage(void)
{
	(void) fprintf(stderr, "usage: xpanex\n");
	(void) fprintf(stderr,
	     "\t[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]\n");
	(void) fprintf(stderr,
		"\t[-display [{host}]:[{vs}]][-fg {color}] [-bg {color}]\n");
	(void) fprintf(stderr,
	"\t[-mono] [-tile {color}] [-{border|bd} {color}] [-tiles {int}]\n");
	(void) fprintf(stderr,
		 "\t[-mode {int}] [-delay msecs] [-pyramid{0|1} {color}]\n");
	exit(1);
}

static XrmOptionDescRec options[] =
{
	{"-fg", "*panex.Foreground", XrmoptionSepArg, NULL},
	{"-bg", "*Background", XrmoptionSepArg, NULL},
	{"-foreground", "*panex.Foreground", XrmoptionSepArg, NULL},
	{"-background", "*Background", XrmoptionSepArg, NULL},
	{"-tile", "*panex.tileColor", XrmoptionSepArg, NULL},
	{"-border", "*panex.tileBorder", XrmoptionSepArg, NULL},
	{"-bd", "*panex.tileBorder", XrmoptionSepArg, NULL},
	{"-tiles", "*panex.tiles", XrmoptionSepArg, NULL},
	{"-mode", "*panex.mode", XrmoptionSepArg, NULL},
	{"-hanoi", "*panex.mode", XrmoptionNoArg, "0"},
	{"-panex", "*panex.mode", XrmoptionNoArg, "1"},
	{"-mono", "*panex.mono", XrmoptionNoArg, "TRUE"},
	{"-pyramid0", "*panex.pyramidColor0", XrmoptionSepArg, NULL},
	{"-pyramid1", "*panex.pyramidColor1", XrmoptionSepArg, NULL},
};

int 
main(int argc, char **argv)
{
	Widget      toplevel, panex;

	toplevel = XtInitialize(argv[0], "Panex",
				options, XtNumber(options), &argc, argv);
	if (argc != 1)
		Usage();

	XtSetArg(arg[0], XtNiconPixmap,
		 XCreateBitmapFromData(XtDisplay(toplevel),
				       RootWindowOfScreen(XtScreen(toplevel)),
			    (char *) panex_bits, panex_width, panex_height));
	XtSetValues(toplevel, arg, 1);
	panex = XtCreateManagedWidget("panex", panexWidgetClass, toplevel,
				      NULL, 0);
	XtAddCallback(panex, XtNselectCallback, (XtCallbackProc) CallbackPanex,
		      (XtPointer) NULL);
	Initialize(panex);
	XtRealizeWidget(toplevel);
	XGrabButton(XtDisplay(panex), AnyButton, AnyModifier, XtWindow(panex),
		TRUE, ButtonPressMask | ButtonMotionMask | ButtonReleaseMask,
		    GrabModeAsync, GrabModeAsync, XtWindow(panex),
		    XCreateFontCursor(XtDisplay(panex), XC_crosshair));
	XtMainLoop();

#ifdef VMS
	return 1;
#else
	return 0;
#endif
}

static void 
Initialize(Widget w)
{
	int         tiles, mode;

	/*XtVaSetValues(w,
	   XtNstart, FALSE,
	   NULL); */
	XtVaGetValues(w,
		      XtNtiles, &tiles,
		      XtNmode, &mode,
		      NULL);
	ReadRecords();
	PrintRecord(tiles, mode, recordDsp);
	PrintState(XtParent(w), progDsp[mode], tiles, movesDsp,
		   recordDsp, messageDsp);
}

static void 
CallbackPanex(Widget w, caddr_t clientData, panexCallbackStruct * callData)
{
	int         tiles, mode;

	XtVaGetValues(w,
		      XtNtiles, &tiles,
		      XtNmode, &mode,
		      NULL);
	(void) strcpy(messageDsp, "");
	switch (callData->reason) {
		case PANEX_RESTORE:
		case PANEX_RESET:
			movesDsp = 0;
			break;
		case PANEX_ILLEGAL:
			(void) strcpy(messageDsp, "Illegal move");
			break;
		case PANEX_BLOCKED:
			(void) strcpy(messageDsp, "Blocked");
			break;
		case PANEX_SPACE:
			/*(void) strcpy(messageDsp, "Spaces can't move"); *//* Too annoying */
			break;
		case PANEX_IGNORE:
			(void) strcpy(messageDsp, "Randomize to start");
			break;
		case PANEX_MOVED:
			movesDsp++;
			XtSetArg(arg[0], XtNstart, TRUE);
			XtSetValues(w, arg, 1);
			break;
		case PANEX_SOLVED:
			if (HandleSolved(movesDsp, tiles, mode))
				(void) sprintf(messageDsp, "Congratulations %s!!", getlogin());
			else
				(void) strcpy(messageDsp, "Solved!");
			XtSetArg(arg[0], XtNstart, FALSE);
			XtSetValues(w, arg, 1);
			break;
		case PANEX_DEC:
			movesDsp = 0;
			tiles--;
			PrintRecord(tiles, mode, recordDsp);
			XtSetArg(arg[0], XtNtiles, tiles);
			XtSetValues(w, arg, 1);
			break;
		case PANEX_INC:
			movesDsp = 0;
			tiles++;
			PrintRecord(tiles, mode, recordDsp);
			XtSetArg(arg[0], XtNtiles, tiles);
			XtSetValues(w, arg, 1);
			break;
		case PANEX_MODE:
			movesDsp = 0;
			mode = (mode == PANEX) ? HANOI : PANEX;
			PrintRecord(tiles, mode, recordDsp);
			XtSetArg(arg[0], XtNmode, mode);
			XtSetValues(w, arg, 1);
			break;
		case PANEX_COMPUTED:
			XtSetArg(arg[0], XtNstart, FALSE);
			XtSetValues(w, arg, 1);
			break;
		case PANEX_UNDO:
			movesDsp--;
			XtSetArg(arg[0], XtNstart, TRUE);
			XtSetValues(w, arg, 1);
			break;
	}
	PrintState(XtParent(w), progDsp[mode], tiles, movesDsp,
		   recordDsp, messageDsp);
}

static void 
PrintRecord(int tiles, int mode, char *record)
{
	int         i = tiles - MINTILES, j = mode - HANOI;

	if (tiles > MAXTILES)
		(void) strcpy(record, "NOT RECORDED");
	else if (panexRecord[j][i] >= MAXRECORD)
		(void) strcpy(record, "NEVER");
	else
		(void) sprintf(record, "%d", panexRecord[j][i]);
}

static int 
HandleSolved(int counter, int tiles, int mode)
{
	int         i = tiles - MINTILES, j = mode - HANOI;

	if (tiles <= MAXTILES && counter < panexRecord[j][i]) {
		panexRecord[j][i] = counter;
		WriteRecords();
		(void) sprintf(recordDsp, "%d", counter);
		return TRUE;
	}
	return FALSE;
}

static void 
PrintState(Widget w, char *prog, int tiles, int moves, char *record, char *message)
{
	(void) sprintf(titleDsp, "%s: %d @ (%d/%s) - %s",
		       prog, tiles, moves, record, message);
	XtSetArg(arg[0], XtNtitle, titleDsp);
	XtSetValues(w, arg, 1);
}

static void 
ReadRecords(void)
{
	FILE       *fp;
	int         i, mode, n;

	for (mode = 0; mode < MAXMODES; mode++)
		for (i = 0; i < MAXTILES - MINTILES + 1; i++)
			panexRecord[mode][i] = MAXRECORD;
	if ((fp = fopen(SCOREFILE, "r")) == NULL)
		(void) sprintf(messageDsp, "Can not open %s, taking defaults.", SCOREFILE);
	else {
		for (mode = 0; mode < MAXMODES; mode++)
			for (i = 0; i < MAXTILES - MINTILES + 1; i++) {
				(void) fscanf(fp, "%d", &n);
				panexRecord[mode][i] = n;
			}
		(void) fclose(fp);
	}
}

static void 
WriteRecords(void)
{
	FILE       *fp;
	int         i, mode;

	if ((fp = fopen(SCOREFILE, "w")) == NULL)
		(void) sprintf(messageDsp, "Can not write to %s.", SCOREFILE);
	else {
		for (mode = 0; mode < MAXMODES; mode++) {
			for (i = 0; i < MAXTILES - MINTILES + 1; i++)
				(void) fprintf(fp, "%d ", panexRecord[mode][i]);
			(void) fprintf(fp, "\n");
		}
		(void) fprintf(fp, "\n");
		(void) fclose(fp);
	}
}
