/*** analog 1.91beta ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/  */

/*** output2.c; output functions. ***/
/* See also output.c */

#include "analhea2.h"

/*** The first function prints the "goto" line; links to all reports except
     possibly one (the one we're on). If called gotos('\0') won't omit one.
     If called gotos('z') will omit 'Top'. ***/

void gotos(FILE *outf, char c)
{
  extern char reportorder[];
  extern flag bq, Bq, cq, dq, Dq, eq, fq, hq, Hq, iq, tq, mq, oq, rq, Sq, Wq;
  extern flag xq;
  extern int lang;

  char *i;
  char langstr[MAXSTRINGLENGTH];

  if (xq) {  /* NB Have already tested aq == HTML */
    if (lang == ENGLISH)
      strcpy(langstr, "Go To");
    else if (lang == FRENCH)
      strcpy(langstr, "Autres choix");
    else /* lang == GERMAN */
      strcpy(langstr, "Andere Statistiken");
    fprintf(outf, "\n\n<p>(<b>%s</b>", langstr);

    if (c != 'z') {
      if (lang == ENGLISH)
	strcpy(langstr, "Top");
      else if (lang == FRENCH)
	strcpy(langstr, "Sommet");
      else /* lang == GERMAN */
	strcpy(langstr, "Anfang");
      fprintf(outf, "%s: <a HREF=\"#Top\">%s</a>",
		    (lang == FRENCH)?" ":"", langstr);
    }

    for (i = reportorder; *i != '\0'; i++) {
      if (c != *i) {   /* o/wise we don't want this one */
	switch(*i) {
	case 'b':
	  if (bq) {
	    if (lang == ENGLISH)
	      strcpy(langstr, "Browser summary");
	    else if (lang == FRENCH)
	      strcpy(langstr, "R&eacute;sum&eacute; des navigateurs");
	    else /* lang == GERMAN */
	      strcpy(langstr, "Browser-&Uuml;bersicht");
	    fprintf(outf, "%s: <a HREF=\"#Browser\">%s</a>",
		    (lang == FRENCH)?" ":"", langstr);
	  }
	  break;
	case 'B':
	  if (Bq) {
	    if (lang == ENGLISH)
	      strcpy(langstr, "Browser report");
	    else if (lang == FRENCH)
	      strcpy(langstr, "Rapport des navigateurs");
	    else /* lang == GERMAN */
	      strcpy(langstr, "Browser-Bericht");
	    fprintf(outf, "%s: <a HREF=\"#FullBrowser\">%s</a>",
		    (lang == FRENCH)?" ":"", langstr);
	  }
	  break;
	case 'c':
	  if (cq) {
	    if (lang == ENGLISH)
	      strcpy(langstr, "Status code report");
	    else if (lang == FRENCH)
	      strcpy(langstr, "Rapport des statuts");
	    else /* lang == GERMAN */
	      strcpy(langstr, "Statuscode-Bericht");
	    fprintf(outf, "%s: <a HREF=\"#Status\">%s</a>",
		    (lang == FRENCH)?" ":"", langstr);
	  }
	  break;
	case 'd':
	  if (dq) {
	    if (lang == ENGLISH)
	      strcpy(langstr, "Daily summary");
	    else if (lang == FRENCH)
	      strcpy(langstr, "R&eacute;sum&eacute; quotidien");
	    else /* lang == GERMAN */
	      strcpy(langstr, "Tages&uuml;bersicht");
	    fprintf(outf, "%s: <a HREF=\"#Daily\">%s</a>",
		    (lang == FRENCH)?" ":"", langstr);
	  }
	  break;
	case 'D':
	  if (Dq) {
	    if (lang == ENGLISH)
	      strcpy(langstr, "Daily report");
	    else if (lang == FRENCH)
	      strcpy(langstr, "Rapport quotidien");
	    else /* lang == GERMAN */
	      strcpy(langstr, "Tagesbericht");
	    fprintf(outf, "%s: <a HREF=\"#FullDaily\">%s</a>",
		    (lang == FRENCH)?" ":"", langstr);
	  }
	  break;
	case 'e':
	  if (eq) {
	    if (lang == ENGLISH)
	      strcpy(langstr, "Error report");
	    else if (lang == FRENCH)
	      strcpy(langstr, "Rapport des erreurs");
	    else /* lang == GERMAN */
	      strcpy(langstr, "Fehlerbericht");
	    fprintf(outf, "%s: <a HREF=\"#Error\">%s</a>",
		    (lang == FRENCH)?" ":"", langstr);
	  }
	  break;
	case 'f':
	  if (fq) {
	    if (lang == ENGLISH)
	      strcpy(langstr, "Referrer report");
	    else if (lang == FRENCH)
	      strcpy(langstr, "Rapport des appelants");
	    else /* lang == GERMAN */
	      strcpy(langstr, "Verweis-Bericht");
	    fprintf(outf, "%s: <a HREF=\"#Referrer\">%s</a>",
		    (lang == FRENCH)?" ":"", langstr);
	  }
	  break;
	case 'H':
	  if (Hq) {
	    if (lang == ENGLISH)
	      strcpy(langstr, "Hourly report");
	    else if (lang == FRENCH)
	      strcpy(langstr, "Rapport horaire");
	    else /* lang == GERMAN */
	      strcpy(langstr, "St&uuml;ndlicher Bericht");
	    fprintf(outf, "%s: <a HREF=\"#FullHourly\">%s</a>",
		    (lang == FRENCH)?" ":"", langstr);
	  }
	  break;
	case 'h':
	  if (hq) {
	    if (lang == ENGLISH)
	      strcpy(langstr, "Hourly summary");
	    else if (lang == FRENCH)
	      strcpy(langstr, "R&eacute;sum&eacute; horaire");
	    else /* lang == GERMAN */
	      strcpy(langstr, "St&uuml;ndliche &Uuml;bersicht");
	    fprintf(outf, "%s: <a HREF=\"#Hourly\">%s</a>",
		    (lang == FRENCH)?" ":"", langstr);
	  }
	  break;
	case 'i':
	  if (iq) {
	    if (lang == ENGLISH)
	      strcpy(langstr, "Directory report");
	    else if (lang == FRENCH)
	      strcpy(langstr, "Rapport des r&eacute;pertoires");
	    else /* lang == GERMAN */
	      strcpy(langstr, "Verzeichnisbericht");
	    fprintf(outf, "%s: <a HREF=\"#Directory\">%s</a>",
		    (lang == FRENCH)?" ":"", langstr);
	  }
	  break;
	case 'm':
	  if (mq) {
	    if (lang == ENGLISH)
	      strcpy(langstr, "Monthly report");
	    else if (lang == FRENCH)
	      strcpy(langstr, "Rapport mensuel");
	    else /* lang == GERMAN */
	      strcpy(langstr, "Monatsbericht");
	    fprintf(outf, "%s: <a HREF=\"#Monthly\">%s</a>",
		    (lang == FRENCH)?" ":"", langstr);
	  }
	  break;
	case 'o':
	  if (oq) {
	    if (lang == ENGLISH)
	      strcpy(langstr, "Domain report");
	    else if (lang == FRENCH)
	      strcpy(langstr, "Rapport des domaines");
	    else /* lang == GERMAN */
	      strcpy(langstr, "Dom&auml;nen-Bericht");
	    fprintf(outf, "%s: <a HREF=\"#Domain\">%s</a>",
		    (lang == FRENCH)?" ":"", langstr);
	  }
	  break;
	case 'r':
	  if (rq) {
	    if (lang == ENGLISH)
	      strcpy(langstr, "Request report");
	    else if (lang == FRENCH)
	      strcpy(langstr, "Rapport des requ&ecirc;tes");
	    else /* lang == GERMAN */
	      strcpy(langstr, "Anfrage-Bericht");
	    fprintf(outf, "%s: <a HREF=\"#Request\">%s</a>",
		    (lang == FRENCH)?" ":"", langstr);
	  }
	  break;
	case 'S':
	  if (Sq) {
	    if (lang == ENGLISH)
	      strcpy(langstr, "Host report");
	    else if (lang == FRENCH)
	      strcpy(langstr, "Rapport des h&ocirc;tes");
	    else /* lang == GERMAN */
	      strcpy(langstr, "Host-Bericht");
	    fprintf(outf, "%s: <a HREF=\"#Host\">%s</a>",
		    (lang == FRENCH)?" ":"", langstr);
	  }
	  break;
	case 't':
	  if (tq) {
	    if (lang == ENGLISH)
	      strcpy(langstr, "File type report");
	    else if (lang == FRENCH)
	      strcpy(langstr, "Rapport des types de fichier");
	    else /* lang == GERMAN */
	      strcpy(langstr, "Dateityp-Bericht");
	    fprintf(outf, "%s: <a HREF=\"#FileType\">%s</a>",
		    (lang == FRENCH)?" ":"", langstr);
	  }
	  break;
	case 'W':
	  if (Wq) {
	    if (lang == ENGLISH)
	      strcpy(langstr, "Weekly report");
	    else if (lang == FRENCH)
	      strcpy(langstr, "Rapport hebdomadaire");
	    else /* lang == GERMAN */
	      strcpy(langstr, "Wochenbericht");
	    fprintf(outf, "%s: <a HREF=\"#Weekly\">%s</a>",
		    (lang == FRENCH)?" ":"", langstr);
	  }
	  break;

	}   /* end switch */
      }     /* end if this i wanted */
    }       /* end for i */

    fprintf(outf, ")\n");

  }         /* end if xq */
}           /* end function gotos() */

/*** Next, to print strings with HTML reserved characters translated ***/

void htmlputc(char c, FILE *outf)
{
  if (c == '<')
    fprintf(outf, "&lt;");
  else if (c == '>')
    fprintf(outf, "&gt;");
  else if (c == '&')
    fprintf(outf, "&amp;");
  else if (c == '"')
    fprintf(outf, "&quot;");
  else
    putc(c, outf);
}

void htmlfprintf(FILE *outf, char string[MAXSTRINGLENGTH])
{
  extern flag html2;

  char *c;

  for (c = string; *c != '\0'; c++) {
    if (*c == '\\' && *(c + 1) != '\0') {
      html2 = OFF;
      putc(*(++c), outf);
    }
    else
      htmlputc(*c, outf);
  }
}

/*** Now a little routine to find the correct divider for large numbers of
     bytes. Also sets bprefix[0] as a side effect. ***/

double finddivider(double bytes, char *bprefix)
{
  extern flag rawbytes;

  double bdivider;

  if (rawbytes)
    bdivider = 1.0;
  else
    for (bdivider = 1; bytes / bdivider >= 999999.5;
	 bdivider *= 1024)
      ;  /* run bdivider to right multiplier */

  if (bdivider == 1.0)
    *bprefix = '\0';
  else if (bdivider == 1024.0)
    *bprefix = 'k';
  else if (bdivider == 1048576.0)
    *bprefix = 'M';
  else if (bdivider == 1073741824.0)
    *bprefix = 'G';
  else if (bdivider == 1099511627776.0)
    *bprefix = 'T';
  else       /* 10^6 terabytes should be enough. Just about. */
    *bprefix = '?';

  return(bdivider);
}

/*** print a line across the page, assuming ASCII mode ***/

void asciiline(FILE *outf)
{
  extern int pagewidth;

  int i;

  for (i = 0; i < pagewidth; i++)
    fprintf(outf, "-");
  fprintf(outf, "\n\n");
}

/*** a barchart bar, length n, within <pre><tt> ***/

void barplot(FILE *outf, int n)
{
  extern int aq;
  extern flag graphical;
  extern char *imagedir;
  extern char markchar;

  int i, k;
  flag first = TRUE;

  if (aq || !graphical) {
    for ( ; n > 0; n--)
      fprintf(outf, "%c", markchar);
  }

  else {
    for (k = 32; k >= 1; k /= 2) {
      while (n >= k) {
	fprintf(outf, "<img src=\"");
	htmlfprintf(outf, imagedir);
	fprintf(outf, "bar%d.gif\" alt=\"", k);
	if (first) {
	  for (i = n; i > 0; i--)
	    htmlputc(markchar, outf);
	  first = FALSE;
	}
	fprintf(outf, "\">");
	n -= k;
      }
    }
  }
}

/*** Left hand two columns in OUTPUT PREFORMATTED ***/
/* NB: Check (aq == PREFORMATTED) elsewhere */

void precols(FILE *outf, char *wantcols, char codeletter, flag byq)
{
  extern char *presep;

  char *cols;

  fprintf(outf, "%c%s", codeletter, presep);
  for (cols = wantcols; *cols != '\0'; cols++) {
    switch(*cols) {
    case 'R':
    case 'r':
    case 'P':
    case 'p':
      fprintf(outf, "%c", *cols);
      break;
    case 'b':
    case 'B':
      if (byq)
	fprintf(outf, "%c", *cols);
      break;
    }
  }
  fprintf(outf, "%s", presep);
}

/*** Two functions to print R,r,P,p,B,b cols given various parameters ***/

void printcolheads(FILE *outf, char *wantcols, int fieldwidth, int pfieldwidth,
		   int bfieldwidth, char bprefix[2], char name[20], char type,
		   flag byq, flag name1st)
{   /* assume aq != PREFORMATTED already tested */
  extern int lang;

  char *cols;
  char langstr[MAXSTRINGLENGTH], langstr2[MAXSTRINGLENGTH];
  int i;
  char *tempc;
  flag tempflag;

  if (name1st)
    fprintf(outf, "%s: ", name);
  for (cols = wantcols; *cols != '\0'; cols++) {
    switch(*cols) {
    case 'R':
      /* lang: number of requests and number of occurrences. 5 characters */
      if (lang == GERMAN) {
	strcpy(langstr, "#Anf.");
	strcpy(langstr2, " Anz.");
      }
      else { /* lang == ENGLISH or FRENCH */
	strcpy(langstr, "#reqs");
	strcpy(langstr2, "#occs");
      }
      for (i = 5; i < fieldwidth; i++)
	fprintf(outf, " ");
      if (type == 'o')
	fprintf(outf, " %s : ", langstr);
      else if (type == 'c' || type == 'e')
	fprintf(outf, "%s: ", langstr2);
      else
	fprintf(outf, "%s: ", langstr);
      break;
    case 'r':
      /* lang: percentage requests and occurrences. 6 characters */
      if (lang == GERMAN) {
	strcpy(langstr, " %Anf.");
	strcpy(langstr2, " %Anz.");
      }
      else { /* lang == ENGLISH or FRENCH */
	strcpy(langstr, " %reqs");
	strcpy(langstr2, " %occs");
      }
      if (type == 'o')
	fprintf(outf, " %s : ", langstr);
      else if (type == 'c' || type == 'e')
	fprintf(outf, "%s: ", langstr2);
      else
	fprintf(outf, "%s: ", langstr);
      break;
    case 'P':
      /* lang: number of pages. 5 characters */
      if (lang == GERMAN)
	strcpy(langstr, "Seit.");
      else  /* lang == ENGLISH or FRENCH */
	strcpy(langstr, "pages");
      for (i = 5; i < pfieldwidth; i++)
	fprintf(outf, " ");
      if (type == 'o')
	fprintf(outf, " %s : ", langstr);
      else
	fprintf(outf, "%s: ", langstr);
      break;
    case 'p':
      /* lang: percentage pages. 6 characters */
      if (lang == GERMAN)
	strcpy(langstr, "%Seit");
      else  /* lang == ENGLISH or FRENCH */
	strcpy(langstr, "%pages");
      if (type == 'o')
	fprintf(outf, " %s : ", langstr);
      else
	fprintf(outf, "%s: ", langstr);
      break;
    case 'B':
      if (byq) {
	/* lang: bytes. 5 characters. Compensating space below if < 5. */
	if (lang == FRENCH)
	  strcpy(langstr, "octs");
	else if (lang == ENGLISH || bprefix[0] != '\0')
	  strcpy(langstr, "bytes");
	else /* bprefix[0] == '\0' && lang == GERMAN */
	  strcpy(langstr, "Bytes");
	for (i = 6; i < bfieldwidth; i++)
	  fprintf(outf, " ");
	if (type == 'o')
	  fprintf(outf, " %s%s%s : ", (lang == FRENCH)?" ":"",
		  (bprefix[0] == '\0')?" ":bprefix, langstr);
	else
	  fprintf(outf, "%s%s%s: ", (lang == FRENCH)?" ":"",
		  (bprefix[0] == '\0')?" ":bprefix, langstr);
      }
      break;
    case 'b':
      if (byq) {
	if (lang == ENGLISH)
	  strcpy(langstr, "%bytes");
	else if (lang == FRENCH)
	  strcpy(langstr, " %octs");
	else /* lang == GERMAN */
	  strcpy(langstr, "%Bytes");
	if (type == 'o')
	  fprintf(outf, " %s : ", langstr);
	else
	  fprintf(outf, "%s: ", langstr);
      }
      break;
    }
  }
  if (!name1st)
    fprintf(outf, "%s", name);
  fprintf(outf, "\n");

  if (name1st) {
    tempflag = ON;
    for (tempc = name; *tempc != '\0'; tempc++) {
      if (*tempc == '&')
	tempflag = OFF;    /* only print one dash for e.g. &eacute; */
      else if (*tempc == ';')
	tempflag = ON;
      if (tempflag)
	fprintf(outf, "-");
    }
    fprintf(outf, "  ");
  }
  for (cols = wantcols; *cols != '\0'; cols++) {
    switch(*cols) {
    case 'R':
      for (i = 1; i <= fieldwidth + 2 * (type == 'o'); i++)
	fprintf(outf, "-");
      fprintf(outf, "  ");
      break;
    case 'r':
      fprintf(outf, "%s------  ", (type == 'o')?"--":"");
      break;
    case 'P':
      for (i = 1; i <= pfieldwidth + 2 * (type == 'o'); i++)
	fprintf(outf, "-");
      fprintf(outf, "  ");
      break;
    case 'p':
      fprintf(outf, "%s------  ", (type == 'o')?"--":"");
      break;
    case 'B':
      if (byq) {
	for (i = 1; i <= bfieldwidth + 2 * (type == 'o'); i++)
	  fprintf(outf, "-");
	fprintf(outf, "  ");
      }
      break;
    case 'b':
      if (byq)
	fprintf(outf, "%s------  ", (type == 'o')?"--":"");
      break;
    }
  }
  if (!name1st) {
    tempflag = ON;
    for (tempc = name; *tempc != '\0'; tempc++) {
      if (*tempc == '&')
	tempflag = OFF;    /* only print one dash for e.g. &eacute; */
      else if (*tempc == ';')
	tempflag = ON;
      if (tempflag)
	fprintf(outf, "-");
    }
  }
  fprintf(outf, "\n");
}

void printcols(FILE *outf, char *wantcols, int reqs, int pages, double bytes,
	       int fieldwidth, int pfieldwidth, int bfieldwidth,
	       double bdivider, int totreqs, int totpages, double totbytes,
	       char type, flag byq)
{
  extern char *presep;
  extern char repsepchar, decpoint;
  extern flag aq;

  char *cols;
  double pc;
  int pc1, pc2;
  int k;

  for (cols = wantcols; *cols != '\0'; cols++) {
    switch(*cols) {
    case 'R':
      if (aq == PREFORMATTED)
	fprintf(outf, "%d%s", reqs, presep);
      else {
	if (type == 'o')
	  fprintf(outf, " ");
	else if (type == 'O')
	  fprintf(outf, "(");
	int3printf(outf, reqs, repsepchar, fieldwidth);
	if (type == 'o')
	  fprintf(outf, " : ");
	else if (type == 'O')
	  fprintf(outf, "): ");
	else
	  fprintf(outf, ": ");
      }
      break;
    case 'r':
      if (totreqs == 0)
	pc = 0;
      else
	pc = (reqs + 0.0) / ((totreqs + 0.0) / 10000);
      pc1 = ((int)(pc + 0.5)) / 100;     /* whole no. of %reqs */
      pc2 = ((int)(pc + 0.5)) % 100;     /* remaining 100ths. */
      if (aq != PREFORMATTED) {
	if (type == 'o')
	  fprintf(outf, " ");
	else if (type == 'O')
	  fprintf(outf, "(");
      }
      if (pc1 == 100) {
	if (aq == PREFORMATTED)
	  fprintf(outf, "100.00");
	else
	  fprintf(outf, "  100%%");
      }
      else if (pc1 > 0 || pc2 > 0) {
	if (aq == PREFORMATTED)
	  fprintf(outf, "%d.%02d", pc1, pc2);
	else
	  fprintf(outf, "%2d%c%02d%%", pc1, decpoint, pc2);
      }
      else if (aq == PREFORMATTED)
	fprintf(outf, "0.00");
      else
	fprintf(outf, "      ");
      if (aq == PREFORMATTED)
	fprintf(outf, "%s", presep);
      else if (type == 'o')
	fprintf(outf, " : ");
      else if (type == 'O')
	fprintf(outf, "): ");
      else
	fprintf(outf, ": ");
      break;
    case 'P':
      if (aq == PREFORMATTED)
	fprintf(outf, "%d%s", pages, presep);
      else {
	if (type == 'o')
	  fprintf(outf, " ");
	else if (type == 'O')
	  fprintf(outf, "(");
	int3printf(outf, pages, repsepchar, pfieldwidth);
	if (type == 'o')
	  fprintf(outf, " : ");
	else if (type == 'O')
	  fprintf(outf, "): ");
	else
	  fprintf(outf, ": ");
      }
      break;
    case 'p':
      if (totpages == 0)
	pc = 0;
      else
	pc = (pages + 0.0) / ((totpages + 0.0) / 10000);
      pc1 = ((int)(pc + 0.5)) / 100;
      pc2 = ((int)(pc + 0.5)) % 100;
      if (aq != PREFORMATTED) {
	if (type == 'o')
	  fprintf(outf, " ");
	else if (type == 'O')
	  fprintf(outf, "(");
      }
      if (pc1 == 100) {
	if (aq == PREFORMATTED)
	  fprintf(outf, "100.00");
	else
	  fprintf(outf, "  100%%");
      }
      else if (pc1 > 0 || pc2 > 0) {
	if (aq == PREFORMATTED)
	  fprintf(outf, "%d.%02d", pc1, pc2);
	else
	  fprintf(outf, "%2d%c%02d%%", pc1, decpoint, pc2);
      }
      else if (aq == PREFORMATTED)
	fprintf(outf, "0.00");
      else
	fprintf(outf, "      ");
      if (aq == PREFORMATTED)
	fprintf(outf, "%s", presep);
      else if (type == 'o')
	fprintf(outf, " : ");
      else if (type == 'O')
	fprintf(outf, "): ");
      else
	fprintf(outf, ": ");
      break;
    case 'B':
      if (byq) {
	if (aq == PREFORMATTED)
	  fprintf(outf, "%.0f", bytes);
	else if (bytes / bdivider > 0.5) {
	  if (type == 'o')
	    fprintf(outf, " ");
	  else if (type == 'O')
	    fprintf(outf, "(");
	  double3printf(outf, ROUND(bytes / bdivider), repsepchar,
			bfieldwidth);
	  if (type == 'o')
	    fprintf(outf, " ");
	  else if (type == 'O')
	    fprintf(outf, ")");
	}
	else for (k = 0; k < bfieldwidth + 2 * (type == 'o' || type == 'O');
		  k++)
	  fprintf(outf, " ");
	fprintf(outf, "%s", (aq == PREFORMATTED)?presep:": ");
      }
      break;
    case 'b':
      if (byq) {
	if (totbytes < 0.5)
	  pc = 0;
	else
	  pc = bytes / (totbytes / 10000);
	pc1 = ((int)(pc + 0.5)) / 100;    /* whole no. of %bytes */
	pc2 = ((int)(pc + 0.5)) % 100;    /* remaining 100ths. */
	if (aq != PREFORMATTED) {
	  if (type == 'o')
	    fprintf(outf, " ");
	  else if (type == 'O')
	    fprintf(outf, "(");
	}
	if (pc1 == 100) {
	  if (aq == PREFORMATTED)
	    fprintf(outf, "100.00");
	  else
	    fprintf(outf, "  100%%");
	}
	else if (pc1 > 0 || pc2 > 0) {
	  if (aq == PREFORMATTED)
	    fprintf(outf, "%d.%02d", pc1, pc2);
	  else
	    fprintf(outf, "%2d%c%02d%%", pc1, decpoint, pc2);
	}
	else if (aq == PREFORMATTED)
	  fprintf(outf, "0.00");
	else
	  fprintf(outf, "      ");
	if (aq == PREFORMATTED)
	  fprintf(outf, "%s", presep);
	else if (type == 'o')
	  fprintf(outf, " : ");
	else if (type == 'O')
	  fprintf(outf, "): ");
	else
	  fprintf(outf, ": ");
      }
      break;
    }
  }
}


/*** A nasty header bit. Return rough floor -- accurate if negative. ***/
/* (NB: good enough to use total_bytes in place of total_brow_bytes etc. */
int whatincluded(FILE *outf, int sortby, char *minreqstr, char *minpagestr,
		 char *minbytestr, char singular[27], char plural[29],
		 flag subdoms, char gender)
{
  extern double total_bytes;
  extern int total_succ_reqs, total_page_reqs;
  extern int aq, lang;

  int genfloor;
  int tempint;
  char tempc;

  if (sortby == BYBYTES) {
    if (minbytestr[0] == '-') {
      genfloor = (int)bytefloor(total_bytes, minbytestr);
      if (genfloor == -1) {
	if (lang == ENGLISH)
	  fprintf(outf, "Printing the first %s", singular);
	else if (lang == FRENCH)
	  fprintf(outf, "Affichage d%s premi%s %s",
		  (gender == 'm')?"u":"e la",
		  (gender == 'm')?"er":((aq == HTML)?"&egrave;re":"ere"),
		  singular);
	else /* lang == GERMAN */
	  fprintf(outf, "Ausgabe de%s erste%s %s",
		  (gender == 'f')?"r":"s", (gender == 'f')?"r":"n",
		  singular);
      }
      else {
	if (lang == ENGLISH)
	  fprintf(outf, "Printing the first %d %s", -genfloor, plural);
	else if (lang == FRENCH)
	  fprintf(outf, "Affichage des %d premi%ss %s", -genfloor,
		  (gender == 'm')?"er":((aq == HTML)?"&egrave;re":"ere"),
		  plural);
	else /* lang == GERMAN */
	  fprintf(outf, "Ausgabe der ersten %d %s", -genfloor, plural);
      }
    }  /* end if minbytestr[0] == '-' */
    else {
      if (lang == ENGLISH)
	fprintf(outf, "Printing all %s", plural);
      else if (lang == FRENCH)
	fprintf(outf, "Affichage de tou%ss les %s", (gender == 'f')?"te":"",
		plural);
      else /* lang == GERMAN */
	fprintf(outf, "Ausgabe aller %s", plural);
      genfloor = (int)(ceil(bytefloor(total_bytes, minbytestr)));
      if (genfloor > 0) {
	if (lang == ENGLISH)
	  fprintf(outf, " with at least ");
	else if (lang == FRENCH)
	  fprintf(outf, " avec au moins ");
	else /* lang == GERMAN */
	  fprintf(outf, " mit mindestens ");
	tempint = MAX((int)strlen(minbytestr) - 1, 0);
	if (minbytestr[tempint] == '%') {
	  minbytestr[tempint] = '\0';
	  doublefprintf(outf, atof(minbytestr));
	  if (lang == GERMAN)
	    fprintf(outf, "%% Anteil an gesendeten Daten");
	  else /* lang == FRENCH || ENGLISH */
	    fprintf(outf, "%% %s traffic", (lang == FRENCH)?"du":"of the");
	}
	else if (minbytestr[tempint] == 'k' || minbytestr[tempint] == 'M' ||
		 minbytestr[tempint] == 'G' || minbytestr[tempint] == 'T') {
	  tempc = minbytestr[tempint];
	  minbytestr[tempint] = '\0';
	  doublefprintf(outf, atof(minbytestr));
	  if (lang == ENGLISH)
	    fprintf(outf, " %cbytes of", tempc);
	  else if (lang == FRENCH)
	    fprintf(outf, " %coctets du", tempc);
	  else /* lang == GERMAN */
	    fprintf(outf, " %cbytes gesendeten Daten", tempc);
	}
	else {
	  doublefprintf(outf, atof(minbytestr));
	  if (lang == ENGLISH)
	    fprintf(outf, " bytes of");
	  else if (lang == FRENCH)
	    fprintf(outf, " octets du");
	  else /* lang == GERMAN */
	    fprintf(outf, " Bytes gesendeten Daten");
	}
      }
    }      /* end if minbytestr[0] == '-' */
    if (subdoms)
      fprintf(outf, ".\n");
    else if (lang == ENGLISH)
      fprintf(outf, ",%ssorted by amount of traffic.\n",
              (genfloor > 0)?"\n  ":" ");
    else if (lang == FRENCH)
      fprintf(outf, ",%stri%s%s%s par le taux de traffic.\n",
	      (genfloor > 0)?"\n  ":" ", (aq == HTML)?"&eacute;":"e",
	      (gender == 'f')?"e":"", (genfloor == -1)?"":"s");
    else /* lang == GERMAN */
      fprintf(outf, ",%ssortiert nach Menge gesendeter Daten.\n",
              (genfloor > 0)?"\n  ":" ");
  }        /* end if sortby BYBYTES */
  else if (sortby == BYPAGES) {
    genfloor = reqfloor(total_page_reqs, minpagestr);
    if (minpagestr[0] == '-') {
      if (genfloor == -1) {
	if (lang == ENGLISH)
	  fprintf(outf, "Printing the first %s", singular);
	else if (lang == FRENCH)
	  fprintf(outf, "Affichage d%s premi%s %s",
		  (gender == 'm')?"u":"e la",
		  (gender == 'm')?"er":((aq == HTML)?"&egrave;re":"ere"),
		  singular);
	else /* lang == GERMAN */
	  fprintf(outf, "Ausgabe de%s erste%s %s",
		  (gender == 'f')?"r":"s", (gender == 'f')?"r":"n",
		  singular);
      }
      else {
	if (lang == ENGLISH)
	  fprintf(outf, "Printing the first %d %s", -genfloor, plural);
	else if (lang == FRENCH)
	  fprintf(outf, "Affichage des %d premi%ss %s", -genfloor,
		  (gender == 'm')?"er":((aq == HTML)?"&egrave;re":"ere"),
		  plural);
	else /* lang == GERMAN */
	  fprintf(outf, "Ausgabe der ersten %d %s", -genfloor, plural);
      }
    }    /* end if minpagestr[0] == '-' */
    else {
      if (lang == ENGLISH)
	fprintf(outf, "Printing all %s", plural);
      else if (lang == FRENCH)
	fprintf(outf, "Affichage de tou%ss les %s", (gender == 'f')?"te":"",
		plural);
      else /* lang == GERMAN */
	fprintf(outf, "Ausgabe aller %s", plural);
      if (genfloor > 0) {
	if (lang == ENGLISH)
	  fprintf(outf, " with at least ");
	else if (lang == FRENCH)
	  fprintf(outf, " avec au moins ");
	else /* lang == GERMAN */
	  fprintf(outf, " mit mindestens ");
	tempint = MAX((int)strlen(minpagestr) - 1, 0);
	if (minpagestr[tempint] == '%') {
	  minpagestr[tempint] = '\0';
	  doublefprintf(outf, atof(minpagestr));
	  if (lang == ENGLISH)
	    fprintf(outf, "%% of the requests for pages");
	  else if (lang == FRENCH)
	    fprintf(outf, "%% des requ%stes pour pages",
		    (aq == HTML)?"&ecirc;":"e");
	  else /* lang == GERMAN */
	    fprintf(outf, "%% Anteil an Seiten-Anfragen");
	}
	else if (lang == ENGLISH)
	  fprintf(outf, "%d request%s", atoi(minpagestr),
		  (atoi(minpagestr) == 1)?" for a page":"s for pages");
	else if (lang == FRENCH)
	  fprintf(outf, "%d requ%ste%s", atoi(minpagestr),
		  (aq == HTML)?"&ecirc;":"e",
		  (atoi(minpagestr) == 1)?" sur une page":"s sur des pages");
	else
	  fprintf(outf, "%d Seiten-Anfrage%s", atoi(minreqstr),
                  (atoi(minpagestr) == 1)?"":"n");
      }
    }      /* end if minpagestr[0] != '-' */
    if (subdoms)
      fprintf(outf, ".\n");
    else if (lang == ENGLISH)
      fprintf(outf, ",%ssorted by number of page requests.\n",
	      (genfloor > 0)?"\n  ":" ");
    else if (lang == FRENCH)
      fprintf(outf, ",\n  tri%s%s%s par le nombre de requ%stes sur des pages.\n",
	      (aq == HTML)?"&eacute;":"e", (gender == 'f')?"e":"",
	      (genfloor == -1)?"":"s", (aq == HTML)?"&ecirc;":"e");
    else /* lang == GERMAN */
      fprintf(outf, ",\n  sortiert nach Anzahl der Seiten-Anfragen.\n");
  }   /* end if sortby BYPAGES */
  else {   /* sortby not BYBYTES or BYPAGES */
    genfloor = reqfloor(total_succ_reqs, minreqstr);
    if (minreqstr[0] == '-') {
      if (genfloor == -1) {
	if (lang == ENGLISH)
	  fprintf(outf, "Printing the first %s", singular);
	else if (lang == FRENCH)
	  fprintf(outf, "Affichage d%s premi%s %s",
		  (gender == 'm')?"u":"e la",
		  (gender == 'm')?"er":((aq == HTML)?"&egrave;re":"ere"),
		  singular);
	else /* lang == GERMAN */
	  fprintf(outf, "Ausgabe de%s erste%s %s",
		  (gender == 'f')?"r":"s", (gender == 'f')?"r":"n",
		  singular);
      }
      else {
	if (lang == ENGLISH)
	  fprintf(outf, "Printing the first %d %s", -genfloor, plural);
	else if (lang == FRENCH)
	  fprintf(outf, "Affichage des %d premi%ss %s", -genfloor,
		  (gender == 'm')?"er":((aq == HTML)?"&egrave;re":"ere"),
		  plural);
	else /* lang == GERMAN */
	  fprintf(outf, "Ausgabe der ersten %d %s", -genfloor, plural);
      }
    }    /* end if minreqstr[0] == '-' */
    else {
      if (lang == ENGLISH)
	fprintf(outf, "Printing all %s", plural);
      else if (lang == FRENCH)
	fprintf(outf, "Affichage de tou%ss les %s", (gender == 'f')?"te":"",
		plural);
      else /* lang == GERMAN */
	fprintf(outf, "Ausgabe aller %s", plural);
      if (genfloor > 0) {
	if (lang == ENGLISH)
	  fprintf(outf, " with at least ");
	else if (lang == FRENCH)
	  fprintf(outf, " avec au moins ");
	else /* lang == GERMAN */
	  fprintf(outf, " mit mindestens ");
	tempint = MAX((int)strlen(minreqstr) - 1, 0);
	if (minreqstr[tempint] == '%') {
	  minreqstr[tempint] = '\0';
	  doublefprintf(outf, atof(minreqstr));
	  if (lang == ENGLISH)
	    fprintf(outf, "%% of the requests");
	  else if (lang == FRENCH)
	    fprintf(outf, "%% des requ%stes", (aq == HTML)?"&ecirc;":"e");
	  else /* lang == GERMAN */
	    fprintf(outf, "%% Anteil an Anfragen");
	}
	else if (lang == ENGLISH)
	  fprintf(outf, "%d request%s", atoi(minreqstr),
		  (atoi(minreqstr) == 1)?"":"s");
	else if (lang == FRENCH)
	  fprintf(outf, "%d requ%ste%s", atoi(minreqstr),
		  (aq == HTML)?"&ecirc;":"e", (atoi(minreqstr) == 1)?"":"s");
	else
	  fprintf(outf, "%d Anfrage%s", atoi(minreqstr),
                  (atoi(minreqstr) == 1)?"":"n");
      }
    }      /* end if minreqstr[0] != '-' */
    if (subdoms)
      fprintf(outf, ".\n");
    else if (lang == ENGLISH) {
      if (sortby == BYREQUESTS)
	fprintf(outf, ",%ssorted by number of requests.\n",
		(genfloor > 0)?"\n  ":" ");
      else if (sortby == ALPHABETICAL)
	fprintf(outf, ",%ssorted alphabetically.\n",
		(genfloor > 0)?"\n  ":" ");
      else
	fprintf(outf, ", unsorted.\n");
    }
    else if (lang == FRENCH) {
      if (sortby == BYREQUESTS)
	fprintf(outf, ",%stri%s%s%s par le nombre de requ%stes.\n",
		(genfloor > 0)?"\n  ":" ", (aq == HTML)?"&eacute;":"e",
		(gender == 'f')?"e":"", (genfloor == -1)?"":"s",
		(aq == HTML)?"&ecirc;":"e");
      else if (sortby == ALPHABETICAL)
	fprintf(outf, ",%stri%s%s%s par ordre alphab%stique.\n",
		(genfloor > 0)?"\n  ":" ", (aq == HTML)?"&eacute;":"e",
		(gender == 'f')?"e":"", (genfloor == -1)?"":"s",
		(aq == HTML)?"&eacute;":"e");
      else
	fprintf(outf, ", non tri%s%s%s.\n", (aq == HTML)?"&eacute;":"e",
		(gender == 'f')?"e":"", (genfloor == -1)?"":"s");
    }
    else {   /* lang == GERMAN */ 
      if (sortby == BYREQUESTS)
        fprintf(outf, ",%ssortiert nach Anzahl der Anfragen.\n",
                (genfloor > 0)?"\n  ":" ");
      else if (sortby == ALPHABETICAL)
        fprintf(outf, ",%salphabetisch sortiert.\n",
                (genfloor > 0)?"\n  ":" ");
      else
        fprintf(outf, ", unsortiert.\n");
    }

  }   /* end if sortby not bybytes or bypages */

  return(genfloor);

}


/*** Generic output function for generic objects ***/

void genout(FILE *outf, struct genstruct *sorthead, int tot_reqs,
	    int tot_pages, double tot_bytes, int sortby, char *minreqstr,
	    char *minpagestr, char *minbytestr, int max_reqs, int max_pages,
	    double max_bytes, char *wantcols, char anchor[10], char title[36],
	    char singular[22], char plural[24], char colhead[24], char gender,
	    char codeletter, flag alphahost, flag byq, struct include *links,
	    struct alias *aka, char baseurl[MAXSTRINGLENGTH])
/* lang: note for making arguments to this function: singular and plural are
   passed to whatincluded(). colhead is often the same as singular, but is
   for the column heading. So in "including the first requested page", the
   singular is "requested page" and the colhead is just "page"; or in German,
   the singular is in the genitive, and the colhead in the nominative. */
{
  extern int pagewidth;
  extern int dirlevel;
  extern int Smaxlength;
  extern int aq, lang;
  extern flag rawbytes;
  extern char repsepchar;

  struct genstruct *p;
  int fieldwidth, pfieldwidth, bfieldwidth, graphwidth;
  int genfloor;
  double bdivider;
  char bprefix[2];
  char akaname[MAXSTRINGLENGTH];
  char *cols;
  int i, j, tempint;
  char *tempc;
  
  bprefix[0] = '\0';
  bprefix[1] = '\0';

  if (aq != PREFORMATTED) {

    if (!aq) {
      fprintf(outf, "\n\n<hr>\n<h2><a NAME=\"%s\">%s</a></h2>\n\n", anchor,
	      title);
      gotos(outf, codeletter);
      fprintf(outf, "<p>");
    }
    else {
      fprintf(outf, "%s\n", title);
      for (tempc = title; *tempc != '\0'; tempc++)
	fprintf(outf, "-");
      fprintf(outf, "\n");
    }
    
    genfloor = whatincluded(outf, sortby, minreqstr, minpagestr, minbytestr,
			    singular, plural, FALSE, gender);
    if (codeletter == 'i') {
      if (!aq)
	fprintf(outf, "<br>");
      if (lang == ENGLISH)
	fprintf(outf, "Printing directories to depth %d.\n", dirlevel);
      else if (lang == FRENCH)
	fprintf(outf,
		"Affichage des r%spertoires %s une profondeur de %d.\n",
		(aq == HTML)?"&eacute;":"e", (aq == HTML)?"&agrave;":"a",
		dirlevel);
      else /* lang == GERMAN */
	fprintf(outf, "Ausgabe der Verzeichnisse bis Tiefe %d.\n", dirlevel);
    }

    if (aq)
      fprintf(outf, "\n");
    else
      fprintf(outf, "<pre>");

    tempint = 10000;
    for (fieldwidth = 5; max_reqs / tempint >= 10; fieldwidth++)
      tempint *= 10;
    if (repsepchar != '\0' && max_reqs >= 10000)
      fieldwidth = fieldwidth + ((fieldwidth - 1) / 3);

    tempint = 10000;
    for (pfieldwidth = 5; max_pages / tempint >= 10; pfieldwidth++)
      tempint *= 10;
    if (repsepchar != '\0' && max_pages >= 10000)
      pfieldwidth = pfieldwidth + ((pfieldwidth - 1) / 3);

    if (byq) {
      bdivider = finddivider(max_bytes, bprefix);
      if (rawbytes) {
	tempint = 100000;
	for (bfieldwidth = 6; max_bytes / tempint >= 10; bfieldwidth++)
	  tempint *= 10;
      }
      else
	bfieldwidth = 6;
      if (repsepchar != '\0' && max_bytes / bdivider >= 99999.5)
	bfieldwidth = bfieldwidth + ((bfieldwidth - 1) / 3);
    }

    printcolheads(outf, wantcols, fieldwidth, pfieldwidth, bfieldwidth,
		  bprefix, colhead, codeletter, byq, FALSE);

    if (genfloor < 0)
      j = genfloor;
    else j = 1;

    if (alphahost) {
      graphwidth = pagewidth;
      for (cols = wantcols; *cols != '\0'; cols++) {
	switch(*cols) {
	case 'R':
	  graphwidth -= fieldwidth + 2;
	  break;
	case 'P':
	  graphwidth -= pfieldwidth + 2;
	  break;
	case 'B':
	  graphwidth -= bfieldwidth + 2;
	  break;
	case 'r':
	case 'p':
	case 'b':
	  graphwidth -= 8;
	  break;
	}
      }
      graphwidth = MIN(graphwidth, Smaxlength);
    }
  }

  for(p = sorthead; p -> name != NULL && (j++) != 0;
      p = p -> next) {

    if (aq == PREFORMATTED)
      precols(outf, wantcols, codeletter, byq);

    printcols(outf, wantcols, p -> reqs, p -> pages, p -> bytes, fieldwidth,
	      pfieldwidth, bfieldwidth, bdivider, tot_reqs, tot_pages,
	      tot_bytes, codeletter, byq);

    if (alphahost && !isdigit(p -> name[0])) {  /* we've swapped the names */
      reversehostname(p -> name);
      strcpy(akaname, p -> name);
      if (aka != NULL)
	doaliaslist(akaname, aka);
      /* Also in that case right align names */
      if (aq != PREFORMATTED) {
	for (i = graphwidth - (int)strlen(akaname); i > 0; i--)
	  fprintf(outf, " ");
      }
    }
    else {
      strcpy(akaname, p -> name);
      if (aka != NULL)
	doaliaslist(akaname, aka);
    }

    if (links != NULL && included(p -> name, p -> ispage, links)) {
      fprintf(outf, "<a HREF=\"");
      htmlfprintf(outf, baseurl);
      htmlfprintf(outf, p -> name);
      fprintf(outf, "\">");
      htmlfprintf(outf, akaname);
      fprintf(outf, "</a>");
    }
    else   /* (the usual case for most reports) */
      if (aq == HTML)
	htmlfprintf(outf, akaname);
      else
	fprintf(outf, "%s", akaname);
    fprintf(outf, "\n");

  }
      
  if (aq == ASCII)
    asciiline(outf);
  else if (aq == HTML)
    fprintf(outf, "</pre>");
	
}

/*** The domain report is similar to the generic ones. It differs in that
     the domains are stored in a different structure, and that subdomains
     must be printed. ***/

void domout(FILE *outf, int firstdom)
{
  extern struct domain **ohead;
  extern int aq, lang;
  extern flag byq, rawbytes;
  extern int osortby;
  extern char *ominbytestr, *ominpagestr, *ominreqstr;
  extern char *Ominbytestr, *Ominpagestr, *Ominreqstr;
  extern int omaxreqs, omaxpages;
  extern double omaxbytes;
  extern int Onumber;
  extern char ocols[];
  extern double total_bytes;
  extern int total_succ_reqs, total_page_reqs;
  extern char *presep;
  extern char repsepchar;

  int ofloor;

  struct domain *p;
  double bdivider;
  char bprefix[2];
  int fieldwidth, pfieldwidth, bfieldwidth;
  char langstr[MAXSTRINGLENGTH], langstr2[MAXSTRINGLENGTH];
  int i, j, tempint;
  char *tempp;

  bprefix[0] = '\0';
  bprefix[1] = '\0';

  if (aq != PREFORMATTED) {

    if (lang == ENGLISH) {
      strcpy(langstr, "Domain Report");
      strcpy(langstr2, "-------------");
    }
    else if (lang == FRENCH) {
      strcpy(langstr, "Rapport des Domaines");
      strcpy(langstr2, "--------------------");
    }
    else if (aq == HTML) { /* lang == GERMAN */
      strcpy(langstr, "Dom&auml;nen-Bericht");
      strcpy(langstr2, "---------------");
    }
    else { /* GERMAN and not HTML */
      strcpy(langstr, "Domaenen-Bericht");
      strcpy(langstr2, "----------------");
    }
    if (!aq) {
      fprintf(outf,
	      "\n\n<hr>\n<h2><a NAME=\"Domain\">%s</a></h2>\n\n", langstr);
      gotos(outf, 'o');
    }
    else
      fprintf(outf, "%s\n%s\n", langstr, langstr2);
  
    if (!aq)
      fprintf(outf, "<p>");

    if (lang == ENGLISH) {
      strcpy(langstr, "domain");
      strcpy(langstr2, "domains");
    }
    else if (lang == FRENCH) {
      strcpy(langstr, "domaine");
      strcpy(langstr2, "domaines");
    }
    else if (aq == HTML) { /* lang == GERMAN */
      strcpy(langstr, "Dom&auml;ne");
      strcpy(langstr2, "Dom&auml;nen");
    }
    else { /* GERMAN and not HTML */
      strcpy(langstr, "Domaene");
      strcpy(langstr2, "Domaenen");
    }
    ofloor = whatincluded(outf, osortby, ominreqstr, ominpagestr, ominbytestr,
			  langstr, langstr2, FALSE, 'm');
    if (Onumber > 0) {
      if (!aq)
	fprintf(outf, "<br>");
      if (lang == ENGLISH) {
	strcpy(langstr, "requested subdomain");
	strcpy(langstr2, "requested subdomains");
      }
      else if (lang == FRENCH && aq == HTML) {
	strcpy(langstr, "sous-domaine demand&eacute;");
	strcpy(langstr2, "sous-domaines demand&eacute;s");
      }
      else if (lang == FRENCH) { /* and not HTML */
	strcpy(langstr, "sous-domaine demande");
	strcpy(langstr2, "sous-domaines demandes");
      }
      else if (aq == HTML) { /* lang == GERMAN */
	strcpy(langstr, "verlangter Unter-Dom&auml;ne");
	strcpy(langstr2, "verlangten Unter-Dom&auml;nen");
      }
      else { /* GERMAN and not HTML */
	strcpy(langstr, "verlangter Unter-Domaene");
	strcpy(langstr2, "verlangten Unter-Domaenen");
      }
      whatincluded(outf, osortby, Ominreqstr, Ominpagestr, Ominbytestr,
		   langstr, langstr2, TRUE, 'm');
    }

    if (aq)
      fprintf(outf, "\n");
    else
      fprintf(outf, "<pre>");
  
    tempint = 10000;
    for (fieldwidth = 5; omaxreqs / tempint >= 10; fieldwidth++)
      tempint *= 10;
    if (repsepchar != '\0' && omaxreqs >= 10000)
      fieldwidth = fieldwidth + ((fieldwidth - 1) / 3);

    tempint = 10000;
    for (pfieldwidth = 5; omaxpages / tempint >= 10; pfieldwidth++)
      tempint *= 10;
    if (repsepchar != '\0' && omaxpages >= 10000)
      pfieldwidth = pfieldwidth + ((pfieldwidth - 1) / 3);
  
    if (byq) {
      bdivider = finddivider(omaxbytes, bprefix);
      if (rawbytes) {
	tempint = 100000;
	for (bfieldwidth = 6; omaxbytes / tempint >= 10; bfieldwidth++)
	  tempint *= 10;
      }
      else
	bfieldwidth = 6;
      if (repsepchar != '\0' && omaxbytes / bdivider >= 99999.5)
	bfieldwidth = bfieldwidth + ((bfieldwidth - 1) / 3);
    }
  
    if (lang == ENGLISH)
      strcpy(langstr, "domain");
    else if (lang == FRENCH)
      strcpy(langstr, "domaine");
    else if (aq == HTML) /* and lang == GERMAN */
      strcpy(langstr, "Dom&auml;ne");
    else  /* GERMAN and not HTML */
      strcpy(langstr, "Domaene");
    printcolheads(outf, ocols, fieldwidth, pfieldwidth, bfieldwidth, bprefix,
		  langstr, (Onumber > 0)?'o':'\0', byq, FALSE);

    if (ofloor < 0)
      j = ofloor;    
    else j = 1;
  }

  for (i = firstdom; i >= 0 && (j++) != 0; i = ohead[i] -> nexti) {

    if (!(i == DOMHASHSIZE - 2 && ohead[i] -> reqs == -1)) {

      if (aq == PREFORMATTED)
	precols(outf, ocols, 'o', byq);

      printcols(outf, ocols, ohead[i] -> reqs, ohead[i] -> pages,
		ohead[i] -> bytes, fieldwidth, pfieldwidth, bfieldwidth,
		bdivider, total_succ_reqs, total_page_reqs, total_bytes,
		(Onumber > 0)?'o':'\0', byq);
      
      if (ohead[i] -> id[0] == '*')
	/* flagged domains, not real domain names */
	fprintf(outf, "[%s]\n", ohead[i] -> name);
      else if (ohead[i] -> name[0] == '?')
	/* real domain, but don't print name */
	fprintf(outf, ".%s\n", ohead[i] -> id);
      else if (aq == PREFORMATTED)
	fprintf(outf, ".%s%s%s\n", ohead[i] -> id, presep, ohead[i] -> name);
      else if (aq == ASCII)
	fprintf(outf, ".%s (%s)\n", ohead[i] -> id, ohead[i] -> name);
      else {  /* aq == HTML */
	fprintf(outf, ".%s (", ohead[i] -> id);
	htmlfprintf(outf, ohead[i] -> name);
	fprintf(outf, ")\n");
      }
      
      /* Now print its subdomains too. */
      
      for (p = ohead[i] -> next; p -> name != NULL;
	   p = p -> next) {

	if (aq == PREFORMATTED)
	  precols(outf, ocols, 'O', byq);

	printcols(outf, ocols, p -> reqs, p -> pages, p -> bytes, fieldwidth,
		  pfieldwidth, bfieldwidth, bdivider, total_succ_reqs,
		  total_page_reqs, total_bytes, 'O', byq);

	if (aq != PREFORMATTED) {
	  tempp = p -> id;
	  while ((tempp = strchr(tempp, '.')) != NULL) {
	    fprintf(outf, "  "); 
	    /* print two spaces for each dot in name */
	    tempp++;
	  }
	  if (i == DOMHASHSIZE - 1)
	    fprintf(outf, "  ");  /* + 2 more for numerical domains */
	}
	
	fprintf(outf, "%s", p -> id);
	
	if (p -> name[0] != '?') {   /* print name */
	  if (aq == PREFORMATTED)
	    fprintf(outf,"%s%s", presep, p -> name);
	  else if (aq == ASCII)
	    fprintf(outf, " (%s)", p -> name);
	  else {
	    fprintf(outf, " (");
	    htmlfprintf(outf, p -> name);
	    fprintf(outf, ")");
	  }
	}
	
	fprintf(outf, "\n");
	
      }    /* end for domp */
	
    }

  }   /* end for (i = running over domains) */
    
  if (aq == ASCII)
    asciiline(outf);
  else if (aq == HTML)
    fprintf(outf, "</pre>");
	
}

/*** The date reports aren't quite generic enough to combine completely,
     but we can go a long way towards it. ***/
/*** First a function for printing out the headers of a report and finding
     the fieldwidths etc.; then one for printing out each individual line. ***/

void datehead(FILE *outf, int maxreq, int maxpages, double maxbytes,
	      char *wantcols, char *graphtype, char anchor[11],
	      char title[21], char htmltitle[31], char colhead[13],
	      char codeletter, int *unit, int *fieldwidth, int *pfieldwidth,
	      int *bfieldwidth, int *graphwidth, double *bdivider)
     /* NB: colhead: inc. leading spaces. */
     /* The last 5 args are returned altered */
{
  extern int aq, lang;
  extern flag byq, rawbytes, graphical;
  extern int pagewidth;
  extern char *imagedir;
  extern char markchar, sepchar, repsepchar;

  char *cols;
  char bprefix[2];
  char langstr[MAXSTRINGLENGTH];
  int i, j, tempint;
  char *tempc;

  bprefix[0] = '\0';
  bprefix[1] = '\0';

  if (*graphtype == 'b')
    *graphtype = 'B';
  if (*graphtype == 'p')
    *graphtype = 'P';

  if (!aq) {
    fprintf(outf, "<hr>\n<h2><a NAME=\"%s\">%s</a></h2>\n", anchor, htmltitle);
	  gotos(outf, codeletter);
  }
  else {
    fprintf(outf, "%s\n", title);
    for (tempc = title; *tempc != '\0'; tempc++)
      fprintf(outf, "-");
    fprintf(outf, "\n");
  }
    
  tempint = 10000;
  for (*fieldwidth = 5; maxreq / tempint >= 10; (*fieldwidth)++)
    tempint *= 10;   /* so fieldwidth is log_10(maxreq), but >= 5 */
  if (repsepchar != '\0' && maxreq >= 10000)
    *fieldwidth = *fieldwidth + ((*fieldwidth - 1) / 3);

  tempint = 10000;
  for (*pfieldwidth = 5; maxpages / tempint >= 10; (*pfieldwidth)++)
    tempint *= 10;
  if (repsepchar != '\0' && maxpages >= 10000)
    *pfieldwidth = *pfieldwidth + ((*pfieldwidth - 1) / 3);
	
  if (byq) {
    *bdivider = finddivider(maxbytes, bprefix);
    if (rawbytes || (*graphtype == 'B' && *unit > 0)) {
      tempint = 100000;
      for (*bfieldwidth = 6; maxbytes / tempint >= 10; (*bfieldwidth)++)
	tempint *= 10;
    }
    else
      *bfieldwidth = 6;
    if (repsepchar != '\0' && maxbytes / *bdivider >= 99999.5)
      *bfieldwidth = *bfieldwidth + ((*bfieldwidth - 1) / 3);
  }

  if (*unit <= 0) {   /* (o/wise just use the given amount) */

    /* Calculate the graphwidth */
    *graphwidth = pagewidth - (int)strlen(colhead) - 2;
    for (cols = wantcols; *cols != '\0'; cols++) {
      switch(*cols) {
      case 'R':
	*graphwidth -= *fieldwidth + 2;
	break;
      case 'P':
	*graphwidth -= *pfieldwidth + 2;
	break;
      case 'B':
	*graphwidth -= *bfieldwidth + 2;
	break;
      case 'r':
      case 'p':
      case 'b':
	*graphwidth -= 8;
	break;
      }
    }
    *graphwidth = MAX(*graphwidth, MINGRAPHWIDTH);  /* must be >= MGW wide */
	                                  
    if (*graphtype == 'B')
      *unit = (maxbytes - 1) / (*bdivider * *graphwidth);
    else if (*graphtype == 'P')
      *unit = (maxpages - 1) / *graphwidth;
    else   /* graphtype assumed to be 'R' */
      *unit = (maxreq - 1) / *graphwidth;
                   	        /* except we want a 'nice' amount, so ... */
	             /* (Nice amount is 1, 1.5, 2, 2.5, 3, 4, 5, 6, 8 * 10^n */

    j = 0;
    while (*unit > 24) {
      *unit /= 10;
      j++;
    }
    if (*unit == 6)
      *unit = 7;
    else if (*unit == 8)
      *unit = 9;
    else if (*unit >= 20)
      *unit = 24;
    else if (*unit >= 15)
      *unit = 19;
    else if (*unit >= 10)
      *unit = 14;
    (*unit)++;
    for (i = 0; i < j; i++) {
      *unit *= 10;
    }

  }     /* end if (*unit <= 0) */

  else if (*graphtype == 'B') {   /* o/wise unit doesn't make sense */
    *bdivider = 1;
    bprefix[0] = '\0';
  }

  if (!aq)
    fprintf(outf, "\n<p>");
  if (!aq && graphical) {
    if (lang == ENGLISH)
      strcpy(langstr, "Each unit");
    else if (lang == FRENCH)
      strcpy(langstr, "Chaque unit&eacute;");
    else /* lang == GERMAN */
      strcpy(langstr, "Jede Einheit");
    fprintf(outf, "%s (<tt><img src=\"", langstr);
    htmlfprintf(outf, imagedir);
    fprintf(outf, "bar1.gif\" alt=\"");
    htmlputc(markchar, outf);
    if (lang == ENGLISH)
      strcpy(langstr, "represents");
    else if (lang == FRENCH)
      strcpy(langstr, "repr&eacute;sente");
    else /* lang == GERMAN */
      strcpy(langstr, "entspricht");
    fprintf(outf, "\"></tt>) %s ", langstr);
    int3printf(outf, *unit, sepchar, 0);
    if (*graphtype == 'B') {
      if (lang == ENGLISH)
	fprintf(outf, " %sbyte%s, or part thereof.\n\n", bprefix,
		(*unit == 1)?"":"s");
      else if (lang == FRENCH)
	fprintf(outf, " %soctet%s, ou une partie du moins.\n\n", bprefix,
		(*unit == 1)?"":"s");
      else /* lang == GERMAN */
	fprintf(outf, " %s%syte%s, oder einem Teil dessen.\n\n", bprefix,
                (bprefix[0] == '\0')?"B":"b", (*unit == 1)?"":"s");

    }
    else if (*graphtype == 'P') {
      if (lang == ENGLISH)
	fprintf(outf, " request%s.\n\n",
		(*unit == 1)?" for a page":"s for pages, or part thereof");
      else if (lang == FRENCH)
	fprintf(outf, " requ&ecirc;te%s.\n\n",
		(*unit == 1)?" sur une page":
		"s sur des pages, ou une partie du moins");
      else  /* lang == GERMAN */
	fprintf(outf, " Seiten-Anfrage%s.\n\n",
		(*unit == 1)?"":"n, oder einem Teil dessen");
    }
    else if (lang == ENGLISH)
      fprintf(outf, " request%s.\n\n", (*unit == 1)?"":"s, or part thereof");
    else if (lang == FRENCH)
      fprintf(outf, " requ&ecirc;te%s.\n\n",
	      (*unit == 1)?"":"s, ou une partie du moins");
    else  /* lang == GERMAN */
      fprintf(outf, " Anfrage%s.\n\n",
	      (*unit == 1)?"":"n, oder einem Teil dessen");
  }
  else {
    if (lang == ENGLISH)
      fprintf(outf, "\nEach unit (%c) represents ", markchar);
    else if (lang == FRENCH)
      fprintf(outf, "\nChaque unit%s (%c) repr%ssente ",
	      (aq == HTML)?"&eacute;":"e", markchar,
	      (aq == HTML)?"&eacute;":"e");
    else /* lang == GERMAN */
      fprintf(outf, "\nJede Einheit (%c) entspricht ", markchar);
    int3printf(outf, *unit, sepchar, 0);
    if (*graphtype == 'B') {
      if (lang == ENGLISH)
	fprintf(outf, " %sbyte%s, or part thereof.\n\n", bprefix,
		(*unit == 1)?"":"s");
      else if (lang == FRENCH)
	fprintf(outf, " %soctet%s, ou une partie du moins.\n\n", bprefix,
		(*unit == 1)?"":"s");
      else
	fprintf(outf, " %s%syte%s, oder einem Teil dessen.", bprefix,
                (bprefix[0] == '\0')?"B":"b", (*unit == 1)?"":"s");
    }
    else if (*graphtype == 'P') {
      if (lang == ENGLISH)
	fprintf(outf, " request%s.\n\n",
		(*unit == 1)?" for a page":"s for pages, or part thereof");
      else if (lang == FRENCH)
	fprintf(outf, " requ%ste%s.\n\n", (aq == HTML)?"&ecirc;":"e",
		(*unit == 1)?" sur une page":
		"s sur des pages, ou une partie du moins");
      else  /* lang == GERMAN */
	fprintf(outf, " Seiten-Anfrage%s.\n\n",
		(*unit == 1)?"":"n, oder einem Teil dessen");
    }
    else if (lang == ENGLISH)
      fprintf(outf, " request%s.\n\n", (*unit == 1)?"":"s, or part thereof");
    else if (lang == FRENCH)
      fprintf(outf, " requ%ste%s.\n\n", (aq == HTML)?"&ecirc;":"e",
	      (*unit == 1)?"":"s, ou une partie du moins");
    else
      fprintf(outf, " Anfrage%s.\n\n",
	      (*unit == 1)?"":"n, oder einem Teil dessen");
  }
  if (!aq)
    fprintf(outf, "<pre width=%d><tt>\n", pagewidth);
	
  printcolheads(outf, wantcols, *fieldwidth, *pfieldwidth, *bfieldwidth,
		bprefix, colhead, codeletter, byq, TRUE);

}

/* As promised, each separate line. We print name of date in output() though */

void dateline(FILE *outf, int reqs, int pages, double bytes, char *wantcols,
	      char graphtype, int fieldwidth, int pfieldwidth, int bfieldwidth,
	      int unit, double bdivider)
{
  extern double total_bytes;
  extern int total_succ_reqs, total_page_reqs;
  extern flag aq, byq;

  printcols(outf, wantcols, reqs, pages, bytes, fieldwidth, pfieldwidth,
	    bfieldwidth, bdivider, total_succ_reqs, total_page_reqs,
	    total_bytes, '\0', byq);

  if (aq != PREFORMATTED) {
    if (graphtype == 'B')
      barplot(outf, (int)(ceil(bytes / (unit * bdivider))));
    else if (graphtype == 'P')
      barplot(outf, (pages == 0)?0:((pages - 1) / unit) + 1);
    else
      barplot(outf, (reqs == 0)?0:((reqs - 1) / unit) + 1);
    fprintf(outf, "\n");  /* PREFORMATTED has more before the \n */
  }
}

/*** The status code report (very simple) ***/

void statusout(FILE *outf)
{
  extern int status[], statusnos[];
  extern char statusstrs[NO_STATUS][MAXSTATUSLENGTH];
  extern char ccols[];
  extern int aq, lang;
  extern char repsepchar;

  int fieldwidth;
  int maxreqs = 0;
  char langstr[MAXSTRINGLENGTH];
  int i;

  if (aq != PREFORMATTED) {
    for (i = 0; i < NO_STATUS; i++)
      maxreqs = MAX(maxreqs, status[i]);

    if (lang == ENGLISH)
      strcpy(langstr, "Status Code Report");
    else if (lang == FRENCH)
      strcpy(langstr, "Rapport des Statuts");
    else /* lang == GERMAN */
      strcpy(langstr, "Statuscode-Bericht");
    if (aq == HTML) {
      fprintf(outf, "\n\n<hr>\n<h2><a NAME=\"Status\">%s</a></h2>\n\n",
	      langstr);
      gotos(outf, 'c');
      fprintf(outf, "<pre>");
    }
    else
      fprintf(outf, "%s\n------------------%s\n\n", langstr,
	      (lang == FRENCH)?"-":"");

    i = 10000;
    for (fieldwidth = 5; maxreqs / i >= 10; fieldwidth++)
      i *= 10;
    if (repsepchar != '\0' && maxreqs > 10000)
      fieldwidth = fieldwidth + ((fieldwidth - 1) / 3);

    if (lang == GERMAN)
      strcpy(langstr, "Nr. Beschreibung");
    else /* lang == FRENCH or ENGLISH */
      strcpy(langstr, "no. description");
    printcolheads(outf, ccols, fieldwidth, 0, 0, "", langstr, 'c', FALSE,
		  FALSE);
  }

  for (i = 0; i < NO_STATUS; i++) {
    if (status[i] > 0) {
      if (aq == PREFORMATTED)
	precols(outf, ccols, 'c', FALSE);
      printcols(outf, ccols, status[i], 0, 0, fieldwidth, 0, 0, 0, 1, 1, 1,
		'c', OFF);
      if (aq == PREFORMATTED)
	fprintf(outf, "%d\n", statusnos[i]);
      else if (statusstrs[i][0] == '[')
	fprintf(outf, "    %s\n", statusstrs[i]);
      else
	fprintf(outf, "%d %s\n", statusnos[i], statusstrs[i]);
    }
  }

  if (aq == ASCII)
    asciiline(outf);
  else if (aq == HTML)
    fprintf(outf, "</pre>");
}

/*** The error report ***/

void errout(FILE *outf, int errorder[NO_ERRS])
{
  extern int errors[NO_ERRS];
  extern char errs[NO_ERRS][MAXERRLENGTH];
  extern int eminreqs;
  extern char ecols[];
  extern int aq, lang;
  extern char repsepchar;

  int fieldwidth;
  char langstr[MAXSTRINGLENGTH], langstr2[MAXSTRINGLENGTH];
  int i;

  if (lang == ENGLISH) {
    strcpy(langstr, "Error Report");
    strcpy(langstr2, "------------");
  }
  else if (lang == FRENCH) {
    strcpy(langstr, "Rapport des Erreurs");
    strcpy(langstr2, "-------------------");
  }
  else { /* lang == GERMAN */
    strcpy(langstr, "Fehlerbericht");
    strcpy(langstr2, "-------------");
  }
  if (aq != PREFORMATTED) {
    if (aq == HTML) {
      fprintf(outf, "\n\n<hr>\n<h2><a NAME=\"Error\">%s</a></h2>\n\n",
	      langstr);
      gotos(outf, 'e');
      fprintf(outf, "<p>");
    }
    else /* not HTML */
      fprintf(outf, "%s\n%s\n", langstr, langstr2);

    if (eminreqs == 0) {
      if (lang == ENGLISH)
	fprintf(outf, "Printing all possible errors, ");
      else if (lang == FRENCH)
	fprintf(outf, "Affichage de toutes les erreurs possibles, ");
      else if (aq == HTML)  /* and GERMAN */
	fprintf(outf, "Ausgabe aller m&ouml;glichen Fehler, ");
      else  /* GERMAN and not HTML */
	fprintf(outf, "Ausgabe aller moeglichen Fehler, ");
    }
    else if (lang == ENGLISH)
      fprintf(outf, "Printing all errors with at least %d occurrence%s,\n",
	      eminreqs, (eminreqs == 1)?"":"s");
    else if (lang == FRENCH)
      fprintf(outf,
	      "Affiche toutes les erreurs avec au moins %d occurence%s,\n",
	      eminreqs, (eminreqs == 1)?"":"s");
    else /* lang == GERMAN */
      fprintf(outf,
	      "Ausgabe aller Fehler die mindestens %d mal aufgetreten sind,\n",
              eminreqs);
    if (lang == ENGLISH)
      fprintf(outf, "  sorted by number of occurrences.");
    else if (lang == FRENCH)
      fprintf(outf, "  tri%ses par le nombre d'occurences.",
	      (aq == HTML)?"&eacute;":"e");
    else
      fprintf(outf, "  sortiert nach H%sufigkeit.",
	      (aq == HTML)?"&auml;":"ae");
    if (aq)
      fprintf(outf, "\n\n");
    else
      fprintf(outf, "<pre>");

    i = 10000;
    for (fieldwidth = 5; errors[errorder[0]] / i >= 10; fieldwidth++)
      i *= 10;
    if (repsepchar != '\0' && errors[errorder[0]] >= 10000)
      fieldwidth = fieldwidth + ((fieldwidth - 1) / 3);

    if (lang == ENGLISH)
      strcpy(langstr, "error type");
    else if (lang == FRENCH)
      strcpy(langstr, "type d'erreur");
    else /* lang == GERMAN */
      strcpy(langstr, "Fehlertyp");
    printcolheads(outf, ecols, fieldwidth, 0, 0, "", langstr, 'e', FALSE,
		  FALSE);
  }

  for (i = 0; errors[errorder[i]] >= eminreqs && i < NO_ERRS; i++) {
    if (aq == PREFORMATTED)
      precols(outf, ecols, 'e', FALSE);
    printcols(outf, ecols, errors[errorder[i]], 0, 0, fieldwidth, 0, 0, 0,
	      1, 1, 1, 'e', OFF);
    fprintf(outf, "%s\n",
	    (errs[errorder[i]][0] == '\0')?"[unknown]":errs[errorder[i]]);
  }

  if (aq == ASCII)
    asciiline(outf);
  else if (aq == HTML)
    fprintf(outf, "</pre>");
}

/*** And the general summary ***/

void gensum(FILE *outf)
{
  extern int corrupt_lines, other_lines;
  extern int no_urls, no_hosts, no_urls7, no_hosts7, no_new_hosts7;
  extern double total_bytes, total_bytes7;
  extern int total_succ_reqs, total_fail_reqs, total_other_reqs;
  extern int total_succ_reqs7, total_fail_reqs7, total_other_reqs7;
  extern int total_page_reqs, total_page_reqs7;
  extern flag mq, Wq, dq, Dq, hq, oq, Sq, iq, rq, q7, byq;
  extern int sq, aq, lang, dialect;
  extern char sepchar, *presep;
  extern struct timestruct starttimec, totime, firsttime, lasttime, oldtime;
  extern char dayname[7][4];
  extern char monthname[12][12];

  int totalmins;    /* between first and last entries analysed */
  char langstr[MAXSTRINGLENGTH], langstr2[MAXSTRINGLENGTH];
  double bdivider;
  char bprefix[2];  /* kilo, Mega, etc. */

  bprefix[0] = '\0';
  bprefix[1] = '\0';

  if (aq == HTML)
    fprintf(outf, "<hr>");

  if (aq == PREFORMATTED)
    fprintf(outf, "\nx%sPS%s%d%s%d%s%d%s%d%s%d", presep,
	    presep, starttimec.year, presep, starttimec.monthno + 1,
	    presep, starttimec.date, presep, starttimec.hr, presep,
	    starttimec.min);
  else if (lang == ENGLISH && dialect == NONE)
    fprintf(outf,
	    "\nProgram started at %s-%02d-%s-%d %02d:%02d local time.\n",
	    dayname[dayofdate(starttimec.date, starttimec.monthno,
			      starttimec.year)], starttimec.date,
	    monthname[starttimec.monthno], starttimec.year,
	    starttimec.hr, starttimec.min);
  else if (lang == ENGLISH && dialect == US_ENGLISH)
    fprintf(outf, "\nProgram started at %s-%s-%02d-%d %02d:%02d local time.\n",
	    dayname[dayofdate(starttimec.date, starttimec.monthno,
			      starttimec.year)],
	    monthname[starttimec.monthno], starttimec.date, starttimec.year,
	    starttimec.hr, starttimec.min);
  else if (lang == GERMAN) {
    if (aq == HTML)
      strcpy(langstr, "<b>Programmstart:</b>");
    else
      strcpy(langstr, "Programmstart:");
    fprintf(outf, "\n%s %s, %d. %s %d %02d:%02d Ortszeit.\n", langstr,
	    dayname[dayofdate(starttimec.date, starttimec.monthno,
			      starttimec.year)], starttimec.date,
	    monthname[starttimec.monthno], starttimec.year,
	    starttimec.hr, starttimec.min);
  }
  else { /* lang == FRENCH */
    if (aq == HTML)
      strcpy(langstr, "Programme lanc&eacute; le");
    else
      strcpy(langstr, "Programme lance le");
    fprintf(outf, "\n%s %s %02d %s %d %02d:%02d heure locale.\n", langstr,
	    dayname[dayofdate(starttimec.date, starttimec.monthno,
			      starttimec.year)], starttimec.date,
	    monthname[starttimec.monthno], starttimec.year,
	    starttimec.hr, starttimec.min);
  }

  if (firsttime.code > oldtime.code)
    q7 = OFF;

  if (total_succ_reqs > 0) {
    totalmins = minsbetween(firsttime.date, firsttime.monthno,
			    firsttime.year, firsttime.hr, firsttime.min,
			    lasttime.date, lasttime.monthno, lasttime.year,
			    lasttime.hr, lasttime.min) + 1;
    if (aq == HTML)
      fprintf(outf, "<br>");
    if (aq == PREFORMATTED) {
      fprintf(outf, "\nx%sFR%s%d%s%d%s%d%s%d%s%d", presep, presep,
	      firsttime.year, presep, firsttime.monthno + 1, presep,
	      firsttime.date, presep, firsttime.hr, presep, firsttime.min);
      fprintf(outf, "\nx%sLR%s%d%s%d%s%d%s%d%s%d", presep, presep,
	      lasttime.year, presep, lasttime.monthno + 1, presep,
	      lasttime.date, presep, lasttime.hr, presep, lasttime.min);
      if (q7)
	fprintf(outf, "\nx%sL7%s%d%s%d%s%d%s%d%s%d", presep, presep,
		oldtime.year, presep, oldtime.monthno + 1, presep,
		oldtime.date, presep, oldtime.hr, presep, oldtime.min);
    }
    else if (lang == ENGLISH && dialect == NONE)
      fprintf(outf, "Analysed requests from %s-%02d-%s-%d %02d:%02d to %s-%02d-%s-%d %02d:%02d\n  (%.1f days).\n\n",
	      dayname[dayofdate(firsttime.date,
				firsttime.monthno, firsttime.year)],
	      firsttime.date, monthname[firsttime.monthno], firsttime.year,
	      firsttime.hr, firsttime.min,
	      dayname[dayofdate(lasttime.date, lasttime.monthno,
				lasttime.year)],
	      lasttime.date, monthname[lasttime.monthno], lasttime.year,
	      lasttime.hr, lasttime.min, (double)totalmins / 1440.0);
    else if (lang == ENGLISH && dialect == US_ENGLISH)
      fprintf(outf, "Analyzed requests from %s-%s-%02d-%d %02d:%02d to %s-%s-%02d-%d %02d:%02d\n  (%.1f days).\n\n",
	      dayname[dayofdate(firsttime.date,
				firsttime.monthno, firsttime.year)],
	      monthname[firsttime.monthno], firsttime.date, firsttime.year,
	      firsttime.hr, firsttime.min,
	      dayname[dayofdate(lasttime.date, lasttime.monthno,
				lasttime.year)],
	      monthname[lasttime.monthno], lasttime.date, lasttime.year,
	      lasttime.hr, lasttime.min, (double)totalmins / 1440.0);
    else if (lang == GERMAN) {
      if (aq == HTML)
	strcpy(langstr, "<b>Auswertungszeitraum:</b>");
      else
	strcpy(langstr, "Auswertungszeitraum:");
      fprintf(outf, "%s %s, %d. %s %d %02d:%02d bis %s, %d. %s %d %02d:%02d\n  (%.1f Tage).\n\n",
	      langstr, dayname[dayofdate(firsttime.date,
					 firsttime.monthno, firsttime.year)],
	      firsttime.date, monthname[firsttime.monthno], firsttime.year,
	      firsttime.hr, firsttime.min,
	      dayname[dayofdate(lasttime.date, lasttime.monthno,
				lasttime.year)],
	      lasttime.date, monthname[lasttime.monthno], lasttime.year,
	      lasttime.hr, lasttime.min, (double)totalmins / 1440.0);
    }
    else { /* lang == FRENCH */
      if (aq == HTML) {
	strcpy(langstr, "Requ&ecirc;tes analys&eacute;es de");
	strcpy(langstr2, "&agrave;");
      }
      else {
	strcpy(langstr, "Requetes analysees de");
	strcpy(langstr2, "a");
      }
      fprintf(outf, "%s %s %02d %s %d %02d:%02d %s %s %02d %s %d %02d:%02d\n  (%.1f jours).\n\n",
	      langstr, dayname[dayofdate(firsttime.date,
					 firsttime.monthno, firsttime.year)],
	      firsttime.date, monthname[firsttime.monthno], firsttime.year,
	      firsttime.hr, firsttime.min, langstr2,
	      dayname[dayofdate(lasttime.date, lasttime.monthno,
				lasttime.year)],
	      lasttime.date, monthname[lasttime.monthno], lasttime.year,
	      lasttime.hr, lasttime.min, (double)totalmins / 1440.0);
    }
  }

  if (aq == HTML) {
    if (lang == ENGLISH)
      fprintf(outf, "<p><b>Total successful requests:</b> ");
    else if (lang == FRENCH)
      fprintf(outf, "<p><b>Nombre total de requ&ecirc;tes effectu&eacute;s :</b> ");
    else /* lang == GERMAN */
      fprintf(outf, "<p><b>Erfolgreich bearbeitete Anfragen:</b> ");
  }
  else if (aq == ASCII) {
    if (lang == ENGLISH)
      fprintf(outf, "Total successful requests: ");
    else if (lang == FRENCH)
      fprintf(outf, "Nombre total de requetes effectues : ");
    else /* lang == GERMAN */
      fprintf(outf, "Erfolgreich bearbeitete Anfragen: ");
  }
  else   /* aq == PREFORMATTED */
    fprintf(outf, "\nx%sSR%s", presep, presep);
  int3printf(outf, total_succ_reqs, sepchar, 0);
  if (q7) {
    if (aq == PREFORMATTED)
      fprintf(outf, "\nx%sS7%s%d", presep, presep, total_succ_reqs7);
    else {
      fprintf(outf, " (");
      int3printf(outf, total_succ_reqs7, sepchar, 0);
      fprintf(outf, ")");
    }
  }
  if (totalmins > 30 && aq != PREFORMATTED) {
    if (aq == HTML) {
      if (lang == ENGLISH)
	fprintf(outf, "\n<br><b>Average successful requests per day:</b> ");
      else if (lang == FRENCH)
	fprintf(outf, "\n<br><b>Moyenne par jour des requ&ecirc;tes effectu&eacute;s :</b> ");
      else /* lang == GERMAN */
	fprintf(outf, "\n<br><b>Durchschnittlich bearbeitete Anfragen pro Tag:</b> ");
    }
    else if (lang == ENGLISH)
      fprintf(outf, "\nAverage successful requests per day: ");
    else if (lang == FRENCH)
      fprintf(outf, "\nMoyenne par jour des requetes effectues : ");
    else /* lang == GERMAN */
      fprintf(outf, "\nDurchschnittlich bearbeitete Anfragen pro Tag: ");
    if (total_succ_reqs < 2)
      fprintf(outf, "0");
    else
      double3printf(outf, ROUND((double)(total_succ_reqs - 1)) * 1440.0 / (totalmins + 0.0), sepchar, 0);
    if (q7) {
      fprintf(outf, " (");
      int3printf(outf, total_succ_reqs7 / 7, sepchar, 0);
      fprintf(outf, ")");
    }
  }
  if (total_page_reqs > 0) {
    if (aq == HTML) {
      if (lang == ENGLISH)
	fprintf(outf, "\n<br><b>Total successful requests for pages:</b> ");
      else if (lang == FRENCH)
	fprintf(outf, "\n<br><b>Nombre total de requ&ecirc;tes sur des pages effectu&eacute;s :</b> ");
      else /* lang == GERMAN */
	fprintf(outf, "\n<br><b>Erfolgreich bearbeitete Seiten-Anfragen:</b> ");
    }
    else if (aq == ASCII) {
      if (lang == ENGLISH)
	fprintf(outf, "\nTotal successful requests for pages: ");
      else if (lang == FRENCH)
	fprintf(outf, "\nNombre total de requetes pour pages effectues : ");
      else /* lang == GERMAN */
	fprintf(outf, "\nErfolgreich bearbeitete Anfragen fuer Seiten: ");
    }
    else   /* aq == PREFORMATTED */
      fprintf(outf, "\nx%sPR%s", presep, presep);
    int3printf(outf, total_page_reqs, sepchar, 0);
    if (q7) {
      if (aq == PREFORMATTED)
	fprintf(outf, "\nx%sP7%s%d", presep, presep, total_page_reqs7);
      else {
	fprintf(outf, " (");
	int3printf(outf, total_page_reqs7, sepchar, 0);
	fprintf(outf, ")");
      }
    }
  }
  if (total_fail_reqs > 0) {
    if (aq == HTML) {
      if (lang == ENGLISH)
	fprintf(outf, "\n<br><b>Total failed requests:</b> ");
      else if (lang == FRENCH)
	fprintf(outf,
		"\n<br><b>Nombre de requ&ecirc;tes rat&eacute;s :</b> ");
      else /* lang == GERMAN */
	fprintf(outf, "\n<br><b>Fehlgeschlagene Anfragen:</b> ");
    }
    else if (aq == ASCII) {
      if (lang == ENGLISH)
	fprintf(outf, "\nTotal failed requests: ");
      else if (lang == FRENCH)
	fprintf(outf, "\nNombre de requetes rates : ");
      else /* lang == GERMAN */
	fprintf(outf, "\nFehlgeschlagene Anfragen: ");
    }
    else   /* aq == PREFORMATTED */
      fprintf(outf, "\nx%sFL%s", presep, presep);
    int3printf(outf, total_fail_reqs, sepchar, 0);
    if (q7) {
      if (aq == PREFORMATTED)
	fprintf(outf, "\nx%sF7%s%d", presep, presep, total_fail_reqs7);
      else {
	fprintf(outf, " (");
	int3printf(outf, total_fail_reqs7, sepchar, 0);
	fprintf(outf, ")");
      }
    }
  }
  if (total_other_reqs > 0) {
    if (aq == HTML) {
      if (lang == ENGLISH)
	fprintf(outf, "\n<br><b>Total redirected requests:</b> ");
      else if (lang == FRENCH)
	fprintf(outf,
		"\n<br><b>Nombre de requ&ecirc;tes redirig&eacute; :</b> ");
      else /* lang == GERMAN */
	fprintf(outf, "\n<br><b>Umgeleitete Anfragen:</b> ");
    }
    else if (aq == ASCII) {
      if (lang == ENGLISH)
	fprintf(outf, "\nTotal redirected requests: ");
      else if (lang == FRENCH)
	fprintf(outf, "\nNombre de requetes redirige : ");
      else /* lang == GERMAN */
	fprintf(outf, "\nUmgeleitete Anfragen: ");
    }
    else   /* aq == PREFORMATTED */
      fprintf(outf, "\nx%sRR%s", presep, presep);
    int3printf(outf, total_other_reqs, sepchar, 0);
    if (q7) {
      if (aq == PREFORMATTED)
	fprintf(outf, "\nx%sR7%s%d", presep, presep, total_other_reqs7);
      else {
	fprintf(outf, " (");
	int3printf(outf, total_other_reqs7, sepchar, 0);
	fprintf(outf, ")");
      }
    }
  }
  if (rq) {   /* These data are not collected o/wise */
    if (aq == HTML) {
      if (lang == ENGLISH)
	fprintf(outf, "\n<br><b>Number of distinct files requested:</b> ");
      else if (lang == FRENCH)
	fprintf(outf, "\n<br><b>Nombre de fichiers distincts appel&eacute;s :</b> ");
      else /* lang == GERMAN */
	fprintf(outf, "\n<br><b>Anzahl unterschiedlicher verlangter Dateien:</b> ");
    }
    else if (aq == ASCII) {
      if (lang == ENGLISH)
	fprintf(outf, "\nNumber of distinct files requested: ");
      else if (lang == FRENCH)
	fprintf(outf, "\nNombre de fichiers distincts appeles : ");
      else /* lang == GERMAN */
	fprintf(outf, "\nAnzahl unterschiedlicher verlangter Dateien: ");
    }
    else   /* aq == PREFORMATTED */
      fprintf(outf, "\nx%sNF%s", presep, presep);
    int3printf(outf, no_urls, sepchar, 0);
    if (q7) {
      if (aq == PREFORMATTED)
	fprintf(outf, "\nx%sN7%s%d", presep, presep, no_urls7);
      else {
	fprintf(outf, " (");
	int3printf(outf, no_urls7, sepchar, 0);
	fprintf(outf, ")");
      }
    }
  }
  if ((sq == ON || sq == APPROX) && no_hosts > 0) {
    if (aq == HTML) {
      if (lang == ENGLISH)
	fprintf(outf, "\n<br><b>%sumber of distinct hosts served:</b> ",
		(sq == ON)?"N":"Approximate n");
      else if (lang == FRENCH)
	fprintf(outf,
		"\n<br><b>Nombre%s d'invit&eacute;s distincts servis :</b> ",
		(sq == ON)?"":" approximatif");
      else /* lang == GERMAN */
	fprintf(outf, "\n<br><b>%sAnzahl unterschiedlicher anfragender Hosts:</b> ", (sq == ON)?"":"Ungef&auml;hre ");
    }
    else if (aq == ASCII) {
      if (lang == ENGLISH)
	fprintf(outf, "\n%sumber of distinct hosts served: ",
		(sq == ON)?"N":"Approximate n");
      else if (lang == FRENCH)
	fprintf(outf, "\nNombre%s d'invites distincts servis : ",
		(sq == ON)?"":" approximatif");
      else /* lang == GERMAN */
	fprintf(outf, "\n%sAnzahl unterschiedlicher anfragender Hosts: ",
		(sq == ON)?"":"Ungefaehre ");
    }
    else   /* aq == PREFORMATTED */
      fprintf(outf, "\nx%s%cH%s", presep, (sq == ON)?'N':'A', presep);
    int3printf(outf, no_hosts, sepchar, 0);
    if (q7) {
      if (aq == PREFORMATTED)
	fprintf(outf, "\nx%s%c7%s%d", presep, (sq == ON)?'H':'A', presep,
		no_hosts7);
      else {
	fprintf(outf, " (");
	int3printf(outf, no_hosts7, sepchar, 0);
	fprintf(outf, ")");
      }
      if (aq == HTML) {
	if (lang == ENGLISH)
	  fprintf(outf, "\n<br><b>%sumber of new hosts served in last 7 days:</b> ",
		  (sq == ON)?"N":"Approximate n");
	else if (lang == FRENCH)
	  fprintf(outf, "\n<br><b>Nombre%s de nouveaux invit&eacute;s les 7 derniers jours :</b> ",
		  (sq == ON)?" approximatif":"");
	else /* lang == GERMAN */
	  fprintf(outf, "\n<br><b>%sAnzahl neu anfragender Hosts in den letzten 7 Tagen:</b> ",
		  (sq == ON)?"":"Ungef&auml;hre ");
      }
      else if (aq == ASCII) {
	if (lang == ENGLISH)
	  fprintf(outf, "\n%sumber of new hosts served in last 7 days: ",
		  (sq == ON)?"N":"Approximate n");
	else if (lang == FRENCH)
	  fprintf(outf,
		  "\nNombre%s de nouveaux invites les 7 derniers jours : ",
		  (sq == ON)?" approximatif":"");
	else /* lang == GERMAN */
	  fprintf(outf, "\n%sAnzahl neu anfragender Hosts in den letzten 7 Tagen: ",
		  (sq == ON)?"":"Ungefaehre ");
      }
      else   /* aq == PREFORMATTED */
	fprintf(outf, "\nx%s%cV%s", presep, (sq == ON)?'N':'A', presep);
      int3printf(outf, no_new_hosts7, sepchar, 0);
    }
  }
  if (corrupt_lines > 0) {
    if (aq == HTML) {
      if (lang == ENGLISH)
	fprintf(outf, "\n<br><b>Corrupt logfile lines:</b> ");
      else if (lang == FRENCH)
	fprintf(outf,
		"\n<br><b>Lignes invalides dans le fichier log :</b> ");
      else /* lang == GERMAN */
	fprintf(outf, "\n<br><b>Unlesbare Zeilen in der Logdatei:</b> ");
    }
    else if (aq == ASCII) {
      if (lang == ENGLISH)
	fprintf(outf, "\nCorrupt logfile lines: ");
      else if (lang == FRENCH)
	fprintf(outf, "\nLignes invalides dans le fichier log : ");
      else /* lang == GERMAN */
	fprintf(outf, "\nUnlesbare Zeilen in der Logdatei: ");
    }
    else   /* aq == PREFORMATTED */
      fprintf(outf, "\nx%sCL%s", presep, presep);
    int3printf(outf, corrupt_lines, sepchar, 0);
  }
  if (other_lines > 0) {
    if (aq == HTML) {
      if (lang == ENGLISH)
	fprintf(outf, "\n<br><b>Unwanted logfile entries:</b> ");
      else if (lang == FRENCH)
	fprintf(outf, "\n<br><b>Entr&eacute;es non desir&eacute;es dans le fichier log :</b> ");
      else /* lang == GERMAN */
	fprintf(outf, "\n<br><b>Nichtverwendete Eintr&auml;ge in der Logdatei:</b> ");
    }
    else if (aq == ASCII) {
      if (lang == ENGLISH)
	fprintf(outf, "\nUnwanted logfile entries: ");
      else if (lang == FRENCH)
	fprintf(outf, "\nEntrees non desirees dans le fichier log : ");
      else /* lang == GERMAN */
	fprintf(outf, "\nNichtverwendete Eintraege in der Logdatei: ");
    }
    else   /* aq == PREFORMATTED */
      fprintf(outf, "\nx%sUL%s", presep, presep);
    int3printf(outf, other_lines, sepchar, 0);
  }
  if (byq) {
    if (aq == HTML) {
      if (lang == ENGLISH)
	fprintf(outf, "\n<br><b>Total data transferred:</b> ");
      else if (lang == FRENCH)
	fprintf(outf, "\n<br><b>Quantit&eacute; de traffic total :</b> ");
      else /* lang == GERMAN */
	fprintf(outf, "\n<br><b>Menge verschickter Daten:</b> ");
    }
    else if (aq == ASCII) {
      if (lang == ENGLISH)
	fprintf(outf, "\nTotal data transferred: ");
      else if (lang == FRENCH)
	fprintf(outf, "\nQuantite de traffic total : ");
      else /* lang == GERMAN */
	fprintf(outf, "\nMenge verschickter Daten: ");
    }
    else   /* aq == PREFORMATTED */
      fprintf(outf, "\nx%sBT%s", presep, presep);
    bdivider = finddivider(total_bytes, bprefix);
    double3printf(outf, ROUND(total_bytes / bdivider), sepchar, 0);
    if (aq != PREFORMATTED)
      fprintf(outf, " %s%s", bprefix, (lang == FRENCH)?"octets":"bytes");
    if (q7) {
      if (aq == PREFORMATTED)
	fprintf(outf, "\nx%sB7%s", presep, presep);
      else
	fprintf(outf, " (");
      bdivider = finddivider(total_bytes7, bprefix);
      double3printf(outf, ROUND(total_bytes7 / bdivider), sepchar, 0);
      if (aq != PREFORMATTED)
	fprintf(outf, " %s%s)", bprefix, (lang == FRENCH)?"octets":"bytes");
    }
    if (totalmins > 30 && aq != PREFORMATTED) {
      if (aq == HTML) {
	if (lang == ENGLISH)
	  fprintf(outf, "\n<br><b>Average data transferred per day:</b> ");
	else if (lang == FRENCH)
	  fprintf(outf, "\n<br><b>Taux de traffic moyen par jour :</b> ");
	else /* lang == GERMAN */
	  fprintf(outf, "\n<br><b>Durchschnittliche Menge verschickter Daten pro Tag:</b> ");
      }
      else if (lang == ENGLISH)
	fprintf(outf, "\nAverage data transferred per day: ");
      else if (lang == FRENCH)
	fprintf(outf, "\nTaux de traffic moyen par jour : ");
      else /* lang == GERMAN */
	fprintf(outf,
		"\nDurchschnittliche Menge verschickter Daten pro Tag: ");
      bdivider = finddivider((total_bytes * 1440) / (totalmins + 0.0),
			     bprefix);
      double3printf(outf, ROUND((total_bytes * 1440) / (totalmins + 0.0) / bdivider), sepchar, 0);
      fprintf(outf, " %s%s", bprefix, (lang == FRENCH)?"octets":"bytes");
      if (q7) {
	fprintf(outf, " (");
	bdivider = finddivider(total_bytes7 / 7.0, bprefix);
	double3printf(outf, ROUND(total_bytes7 / 7.0 / bdivider), sepchar, 0);
	fprintf(outf, " %sbytes)", bprefix);
      }
    }
  }
  if (q7 && aq != PREFORMATTED) {
    if (aq == HTML)
      fprintf(outf, "\n<br>");
    else
      fprintf(outf, "\n");
    if (lang == ENGLISH)
      fprintf(outf, "(Figures in parentheses refer to the ");
    else if (lang == FRENCH)
      fprintf(outf, "(Les valeurs entre parenth%sses repr%ssentent les ",
	      (aq == HTML)?"&egrave;":"e", (aq == HTML)?"&eacute;":"e");
    else /* lang == GERMAN */
      fprintf(outf, "(Zahlen in Klammern beziehen sich auf die ");
    if (starttimec.code > totime.code) {
      if (lang == ENGLISH)
	strcpy(langstr, "days to");
      else if (lang == FRENCH)
	strcpy(langstr, "jours au");
      else /* lang == GERMAN */
	strcpy(langstr, "Tage bis");
      fprintf(outf, "7 %s %02d-%s-%4d).", langstr, totime.date,
	      monthname[totime.monthno], totime.year);
    }
    else if (lang == ENGLISH)
      fprintf(outf, "last 7 days).");
    else if (lang == FRENCH)
      fprintf(outf, "7 derniers jours).");
    else /* lang == GERMAN */
      fprintf(outf, "letzten 7 Tage).");
  }
  
  if (aq == HTML && (mq || Wq || dq || Dq || hq || oq || Sq || iq || rq))
    gotos(outf, 'z');
  else if (aq == ASCII) {
    fprintf(outf, "\n");
    asciiline(outf);
  }
  else if (aq == PREFORMATTED)
    fprintf(outf, "\n");
}


