/*
** hash.c - functions for a hash table.
**
** Copyright (c) 1996 Thorsten Kukuk
**
** This file is part of the NYS YP Server.
**
** The NYS YP Server is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS YP Server is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
** 
** You should have received a copy of the GNU General Public
** License along with the NYS YP Server; see the file COPYING.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Author: Thorsten Kukuk <kukuk@uni-paderborn.de>
*/

static char rcsid[] = "$Id: hash.c,v 1.0.4.1 1996/07/14 15:10:45 kukuk Exp $";

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "hash.h"

data_t **hash_malloc(void)
{
  data_t **work;
  unsigned long int i;

  work = malloc(sizeof(data_t *)  * TABLESIZE);
  for(i = 0; i < TABLESIZE; i++) work[i] = NULL;

  return work;
}

int hash_insert(data_t **table, const char *key, const char *val)
{
  long hkey;
  size_t i;

  hkey = 0;
  for(i = 0; i < strlen(key); i++)
    hkey = (256*hkey+key[i]) % TABLESIZE;

  if(table[hkey] != NULL)
    {
      if(strcmp(table[hkey]->key,key)==0)
        return -1;
      else
        {
          data_t *work, *ptr;
          
          work=table[hkey]->next;
          ptr = table[hkey];

          while(work != NULL)
            if(strcmp(work->key,key)==0)
              return -1;
            else
              {
                ptr = work;
                work = work->next;
              }
          
          ptr->next = malloc(sizeof(data_t));
          work = ptr->next;
          work->next = NULL;
          work->key = strdup(key);
          work->val = malloc(strlen(val)+1);
          strcpy(work->val,val);
        }
    }
  else
    {
      table[hkey] = malloc(sizeof(data_t));
      table[hkey]->key = strdup(key);
      table[hkey]->next = NULL;
      table[hkey]->val = malloc(strlen(val)+1);
      strcpy(table[hkey]->val,val);
    }

  return 0;
}

int hash_free (data_t **table)
{
  /* XXX Not implementet yet! */

  return 0;
}

char *hash_search (data_t **table, const char *key)
{
  data_t *work;
  long hkey;
  size_t i;
  
  hkey = 0;
  for(i = 0; i < strlen(key); i++)
    hkey = (256*hkey +key[i]) % TABLESIZE;
  
  if(table[hkey] == NULL)
    return NULL;
  else
    if(strcmp(table[hkey]->key,key)!=0)
      {
        if(table[hkey]->next == NULL)
          return NULL;
        else
          {
            work=table[hkey]->next;
            while(work != NULL)
              if(strcmp(work->key,key)==0) 
		return work->val;
              else
                work = work->next;
            if(work == NULL) 
              return NULL;
          }
      }
    else
      return table[hkey]->val;
  
  return NULL;
}

int hash_delkey (data_t **table, const char *key)
{  
  data_t *work, *prev;
  long hkey;
  size_t i;
  
  hkey = 0;
  for(i = 0; i < strlen(key); i++)
    hkey = (256*hkey +key[i]) % TABLESIZE;
  
  if(table[hkey] == NULL)
    return -1;
  else
    if(strcmp(table[hkey]->key,key)!=0)
      {
        if(table[hkey]->next == NULL)
          return -1;
        else
          {
            work=table[hkey]->next;
	    prev=table[hkey];
            while(work != NULL)
              if(strcmp(work->key,key)==0) 
		{
		  prev->next = work->next;
		  free(work->key);
		  free(work->val);
		}
              else
		{
		  prev = work;
		  work = work->next;
		}
            if(work == NULL) 
              return -1;
          }
      }
    else
      {
	free(table[hkey]->key);
	free(table[hkey]->val);
	table[hkey] = table[hkey]->next;
      }

  return 0;
}

data_t *hash_first(data_t **table)
{
  unsigned long i;

  for(i = 0; i < TABLESIZE; i++)
    if(table[i] != NULL) return table[i];

  return NULL;
}

data_t *hash_next (data_t **table, const char *key)
{
  data_t *work;
  long hkey;
  size_t i;
  
  hkey = 0;
  for(i = 0; i < strlen(key); i++)
    hkey = (256*hkey +key[i]) % TABLESIZE;
  
  if(table[hkey] == NULL)
    return NULL;

  if(strcmp(table[hkey]->key,key)==0)
    {
      if(table[hkey]->next != NULL)
	return table[hkey]->next;
    }
  else
    {
      work = table[hkey]->next;
      while(work != NULL)
	{
	  if(strcmp(work->key,key)==0)
	    if(work->next!= NULL)
	      return work->next;
	    else
	      break;
	  work = work->next;
	}
      return NULL;
    }

  for(i=hkey+1; i < TABLESIZE; i++)
    if(table[i] != NULL)
      return table[i];

  return NULL;
}
