.TH gv 1 "" "gv" \" -*- nroff -*-

\fBName\fP

.Pp
.DS
.sp 
.ft CR
.nf
       gv - View PostScript and PDF documents using ghostscript
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.SH \fBSynopsis\fP 

.Pp
.Pp
.DS
.sp 
.ft CR
.nf
gv [ filename ]
   [-monochrome] [-grayscale] [-color]
   [-resolution <dpi>] [-dpi <dpi>]
   [-xdpi <dpi>] [-ydpi <dpi>]
   [-[no]safer] [-[no]quiet] [-arguments <arguments>]
   [-page <label>] [-[no]center]
   [-letter] [-tabloid] [-ledger] [-legal] [-folio]
   [-quarto] [-10x14] [-statement] [-executive]
   [-a3] [-a4] [-a5] [-b4] [-b5]
   [-portrait] [-landscape] [-upsidedown] [-seascape]
   [-magstep <n>]
   [-swap] [-noswap]
   [-?] [-h] [-help]
   [-resize] [-noresize]
   [-geometry [<width>][x<height>][{+-}<x>{+-}<y>]]
   [-ad <resource file>]
   [-style <resource file>]
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.SH \fBDescription\fP 

.Pp
.Pp
.Pp
gv allows to view and navigate through
PostScript and PDF documents on an X display
by providing a user interface for the ghostscript interpreter.
.Pp
Please note that gv is derived from Tim Theisen's
ghostview 1.5.
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.SH \fBOptions\fP 

.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fB-ad <resource file>\fP"
.nr bi 1
.Pp
Read and use additional resources from the file
<resource file>.
These resources have higher priority than those provided
in the context of the -style <resource file> option.
.IP "\fB-antialias\fP, \fB-noantialias\fP"
.nr bi 1
.Pp
Whether to use antialiasing.
.IP "\fB-arguments <arguments>\fP"
.nr bi 1
.Pp
Start ghostscript with additional options as specified by the
string <arguments>.
.IP "\fB-center\fP, \fB-nocenter\fP"
.nr bi 1
.Pp
Whether the page should be centered automatically.
.IP "\fB-dpi <dpi>\fP, \fB-resolution <dpi>\fP"
.nr bi 1
.Pp
Sets the resolution to <dpi> dots per inch.
.IP "\fB-h\fP, \fB-?\fP "
.nr bi 1
.Pp
Display a short help message and exit.
.IP "\fB-help\fP"
.nr bi 1
.Pp
Display a a more explicit help message and exit.
.IP "\fB-magstep <n>\fP"
.nr bi 1
.Pp
Allow magnifications ranging from -<n> to +<n>.
.IP "\fB-monochrome\fP, \fB-grayscale\fP, \fB-color\fP"
.nr bi 1
.Pp
Sets the color palette to be used.
.IP "\fB-page <label>\fP"
.nr bi 1
.Pp
Display the page with label <label> first.
.IP "\fB-<paper-size>\fP"
.nr bi 1
.Pp
Sets the paper-size. Valid values for <paper-size> are:
.DS
.sp 
.ft CR
.nf
   Size      X (pts)  Y (pts)   X cm    Y cm
   -----------------------------------------
   letter      612      792    21.59   27.94
   tabloid     792     1224
   ledger     1224      792    43.18   27.94
   legal       612     1008    21.59   35.56
   statement   396      612
   executive   540      720
   a3          842     1190    29.70   41.98
   a4          595      842    20.99   29.70
   a5          420      595    14.85   20.99
   b4          729     1032    25.01   35.35
   b5          516      729    17.67   25.01
   folio       612      936 
   quarto      610      780
   10x14       720     1008
   
.DE
.fi 
.ec
.ft P
.sp
.IP "\fB-portrait\fP, \fB-landscape\fP, \fB-seascape\fP, \fB-upsidedown\fP"
.nr bi 1
.Pp
Sets the orientation.
.IP "\fB-quiet\fP, \fB-noquiet\fP"
.nr bi 1
.Pp
Whether to start ghostscript with the -dQUIET option.
.IP "\fB-resize\fP, \fB-noresize\fP"
.nr bi 1
.Pp
Whether gv is allowed to automatically fit the
size of its window to the size of the displayed page.
.IP "\fB-safer\fP, \fB-nosafer\fP"
.nr bi 1
.Pp
Whether to start ghostscript with the -dSAFER option.
.IP "\fB-style <resource file>\fP"
.nr bi 1
.Pp
Read and use additional resources from the file <resource file>.
These resources have  lower priority than those provided
in the context of the -ad <resource file> option.
.IP "\fB-swap\fP, \fB-noswap\fP"
.nr bi 1
.Pp
Whether to interchange the meaning of the orientations
landscape and seascape.
.IP "\fB-xdpi <dpi>\fP, \fB-ydpi <dpi>\fP"
.nr bi 1
.Pp
Sets the horizontal, vertical resolution to <dpi> dots
per inch. 
.if \n(ll>1 .RE
.nr ll -1
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.SH \fBThe User Interface\fP 

.Pp
This section covers some of the not so obvious features
of the user interface.
.Pp
.DS
.sp 
.ft CR
.nf
.DE
.fi 
.ec
.ft P
.sp
.Pp
\fBScrolling\fP 

.Pp
To scroll the displayed page 'proportionally' using the mouse 
.DS
.sp 
.ft CR
.nf
    position the mouse pointer on the page,
    press the left mouse button,
    move the mouse,
    release the left mouse button.
.DE
.fi 
.ec
.ft P
.sp

To scroll it 'absolutely' using the mouse
.DS
.sp 
.ft CR
.nf
    position the mouse pointer on the page,   
    press the left button,
    press the third mouse  button,            
    move the mouse,                           
    release the third mouse button,            
    release the left mouse button.            
.DE
.fi 
.ec
.ft P
.sp

Alternatively the arrow keys may be used to scroll the
main window.
.Pp
.DS
.sp 
.ft CR
.nf
.DE
.fi 
.ec
.ft P
.sp
.Pp
Similarly, to scroll the file lists shown in the file
selection box using the mouse
.DS
.sp 
.ft CR
.nf
    position the mouse pointer on the list,    
    press the left mouse button,              
    move the mouse,
    release the left mouse button.
.DE
.fi 
.ec
.ft P
.sp

Alternatively, clicking with the second mouse button
in the upper/lower half of the list       
scrolls the list up/down page by page.
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.SH Authors 

.Pp
.Pp
.DS
.sp 
.ft CR
.nf

Copyright (C) 1992-1996  Johannes Plass, Timothy O. Theisen

This  program is free software; you can redistribute it 
and/or  modify  it under the terms  of the  GNU General 
Public  License  as  published  by  the  Free  Software 
Foundation;  either  version 2 of  the License, or  (at 
your option) any later version.

This  program is distributed in  the hope  that it will 
be useful, but  WITHOUT ANY WARRANTY;  without even the
implied warranty  of  MERCHANTABILITY or  FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You  should  have  received a  copy of  the  GNU General
Public License along with this program; if not, write to
the  Free  Software  Foundation,  Inc.,  675  Mass  Ave, 
Cambridge, MA 02139, USA.

Please send suggestions or bug reports to: 
       plass@dipmza.physik.uni-mainz.de
.DE
.fi 
.ec
.ft P
.sp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
.Pp
