# $Header: /usr/lib/cvs/root/tcpquota/lib/cron_functions.pl,v 1.3 1998/03/21 23:17:50 turbo Exp $
#
# $Log: cron_functions.pl,v $
# Revision 1.3  1998/03/21 23:17:50  turbo
# * Changed the explanation about what the file/function does and what happens
#   if we do a 'return(0);' as the first line in the code...
# * Logg the execution of the function as 'CRON:'...
# * Make sure we protect the '@'... perl does not like it otherwise...
#
# Revision 1.2  1998/03/21 22:52:35  turbo
# Removed some variables that where initialized in the main daemon... Better
# to spell it our propperly instead...
#
# Revision 1.1  1998/03/21 22:38:51  turbo
# Moved the function 'verify_link()' to it's separate file, and added a
# require line in the daemon, that way one can edit and change the behavior
# on it much easier... (I wanted a way to do a finger on our mail delivery
# system, it could as easily be TCPQuota that do that)...
#
#

######################################################################
#
# proc: verify_link()
#
# This file/function can be used to do certain repetive stuff on/to the link...
# For example: Double check to se if the ISDN card is working,
#              Trigger mail delivering
#
# If you do not want to use this function, just remove the comment on
# the line that says: 'return(0);'...
#
sub verify_link {
#    return(0);  # If we return here, none of the below code will be executed...

    # Logging is good, say after me 'logging is good'...
    &logg(1, "CRON: Doing verify_link()...\n");

    # Just check that a signal can go through to the other side...
    # (our card is a little buggy, so it crashes once every now and then)
    if(system("/bin/ping -c 2 $cf{'REM_ADDR'} 2> /dev/null > /dev/null")) {
	# Ping returned a positive value, which means it could not find the
	# other end...
	&logg(1, "HANGUP: Link have crashed (again!), hanging up...\n");
	system("/usr/sbin/isdnctrl hangup ippp0");
    }

    # Trigger our mail delivery system...
    system("finger ccw\@nexus.tripnet.se >/dev/null 2>&1");
}

1;
