#include "forms.h"
#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <stdlib.h>
#include "xmysqladmin.h"
#include "xmysqladmin2.h"
#include "mysql.h"

#define NO_SELECT_HOST 0
#define SELECTED_HOST  1
#define NO_SELECT_USER 2
#define SELECTED_USER  3
#define NO_SELECT_DBF  4
#define SELECTED_DBF   5
#define SELECTED_SUBFORM 6

extern struct setup Setup;
extern struct stat Stat;
FD_inputhost *f_inputhost;
extern struct inputGrant *InputGrant, *InpHost, *InpDb, *InpUser;
struct inputGrant *InputTemp;
extern FD_grant *f_grant;

void main_inputhost(int type);
void inputhost_setfields(void);
void inputhost_getfields(void);
extern void grant_activate(int status);
extern void grant_getHosts(FL_OBJECT *browser);

void inputhost_input(FL_OBJECT *obj, long data)
{
  ;
}
void inputhost_save(FL_OBJECT *obj, long data)
{
  int closeForm = 1;
  
  inputhost_getfields();
  /* creation de la fiche du host */
  if(InputGrant->host[0] && InputGrant->db[0])
  {
    MYSQL connection;
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      char *query;
      
      query = (char *) malloc(2048);
      if(!query) return;
      
      mysql_select_db(&connection, "mysql");
      if(!InputGrant->stat)
	{
	  sprintf(query,
	          "insert into host (host,db,select_priv,insert_priv,update_priv,delete_priv,create_priv,drop_priv) values ('%s','%s','%s','%s','%s','%s','%s','%s')",
                  InputGrant->host,InputGrant->db,InputGrant->select,InputGrant->insert,InputGrant->update,InputGrant->delete,InputGrant->create,InputGrant->drop);
	}
      else
	{
	  sprintf(query,
	          "update host set db='%s',select_priv='%s',insert_priv='%s',update_priv='%s',delete_priv='%s',create_priv='%s',drop_priv='%s' where host='%s' and db='%s'",
                  InputGrant->db,InputGrant->select,
		  InputGrant->insert,InputGrant->update,
		  InputGrant->delete,InputGrant->create,
		  InputGrant->drop,InputTemp->host,InputTemp->db);
	}
      if (!mysql_query(&connection, query))
	{
	  result = mysql_store_result(&connection);
	  if(result != NULL) mysql_free_result(result);
	}
      else
	{
	  fl_show_messages(mysql_error(&connection));
	  closeForm = 0;
	}
	free(query);
	mysql_close(&connection);
    }
  }

  
  if(closeForm)
    {
      free(InputTemp);
      fl_hide_form(f_inputhost->inputhost);
      fl_free_form(f_inputhost->inputhost);
      free(f_inputhost);
      Stat.flagInputHost=0;
      grant_activate(Stat.statusGrant);  

      if(fl_get_browser_maxline(f_grant->users))
	fl_clear_browser(f_grant->users);
      if(fl_get_browser_maxline(f_grant->dbf))
	fl_clear_browser(f_grant->dbf);
      grant_activate(NO_SELECT_HOST);
      memset(InpHost, '\0', sizeof(struct inputGrant));
      memset(InpDb, '\0', sizeof(struct inputGrant));
      memset(InpUser, '\0', sizeof(struct inputGrant));
      grant_getHosts(f_grant->hosts);
    }
}

void inputhost_setfields()
{
  fl_set_input(f_inputhost->hostName       , InputGrant->host);
  fl_set_input(f_inputhost->databaseName   , InputGrant->db);
  if(InputGrant->select[0] == 'Y')
    fl_set_button(f_inputhost->bSelect, 1);
  else
    fl_set_button(f_inputhost->bSelect, 0);

  if(InputGrant->insert[0] == 'Y')
    fl_set_button(f_inputhost->bInsert, 1);
  else
    fl_set_button(f_inputhost->bInsert, 0);
  
  if(InputGrant->update[0] == 'Y')
    fl_set_button(f_inputhost->bUpdate, 1);
  else
    fl_set_button(f_inputhost->bUpdate, 0);
  
  if(InputGrant->delete[0] == 'Y')
    fl_set_button(f_inputhost->bDelete, 1);
  else
    fl_set_button(f_inputhost->bDelete, 0);
  
  if(InputGrant->create[0] == 'Y')
    fl_set_button(f_inputhost->bCreate, 1);
  else
    fl_set_button(f_inputhost->bCreate, 0);
  
  if(InputGrant->drop[0] == 'Y')
    fl_set_button(f_inputhost->bDrop, 1);
  else
    fl_set_button(f_inputhost->bDrop, 0);
  

}

void inputhost_getfields()
{
  char yes[2];
  char no[2];
  
  strcpy(yes, "Y");  strcpy(no, "N");
		     
  strcpy(InputGrant->host, fl_get_input(f_inputhost->hostName));
  strcpy(InputGrant->db,   fl_get_input(f_inputhost->databaseName));

  if(fl_get_button(f_inputhost->bSelect))
    strcpy(InputGrant->select, yes);
  else
    strcpy(InputGrant->select, no);

  if(fl_get_button(f_inputhost->bInsert))
    strcpy(InputGrant->insert, yes);
  else
    strcpy(InputGrant->insert, no);

  if(fl_get_button(f_inputhost->bUpdate))
    strcpy(InputGrant->update, yes);
  else
    strcpy(InputGrant->update, no);

  if(fl_get_button(f_inputhost->bDelete))
    strcpy(InputGrant->delete, yes);
  else
    strcpy(InputGrant->delete, no);

  if(fl_get_button(f_inputhost->bCreate))
    strcpy(InputGrant->create, yes);
  else
    strcpy(InputGrant->create, no);

  if(fl_get_button(f_inputhost->bDrop))
    strcpy(InputGrant->drop, yes);
  else
    strcpy(InputGrant->drop, no);

}


void main_inputhost(int type)
{
  if(Stat.flagInputHost) return;
  Stat.flagInputHost=1;

  InputTemp = (struct inputGrant *) calloc(1, sizeof(struct inputGrant));
  memcpy(InputTemp, InputGrant, sizeof(struct inputGrant));
  
  f_inputhost = create_form_inputhost();

  fl_set_input_maxchars(f_inputhost->hostName        , 60);
  fl_set_input_maxchars(f_inputhost->databaseName    , 32);

  InputGrant->stat = type;
  if(type)
    {
      fl_deactivate_object(f_inputhost->hostName);
      fl_set_object_lcol(f_inputhost->hostName, FL_INACTIVE);
      fl_set_input_color(f_inputhost->hostName, FL_INACTIVE, FL_INACTIVE);
    }
  
  inputhost_setfields();

  if(!type)
    fl_show_form(f_inputhost->inputhost, FL_PLACE_MOUSE, FL_TRANSIENT, "XmysqlAdmin new host");
  else
    fl_show_form(f_inputhost->inputhost, FL_PLACE_MOUSE, FL_TRANSIENT, "XmysqlAdmin modify host");
    
}

void inputhost_close(FL_OBJECT *obj, long data)
{
  free(InputTemp);
  fl_hide_form(f_inputhost->inputhost);
  fl_free_form(f_inputhost->inputhost);
  free(f_inputhost);
  Stat.flagInputHost=0;
  grant_activate(Stat.statusGrant);  
}

void inputhost_revert(FL_OBJECT *obj, long data)
{
  fl_freeze_form(f_inputhost->inputhost);
  memcpy(InputGrant, InputTemp, sizeof(struct inputGrant));
  inputhost_setfields();
  fl_unfreeze_form(f_inputhost->inputhost);
}

