#include "forms.h"
#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <stdlib.h>
#include "xmysqladmin.h"
#include "xmysqladmin2.h"
#include "mysql.h"

#define NO_SELECT_HOST 0
#define SELECTED_HOST  1
#define NO_SELECT_USER 2
#define SELECTED_USER  3
#define NO_SELECT_DBF  4
#define SELECTED_DBF   5
#define SELECTED_SUBFORM 6


extern struct setup Setup;
extern struct stat Stat;
FD_inputuser *f_inputuser;
extern struct inputGrant *InputGrant, *InpHost, *InpDb, *InpUser;
struct inputGrant *InputTemp;
extern FD_grant *f_grant;
void main_inputuser(int type);
void inputuser_setfields(void);
void inputuser_getfields(void);
extern void grant_activate(int status);
extern void grant_getUsers(FL_OBJECT *browser, char *hostName);

void inputuser_input(FL_OBJECT *obj, long data)
{
  ;
}
void inputuser_save(FL_OBJECT *obj, long data)
{
   int closeForm = 1;
  
   inputuser_getfields();

   /* creation de la fiche du host */
   if(InputGrant->host[0] && InputGrant->user[0])
   {
      MYSQL connection;
      if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
      {
	 MYSQL_RES *result;
	 char *query;
      
	 query = (char *) malloc(2048);
	 if(!query) return;
      
	 mysql_select_db(&connection, "mysql");
	 if(!InputGrant->stat) /* if stat == 0 we are in create mode */
	 {
	    if(InputGrant->password[0])
	    {
	       sprintf(query,
		       "insert into user (host,user,password,select_priv,insert_priv,update_priv,delete_priv,create_priv,drop_priv,reload_priv,shutdown_priv,process_priv,file_priv) values ('%s','%s',password('%s'),'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')",
		       InputGrant->host,InputGrant->user,InputGrant->password,
		       InputGrant->select,InputGrant->insert,
		       InputGrant->update,InputGrant->delete,
		       InputGrant->create,InputGrant->drop,
		       InputGrant->reload,InputGrant->shutdown,
		       InputGrant->process,InputGrant->file);
	    }
	    else
	    {
	       sprintf(query,
		       "insert into user (host,user,select_priv,insert_priv,update_priv,delete_priv,create_priv,drop_priv,reload_priv,shutdown_priv,process_priv,file_priv) values ('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')",
		       InputGrant->host,InputGrant->user,
		       InputGrant->select,InputGrant->insert,
		       InputGrant->update,InputGrant->delete,
		       InputGrant->create,InputGrant->drop,
		       InputGrant->reload,InputGrant->shutdown,
		       InputGrant->process,InputGrant->file);
	    }
	 }
	 else  /* here we are in modify mode */
	 {
	    if(InputGrant->password[0])
	    {
	       sprintf(query,
		       "update user set password=password('%s'),select_priv='%s',insert_priv='%s',update_priv='%s',delete_priv='%s',create_priv='%s',drop_priv='%s',reload_priv='%s',shutdown_priv='%s',process_priv='%s',file_priv='%s' where host='%s' and user='%s'",
		       InputGrant->password,InputGrant->select,
		       InputGrant->insert,InputGrant->update,
		       InputGrant->delete,InputGrant->create,
		       InputGrant->drop,
		       InputGrant->reload,InputGrant->shutdown,
		       InputGrant->process,InputGrant->file,
		       InputTemp->host,InputTemp->user);
	    }
	    else
	    {
	       sprintf(query,
		       "update user set password='',select_priv='%s',insert_priv='%s',update_priv='%s',delete_priv='%s',create_priv='%s',drop_priv='%s',reload_priv='%s',shutdown_priv='%s',process_priv='%s',file_priv='%s' where host='%s' and user='%s'",
		       InputGrant->select,
		       InputGrant->insert,InputGrant->update,
		       InputGrant->delete,InputGrant->create,
		       InputGrant->drop,
		       InputGrant->reload,InputGrant->shutdown,
		       InputGrant->process,InputGrant->file,
		       InputTemp->host,InputTemp->user);
	    }
	 }
	 if (!mysql_query(&connection, query))
	 {
	    result = mysql_store_result(&connection);
	    if(result != NULL) mysql_free_result(result);
	 }
	 else
	 {
	    fl_show_messages(mysql_error(&connection));
	    closeForm = 0;
	 }
	 free(query);
	 mysql_close(&connection);
      }
   }

   if(closeForm)
   {
      free(InputTemp);
      fl_hide_form(f_inputuser->inputuser);
      fl_free_form(f_inputuser->inputuser);
      free(f_inputuser);
      Stat.flagInputUser=0;
      grant_activate(Stat.statusGrant);  

      if(fl_get_browser_maxline(f_grant->dbf))
	 fl_clear_browser(f_grant->dbf);
      grant_activate(NO_SELECT_USER);
      grant_getUsers(f_grant->users, InputGrant->host);
      memset(InpDb, '\0', sizeof(struct inputGrant));
      memset(InpUser, '\0', sizeof(struct inputGrant));
   }
}

void inputuser_setfields()
{
  fl_set_input(f_inputuser->hostName       , InputGrant->host);
  fl_set_input(f_inputuser->userName       , InputGrant->user);
  
  if(InputGrant->select[0] == 'Y')
    fl_set_button(f_inputuser->bSelect, 1);
  else
    fl_set_button(f_inputuser->bSelect, 0);

  if(InputGrant->insert[0] == 'Y')
    fl_set_button(f_inputuser->bInsert, 1);
  else
    fl_set_button(f_inputuser->bInsert, 0);
  
  if(InputGrant->update[0] == 'Y')
    fl_set_button(f_inputuser->bUpdate, 1);
  else
    fl_set_button(f_inputuser->bUpdate, 0);
  
  if(InputGrant->delete[0] == 'Y')
    fl_set_button(f_inputuser->bDelete, 1);
  else
    fl_set_button(f_inputuser->bDelete, 0);
  
  if(InputGrant->create[0] == 'Y')
    fl_set_button(f_inputuser->bCreate, 1);
  else
    fl_set_button(f_inputuser->bCreate, 0);
  
  if(InputGrant->drop[0] == 'Y')
    fl_set_button(f_inputuser->bDrop, 1);
  else
    fl_set_button(f_inputuser->bDrop, 0);

  if(InputGrant->reload[0] == 'Y')
    fl_set_button(f_inputuser->breload, 1);
  else
    fl_set_button(f_inputuser->breload, 0);
  
  if(InputGrant->shutdown[0] == 'Y')
    fl_set_button(f_inputuser->bshutdown, 1);
  else
    fl_set_button(f_inputuser->bshutdown, 0);
  
  if(InputGrant->process[0] == 'Y')
    fl_set_button(f_inputuser->bProcess, 1);
  else
    fl_set_button(f_inputuser->bProcess, 0);
  
  if(InputGrant->file[0] == 'Y')
    fl_set_button(f_inputuser->bFile, 1);
  else
    fl_set_button(f_inputuser->bFile, 0);
  
}

void inputuser_getfields()
{
  char yes[2];
  char no[2];
  
  strcpy(yes, "Y");  strcpy(no, "N");
		     
  strcpy(InputGrant->host, fl_get_input(f_inputuser->hostName));
  strcpy(InputGrant->password, fl_get_input(f_inputuser->password));
  strcpy(InputGrant->user, fl_get_input(f_inputuser->userName));
  
  if(fl_get_button(f_inputuser->bSelect))
    strcpy(InputGrant->select, yes);
  else
    strcpy(InputGrant->select, no);

  if(fl_get_button(f_inputuser->bInsert))
    strcpy(InputGrant->insert, yes);
  else
    strcpy(InputGrant->insert, no);

  if(fl_get_button(f_inputuser->bUpdate))
    strcpy(InputGrant->update, yes);
  else
    strcpy(InputGrant->update, no);

  if(fl_get_button(f_inputuser->bDelete))
    strcpy(InputGrant->delete, yes);
  else
    strcpy(InputGrant->delete, no);

  if(fl_get_button(f_inputuser->bCreate))
    strcpy(InputGrant->create, yes);
  else
    strcpy(InputGrant->create, no);

  if(fl_get_button(f_inputuser->bDrop))
    strcpy(InputGrant->drop, yes);
  else
    strcpy(InputGrant->drop, no);

  if(fl_get_button(f_inputuser->breload))
    strcpy(InputGrant->reload, yes);
  else
    strcpy(InputGrant->reload, no);

  if(fl_get_button(f_inputuser->bshutdown))
    strcpy(InputGrant->shutdown, yes);
  else
    strcpy(InputGrant->shutdown, no);

  if(fl_get_button(f_inputuser->bProcess))
    strcpy(InputGrant->process, yes);
  else
    strcpy(InputGrant->process, no);

  if(fl_get_button(f_inputuser->bFile))
    strcpy(InputGrant->file, yes);
  else
    strcpy(InputGrant->file, no);
}


void main_inputuser(int type)
{
  if(Stat.flagInputUser) return;
  Stat.flagInputUser=1;

  InputTemp = (struct inputGrant *) calloc(1, sizeof(struct inputGrant));
  memcpy(InputTemp, InputGrant, sizeof(struct inputGrant));

  f_inputuser = create_form_inputuser();

  fl_set_input_maxchars(f_inputuser->hostName        , 60);
  fl_set_input_maxchars(f_inputuser->password        , 40);
  fl_set_input_maxchars(f_inputuser->password2       , 40);
  fl_set_input_maxchars(f_inputuser->userName        , 16);

  InputGrant->stat = type;
  if(type)
    {
      fl_deactivate_object(f_inputuser->userName);
      fl_set_object_lcol(f_inputuser->userName, FL_INACTIVE);
      fl_set_input_color(f_inputuser->userName, FL_INACTIVE, FL_INACTIVE);
    }
  fl_set_object_lcol(f_inputuser->hostName, FL_INACTIVE);
  fl_deactivate_object(f_inputuser->hostName);
  fl_set_input_color(f_inputuser->hostName, FL_INACTIVE, FL_INACTIVE);
  
  inputuser_setfields();
  if(!type)
    fl_show_form(f_inputuser->inputuser, FL_PLACE_MOUSE, FL_TRANSIENT, "xMySQLdmin new user");
  else
    fl_show_form(f_inputuser->inputuser, FL_PLACE_MOUSE, FL_TRANSIENT, "xMySQLdmin modify user");
    
}

void inputuser_close(FL_OBJECT *obj, long data)
{
  free(InputTemp);
  fl_hide_form(f_inputuser->inputuser);
  fl_free_form(f_inputuser->inputuser);
  free(f_inputuser);
  Stat.flagInputUser=0;
  grant_activate(Stat.statusGrant);  
}

void inputuser_revert(FL_OBJECT *obj, long data)
{
  fl_freeze_form(f_inputuser->inputuser);
  inputuser_setfields();
  fl_unfreeze_form(f_inputuser->inputuser);
}

void inputuser_password(FL_OBJECT *obj, long data)
{
  if(strcmp(fl_get_input(f_inputuser->password),
	    fl_get_input(f_inputuser->password2)))
     {
       fl_set_input(f_inputuser->password, "");
       fl_set_input(f_inputuser->password2, "");
       fl_show_messages("Passwords must be the same\nFields passwords has been erased.\nReenter the password");
     }
}
