"<HTML> <HEAD>",
"<TITLE>XImtool On-Line Help Summary</TITLE>",
"</HEAD> <BODY>",
"<H2>Welcome to XImtool V1.1</H2>",
"",
"XImtool is an image display server developed by the IRAF Project at the",
"National Optical Astronomy Observatories.  To view images you need",
"client software (such as IRAF) to load images into the display, or it can",
"load images directly when run as a standalone task.  XImtool is",
"interchangeable with older display servers such as <I>SAOimage</I> /",
"<I>IMTOOL</I> and with newer servers like <I>SAOtng</I>, but offers many new",
"features not available elsewhere.",
"<P>",
"More <a href=#toc>detailed help</a> is available on the following topics:",
"<DL><DL>",
"<DT>Basic Usage:</DT>",
"<UL>",
"<LI><A HREF=\"#basic\">Getting Started</A> -- The basics. </LI>",
"<LI><A HREF=\"#gui\">GUI Overview</A> -- What it looks like. </LI>",
"<LI><A HREF=\"#mouse\">Mouse Operations</A> -- Doing stuff. </LI>",
"<LI><A HREF=\"#keystroke\">Keystroke Accelerators</A> -- Keystroke summary.</LI>",
"<LI><A HREF=\"#markers\">Markers</A> -- Panner/WCS markers, general markers.</LI>",
"<LI><A HREF=\"#control\">Control Panel</A> -- Operating the Control panel.</LI>",
"<LI><A HREF=\"#load\">Load Panel</A> -- Load panel operation and options.</LI>",
"<LI><A HREF=\"#save\">Save Panel</A> -- Save panel operation and options.</LI>",
"<LI><A HREF=\"#print\">Print Panel</A> -- Print panel operation and options.</LI>",
"<LI><A HREF=\"#info\">Info Panel</A> -- Information panel.</LI>",
"</UL></DL></DL>",
"<DL><DL>",
"<DT>Advanced Features:</DT>",
"<UL>",
"<LI><A HREF=\"#comline\">Command-line Options</A> -- Startup flags. </LI>",
"<LI><A HREF=\"#client\">Client Connections</A> -- Use as a display server. </LI>",
"<LI><A HREF=\"#framebuf\">Frame Buffers</A> -- Explanation of Frame buffers. </LI>",
"<LI><A HREF=\"#pprinter\">Printer Configurations</A> -- Configuring output devices. </LI>",
"<LI><A HREF=\"#tclshell\">TclShell</A> -- Expert-mode interactive shell.</LI>",
"</UL></DL></DL>",
"<P>",
"Please contact <I>iraf@noao.edu</I> with comments, bugs, or suggestions.",
"<P>",
"<HR></P>",
"",
"<a name=#toc> <h2>Table of Contents:</h2> </a>",
"<PRE>",
"        <A HREF=\"#basic\">Getting Started</A>",
"        <A HREF=\"#gui\">GUI Overview</A>",
"        <A HREF=\"#mouse\">Mouse Operations</A>",
"        <A HREF=\"#keystroke\">Keystroke Accelerators</A>",
"        <A HREF=\"#comline\">Command-line Options</A>",
"        <A HREF=\"#client\">Client Connections</A>",
"	<A HREF=\"#framebuf\">Frame Buffers</A>",
"        <A HREF=\"#markers\">Markers</A>",
"            <A HREF=\"#panner\">Panner Marker</A>",
"            <A HREF=\"#coords\">Coords Box Marker</A>",
"            <A HREF=\"#genmark\">General Markers</A>",
"                <A HREF=\"#markmenu\">Menu Options</A>",
"        <A HREF=\"#control\">Control Panel</A>",
"            <A HREF=\"#cview\">View Controls</A>",
"            <A HREF=\"#cenhance\">Enhancement Controls</A>",
"            <A HREF=\"#cblink\">Blink Controls</A>",
"            <A HREF=\"#copts\">Options:</A>",
"                <A HREF=\"#cautoscale\">Autoscale</A>",
"                <A HREF=\"#cantialias\">Antialiasing</A>",
"                <A HREF=\"#ctile\">Tile Frames</A>",
"                <A HREF=\"#cwarnings\">Warnings</A>",
"	<A HREF=\"#ccmap\">Colormap Selection</A>",
"                <A HREF=\"#cbltin\">Builtin Colormaps</A>",
"                <A HREF=\"#cuser\">User-defined Colormaps</A>",
"        <A HREF=\"#load\">Load Panel</A>",
"            <A HREF=\"#lbrowse\">Directory browsing</A>",
"            <A HREF=\"#lpattern\">File Patterns</A>",
"            <A HREF=\"#lload\">Direct File Load</A>",
"            <A HREF=\"#lframe\">Frame Selections</A>",
"        <A HREF=\"#save\">Save Panel</A>",
"            <A HREF=\"#sfname\">File Name</A>",
"            <A HREF=\"#sformat\">Format</A>",
"            <A HREF=\"#scolor\">Color</A>",
"        <A HREF=\"#print\">Print Panel</A>",
"            <A HREF=\"#popts\">Postscript Options</A>",
"            <A HREF=\"#pcolors\">Color Options</A>",
"            <A HREF=\"#pproc\">Processing Options</A>",
"            <A HREF=\"#pprinter\">Printer selection</A>",
"        <A HREF=\"#info\">Info Panel</A>",
"        <A HREF=\"#tclshell\">TclShell</A>",
"</PRE>",
"<P>",
"<HR>",
"<h2><a name=#basic>Getting Started</a></h2>",
"As a display server, XImtool is started as a separate process from client",
"software such as IRAF.  Once it is running it will accept ",
"<a href=#client>client connections</a> simultaneously on fifo pipes, unix",
"domain sockets, or inet sockets.  A display client like the IRAF DISPLAY",
"task makes a connection and sends the image across using an IIS protocol",
"(other/different protocols may be supported in the future).  Once the image",
"is loaded in the display buffer it may be <a href=#cenhance>enhanced</a>,",
"<a href=#save>saved to a disk file</a> in a number of different formats, or ",
"<a href=#print>printed</a> as Encapsulated Postscript to a printer or disk file.",
"<P>",
"When run in standalone mode, images may be loaded on the ",
"<a href=#comline>command line</a> or by using the <a href=#load>Load Panel</a>.",
"This allows you to browse images and perform the same manipulations as if",
"they had been displayed by a client.",
"<hr>",
"",
"<h2><a name=#gui>GUI Overview</a></h2>",
"<p>",
"The GUI consists of a large image display window and a number of smaller",
"pannels that control various specific functions such as image",
"<a href=#load>Load</a>, <a href=#save>Save</a> and <a href=#print>Print</a>",
"as well as a general purpose <a href=#control>Control Panel</a>. The main",
"window menubar has several menu buttons to the left: the <I>Files</I> menu",
"is used to load/save/print an image as well as quit the task. The <I>View</I>",
"menu let's you select the image orientation, zoom, colormap or frame. The",
"<I>Options</I> menu allows you to call up control panels, toggle markers",
"or blinking etc.  Some of this functionality is duplicated elsewhere in",
"the GUI.  The right side of the menubar contains command buttons to flip the",
"image as well as buttons for frame selection and the help button.",
"<p>",
"For more detailed information on the operation of the control panels please",
"see the on-line help (i.e. use the '?' button or Alt-h keystroke in the",
"main image window).",
"",
"<h2><a name=#mouse>Mouse Operations</a></h2>",
"Clicking and dragging MB1 (mouse button 1) in the main image",
"window creates a rectangular region <a href=#markers>marker</a>, used",
"to select a region of the image.  If you do this accidentally and don't",
"want the marker, put the pointer in the marker and type DELETE or",
"BACKSPACE to delete the marker.  With the pointer in the marker,",
"MB3 will call up a <a href=#markmenu>marker menu</a> listing some things",
" you can do with the marker, like zoom the outlined region.  MB1 can be used",
"to drag or resize the marker. <a href=#markers>See below</a> for more",
"information on markers.",
"<p>",
"Clicking on MB2 in the main image window pans (one click) or zooms (two ",
"clicks) the image.  Further clicks cycle through the builtin zoom factors. ",
"Moving the pointer to a new location and clicking moves the feature under ",
"the pointer to the center of the display window.  Holding down the Shift",
"key while clicking MB2 will cause a full-screen crosshair cursor to appear",
"until the button is released, this can be useful for fine positioning of the",
"cursor.",
"<p>",
"MB3 is used to adjust the contrast and brightness of the displayed image.",
"The position of the pointer within the display window determines the ",
"contrast and brightness values.  Click once to set the values corresponding",
"to the pointer location, or click and drag to continuously adjust the display.",
"<hr>",
"",
"<h2><a name=#keystroke>Keystroke Accelerators</a></h2>",
"	The following keystrokes are currently defined in the GUI:",
"<pre>",
"  ",
"Ctrl-b   Backward frame        Alt-b  Blink frames (toggle)",
"Ctrl-c   Center frame?         Alt-c  Control panel",
"Ctrl-f   Forward frame         Alt-h  Help",
"Ctrl-i   Invert?               Alt-i  Info box popup",
"Ctrl-m   Match LUTs            Alt-l  Load file popup",
"Ctrl-n   Normalize             Alt-p  Print popup",
"Ctrl-p   Print                 Alt-s  Save popup",
"Ctrl-r   Register              Alt-t  TclShell popup",
"Ctrl-t   Tile frames toggle",
"Ctrl-u   Unzoom (zoom=1)",
"Ctrl-x   Flip X       	       Ctrl-Alt-q  Quit",
"Ctrl-y   Flip Y       	       Ctrl-Alt-f  Fitframe",
"",
"Ctrl-=   Print",
"Ctrl-<   Decrease blink rate   Ctrl-+   Zoom in",
"Ctrl->   Increase blink rate   Ctrl--   Zoom out",
"   ",
"Alt-1 thru Alt-4      Set frame displayed",
"Ctrl-1 thru Ctrl-9    Set integer zoom factor  ",
"</pre>",
"NOTE: These keystrokes only work with the cursor in the main image window,",
"not on the subwindows or in markers.",
"<hr>",
"",
"<h2><a name=#client>Client Connections</a></h2>",
"Ximtool allows clients to connect in any of the following ways:",
"</DL>",
"<DT><B>fifo pipes</B></DT>",
"<DD>The traditional approach.  The default, global /dev/imt1[io] pipes may ",
"be used, or a private set of fifos.</DD>",
"<DT><B>tcp/ip socket</B></DT>",
"<DD>Clients connect via a tcp/ip socket.  There is a default port, or a ",
"custom port may be specified.  This permits connecting to the server over a",
"remote network connection anywhere on the Internet.</DD>",
"<DT><B>unix domain socket</B></DT>",
"<DD> Like a tcp/ip socket, but limited to a single host system.  Usually ",
"faster than a tcp/ip socket, and comparable to a fifo.  By default each user",
"gets their own unix domain socket, so this option allows multiple users",
"to run ximtools on the same host without having to customize things.</DD>",
"</DL>",
"By default ximtool listens simultaneously for client connctions on all three",
"types of ports.  Clients communicate with XImtool using the IIS protocol,",
"other protocols may be supported in the future.",
"<hr>",
"",
"<h2><a name=#framebuf>Frame Buffers</a></h2>",
"XImtool starts up using default frame buffer of 512x512 pixels.  When loading",
"disk images the frame buffer configuration file will be searched for a",
"defined frame buffer that is the same size or larger than the current image,",
"when used as a display server the frame buffer configuration number is passed",
"in by the client.  The default file used is /usr/local/lib/imtoolrc, this can",
"be overridden by defining a <b>IMTOOLRC</b> environment variable naming the",
"file to be used, or by creating a <b>.imtoolrc</b> file in your home",
"directory.",
"<P>",
"The format of the frame buffer configuration file is",
"<pre>",
"   configno nframes width height [extra fields]",
"e.g.                   ",
"	1  2  512  512",
"	2  2  800  800",
"	3  1 1024 1024          # comment",
"</pre>",
"At most 128 frame buffer sizes may be defined.",
"<hr>",
"",
"<h2><a name=#comline>Command-line Options</a></h2>",
"	The following command-line options are currently recognized:",
"<pre>",
"  -basePixel &lt num &gt       Base colormap pixel number",
"  -cmap1 &lt file &gt          User cmap 1 ",
"  -cmap2 &lt file &gt          User cmap 2 ",
"  -cmapDir1 &lt dir &gt        User cmapDir 1 ",
"  -cmapDir1 &lt dir &gt        User cmapDir 2 ",
"  -cmapInitialize &lt bool &gt Initialize colormap at startup",
"  -cmapName &lt name &gt       Private colormap name ",
"  -config &lt num &gt          Initial config number",
"  -defgui                  Print default GUI to stdout",
"  -displayPanner &lt bool &gt  Display panner box",
"  -displayCoords &lt bool &gt  Display wcs coords box",
"  -fifo &lt pipe &gt           Fifo pipe to use",
"  -fifo_only               Use fifo pipes only ",
"  -gui &lt file &gt            GUI file to use ",
"  -help                    Print command-line summary ",
"  -imtoolrc &lt file &gt       Frame buffer configuration file ",
"  -inet_only               Use inet sockets only ",
"  -invert                  Invert colormap on startup?",
"  -maxColors &lt num &gt       Number of colors ",
"  -memModel &lt type &gt       Memory model (fast,small,beNiceToServer)",
"  -nframes &lt num &gt         Number of frames at startup",
"  -port &lt num &gt            Inet port to use",
"  -printConfig &lt file &gt    Printer configuration file ",
"  -port_only               Use inet sockets only ",
"  -tile                    Tile frames on startup?",
"  -unix &lt name &gt           Unix socket to use",
"  -unix_only               Use unix sockets only ",
"  &lt file &gt                 File to load on startup",
"</pre>",
"<hr>",
"<h2><a name=#markers>Markers</a></h2>",
"<h3><a name=#panner>Panner Marker</a></h3>",
"<P>",
"The panner window always displays the full frame buffer.  Try setting the",
"frame buffer configuration to a nonsquare frame buffer (e.g. imtcryo) and",
"then displaying a square image (e.g. dev$pix) and the panner will show you",
"exactly where the image has been loaded into the frame.",
"<P>",
"The panner window uses two markers, one for the window border and one to",
"mark the displayed region of the frame.  Most of the usual marker keystrokes",
"mentioned <a href=#genmark>below</a> apply to these markers as well, e.g. ",
"you can use MB1 to reposition on the panner window within the main image ",
"display window, or to drag the region marker within the panner (pan the ",
"image).  Resizing the region marker zooms the image; this is a non-aspect ",
"constrained zoom. The panner window itself can be resized by dragging a ",
"corner with MB1.  Typing delete or backspace anywhere in the panner window ",
"deletes the panner.",
"<P>",
"A special case is MB2.  Hitting MB2 anywhere in the panner window pans the",
"image to that point.  This is analogous to typing MB2 in the main display",
"window to pan the image.",
"",
"<h3><a name=#coords>Coords Box Marker</a></h3>",
"<P>",
"Ximtool provides a limited notion of world coordinates, allowing frame",
"buffer pixel coordinates and pixel values to be converted to some arbitrary",
"client defined coordinate system.  The coords box feature is used to display",
"these world coordinates as the pointer is moved about in the image window.",
"<P>",
"The quantities displayed in the coords box are X, Y, and Z: the X,Y world",
"coordinates of the pointer, and Z, the world equivalent of the pixel value",
"under the pointer.  All coordinate systems are linear.  The precision of a",
"displayed quantity is limited by the range of values of the associated raw",
"frame buffer value.  For example, if the display window is 512x512 only 512",
"coordinate values are possible in either axis (the positional precision can",
"be increased however by zooming the image).  More seriously, at most about",
"200 pixel values can be displayed since this is the limit on the range of",
"pixel values loaded into the frame buffer.  If a display pixel is saturated",
"a \"+\" will be displayed after the intensity value.",
"<P>",
"The coords box is a marker (text marker) and it can be moved and resized",
"with the pointer like any other marker.",
"",
"<h3><a name=#genmark>General Markers</a></h3>",
"Although ximtool doesn't do much with markers currently, they are a general",
"feature of the Gterm widget and are used more extensively in other programs",
"(e.g. the prototype IRAF science GUI applications).  Ximtool uses markers",
"for the marker zoom feature discussed above, and also for the ",
"<a href=#panner>panner</a> and the <a href=#coords>coords box</a>.  All ",
"markers share some of the same characteristics, so it is worthwhile learning",
"basic marker manipulation keystrokes.",
"<UL>",
"<LI> MB1 anywhere inside a marker may be used to drag the marker.",
"<LI> MB1 near a marker corner or edge, depending on the type of marker,",
"resizes the marker.",
"<LI> Shift-MB1 on the corner of most markers will rotate the marker.",
"<LI> Markers stack, if you have several markers and you put one on top",
"of the other.  The active marker is highlighted to tell you which of the ",
"stacked markers is active.  If the markers overlap, this will be marker ",
"\"on top\" in the stacking order.",
"<LI> MB2 in the body of a marker \"lowers\" the marker, i.e. moves it to",
"the bottom of the stacking order.",
"<LI> Delete or backspace in a marker deletes it.",
"<LI> Markers have their own translation resources and so the default",
"<a href=#keystroke>keystroke commands</a> will not be recognized when the",
"cursor is in a marker.",
"</UL>",
"For example, try placing the pointer anywhere in the coords box, then press",
"MB1 and hold it down, and drag the coords box marker somewhere else on the",
"screen.  You can also resize the coords box by dragging a corner, or delete",
"it with the delete or backspace key.  (The Initialize button will get the",
"original coords box back if you delete it).",
"<P>",
"<h4><a name=#markmenu>Marker Menu Options</a></h4>",
"<UL>",
"<LI> MB3 (mouse button 3) calls up the marker menu (by default).",
"<LI> <B>Zoom</B> does an equal aspect zoom of the region outlined by the marker.",
"In this way you can mark a region of the image and zoom it up.",
"<LI> <B>Fill</B> exactly zooms the area outlined by the marker, making it fill",
"the display window.  Since the marker is not likely to be exactly square, ",
"the aspect ratio of the resultant image will not be unitary.",
"<LI> <B>Print</B> prints the region outlined by the marker to the printer or",
"file currently configured by the <a href=#print>Print Panel</a>.",
"<LI> <B>Save</B> saves the region outlined by the marker to the file currently",
"configured by the <a href=#save>Save Panel</a>.",
"<LI> <B>Info</B> prints a description of the marked region. The text is ",
"printed in the <a href=#info>Info Panel</a>.",
"<LI> <B>Unrotate</B> unrotates a rotated marker.",
"<LI> <B>Color</B> is a menu of possible marker colors.",
"<LI> <B>Type</B> is a menu of possible marker types.  This is still a little",
"buggy and it isn't very useful, but you can use it to play with different ",
"types of markers.",
"<LI> <B>Destroy</B> destroys the marker.  You can also hit the delete or ",
"backspace key in a marker to destroy the marker.",
"</UL>",
"",
"<hr>",
"<h2><a name=#control>Control Panel</a></h2>",
"<h3><a name=#cview>View Controls</a></h3>",
"<P> The <b>Frame</b> box will list only the frame buffers you currently have",
"defined.  Currently, the only way to destroy a frame buffer is to change the",
"frame buffer configuration, new frame buffers (up to 4) will be created",
"automatically if requested by the client.",
"<P> The <b>text display window</b> gives the field X,Y center, X,Y scale ",
"factors, and the X,Y zoom factors.  The scale factor and the zoom factor ",
"will be the same unless autoscale is enabled.  The scale is in units of ",
"display pixels per frame buffer pixel, and is an absolute measure (it doesn't",
"matter whether or not <a href=#cautoscale>autoscale</a> is enabled).  Zoom is",
"relative to the autoscale factor, which is 1.0 if autoscaling is disabled.  ",
"This information is also presented in the <a href=#info>Info panel</a>.",
"<P> The numbers in the <b>Zoom</b> box are zoom factors.  Blue numbers zoom,",
"red numbers dezoom. <b>Zoom In</b> and <b>Zoom Out</b> may be used to go to",
"larger or smaller zoom factors, e.g. \"Ctrl-5\" followed by \"Zoom In\" will get you",
"to zoom factor 10.  Specific zoom factors may also be accessed directly as ",
"Control <a href=#keystrokes>keystrokes</a>, e.g. Ctrl-5 will set zoom factor 5.",
"<b>Center</b> centers the field. <b>Toggle Zoom</b> toggles between the ",
"current zoom/center values, and the unzoomed image.",
"<P> <b>Aspect</b> recomputes the view so that the aspect ratio is 1.0.  ",
"Aspect also integerizes the zoom factor (use the version in the View menu ",
"if you don't want integerization).",
"<P> <b>Fit Frame</b> makes the display window the same size as the frame ",
"buffer. Note that <a href=#cautoscale>autoscale</a> has much the same effect,",
"and allows you to resize the display window to any size you want, or view ",
"images to large to fit on the screen.",
"",
"<h3><a name=#cenhance>Enhancement Controls</a></h3>",
"",
"<P> At the top is a scrolled list of all the <a href=#cbltin>available ",
"colormaps</a>.  Click on the one you want to load it.  You can add your own",
"<a href=#cuser>colormaps</a> to this list.",
"<P> The two sliders adjust the <b>contrast</b> (upper slider) and ",
"<b>brightness</b> (lower slider) of the display. The <b>Invert</b> button ",
"inverts the colormap (multiples the contrast by -1.0). Note that due to the",
"use of the private colormap the sliders are a bit sluggish when dragged to ",
"window the display.  If this is annoying, using MB3 in the display window is",
"faster.",
"<P>The <b>Normalize</b> button (on the bottom of the control panel) will ",
"normalize the enhancement, i.e. set the contrast and brightness to the default",
"one-to-one values (1.0, 0.5). This is the preferred setting for many of the",
"pseudocolor colortables and for private colormaps loaded from disk images.",
"",
"<h3><a name=#cblink>Blink Controls</a></h3>",
"<UL>",
"<LI> <b>Blink frames</b> is the list of frames to be blinked.  When blink ",
"mode is in effect ximtool just cycles through these frames endlessly, pausing",
"\"blink rate\" seconds between each frame.  The same frame can be entered in ",
"the list more than once.  To program an arbitrary list of blink frames, hit",
"the <b>Reset</b> button and click on each blink frame button until it is set",
"to the desired frame number.",
"<LI> The <b>Blink Rate</b> can be adjusted as slow or as fast as you want",
"using the arrow buttons.  If you set the blink rate small enough it will go",
"to zero, enabling single step mode (see below).",
"<LI> The <b>Register</b> button registers all the blink frames with the current ",
"display frame.  Frames not in the blink list are not affected.",
"<LI> The <b>Match LUTs</b> button sets the enhancement of all blink frames to",
"the same values as the display frame.  Frames not in the blink list are not ",
"affected.",
"<LI> The <b>Blink</b> button turns blink on and off.  When the blink rate is",
"set to zero the Blink button will single step through the blink frames, one",
"frame per button press.",
"</UL>",
"<P>",
"NOTE: you can blink no matter what ximtool options are in effect, but many ",
"of these will slow blink down.  To get the fastest blink you may want to ",
"turn off the panner and coords box, and match the LUTs of all the blink ",
"frames.  All the ximtool controls are fully active during blink mode, plus ",
"you can load frames etc.",
"",
"",
"<h3><a name=#copts>Options:</a></h3>",
"<DL>",
"<DT><b><a name=#cautoscale>Autoscale</a></b></DT>",
"<DD> If autoscale is enabled then at zoom=1, the frame buffer will be ",
"automatically scaled to fit within the display window.  With autoscale ",
"disabled (the default), the image scale is more predictable, but the image ",
"may be clipped by the display window, or may not fill the display window.</DD>",
"",
"<DT><b><a name=#cantialias>Antialiasing</a></b></DT>",
"<DD> When dezooming an image, i.e., displaying a large image in a smaller ",
"display window, antialiasing causes all the data to be used to compute the ",
"displayed image.  If antialiasing is disabled then image is subsampled to ",
"compute the displayed image.  Antialiasing can prevent subsampling from ",
"omitting image features that don't fall in the sample grid, but it is ",
"significantly slower than dezooming via subsampling.  The default is no ",
"antialising.  </DD>",
"",
"<DT><b><a name=#ctile>Tile Frames</a></b></DT>",
"<DD> The default display mode is to view one frame at a time.  In tile frames",
"mode, 2 or 4 frames may be viewed simultaneously in the display window.  All",
"the usual operations (zoom and pan, colortable enhancement, cursor readback,",
"etc.) still work for each frame even when in tile frames mode.  </DD>",
"",
"<DT><b><a name=#cwarnings>Warnings</a></b></DT>",
"<DD> The warnings options toggles whether you see warning dialog boxes in",
"situations like overwriting an existing file, clearing the frame buffer, etc.",
"</DD>",
"</DL>",
"",
"<h3><a name=#ccmap>Colormap Selection</a></h3>",
"By default XImtool will display images using either a grayscale colormap",
"if loaded by a client, or a private colormap when loading an image from",
"disk that contains a colormap.  Each frame defines its own colormap so",
"you can define different colormaps or enhancements for each frame, they",
"will change automatically as you cycle through the frames.",
"",
"<h4><a name=#cbltin>Builtin Colormaps</a></h4>",
"Once loaded, the colormap may either be changed using the builtin colormap",
"menu under the <b>View</b> menu button on the main window, or from the",
"<a href=#cenhance>Enhancement</a> box on the <a href=#control>control panel</a>. Ximtool has about a dozen colormap",
"options builtin, other <a href=#cuser>user-defined colormaps</a> may ",
"optionally be loaded.",
"",
"<h4><a name=#cuser>User-defined Colormaps</a></h4>",
"The cmap[12] and cmapDir[12] resources (or <a href=#comline>command line",
"arguments</a> are used to tell ximtool which specific colormaps to make",
"available or where to look for colortables respectively.  The colortables",
"are loaded when ximtool starts up, or when it is reinitialized (e.g. by",
"pressing the <b>Initialize</b> button in the <a href=#control>control ",
"panel</a>).  Ximtool will ignore any files in the colormap directory",
"which do not look like colortables.  New colortables will also be added",
"for each images loaded from disk.",
"<P>",
"The format of a user lookup table is very simple: each row defines one",
"colortable entry, and consists of three columns defining the red, green,",
"and blue values scaled to the range 0.0 (off) to 1.0 (full intensity).",
"<PRE>",
"        R G B",
"        R G B",
"        (etc.)",
"</PRE>",
"Blank lines and comment lines (# ...) are ignored.",
"<P>",
"Usually 256 rows are provided, but the number may actually be anything in",
"the range 1 to 256.  Ximtool will interpolate the table as necessary to",
"compute the colortable values used in Ximtool.  Ximtool uses at most 201",
"colors to render pixel data, so it is usually necessary to interpolate the",
"table when it is loaded.",
"<P>",
"The name of the colortable as it will appear in the Ximtool control panel",
"is the root name of the file, e.g., if the file is \"rainbow.lut\" the ",
"colortable name will be \"rainbow\".  Lower case names are suggested to avoid",
"name collisions with the builtin colortables.  Private colormaps for disk",
"images will be have the same name as the image loaded.  If the same colortable",
"file appears in multiple user colortable directories, the first one will be",
"used.",
"<P>",
"The directory \"luts\" in the ximtool source directory contains a sample set",
"of colortable files.  This can be installed as /usr/local/lib/imtoolcmap",
"when ximtool is installed.",
"<hr>",
"",
"<h2><a name=#load>Load Panel</a></h2>",
"The Load Panel allows you load images from disk directly to the frame buffer,",
"this is analogous to loading an image on the command line except that ",
"browsing is possible.  At present recognized formats include IRAF OIF format",
"(i.e. .imh extension), simple FITS files, GIF, and Sun rasterfiles.  The",
"task will automatically sense the format of the image and load it",
"appropriately.  Images with private colormaps (such as GIF) will be loaded",
"using the private colormap by default (meaning that changing the ",
"brightness/contrast enhancements will render a random-colored image). If ",
"the <b>Grayscale</b> button is enabled the image will be converted to ",
"grayscale and loaded with the standard grayscale colormap.",
"<P>",
"When loading new images the frame buffer configuration table",
"(<em>imtoolrc</em>) will be searched for a frame buffer that is the same size",
"or larger than the new image size, if no frame buffer can be found a custom",
"buffer exactly the size of the image will be created.  This means that the",
"image may not fill the display window when loaded, or you may see a subsection",
"of the image in the main display window.  Setting the ",
"<a href=#cautoscale>autoscale</a> option will scale the entire image to fit",
"the main display window.",
"<P>",
"Images with more colors than can be displayed will automatically be quantized",
"to the number of available colors before display.  Formats which allow more",
"than 8-bit pixels will be sampled to determine an optimal range in the data",
"to be used to compute the transformation to the number of display colors.",
"This is the same transformation used by the IRAF DISPLAY task.",
"",
"<DL>",
"<DT><B><a name=#lbrowse>Directory browsing</a></B></DT>",
"<DD>",
"The load panel contains a list of files in the current directory that may",
"be selected for loading by selecting with left mouse button.  If the file",
"is a directory the contents of the new directory will be loaded, if it's",
"a plain file an attempt will be made to load it as an image.  Directories",
"in the list are identified with a trailing '/' character, you will always",
"see any directories available even if a <a href=#lpattern>filter</a> is ",
"specified.",
"<P>",
"The <b>Root</b> button will reset the current directory to the system root",
"directory.  The <b>Home</b> button will reset the current directory to the ",
"user's login directory, the <b>Up</b> button moves up one directory level,",
"and <b>Rescan</b> reloads the file list by rescanning the directory.  The",
"current working directory is given below the file selection window.</DD>",
"",
"<DT><B><a name=#lpattern>File Patterns</a></B></DT>",
"<DD> By default all files and directories will be listed.  You may specify a",
"filter to e.g. select only those files with a given extension like \"*.fits\"",
"to list only files with a \".fits\" extension.  Directories will always be seen",
"in the list and are identified with a trailing '/' character.  Any valid",
"unix pattern matching string will be recognized.</DD>",
"<DT><B><a name=#lload>Direct File Load</a></B></DT>",
"<DD> If you know exactly which file you wish to load, you may enter its name",
"in the <b>Load File</b> text box and either hit <cr> or the Load button to",
"load it.  An absolute or relative path name may be given, if a simple filename ",
"is specified it will be searched for in the current working directory.</DD>",
"<DT><B><a name=#lframe>Frame Selections</a></B></DT>",
"<DD> By default images will be loaded into frame number 1, you may select a",
"different frame using the <b>Frame</b> menu button.</DD>",
"</DL>",
"<hr>",
"",
"<h2><a name=#save>Save Panel</a></h2>",
"The Save Panel lets you save the current contents of the main display window ",
"to a disk file (including the Panner/Coords markers, any general graphics",
"markers, or overlay graphics displayed by the client program).  Presently,",
"only the contents of the main display window may be saved, there is no",
"facility for saving the undisplayed contents of the entire frame buffer ",
"other than to enable the <a href=#cautoscale>autoscale</a> feature.  A limited",
"number of formats are currently available, others will be added in future",
"versions.",
"<DL>",
"<DT><b><a name=#sfname>File Name</a></b></DT>",
"<DD> The <b>File Name</b> text box allows you to enter the file name of the",
"saved file. A \"%d\" anywhere in the name will be replaced by a sequence number",
"allowing multiple frames to be saved with unique names. </DD>",
"<DT><b><a name=#sformat>Format</a></b></DT>",
"<DD> The <B>Format</B> box allows you to choose the format of the image to be ",
"created.  Not all formats are currently implemented. </DD>",
"<DT><b><a name=#scolor>Color</a></b></DT>",
"<DD> The <b>Color</b> box lets you choose the color type of the image to be",
"created.  The options will change depending on the format, e.g. FITS doesn't",
"allow color so no color options will be allowed.  Formats which allow 24-bit",
"images will be written using the current colormap after converting to a 24-bit",
"image, pseudocolor images will be written with the current colormap. </DD>",
"</DL>",
"<hr>",
"",
"<h2><a name=#print>Print Panel</a></h2>",
"The Print Panel allows you dump the contents of the main display window as",
"Enacpsulated Postscript to either a named printer device or to a disk file.",
"The <b>Print To</b> selects the type of output, the <b>Print Command</b>",
"box will adjust accordingly, either as a Unix printer command or as a file",
"name.  A \"%d\" anywhere in the name for disk output will be replaced by a ",
"sequence number allowing multiple frames to be saved with unique names.",
"<a href=#pprinter>Selecting printers</a> from the installed list will",
"automatically change the command to be used to generate the output.  This",
"command does not necessarily need to be a printer command, the ",
"<a href=#pprinter>printer configuration file</a> lets you define any command",
"string to process the image.",
"<h3><a name=#pcolors>Color Options</a></h3>",
"The <b>Color</b> box lets you choose the color type of the image to be created.",
"PseudoColor or 24-bit postscript will be created using the current colormap.",
"<h3><a name=#popts>Postscript Options</a></h3>",
"<DL>",
"<DT>Orientation</DT>",
"<DD> Set the page orientation.",
"<DT>Paper Size</DT>",
"<DD> Select the paper size to be used.",
"<DT>Image Scale</DT>",
"<DD> Set the scale factor used to compute the final image size.",
"</DL>",
"<h3><a name=#pproc>Processing Options</a></h3>",
"<DL>",
"<DT>Auto Scale</DT>",
"<DD> The auto scale toggles whether or not the image is automatically scaled",
"to fit the page.   If not enabled, the <b>image scale</b> will be used to ",
"dtermine the output image size.",
"<DT>Auto Rotate</DT>",
"<DD> Auto rotate determines whether or not the image will be rotated to fit ",
"on the page.  When set, an image larger than the current orientation will be",
"rotated and possibly scaled to fit the page.",
"<DT>Max Aspect</DT>",
"<DD> Max Aspect takes images smaller than the page and automatically increases",
"the scale so the image fills the page in the current orientation.",
"<DT>Annotate</DT>",
"<DD> The annotate option toggles whether or not the final file includes",
"annotation such as the image title, a colorbar, and axis labels.",
"</DL>",
"<h3><a name=#pprinter>Printer selection</a></h3>",
"The printer selection list lets choose the printer to be used.  The printer",
"configuration file is /usr/local/lib/ximprint.cfg  by default or may be reset",
"using the <em>printConfig</em> resource.  The format of the file is simply",
"<pre>",
"	<b>name</b> &lt tab &gt <em>command</em>",
"</pre>",
"The <b>name</b> value is what appears in the selection list and may be more",
"than a single word, the <em>command</em> can be any command that accepts EPS",
"input from a pipe, the two fields must be separated by a tab character. ",
"Normally the command will be",
"a simple 'lpr -Pfoo' or some such, but can also include converters or",
"previewers.  At most 128 printer commands may be used.",
"<hr>",
"",
"<h2><a name=#info>Info Panel</a></h2>",
"	The information panel is underused at present but is meant to provide",
"basic information about the frame being displayed.  It is updated to be",
"current while changing enhancements, pan/zoom regions, or frame selection.",
"In cases where the image title string is truncated in the main display window,",
"the user can always pop up the info window to see the full title.",
"<hr>",
"",
"<h2><a name=#tclshell>TclShell</a></h2>",
"	The <em>TclShell</em> is mostly used as a development or debugging",
"tool for the GUI.  It allows the user to type commands directly to the",
"TCL interpreter letting you send messages to the object manager or execute",
"specific procedures in the TCL code that makes up the GUI.  Most users will",
"never need this, but for an example of what it does, bring it up and type a",
"command such as",
"<pre>",
"    send helpButton set background red",
"</pre>",
"Cool, huh.",
"<hr>",
"",
"<h2><a name=#acknowledgements>Acknowledgements</a></h2>",
"	<I>XImtool</I> was developed by the IRAF Group at the National Optical",
"Astronomy Observatories in Tucson, AZ.  For further information or to report",
"problems please contact <I>iraf@noao.edu</I>",
"<hr>",
"This document was last updated 11/6/96.",
"",
"</BODY>",
"</HTML>",
