/* option utilities library
   Copyright 1998 Gene McCulley <mcculley@cuspy.com>, Cuspy Solutions, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef OPTUTIL_INCLUDED
#define OPTUTIL_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <stdio.h>

typedef struct {
  char *parameters;
  char *help;
  XtResource resource;
  XrmOptionDescRec option;
} ResourceOption;

extern XtResource *OU_GetResources(const ResourceOption *ros, unsigned num_ros);
extern XrmOptionDescRec *OU_GetOptions(const ResourceOption *ros,
                                       unsigned num_ros);
extern void OU_DumpOptions(const ResourceOption *ros, unsigned num_ros,
                           FILE *fp);
extern void OU_GetEnvironment(const char *varname, char **argv[], int *argc);

#ifdef __cplusplus
}
#endif

#endif
