#ifndef AudioConfig_h
#define AudioConfig_h

class AudioConfig
{

 public:

    // Configuration constants.
    enum
    {
         MONO = 1,
         STEREO = 2,
         BITS_8 = 8,
         BITS_16 = 16,
         SIGNED_PCM = 0x7f,
         UNSIGNED_PCM = 0x80
    };
    
    
    int frequency;
    int precision;
    int channels;
    int encoding;

    int bufSize;       // sample buffer size
    
    // Special!
    int maxFrags;
    int fragSize;
    int blockSize;     // run-time only

    AudioConfig()
    {
        frequency = 22050;
        precision = BITS_8;
        channels = MONO;
        encoding = UNSIGNED_PCM;
        bufSize = 3072;
        maxFrags = 32;
        fragSize = 1024;
        blockSize = 0;
    }

};

#endif  // AudioConfig_h
