#include "AudioDialog.h"
#define Inherited AudioDialogData

static int frequencyList[] = 
{
    // in Hz
    8000, 11025, 16500, 22050, 27500, 32000, 37500, 44100, 48000,
    0  // end
};

AudioDialog::AudioDialog(QWidget* parent, const char* name) : Inherited(parent,name)
{
    setCaption("Audio Configuration");
    setFixedSize(width(),height());
    setIcon(*myMainIcon);
    
    setButtons();
}

void AudioDialog::setButtons()
{
    bit8Btn->setChecked(config.precision==AudioConfig::BITS_8);
    bit16Btn->setChecked(config.precision==AudioConfig::BITS_16);
    monoBtn->setChecked(config.channels==AudioConfig::MONO);
    stereoBtn->setChecked(config.channels==AudioConfig::STEREO);
    // Activate startup value in frequency box.
    int i = 0, foundIndex = 0;
    while (frequencyList[i] != 0)
    {
        if (config.frequency >= frequencyList[i])
        {
            foundIndex = i;
        }
        i++;
    };
    frequencyBox->setCurrentItem(foundIndex);
}

void AudioDialog::setConfig(const AudioConfig& inConfig)
{
    // Copy without verification.
    config = inConfig;
    setButtons();
}

const AudioConfig& AudioDialog::getConfig() const
{
    return config;
}

void AudioDialog::setPrecision(int)
{
    if (bit8Btn->isChecked())
        config.precision = AudioConfig::BITS_8;
    else  // if (bit16Btn->isChecked())
        config.precision = AudioConfig::BITS_16;
    emit changed(config);
}

void AudioDialog::setChannels(int)
{
    if (monoBtn->isChecked())
        config.channels = AudioConfig::MONO;
    else  // if (stereoBtn->isChecked())
        config.channels = AudioConfig::STEREO;
    emit changed(config);
}

void AudioDialog::setFrequency(int)
{
    config.frequency = frequencyList[frequencyBox->currentItem()];
    emit changed(config);
}
