#ifndef MainDialog_h
#define MainDialog_h

#include <qapplication.h>
#include <qbitmap.h>
#include <qdict.h>
#include <qfiledialog.h>
#include <qkeycode.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qtooltip.h>

#include <sidplay/player.h>

#include "MainDialogData.h"
#include "AudioDialog.h"
#include "EmuDialog.h"
#include "FilterDialog.h"
#include "HistoryDialog.h"
#include "HVSCDialog.h"
#include "MixerDialog.h"
#include "StilDialog.h"
#include "WaveViewDialog.h"
#include "HVSCconfig.h"
#include "ConfigFile.h"
#include "PicButton.h"
#include "TimeLCD.h"
#include "AudioDriver.h"
#include "myTimer.h"
#include "stil.h"

class MainDialog : public MainDialogData
{
    Q_OBJECT

public:

    MainDialog(QWidget* parent = NULL, const char* name = NULL);
    ~MainDialog();
    
    // Affects Play/Pause/Stop/... buttons
    // and player state.
    enum playerState
    {
        IS_INTERRUPTED = 0,
        IS_STOPPED = 0x01,
        IS_PLAYING = 0x02,
        IS_PAUSED = 0x04,
        IS_FORWARDING = 0x08
    };

    void adjustCommandButtons();
    void buttonsOff();
    void buttonsForceInitialState();
    void setPrevBtnState();
    void setNextBtnState();
	
    void showSidTuneInfo();
    void clearSidTuneInfo();
    void enableWaveViewDlg(bool);

    void showStilInfo();
    bool isStilInfoEnabled();
    void setStilInfoEnabled(bool);
    bool initStil();

    bool writeConfigFile();

    void setAudioConfig(const AudioConfig&);
    void setEmuConfig(const emuConfig&);
    const emuConfig& getEmuConfig() const;
    void setHVSCconfig(const HVSCconfig&);
    void setVariousConfig(const VariousConfig&);

    // sub-dialogs
	
    QFileDialog* myFileDlg;

    AudioDialog* myAudioDlg;
    EmuDialog* myEmuDlg;
    FilterDialog* myFilterDlg;
    HistoryDialog* myHistoryDlg;
    HVSCDialog* myHVSCDlg;
    MixerDialog* myMixerDlg;
    StilDialog* myStilDlg;
    WaveViewDialog* myWaveViewDlg;

public slots:
	
    void receiveAudioConfig(const AudioConfig&);
    void receiveEmuConfig(const emuConfig&);
    void receiveHVSCconfig(const HVSCconfig&);
    void receiveMixerConfig(const MixerConfig&);
    
    void playFile(const char*);
    void playHistoryFile(const char*);
    void loadStilData(const char*);
    void loadSidTune(const char*, const int);
	
    virtual void open();
    virtual void saveAs();
    virtual void quit();
	
    void openAudioDialog();
    void openEmulatorDialog();
    void openFilterDialog();
    void openHVSCDialog();
    void openHistoryDialog();
    void openMixerDialog();
    void openWaveViewDialog();
	
    void toggleStilDialog();

    void about();
    void aboutQt();

    void timerJob();
    
 protected:
    
    QPixmap* prevPic;
    QPixmap* stopPic;
    QPixmap* playPic;
    QPixmap* pausePic;
    QPixmap* ffPic;
    QPixmap* nextPic;
    
    QPixmap* stop_pPic;
    QPixmap* pause_pPic;
    QPixmap* ff_pPic;
	
    QPixmap* prev_lPic;
    QPixmap* stop_lPic;
    QPixmap* play_lPic;
    QPixmap* pause_lPic;
    QPixmap* ff_lPic;
    QPixmap* next_lPic;
	
    QPixmap* prev_l_pPic;
    QPixmap* stop_l_pPic;
    QPixmap* play_l_pPic;
    QPixmap* next_l_pPic;

    bool openAudioDriver();
    void closeAudioDriver();
    
    void stopPlaying();
    void pausePlaying();
    void resumePlaying();
    void startPlaying();
    
    void resetTimeDisplay();

    void initAudioBufferSystem();
    void openAudioBufferSystem();
    void freeAudioBufferSystem();
    
 protected slots:

	virtual void done(int);
	
    void prevSongPressed();
    void prevSongReleased();
    void stopSongPressed();
    void stopSongReleased();
    void playSongPressed();
    void playSongReleased();
    void forwardSongPressed();
    void forwardSongReleased();
    void nextSongPressed();
    void nextSongReleased();

 private:
	
    QMenuBar *menu;
    QPopupMenu *extra;
    int waveViewID, stilID;

    VariousConfig myVarConfig;
    udword usage;  // a local copy of the listening mileage

    bool isHistoryFile;  // whether to pipe current file to history
    
    playerState playbackState;
    bool isReadyToPlay;
    bool driverIsOpen;

    myTimer playbackTimer;
    
    // Instantiate emulator engine.
    emuEngine* myEmuEngine;
    emuConfig myEmuConfig;
    emuConfig defaultEmuConfig;
    
    // Instantiate sidtune loader.
    sidTune* mySidTune;
    sidTuneInfo mySidTuneInfo;
    
    AudioDriver myAudio;
    
    STIL mySTIL;
    QString hvscFileName;

    // Mostly unimplemented! Multi-buffering system.
    
#define maxBuffers 256 
    // worst case: 256*256 = 64 KB
    
    bool audioBuffersReady;
    int buffers;
    int multiBufferSize;
    int currentBuffer,
        nextBuffer;
    bool bufferFlag[maxBuffers];
    ubyte* pBuffer[maxBuffers];
    int bufferCount[maxBuffers];
    int lastBufferCount;
    
};

#endif  // MainDialog_h
