// details.h				emacs, this is written in -*-c++-*-
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997, 1998

#ifndef DETAILS_H
#define DETAILS_H

#include <qtabbar.h>
#include <qintdict.h>

#include "htable.h"
#include "proc.h"
#include "lookup.h"

// abstract interface class for clients to the details window
class Pane
{
public:
    Pane(QWidget *qw) : w(qw) {};
    virtual void config_change();
    virtual void refresh() = 0;
    QWidget *asQWidget() { return w; };

private:
    QWidget *w;			// myself as QWidget (alas!)
};

class Qps;

class Details : public QWidget
{
    Q_OBJECT
public:
    Details(Procinfo *p, Qps *qps);
    ~Details();

    void refresh();
    void config_change();
    void process_gone();
    Procinfo *procinfo() { return pi; };
    void set_procinfo(Procinfo *p) { pi = p; };

signals:
    void closed(Details *);

public slots:
    void dismiss();
    void tab_change(int id);

protected:
    virtual void paintEvent(QPaintEvent *);
    virtual void resizeEvent(QResizeEvent *);
    virtual void closeEvent(QCloseEvent *);
    
private:
    const int top_spc = 8;	// above tab bar
    const int mid_spc = 4;	// between tab bar and pane
    const int left_spc = 8;	// to the left of tab bar

    QTabBar *tbar;

    Svec<Pane *> panes;		// vector index == QTabBar id
    Procinfo *pi;
};

struct TableField
{
    char *name;
    int width;
    int gap;
    int align;
    char *tooltip;
};

// SimpleTable: a HeadedTable with fixed number of columns

class SimpleTable : public HeadedTable
{
    Q_OBJECT
public:
    SimpleTable(QWidget *parent, TableField *f);

protected:
    virtual QString title(int col);
    virtual QString text(int row, int col) = 0;
    virtual int colWidth(int col);
    virtual int alignment(int col);
    virtual int leftGap(int col);
    virtual QString tipText(int col);

private:
    const TableField *fields;
};

class Sockets : public SimpleTable, public Pane
{
    Q_OBJECT
public:
    Sockets(QWidget *parent);
    ~Sockets();

    void refresh();
    void refresh_window();
    bool refresh_sockets();
    const char *servname(unsigned port);
    QString ipAddr(unsigned addr);
    QString hostname(unsigned addr);
    void config_change();

public slots:
    void update_hostname(unsigned addr);

protected:
    virtual QString text(int row, int col);

private:
    Procinfo *procinfo() { return ((Details *)parent())->procinfo(); };

    enum {
	PROTO, RECVQ, SENDQ, LOCALADDR, LOCALPORT, REMOTEADDR, REMOTEPORT,
	STATE,
	SOCKFIELDS
    };
    static TableField fields[SOCKFIELDS];

    bool doing_lookup;		// if table painted with host lookup

    static Lookup *lookup;
    static bool have_services;	// true if we have tried reading services
    static QIntDict<char> servdict;
};

class Maps : public SimpleTable, public Pane
{
public:
    Maps(QWidget *parent);
    ~Maps();

    void refresh();
    void refresh_window();
    bool refresh_maps();

protected:
    virtual QString text(int row, int col);

private:
    Procinfo *procinfo() { return ((Details *)parent())->procinfo(); };

    enum {
	ADDRESS, SIZE, PERM, OFFSET, DEVICE, INODE, FILENAME,
	MAPSFIELDS
    };
    static TableField fields[MAPSFIELDS];
};

class Files : public SimpleTable, public Pane
{
public:
    Files(QWidget *parent);
    ~Files();

    void refresh();
    void refresh_window();
    bool refresh_fds();

protected:
    virtual QString text(int row, int col);

private:
    Procinfo *procinfo() { return ((Details *)parent())->procinfo(); };

    enum {
	FILEDESC, FILENAME,
	FILEFIELDS
    };
    static TableField fields[FILEFIELDS];
};

#endif	// DETAILS_H

