// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
extern "C" {
#include <stdio.h>
#include <unistd.h>
}
#include "Connection.h"
#include "Poller.h"

//=============================================================================
// Public methods.
//-----------------------------------------------------------------------------
Connection::Connection( const Url& url ) : _url( url ), _fd( -1 ), _size( -1 )
{
//    printf( "Connection::Connection()\n" );
}

Connection::~Connection()
{
//    printf( "Connection::~Connection()\n" );
    poller->dereg( this, _fd );
}

//=============================================================================
// Public slots.
//-----------------------------------------------------------------------------
void Connection::abort()
{
    close( _fd );
    emit endOfData();
}

void Connection::exception()
{
//    printf( "Connection::exception() -- fd = %d\n", _fd );
}

void Connection::readable()
{
}

void Connection::writable()
{
}

void Connection::guessFileType( QString& mediaType, QString& mediaSubtype )
{
    mediaType    = 0;
    mediaSubtype = 0;
    
    // Try filename extension first.
    if ( _url.path().right( 4 ) == ".gif" ) {
        mediaType    = "image";
        mediaSubtype = "gif";
    } else if ( _url.path().right( 4 ) == ".htm" ) {
        mediaType    = "text";
        mediaSubtype = "html";
    } else if ( _url.path().right( 5 ) == ".html" ) {
        mediaType    = "text";
        mediaSubtype = "html";
    } else if ( _url.path().right( 4 ) == ".sgm" ) {
        mediaType    = "text";
        mediaSubtype = "sgml";
    } else if ( _url.path().right( 5 ) == ".sgml" ) {
        mediaType    = "text";
        mediaSubtype = "sgml";
    }

    // If all else fails, fall back on text/plain.
    if ( mediaType.length() == 0 ) {
        mediaType    = "text";
        mediaSubtype = "plain";
    }
}
