// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "ContentModelState.h"

ContentModelState::~ContentModelState()
{
    while ( _id.first() ) {
//	delete _id.first();
	_id.remove();
    }
    while ( _transitions.first() ) {
	delete _transitions.first();
	_transitions.remove();
    }
}

void ContentModelState::addId( SgmlNode* n )
{
    _id.inSort( n );
    if ( n->type() == SgmlNode::Accept ) {
        _accept = TRUE;
    }
}

void ContentModelState::addTransition( const QString&     element,
                                       ContentModelState* state )
{
    _transitions.append( new Transition( element, state ) );
    _transElements.append( element );
}

ContentModelState* ContentModelState::nextState( QString element )
{
    QListIterator<Transition> i( _transitions );

    for ( i.toFirst(); i.current(); ++i ) {
	if ( i.current()->element == element ) {
	    return i.current()->state;
	}
    }

    return 0;
}

bool ContentModelState::defaultTrans( QString& element )
{
    if ( _transitions.count() == 1 ) {
        element = _transElements.first();
        return TRUE;
    } else {
        return FALSE;
    }
}
