// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _DtdManager_h_
#define _DtdManager_h_

#include <qobject.h>
#include "Dtd.h"
#include "Request.h"

//: The DtdManager class keeps a cache of parsed DTDs and style sheets.
//. Any object that inherits from QObject can request a DTD from the
//. DtdManagerm provided that it has a dtd( Dtd* ) slot.  The slot is
//. required because requests are processed asynchronously.  This allows
//. DTDs and style sheets to be retrieved from remote servers with
//. non-blocking I/O.
class DtdManager : public QObject {
    Q_OBJECT
    struct Parser {
        QObject* parser;
        QString  soi;
        Dtd*     dtd;
        Parser( QObject* _parser, QString _soi )
                : parser( _parser ), soi( _soi ), dtd( 0 ) {}
    };
    
    struct DtdRequest {
        Request*    request;
        Dtd*        dtd;
        QString     soi;
        DtdRequest( Request* _request, Dtd* _dtd, QString _soi )
                : request( _request ), dtd( _dtd ), soi ( _soi ) {}
    };

    Dtd* findDtd( const QString& soi );
    
    QList<Dtd>        _dtds;
    QList<Parser>     _parsers;
    QList<DtdRequest> _requests;
public:
    //. Create a new DtdManager.
    DtdManager();

    //. Destroy the DtdManager and its cache of DTDs.
    ~DtdManager();

    //. Process a request for the DTD with the given public identifier.
    void request( QObject* parser, QString doctype, QString id );

    //. Clear the DTD cache.
    void clear();

    //. Lookup a DTD in the cache of parsed DTDs, with the given public
    //. identifier.
    Dtd* find( QString dtdName );
public slots:
    //. This slot process the indication from the DtdParser that the DTD and
    //. its style sheet are ready.
    void done( Dtd* dtd );
signals:
    //. This signal is emitted when a request DTD and its style sheet have
    //. been parsed.  This signal is connected and disconnect when needed, so
    //. that it works like a dynamically bound function call.  This way many
    //. differnet types of objects can request a DTD without being derived
    //. from a more specific class than QObject.
    void dtdReady( Dtd* dtd );
};

extern DtdManager* dtdManager;

#endif
