// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _HLineRenderer_h_
#define _HLineRenderer_h_

#include "Renderer.h"

class QFrame;

//: The HLineRenderer class displays a horizontal rule that spans the width of the page.
class HLineRenderer : public Renderer {
    Q_OBJECT
    QFrame* _frame;
public:
    //. Create a new horizontal renderer.  Create a QFrame that will serve as
    //. the horizontal line.  Use a frame style of Sunken | HLine.
    HLineRenderer( Canvas*     canvas,
                   int         clipWidth=0,
                   QObject*    parent=0,
                   const char* name=0 );

    //. Size the horizontal line to fit within the preferred width.
    virtual bool redraw();
public slots:
    //. We don't really have any data, but an implementation is required so
    //. that this class isn't abstract.
    virtual void endOfData();
};

#endif
