/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: data_win.cpp,v $
 *
 * $Revision: 1.4 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: data_win.cpp,v $
 * Revision 1.4  1997/06/09 12:59:23  ruben
 * switched rcs commands again I think...
 * compiled with -Wall -Werror, fixed bugs and potential bugs
 * fixed Mister Data bugs
 *
// Revision 1.3  1997/05/27  09:10:46  ruben
// some indentstuff and reworked include strategy
//
// Revision 1.3  1997/05/27  09:10:46  ruben
// some indentstuff and reworked include strategy
//
 * Revision 1.2  1997/04/06 21:18:16  ruben
 * changed some signals to 'send' const char* instead of just char*
 *
 * Revision 1.1  1997/03/28 17:04:14  ruben
 * Initial revision
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H

#ifdef USE_RCS_ID
static const char rcs_id[] = "$Id: data_win.cpp,v 1.4 1997/06/09 12:59:23 ruben Exp $";
#endif	 /* USE_RCS_ID */

#include "data_win.h"

char tempo_stringo[PATH_MAX]; // string used by goto_dir ()

char mouse_locked = FALSE;    // this will probably not work 
                              // under multi-thread
char multiple_select=FALSE;

/*---------------------------------------------------------------------------*/
void draw_rect (QPainter *painter,
                int x1,int y1,
                int x2,int y2)
{
 painter->drawLine (x1,y1,x1,y2);
 painter->drawLine (x1,y2,x2,y2);
 painter->drawLine (x2,y2,x2,y1); 
 painter->drawLine (x2,y1,x1,y1);
}
/*---------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------*/
UpDownScroll::UpDownScroll(QWidget * parent, int *change_val):QScrollBar(0, 0, 1, BUTTON_HEIGHT, 0, QScrollBar::Vertical, parent, "vert")
{
	connect(this, SIGNAL(valueChanged(int)),
			SLOT    (scrollBarValueChanged(int)));

	val_to_change = change_val;
}
/*---------------------------------------------------------------------------*/
LeftRightScroll::LeftRightScroll(QWidget * parent, int *change_val):QScrollBar(0, 0, 1, BUTTON_HEIGHT, 0, QScrollBar::Horizontal, parent, "hor")
{
	connect(this, SIGNAL(valueChanged(int)),
			SLOT    (scrollBarValueChanged(int)));

	val_to_change = change_val;
}
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
void    UpDownScroll::scrollBarValueChanged(int new_value)
{
	*val_to_change = (-new_value);
	move_widget->update();
}
/*---------------------------------------------------------------------------*/
void    UpDownScroll::set_parent(QWidget * new_parent)
{
	move_widget = new_parent;
}
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
void    LeftRightScroll::scrollBarValueChanged(int new_value)
{
	*val_to_change = (-new_value);
	move_widget->update();
}
/*---------------------------------------------------------------------------*/
void    LeftRightScroll::set_parent(QWidget * new_parent)
{
	move_widget = new_parent;
}
/*---------------------------------------------------------------------------*/

 
