/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: fpropdlg.cpp,v $
 *
 * $Revision: 1.4 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: fpropdlg.cpp,v $
 * Revision 1.4  1997/06/09 12:59:23  ruben
 * switched rcs commands again I think...
 * compiled with -Wall -Werror, fixed bugs and potential bugs
 * fixed Mister Data bugs
 *
// Revision 1.3  1997/05/27  09:10:46  ruben
// reworked to act as a modal dialog
//
// Revision 1.3  1997/05/27  09:10:46  ruben
// reworked to act as a modal dialog
//
 * Revision 1.2  1997/04/06 21:19:37  ruben
 * Added ghosted controls if properties are not allowed to be changed by
 * active user. suggestion of Alf Clement <alf@hpbidrd.bbn.hp.com>
 *
 * Revision 1.1  1997/03/28 17:04:14  ruben
 * Initial revision
 *
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H

#include <qbttngrp.h>
#include <qchkbox.h>
#include <qcombo.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qstrlist.h>
#include <qtooltip.h>
#include <qfileinf.h>
#include <qdir.h>
#include <qmsgbox.h>
#include <qregexp.h>

#include <pwd.h>
#include <grp.h>
#include <limits.h>
#include <string.h>
#include <unistd.h>
#include <time.h>				// added by MvV
#include <errno.h>				// where is extern int errno ??? (RvS)

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/errno.h>			// could be in here too :(

#include "fpropdlg.h"

#ifdef USE_RCS_ID
static const char rcs_id[] = "$Id: fpropdlg.cpp,v 1.4 1997/06/09 12:59:23 ruben Exp $";
#endif	 /* USE_RCS_ID */

static const char *mode_names[] =
{
	"Special",
	"Owner",
	"Group",
	"Other",
	NULL
};
static const char *rwx_modes[] =
{
	"Hmmm...",
	"Read",
	"Write",
	"Execute",
	NULL
};
static const char *special_modes[] =
{
	"Hmmm...",
	"Set UID",
	"Set GID",
	"Sticky",
	NULL
};

static const char *rwx_modes_help[] =
{
	"Hmmm...",
	"Read permissions are needed to read or copy a file...",
	"Write permissions are needed to write to file...",
	"eXecute permissions are needed to run programs or scripts",
	NULL
};

static const char *mode_names_help[] =
{
	"Set special execution attributes",
	"Set Owner Permissions",
	"Set Group Permissions",
	"Set Other Permissions",
	NULL
};

static const char *special_modes_help[] =
{
	"Hmmm...",
	"Set Owner of file to owner of process",
	"Set Group where file belongs as\n owner of process",
	"File is kept resident after execution",
	NULL
};

static const char *ownership_help[] =
{
	"Sets the owner where the file belongs to",
	"Sets the group where the file belongs to",
	NULL
};

static const char *bad_fnames[] =
{
	"^\\.\\.$",
	".*/.*",
	"^\\.$",
	NULL
};

#define SPECL 07000
#define OWNER 00700
#define GROUP 00070
#define WORLD 00007

/*---------------------------------------------------------------------------*/
void    GetPwdNames(QStrList & names)
{
	struct passwd *spPasswd;

	while ((spPasswd = getpwent()))
	{
		names.inSort(spPasswd->pw_name);
	}
	endpwent();
}
/*---------------------------------------------------------------------------*/
void    GetGrpNames(QStrList & names)
{
	struct group *spGroup;

	while ((spGroup = getgrent()))
	{
		names.inSort(spGroup->gr_name);
	}
	endgrent();
}
/*---------------------------------------------------------------------------*/
FPropdlg::FPropdlg(const char *file, QWidget * parent, const char *name):QDialog(parent, name,TRUE),
        do_rename(FALSE),
        do_chmod(FALSE),
        do_chown(FALSE),
        absfname(NULL),
        newabsfname(NULL),
        fname(NULL),
        names(NULL),
        groups(NULL),
        fileinfo(NULL)
{
	QBoxLayout *root = new QBoxLayout(this, QBoxLayout::TopToBottom),
	       *layout;
	QPushButton *set,
	       *undo,
	       *cancel;

	int     perm_ctl_cnt = 0;

	names = new QStrList;
	groups = new QStrList;

	GetPwdNames(*names);
	GetGrpNames(*groups);

	set = new QPushButton("Set", this);
	set->setDefault(TRUE);
	undo = new QPushButton("Undo", this);
	cancel = new QPushButton("Cancel", this);

	cancel->setMinimumSize(cancel->sizeHint());
	cancel->setMaximumSize(cancel->sizeHint());

	set->setMaximumSize(cancel->size());
	undo->setMaximumSize(cancel->size());

	set->setMinimumSize(set->sizeHint());
	undo->setMinimumSize(undo->sizeHint());

	// Filename adjustment

	layout = new QBoxLayout(QBoxLayout::LeftToRight);
	root->addSpacing(4);
	root->addLayout(layout);

	fname = new QLineEdit(this);
	fname->setMaximumSize(fname->fontMetrics().maxWidth() * NAME_MAX, fname->fontMetrics().height() + 10);
	fname->setMaxLength(NAME_MAX);
	QObject::connect(fname, SIGNAL(textChanged(const char *)), SLOT(nameChanged(const char *)));
	QToolTip::add(fname, "You can rename the file by changing the contents of this field");

	layout->addStretch(0);
	layout->addSpacing(4);
	layout->addWidget(fname, 2);
	layout->addSpacing(4);
	layout->addStretch(0);

	fileinfo = new QLabel(this);
	if (style() == WindowsStyle)
		fileinfo->setFrameStyle(QFrame::Sunken | QFrame::WinPanel);
	else
		fileinfo->setFrameStyle(QFrame::Sunken | QFrame::Panel);
	layout = new QBoxLayout(QBoxLayout::LeftToRight);
	root->addStretch(1);
	root->addLayout(layout);

	layout->addStretch(1);
	layout->addSpacing(4);
	layout->addWidget(fileinfo);
	layout->addSpacing(4);
	layout->addStretch(1);

	// Perm controls

	layout = new QBoxLayout(QBoxLayout::LeftToRight);
	root->addStretch(1);
	root->addLayout(layout);

	QGridLayout *grid = new QGridLayout(4, 4, 4);

	layout->addStretch(0);
	layout->addSpacing(4);
	layout->addLayout(grid);
	layout->addSpacing(4);
	layout->addStretch(0);

	// create 12 funky sticky pushbuttons :)

	QLabel *dummy_001 = new QLabel("test!", this);

	dummy_001->setMinimumSize(dummy_001->sizeHint());

	grid->addWidget(dummy_001, 0, 0);

	for (int i = 0; i < 4; i++)
	{
		QButtonGroup *modegrp = new QButtonGroup(mode_names[i], this);

		modegrp->setFrameStyle(QFrame::NoFrame);

		QToolTip::add(modegrp, mode_names_help[i]);

		for (int j = 1; j < 4; j++)
		{
			const char *mode = ((i > 0) ? rwx_modes[j] : special_modes[j]),
			       *help = (i > 0) ? rwx_modes_help[j] : special_modes_help[j];

			perm_ctl[perm_ctl_cnt] = new QCheckBox(mode, this);

			QToolTip::add(perm_ctl[perm_ctl_cnt], help);
			perm_ctl[perm_ctl_cnt]->setMinimumSize(perm_ctl[perm_ctl_cnt]->sizeHint());

			modegrp->insert(perm_ctl[perm_ctl_cnt], perm_ctl_cnt);
			grid->addWidget(perm_ctl[perm_ctl_cnt], j, i);

			perm_ctl_cnt++;

		}
		QObject::connect(modegrp, SIGNAL(clicked(int)), SLOT(modeChanged(int)));

		grid->addMultiCellWidget(modegrp, 0, 3, i, i);
	}

	// Ownership controls

	layout = new QBoxLayout(QBoxLayout::LeftToRight);
	root->addSpacing(4);
	root->addStretch(1);
	root->addLayout(layout);
	ownership[0] = new QComboBox(FALSE, this);
	ownership[0]->insertStrList(names);
	ownership[0]->setMinimumSize(ownership[0]->sizeHint());
	ownership[0]->setAutoResize(TRUE);
	QToolTip::add(ownership[0], ownership_help[0]);
	QObject::connect(ownership[0], SIGNAL(activated(int)), SLOT(ownerChanged(int)));

	ownership[1] = new QComboBox(FALSE, this);
	ownership[1]->insertStrList(groups);
	ownership[1]->setMinimumSize(ownership[0]->sizeHint());
	ownership[1]->setAutoResize(TRUE);
	QToolTip::add(ownership[1], ownership_help[1]);
	QObject::connect(ownership[1], SIGNAL(activated(int)), SLOT(ownerChanged(int)));

	layout = new QBoxLayout(QBoxLayout::LeftToRight);
	root->addLayout(layout);
	layout->addSpacing(4);
	layout->addStretch(1);
	layout->addWidget(ownership[0]);
	layout->addWidget(ownership[1]);
	layout->addStretch(1);
	layout->addSpacing(4);

	// The bottomline gadgets

	layout = new QBoxLayout(QBoxLayout::LeftToRight);
	root->addStretch(1);
	root->addSpacing(6);
	root->addLayout(layout);
	layout->addStretch(1);
	layout->addSpacing(4);
	layout->addWidget(set);
	layout->addStretch(1);
	layout->addSpacing(4);
	layout->addWidget(undo);
	layout->addStretch(1);
	layout->addSpacing(4);
	layout->addWidget(cancel);
	layout->addSpacing(4);
	layout->addStretch(1);

	root->addSpacing(4);
	getProperties(file);
	root->activate();

	QObject::connect(cancel, SIGNAL(clicked()), SLOT(cancelProperties()));
	QObject::connect(undo, SIGNAL(clicked()), SLOT(undoProperties()));
	QObject::connect(set, SIGNAL(clicked()), SLOT(setProperties()));

}
/*---------------------------------------------------------------------------*/
FPropdlg::~FPropdlg()
{
	delete names;
	delete groups;
	if (newabsfname)
		delete newabsfname;

	if (absfname)
		delete absfname;

}
/*---------------------------------------------------------------------------*/
void    FPropdlg::cancelProperties()
{
	reject();
	emit    propertiesChanged(NULL,NULL);
}
/*---------------------------------------------------------------------------*/
void    FPropdlg::undoProperties()
{
	if (do_rename || do_chmod || do_chown)
		getProperties(NULL);
}
/*---------------------------------------------------------------------------*/
void    FPropdlg::setProperties()
{
	// Write permissions/ownership/name

	QString pw_name(128),
	        gr_name(128);

	new_uid = (uid_t) - 1;
	new_gid = (gid_t) - 1;

	if (do_chmod || do_rename || do_chown)
	{
		new_mode = 0;
		if (newabsfname)
			delete newabsfname;
		newabsfname = new QString(NAME_MAX + 1);
		QFileInfo finfo(*absfname);

		for (int i = 0; i < NumPerms; i++)
		{
			new_mode |= perm_ctl[i]->isChecked()? 1 : 0;
			new_mode <<= 1;
		}
		new_mode >>= 1;

		if ((pw_name = names->at(ownership[UID]->currentItem())))
		{
			struct passwd *pwd = getpwnam(pw_name);

			new_uid = pwd->pw_uid;
		}

		if ((gr_name = groups->at(ownership[GID]->currentItem())))
		{
			struct group *grp = getgrnam(gr_name);

			new_gid = grp->gr_gid;
		}

		if (do_rename && (fname->text() != finfo.fileName() && fname->text()))
		{
			// name has changed, and is valid :) 
			// (contains no patterns as listed in **bad_fnames
			QRegExp check_fname;

			for (int i = 0; i < 3; i++)
			{
				check_fname = bad_fnames[i];
				if (check_fname.match(fname->text()) != -1)
				{
					QMessageBox::message("Error",
							"Your file name cannot be:\n" \
							"a) Nothing\n" \
							"b) The current or parent directory\n" \
							"c) A name in an other directory,\n" \
							"   whether the directory exists or not\n" \
							"   use copy or move for that",
							"I'll try again");
					do_rename = FALSE;
					break;
				}
			}
			if (!do_rename)
			{
				do_rename = TRUE;
				return;			// ok ok a dirty trick, I know!

			}
			*newabsfname = QDir::cleanDirPath(QString(finfo.dir().path()) + QString("/") + QString(fname->text()));
			do_rename = (strcmp(*newabsfname, *absfname) == 0) ? 0 : 1;

			if (do_rename && (access(*newabsfname, F_OK) == 0))
			{
				if (!QMessageBox::query("Warning", "File exists!", "Overwrite", "Leave alone"))
					return;
			}
		}
		else
			do_rename = FALSE;

		if (do_chmod && (orig_mode != new_mode))
		{
			if (chmod(*absfname, new_mode) == -1)
			{
				QMessageBox::message("Error", strerror(errno), "Ok");
				return;
			}
		}

		if (do_chmod && (new_uid != (uid_t) - 1) && (new_gid != (gid_t) - 1) && (new_uid != orig_uid) && (new_gid != orig_gid))
		{
			if (chown(*absfname, new_uid, new_gid) == -1)
			{
				QMessageBox::message("Error", strerror(errno), "Ok");
				return;
			}
		}
		if (do_rename)
		{
			if (rename(*absfname, *newabsfname) == -1)
			{
				QMessageBox::message("Error", strerror(errno), "Ok");
				return;
			}
		}
		accept();
		
		emit    propertiesChanged(*absfname, *newabsfname);
	}
}
/*---------------------------------------------------------------------------*/
void    FPropdlg::getProperties(const char *file)
{
	// Read permissions/ownership/name

	const char *absFileName = file;
	struct stat st;
	struct passwd *pwd;
	struct group *grp;
	int     rwx;

	if (!absFileName && absfname)
		absFileName = *absfname;

	if (absFileName)
	{
		if (!absfname)
			absfname = new QString(absFileName);

		if (stat(absFileName, &st) != -1)
		{
			QFileInfo finfo(absFileName);
			QString fmt(1024),
			        la(ctime(&st.st_atime)),
			        lm(ctime(&st.st_mtime)),
			        lc(ctime(&st.st_ctime));

			setCaption(absFileName);
			fname->setText(finfo.fileName());
			fname->setMinimumSize(fname->fontMetrics().width(absFileName), fname->fontMetrics().height() + 10);
			fname->setEnabled(TRUE);

			fmt.sprintf("Size: %ld bytes\n"
						"Last access       : %s"
						"Last Modification : %s"
						"Last File Change  : %s", (long) st.st_size, (const char *) la, (const char *) lm, (const char *) lc);
			fileinfo->setText(fmt);
			

			ownership[UID]->setEnabled(TRUE);
			ownership[GID]->setEnabled(TRUE);
			
			if ((pwd = getpwuid(orig_uid = st.st_uid)))
			{
				ownership[UID]->setCurrentItem(names->find(pwd->pw_name));
			}
			else
			{
				QString fmt;

				fmt.sprintf("#%ld", (long) st.st_uid);
				ownership[UID]->insertItem(fmt);
				ownership[UID]->setCurrentItem(ownership[UID]->count() - 1);
			}

			if ((grp = getgrgid(orig_gid = st.st_gid)))
			{
				ownership[GID]->setCurrentItem(groups->find(grp->gr_name));
			}
			else
			{
				QString fmt;

				fmt.sprintf("#%ld", (long) st.st_gid);
				ownership[GID]->insertItem(fmt);
				ownership[GID]->setCurrentItem(ownership[GID]->count() - 1);
			}

			// read ugsrwxrwxrwx

			orig_mode = rwx = st.st_mode;

			for (int i = 0; i < NumPerms; i++)
			{
				perm_ctl[i]->setEnabled(TRUE);
				perm_ctl[i]->setChecked(rwx & 0x800);
				rwx <<= 1;
			}
			
			if (st.st_uid != geteuid())
			{
				// Not owner of this file, disable 
				// permission and ownership controls
				// disabling of rename() is a bit difficult
				// I need to know more of the semantics right now
				// If I'm the owner of the dir, I may rename
				// otherwise not ?

				for (int i = 0; i < NumPerms; i++)
					perm_ctl[i]->setEnabled(FALSE);
				ownership[UID]->setEnabled(FALSE);
				ownership[GID]->setEnabled(FALSE);
			}
			/*
			 * RvS 97040.6
			 * This does not compute...
			 * I'll look after it when I have time
			 * 
			{
				QString pathname = absFileName;
				int idx,oldidx=0;
				struct stat dirst;
				gid_t	grplst[NGROUPS_MAX];
				bool have_access=FALSE;
				
				while(idx = pathname.find('/',oldidx))
					oldidx=idx;

				pathname.truncate(oldidx);
				if (stat(pathname,&dirst) == -1)
					fname->setEnabled(FALSE);	// No xs@all !
				else if (!(((dirst.st_mode & S_IRWXO ) & S_IWOTH) || ((dirst.st_uid == geteuid()) && ((dirst.st_mode & S_IRWXU) & S_IXUSR))))
				{
					int numgrp = getgroups(NGROUPS_MAX,grplst);
					for (int i = 0; (i < numgrp) && !have_access; i++)
						if ((dirst.st_gid == grplst[i]) && ((dirst.st_mode & S_IRWXG ) & S_IWGRP))
							have_access = TRUE;
					if (have_access)	
						fname->setEnabled(FALSE);	// No xs@all !
				}
			}
			*/
		}
		else
			fileinfo->setText(strerror(errno));
		fileinfo->setMinimumSize(fileinfo->sizeHint());
	}
	// modified = TRUE;
}
/*---------------------------------------------------------------------------*/
void    FPropdlg::nameChanged(const char *)
{
	do_rename = TRUE;
}
/*---------------------------------------------------------------------------*/
void    FPropdlg::modeChanged(int)
{
	do_chmod = TRUE;
}
/*---------------------------------------------------------------------------*/
void    FPropdlg::ownerChanged(int)
{
	do_chown = TRUE;
}
/*---------------------------------------------------------------------------*/
gid_t   FPropdlg::getUid()
{
	return new_uid;
}
/*---------------------------------------------------------------------------*/
uid_t   FPropdlg::getGid()
{
	return new_gid;
}
/*---------------------------------------------------------------------------*/
mode_t  FPropdlg::getMode()
{
	return new_mode;
}
/*---------------------------------------------------------------------------*/
const char *FPropdlg::getName()
{
	return *absfname;
}
/*---------------------------------------------------------------------------*/
const char *FPropdlg::getNewname()
{
	return *newabsfname;
}
/*---------------------------------------------------------------------------*/
