#include <stddef.h>
#include <setjmp.h>
#include <signal.h>

/* Clear all signals from SET.  */
int sA0emptyset (unsigned *set)
{ *set = 0; return 0; }

/* Set all signals in SET.  */
int sA0fillset (unsigned *set)
{ *set = 0xffffffff; return 0; }

/* Return non-empty value is SET is not empty.  */
int sA0isemptyset (const unsigned *set)
{ return *set; }

/* Get and/or change the set of blocked signals.  */
int sA0procmask (int how,
		 const unsigned *set, unsigned *oset)
{
  if (oset == NULL)
    return sigprocmask(how, (const sigset_t *)set, NULL);
  else
    {
      sigset_t s, os, *sp;
      int result;

      if (set == NULL)
	sp = NULL;
      else
	{
	  sigemptyset(&s);
	  s.__val[0] = *set;
	  sp = &s;
	}
      result = sigprocmask(how, sp, &os);
      *oset = os.__val[0];
      return result;
    }
}

/* Put in SET all signals that are blocked and waiting to be delivered.  */
int sA0pending (unsigned *set)
{
  sigset_t s;
  int result;
  result = sigpending(&s);
  *set = s.__val[0];
  return result;
}

struct kernel_sigaction {
	__sighandler_t k_sa_handler;
	unsigned long k_sa_mask;
	unsigned long k_sa_flags;
	void (*k_sa_restorer)(void);
};

/* Get and/or set the action for signal SIG.  */
int sA0action (int sig, const struct kernel_sigaction *act,
	       struct kernel_sigaction *oact)
{
  struct sigaction a, oa;
  int result;

  if (act != NULL)
    {
      a.sa_handler = act->k_sa_handler;
      sigemptyset(&a.sa_mask);
      a.sa_mask.__val[0] = act->k_sa_mask;
      a.sa_flags = act->k_sa_flags;
      a.sa_restorer = act->k_sa_restorer;
    }
  result = sigaction(sig, act == NULL ? NULL : &a, oact == NULL ? NULL : &oa);
  if (oact != NULL)
    {
      oact->k_sa_handler = oa.sa_handler;
      oact->k_sa_mask = oa.sa_mask.__val[0];
      oact->k_sa_flags = oa.sa_flags;
      oact->k_sa_restorer = oa.sa_restorer;
    }
  return result;
}

int
__sA0jmp_save (sigjmp_buf env, int savemask)
{
  env[0].__mask_was_saved = (savemask &&
			     sA0procmask (SIG_BLOCK, NULL,
					  ((unsigned *)
					   env[0].__saved_mask.__val)) == 0);

  return 0;
}
