#! /bin/sh
#
# Install.man  for  linux-man-pages-ja-0.3  1998-02-01
#

remove_old()
{
	for i in $1 $1.gz $1.z $1.Z
	do
		if [ -f $i ]; then
			rm -f $i || exit 1
		fi
	done
}

setup_man()
{
	chown $2 $1
	chgrp $3 $1
	chmod $4 $1
	if [ "$5" = "y" ]; then
		[ "$VERBOSE" = "y" ] && echo -n "gzip.. "
		gzip --best $1
	elif [ "$6" = "y" ]; then	
		[ "$VERBOSE" = "y" ] && echo -n "compress.. "
		compress $1
	fi
}

###  read config options  ###################
. ./config.man

###  check libc version #####################
if [ -f /lib/libc.so.6 ]; then
	LIBC=glibc2
else
	LIBC=libc5
fi

###  man-page name  #########################
NAME=`basename $1`
[ "$VERBOSE" = "y" ] && echo -n "$NAME :	"

###  man-page section  ######################
SEC=`dirname $1 | sed s/man//`

#
# Source Man-Page
#
if [ "$JMAN" = "y" ]; then
	DIR=$JMANDIR/man$SEC
	MAN=$DIR/$NAME

###  make directory #########################
	[ -d $DIR ] || mkdir -p $DIR || exit 1

###  remove old man-pages  ##################
	remove_old $MAN

###  install source man-pages  ##############
	[ "$VERBOSE" = "y" ] && echo -n "copy.. "
	cp $1 $MAN || exit 1
	setup_man $MAN $JMANOWN $JMANGRP $JMANPERM $MANGZIP $MANCOMP
fi


#
# Formatted Man-Page
#
if [ "$JCAT" = "y" ]; then
	DIR=$JCATDIR/cat$SEC
	CAT=$DIR/$NAME
	GROFF_TMAC_PATH=/usr/share/groff/tmac:./man-ja/tmac
	export GROFF_TMAC_PATH

###  make directory #########################
	[ -d $DIR ] || mkdir -p $DIR || exit 1

###  remove old man-pages  ##################
	remove_old $CAT

###  install formatted man-pages  ###########
	[ "$VERBOSE" = "y" ] && echo -n "format .... "
	./man-ja/$LIBC/man -P /bin/cat -C ./script/man.jconf $1 > $CAT || exit 1
	setup_man $CAT $JCATOWN $JCATGRP $JCATPERM $CATGZIP $CATCOMP
fi


[ "$VERBOSE" = "y" ] && echo "done. "
exit 0
