;;; emacspeak.el --- Emacspeak -- The Complete Audio Desktop
;;; $Id: emacspeak.el,v 8.0 1998/05/01 14:15:46 raman Exp $
;;; $Author: raman $ 
;;; Description:  Emacspeak: A speech interface to Emacs
;;; Keywords: Emacspeak, Speech, Dectalk,
;;{{{  LCD Archive entry: 

;;; LCD Archive Entry:
;;; emacspeak| T. V. Raman |raman@adobe.com 
;;; A speech interface to Emacs |
;;; $Date: 1998/05/01 14:15:46 $ |
;;;  $Revision: 8.0 $ | 
;;; Location undetermined
;;;

;;}}}
;;{{{  Copyright:
;;;Copyright (C) 1995, 1996, 1997, 1998   T. V. Raman  Adobe Systems Incorporated
;;; Copyright (c) 1994, 1995 by Digital Equipment Corporation.
;;; All Rights Reserved. 
;;;
;;; This file is not part of GNU Emacs, but the same permissions apply.
;;;
;;; GNU Emacs is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; GNU Emacs is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Emacs; see the file COPYING.  If not, write to
;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;}}}

(require 'cl)
(require 'advice)
(eval-when (compile)
  (require 'dtk-speak)
  (require 'emacspeak-fix-interactive)
  (require 'emacspeak-speak)
  (require 'emacspeak-keymap))


;;{{{  Introduction:
;;; This is the main emacspeak module.
;;; It actually does very little:
;;; It loads the various parts of the system. 

;;}}}
;;{{{  Setting up things: 

(defconst emacspeak-version
  (let ((x "$Revision: 8.0 $"))
    (string-match "[0-9.]+" x)
    (substring x (match-beginning 0)
               (match-end 0)))
  "Version number for Emacspeak. ")

(defvar emacspeak-startup-hook nil
  "Hook to run after starting emacspeak" )

;;}}}
;;{{{ add autoloads and set some load hooks

(autoload 'emacspeak-remote-connect-to-server "emacspeak-remote"
"Connect to a remote speech server.
Use this when you are running emacspeak on a remote machine and want
to have speech output on the local desktop.
Unlike the simpler rsh based remote-tcl solution
(see file remote-tcl in the emacspeak distribution)
this command emacspeak-remote-connect-to-server allows you
to get remote speech feedback in cases where the remote machine cannot
use rsh on your local desktop."
  t)
(autoload 'emacspeak-remote-quick-connect-to-server "emacspeak-remote"
"Connect to a remote speech server.
Use this when you are running emacspeak on a remote machine and want
to have speech output on the local desktop.
Unlike the simpler rsh based remote-tcl solution
(see file remote-tcl in the emacspeak distribution)
this command emacspeak-remote-connect-to-server allows you
to get remote speech feedback in cases where the remote machine cannot
use rsh on your local desktop."
  t)


(autoload 'emacspeak-eterm-remote-term "emacspeak-eterm"
   "Create a terminal to rlogin into a remote host" t)
(autoload 'voice-lock-mode "voice-lock" "voice lock mode" t)
    (autoload 'emacspeak-toggle-auditory-icons "emacspeak-sounds"
      "Ask emacspeak to use auditory icons" t)
    (autoload 'emacspeak-tabulate-region "emacspeak-tabulate" 
      "Identify columns in the region."  t)
    (add-hook 'term-load-hook (function (lambda () (require 'emacspeak-eterm ))))
    (add-hook 'vm-mode-hook (function (lambda () (require 'emacspeak-vm ))))
    (add-hook 'calendar-load-hook
              (function (lambda () (require 'emacspeak-calendar ))) t)
    (add-hook 'dired-load-hook '(lambda () (require 'emacspeak-dired )) t)

;;}}}
;;{{{ Emacspeak:

(defvar emacspeak-emacs-commands-to-fix 
  '(
    add-completions-from-file
    append-to-file
    append-to-register
    byte-force-recompile
    byte-recompile-directory
    cd
    comint-run
    command-apropos
    copy-rectangle-to-register
    copy-to-buffer
    copy-to-register
    customize-apropos
    customize-apropos-faces
    customize-apropos-groups
    customize-apropos-options
    define-mail-abbrev
    define-mail-alias
    define-mail-alias
    describe-key
    describe-key-briefly
    desktop-save
    dmacro-load
    dtk-set-character-scale
    dtk-set-rate
    emacspeak-dial-dtk
    emacspeak-keymap-choose-new-emacspeak-prefix
    emacspeak-frame-label-or-switch-to-labelled-frame
    emacspeak-generate-documentation
    find-file
    find-file-literally
    find-file-literally
    find-file-other-frame
    find-file-other-window
    find-file-read-only
    find-file-read-only-other-frame
    find-file-read-only-other-window
    fold-goto-line
    global-unset-key
    goto-line
    insert-file
    insert-file-literally
    insert-file-literally
    insert-register
    insert-variable
    jump-to-register
    list-text-properties-at
    load-file
    load-library
    local-unset-key
    locate-library
    mail-attach-file
    mail-attach-file
    mail-fcc
    mail-fcc
    mail-fcc
    make-frame-on-display
    make-frame-on-display
    make-obsolete
    makefile-insert-macro
    makefile-insert-macro
    makefile-insert-macro
    makefile-insert-target
    makefile-insert-target
    makefile-insert-target
    message-resend
    mime-include-audio
    mime-include-external-anonftp
    mime-include-external-ftp
    mime-include-gif
    mime-include-jpeg
    mime-include-postscript
    mime-include-raw-binary
    mime-include-raw-nonbinary
    nonincremental-re-search-backward
    nonincremental-re-search-forward
    nonincremental-search-backward
    nonincremental-search-forward
    point-to-register
    prefer-coding-system
    prefer-coding-system
    prepend-to-buffer
    prepend-to-register
    read-abbrev-file
    recover-file
    run-at-time
    run-at-time
    run-at-time
    run-with-timer
    run-with-timer
    set-buffer-file-coding-system
    set-buffer-file-coding-system
    set-buffer-process-coding-system
    set-buffer-process-coding-system
    set-foreground-color
    set-foreground-color
    set-frame-font
    set-frame-font
    set-left-margin
    set-left-margin
    set-right-margin
    set-right-margin
    set-visited-file-name
    sort-regexp-fields
    string-rectangle
    string-rectangle 
    switch-to-buffer-other-frame
    switch-to-buffer-other-window
    vc-comment-search-forward
    vc-comment-search-reverse
    vc-directory
    vc-rename-file
    vc-version-diff
    vc-version-other-window
    view-register
    window-configuration-to-register
    zap-to-char
    )
  "Precomputed list of interactive functions that have to be fixed.
Precomputing this saves time at start-up.")


(defun emacspeak()
  "Starts the Emacspeak speech subsystem.  Use emacs as you normally would,
emacspeak will provide you spoken feedback as you work.  Emacspeak also
provides commands for having parts of the current buffer, the mode-line etc to
be spoken.

If you are hearing this description as a result of pressing
\\[emacspeak-describe-emacspeak] you may want to press \\[dtk-stop] to stop
speech, and then use the arrow keys to move around in the Help buffer
  to   read the rest of this description, which
includes a summary of all emacspeak keybindings.

All emacspeak commands use \\[emacspeak-prefix-command] as a prefix key.  You
can also set the state of the Dectalk by using
\\[emacspeak-dtk-submap-command] as a prefix.  Here is a summary of all
emacspeak commands along with their bindings.  You need to precede the
keystrokes listed below with \\[emacspeak-prefix-command].

Emacspeak also provides a fluent speech extension to the emacs
 terminal emulator (eterm).
Note: You need to use the eterm package that comes with emacs-19.29.

\\{emacspeak-keymap}

See the online documentation for individual commands and functions for
 details. There is an info manual for Emacspeak, but it is still
 preliminary. The source code documentation is up-to-date, please use it.  "
  
  (interactive)
  (declare (special dtk-program dtk-servers-alist dtk-server-prefix
                    emacspeak-emacs-commands-to-fix))
  (let ((server-flag nil ))
    (load-library "dtk-speak")
    (unless  dtk-program
      (ding t)
      (sit-for 1)
      (ding t)
      (setq server-flag t 
            dtk-program (completing-read "Select Dectalk server:"
                                         dtk-servers-alist  nil
                                         t dtk-server-prefix )))
    (dtk-initialize)
    (when server-flag
      (dtk-speak
       "Make sure you  set the environment variable DTK_PROGRAM next
time!"))
    (require 'emacspeak-speak)
    (load-library "emacspeak-redefine")
    ( load-library "emacspeak-fix-interactive")
    (load-library "emacspeak-keymap")
    (load-library "emacspeak-advice")
    (load-library "emacspeak-replace")
    (require 'emacspeak-buff-menu)
    (mapcar 'emacspeak-fix-interactive-command-if-necessary 
            emacspeak-emacs-commands-to-fix)
    (run-hooks 'emacspeak-startup-hook)
    (emacspeak-dtk-sync)
    (emacspeak-export-environment)
    (message  (format "  Press %s to get an   overview of emacspeak  %s \
 I am  completely operational,  and all my \
circuits are functioning perfectly! "
                      (substitute-command-keys
                       "\\[emacspeak-describe-emacspeak]" )
                      emacspeak-version))))

(defun emacspeak-describe-emacspeak ()
  "Give a brief overview of emacspeak. "
  (interactive)
  (describe-function 'emacspeak)
  (switch-to-buffer "*Help*")
  (dtk-set-punctuations "all")
  (emacspeak-speak-buffer))

;;}}}
;;{{{ autoloads

(autoload 'emacspeak-table-find-file "emacspeak-table-ui"
  "Browse tables. Beginners: please do C-e C-t and specify one of the
.tab files in the tables subdirectory of emacspeak.
Describe function of emacspeak-table-find-file will then give you
detailed documentation on the table browser" t )
(autoload 'emacspeak-table-display-table-in-region "emacspeak-table-ui"
"Parse contents of region as tabular data and display it in table
browsing mode.  Beginners: please do C-e C-t and specify one of the
.tab files in the tables subdirectory of emacspeak.  Describe function
of emacspeak-table-find-file will then give you detailed documentation
on the table browser"
 t )
(autoload 'emacspeak-tapestry-describe-tapestry  "emacspeak-tapestry"
  "Describe layout of buffers in current frame.
This needs the tapestry.el package used by many Emacs systems like the
vm mail reader." t)

(autoload 'emacspeak-hide-or-expose-block "emacspeak-hide"
  "Hide or expose blocks of text that share a common prefix.
Useful in reading email, block comments in program source etc." t)
(autoload 'emacspeak-hide-or-expose-all-blocks "emacspeak-hide"
  "Hide or expose blocks of text that share a common prefix.
Useful in reading email, block comments in program source etc." t)
(autoload 'emacspeak-hide-speak-block-sans-prefix "emacspeak-hide"
  "Speak a block of text sans the prefix that appears on every line of
the block. Use in conjunction with emacspeak-hide-or-expose-block"
   t)
;;; Realaudio
(autoload 'emacspeak-realaudio "emacspeak-realaudio"
  "Single click interface to RealAudio" t)
(autoload 'emacspeak-realaudio-play-url-at-point "emacspeak-realaudio"
  "Single click interface to RealAudio" t)

(autoload 'emacspeak-realaudio-play "emacspeak-realaudio"
  "Single click interface to RealAudio" t)
(autoload 'emacspeak-realaudio-stop "emacspeak-realaudio"
  "Single click interface to RealAudio" t)

;;}}}
;;{{{  Advice for Emacs subsystems:
;;{{{  ange-ftp

(add-hook 'after-load-alist
          '("ange-ftp"
            (loop for f in 
                  '(ange-ftp-copy-file
                    ange-ftp-delete-file
                    ange-ftp-kill-ftp-process
                    ange-ftp-nslookup-host
                    ange-ftp-rename-file
                    ange-ftp-set-user)
                  do
                  (emacspeak-fix-interactive-command-if-necessary f))))

;;}}}
;;{{{ imenu 

(add-hook 'after-load-alist
          '("imenu"
                        (load "emacspeak-imenu")))

;;}}}
;;{{{  jde
(add-hook 'after-load-alist
          '("jde"
                        (load "emacspeak-jde")))

;;}}}
;;{{{  speedbar
(add-hook 'after-load-alist
          '("speedbar"
                        (load "emacspeak-speedbar")))

;;}}}
;;{{{  python
(add-hook 'after-load-alist
          '("python-mode"
                        (load "emacspeak-python")))

;;}}}
;;{{{  tempo
(add-hook 'after-load-alist
          '("tempo"
                        (load "emacspeak-tempo")))

;;}}}
;;{{{  solitaire

(add-hook 'after-load-alist
          '("solitaire"
                        (load "emacspeak-solitaire")))

;;}}}
;;{{{  tetris

(add-hook 'after-load-alist
          '("tetris"
                        (load "emacspeak-tetris")))

(defadvice tetris (before emacspeak pre act comp)
  "Speech enable the game"
  (require 'emacspeak-tetris))

;;}}}
;;{{{  bookmark

(add-hook 'after-load-alist
          '("bookmark"
                        (load "emacspeak-bookmark")))

;;}}}

;;{{{  tar

(add-hook 'after-load-alist
          '("tar-mode"
                        (load "emacspeak-tar")))

;;}}}
;;{{{  arc

(add-hook 'after-load-alist
          '("arc-mode"
                        (load "emacspeak-arc")))

;;}}}
;;{{{  gomoku

(add-hook 'after-load-alist
          '("gomoku"
                        (load "emacspeak-gomoku.elc")))

;;}}}
;;{{{ rmail

(add-hook 'after-load-alist
          '("rmail"
                        (load "emacspeak-rmail")))

;;}}}
;;{{{ view mode

(add-hook 'after-load-alist
          '("view"
                        (load "emacspeak-view")))

;;}}}
;;{{{ enriched text

(add-hook 'after-load-alist
          '("enriched"
                        (load "emacspeak-enriched")))

;;}}}
;;{{{ facemenu 

(add-hook 'after-load-alist
          '("facemenu"
                        (require  'emacspeak-facemenu)))

(add-hook 'after-load-alist
          '("tmm"
                        (require  'emacspeak-facemenu)))

;;}}}
;;{{{ find-dired

(add-hook 'after-load-alist
          '("find-dired"
                        (mapcar
                         'emacspeak-fix-interactive-command-if-necessary
                         (list 'find-dired
                               'find-name-dired
                               'find-grep-dired))))

;;}}}
;;{{{ sgml mode

(add-hook 'after-load-alist
          '("sgml-mode"
                        (load "emacspeak-sgml-mode")))

;;}}}
;;{{{  message mode

(add-hook 'after-load-alist
          '("message"
                        (load "emacspeak-message")))

;;}}}
;;{{{  dismal spread sheet mode

(add-hook 'after-load-alist
          '("dismal"
                        (load "emacspeak-dismal")))

;;}}}
;;{{{ interactive buffer selection

(add-hook 'after-load-alist
          '("buff-sel"
                        (load "emacspeak-buff-sel")))

;;}}}
;;{{{ view process mode

(add-hook 'after-load-alist
          '("view-process-mode"
                        (load "emacspeak-view-process")))

;;}}}
;;{{{ bibtex 

(add-hook 'after-load-alist
          '("bibtex"
                        (load "emacspeak-bibtex")))

;;}}}
;;{{{ widget

(add-hook 'after-load-alist
          '("wid-edit"
                        (load "emacspeak-widget")))
;;}}}
;;{{{ custom

(add-hook 'after-load-alist
          '("custom"
                        (load "emacspeak-custom")))
;;}}}
;;{{{ mspools

(add-hook 'after-load-alist
          '("mspools"
                        (load "emacspeak-mspools")))
;;}}}
;;{{{ winring

(add-hook 'after-load-alist
          '("winring"
                        (load "emacspeak-winring")))
;;}}}
;;{{{ w3

(add-hook 'after-load-alist
          '("w3"
            (require 'emacspeak-w3)))
            

;;}}}
;;{{{  Outline mode

(defadvice outline-mode (after emacspeak pre act comp)
  "Make sure emacspeak extensions are loaded."
  (require 'emacspeak-outline))

(defadvice outline-minor-mode (after emacspeak pre act comp)
  "Make sure emacspeak extensions are loaded."
  (require 'emacspeak-outline))

;;}}}
;;{{{ appointments

(add-hook 'after-load-alist
          '("appt"
            (emacspeak-fix-interactive-command-if-necessary 'appt-add)))

;;}}}
;;{{{  hyperbole:

(defadvice hyperbole (before emacspeak pre act )
  "Make sure emacspeak extensions are loaded."
(require 'emacspeak-hyperbole)
(require 'emacspeak-wrolo))

;;; Entry points to rolodex via hyperbole:
;'(rolo-add 
;rolo-display-matches 
;rolo-edit 
;rolo-kill 
;rolo-sort 
;rolo-grep 
;rolo-fgrep 
;rolo-word 
;rolo-yank)

;;}}}
;;{{{ kotl

(defadvice kotl-mode (before emacspeak pre act )
  "Ensure emacspeak extensions are loaded"
  (require 'emacspeak-kotl))

;;}}}
;;{{{ forms

(add-hook 'after-load-alist
          '("forms"
                        (require 'emacspeak-forms)))

;;}}}
;;; Emacspeak provides speech extensions for several Emacs subsystems.
;;; Many of these are loaded via load-hooks provided by those subsystems,
;;; See function emacspeak.
;;; For those packages that do not provide such load-hooks,
;;; We will advice their entry points to require the Emacspeak extensions.

;;{{{  emacspeak-ispell 

(add-hook 'after-load-alist
          '("ispell"
            (require 'emacspeak-ispell)))

;;}}}
;;{{{ emacspeak-info
(add-hook 'after-load-alist
          '("info"
            (require 'emacspeak-info)))

;;}}}
;;{{{  emacspeak-compile
(add-hook 'after-load-alist
          '("compile"
                        (load "emacspeak-compile")))


;;}}}
;;{{{  calc:

(defadvice calc-dispatch (after emacspeak activate)
  (require 'emacspeak-calc))

;;}}}
;;{{{ folding:

(defadvice folding-mode (after emacspeak activate)
"Load emacspeak folding extension. "
(require 'emacspeak-folding))

;;}}}
;;{{{  C mode: c-mode and cc-mode 

(add-hook 'after-load-alist 
'("cc-mode"
  (require 'emacspeak-c)))


(add-hook 'after-load-alist 
'("c-mode"
  (require 'emacspeak-c)))

(add-hook 'c-mode-common-hook 
(function (lambda ()
(require 'emacspeak-c))))
;;}}}

;;{{{ Auctex: 

(defadvice tex-mode (after emacspeak activate)
"Make sure emacspeak extensions loaded."
(require 'emacspeak-auctex))

;;}}}

;;{{{  html-helper-mode

(add-hook 'html-helper-load-hook
          (function (lambda ()
                      (require 'emacspeak-tempo ))))

;;}}}

;;{{{ w3:

;;; advice all entry points: 
(defadvice w3 (before emacspeak activate )
  (require 'emacspeak-w3))

(defadvice w3-fetch (before emacspeak activate )
  (require 'emacspeak-w3))

(defadvice w3-open-local (before emacspeak activate )
  (require 'emacspeak-w3))
;;}}}

;;{{{ perl:
(defadvice perl-mode (after emacspeak pre act comp)
  "Make sure emacspeak extensions are present."
  (require 'emacspeak-perl))

;;}}}

;;{{{  tcl-mode

(add-hook 'after-load-alist
          '("tcl"
                        (load "emacspeak-tcl")))

(defadvice tcl-mode (after emacspeak pre act comp)
  "Load emacpseak extensions"
  (require 'emacspeak-tcl))

(defadvice inferior-tcl (after emacspeak pre act comp)
  "Ensure emacspeak extensions are present."
  (require 'emacspeak-tcl))

;;}}}
;;{{{  ielm: inferior elisp

(defadvice ielm (after emacspeak pre act)
  "Provide auditory feedback."
  (when (interactive-p)
    (emacspeak-fix-interactive-command-if-necessary 'ielm-change-working-buffer)
    (message "Welcome to the inferior elisp buffer")))

;;}}}



(defadvice oobr ( after emacspeak pre act )
  "Load emacspeak extensions."
  (require 'emacspeak-oo-browser ))

;;{{{ ediff:
;;; newer ediff has ediff-init and uses ediff-load-hook
(if (locate-library "ediff-init")
(add-hook 'ediff-load-hook
          (function (lambda ()
                      (require 'emacspeak-ediff ))))     
;; else older ediff 
(add-hook 'ediff-load-hooks
          (function (lambda ()(require 'emacspeak-old-ediff )))))

;;}}}
;;{{{  bbdb 

(add-hook 'bbdb-load-hook
          (function (lambda ()
                      (require 'emacspeak-bbdb ))))
;;}}} 
;;{{{ dmacro

(defadvice insert-dmacro (before emacspeak-load pre act )
  "Ensure emacspeak extension is loaded"
  (require 'emacspeak-dmacro))

;;}}}
;;{{{man pages:
(defadvice man (before emacspeak pre act )
"Load emacspeak extensions"
(require 'emacspeak-man))


(defadvice manual-entry  (before emacspeak pre act )
"Load emacspeak extensions"
(require 'emacspeak-man))
;;{{{  gud:

(add-hook 'after-load-alist
          '("gud"
                        (load "emacspeak-gud")))

;;}}}
;;{{{  voice locking for html

       (add-hook 'html-helper-load-hook
                 (function (lambda ()
                             (load "html-voice"))))

;;}}}

;;{{{  gud:

(defadvice gdb (before emacspeak  pre act)
  "Ensure emacspeak extensions are loaded."
  (require 'emacspeak-gud))

;;}}}
;;{{{  voice locking for html

       (add-hook 'html-helper-load-hook
                 (function (lambda ()
                             (load "html-voice"))))

;;}}}
;;{{{ gnus
;;; emacs can hang if too many message sfly by as gnus starts
(defadvice gnus (around emacspeak pre act )
  "Temporarily deactivate advice on message"
  (dtk-speak  "Starting gnus")
  (require 'emacspeak-gnus)
  (let ((emacspeak-speak-messages nil))
    ad-do-it)
  (emacspeak-auditory-icon 'news)
  (message "Gnus is ready "))

;;}}}
;;{{{ Entertainment --mpuz

(add-hook 'after-load-alist
          '("doctor"
            (progn 
            (defadvice doctor-txtype (after emacspeak pre act )
  (dtk-speak
   (mapconcat
    (function (lambda (s)
                (format "%s" s)))
    (ad-get-arg 0 )
    " "))))))
(add-hook 'after-load-alist
          '("mpuz"
           (progn
             (declaim (special mpuz-silent ))
             (setq mpuz-silent t )
             (defadvice mpuz-correct-guess (after emacspeak pre act )
               "Provide an auditory icon"
               (emacspeak-auditory-icon 'search-hit ))
             (defadvice mpuz-congratulate (after emacspeak pre act )
               "Produce auditory icon"
               (emacspeak-auditory-icon 'alarm )))))

;;}}}
;;{{{  finder
(add-hook 'after-load-alist
          '("finder"
            (progn
              (load-library "emacspeak-finder")
              (unless (file-newer-than-file-p
                       (concat emacspeak-dir "/"
                               "emacspeak-finder-inf.el")
                       (concat emacspeak-dir "/" "emacspeak.el"))
                (emacspeak-finder-compile-keywords))
              (load-library "emacspeak-finder-inf")
              (push 
               (cons 'emacspeak "Audio Desktop")
               finder-known-keywords))))

;;}}}
;;}}}
;;{{{  Submit bugs

(defconst emacspeak-bug-address
  "raman@adobe.com"
  "Address of the maintainer of this package. ")


(defun emacspeak-submit-bug ()
  "Function to submit a bug to the programs maintainer"
  (interactive)
  (require 'reporter)
  (when
      (yes-or-no-p "Are you sure you want to submit a bug report? ")
    (let (
          (vars '(window-system
                  window-system-version
                  emacs-version
                  system-type
                  emacspeak-version dtk-tcl dtk-program
                  dtk-speech-rate dtk-character-scale
                  dtk-split-caps dtk-capitalize
                  dtk-punctuation-mode
                  emacspeak-line-echo  emacspeak-word-echo
                  emacspeak-character-echo
                  emacspeak-audio-indentation )))
      (mapcar
       (function
        (lambda (x)
          (if (not (and (boundp x) (symbol-value x)))
              (setq vars (delq x vars))))) vars)
      (reporter-submit-bug-report  emacspeak-bug-address 
                                   (concat "Emacspeak Version: " emacspeak-version )
                                   vars
                                   nil nil
                                   "Description of Problem:"))))

;;}}}
;;{{{ exporting emacspeak environment to subprocesses

(defun emacspeak-export-environment ()
  "This exports emacspeak's system variables to the environment
so it can be passed to subprocesses."
  (declare (special emacspeak-dir
                    emacspeak-play-program
                    emacspeak-sounds-directory))
(setenv "EMACSPEAK_DIR" emacspeak-dir)
   (setenv "EMACSPEAK_SOUNDS_DIR" emacspeak-sounds-directory)
 (setenv "EMACSPEAK_PLAY_PROGRAM" emacspeak-play-program)
 )

;;}}}
(provide 'emacspeak)
;;{{{ end of file 

;;; local variables:
;;; folded-file: t
;;; end: 

;;}}}
