#
#########################################################################
#
# makefile for The Hessling Editor (THE)
#
#########################################################################
#

VER = 25
VERDOT = 2.5

!if "$(COMPUTERNAME)" == "SNARK"
SRC       = c:\the
CURSBIN   = c:\pdc\vc
CURSLIB   = $(CURSBIN)\curses.lib # pdcurses.lib for static linking
CURSINC   = -Ic:\curses
SETARGV   = "c:\program files\devstudio\vc\lib\setargv.obj"
REGINA_BIN = e:\regina-0.08f\vc
REGINA_REXXLIBS = $(REGINA_BIN)\regina.lib
REGINA_REXXINC = -Ie:\regina-0.08f -DUSE_REGINA
OREXX_REXXLIBS = c:\objrexx\api\rexx.lib c:\objrexx\api\rexxapi.lib
OREXX_REXXINC = -Ic:\objrexx\api -DUSE_OREXX
WINREXX_REXXLIBS = e:\winrexx\api\rxrexx.lib
WINREXX_REXXINC = -Ie:\winrexx\api -DUSE_WINREXX
QUERCUS_REXXLIBS = e:\quercus\api\wrexx32.lib
QUERCUS_REXXINC = -Ie:\quercus\api -DUSE_QUERCUS
UNIREXX_REXXLIBS = e:\unirexx\rxx.lib
UNIREXX_REXXINC = -Ie:\unirexx -DUSE_UNIREXX
REXXTRANS_REXXLIBS = c:\rexxtrans-1.0\vc\rexxtrans.lib
REXXTRANS_REXXINC = -Ie:\regina-0.08f -DUSE_REGINA
!else
SRC       = e:\mhes\the
CURSLIB   = e:\mhes\pdc\vc\curses.lib # pdcurses.lib for static linking
CURSINC   = -Ie:\mhes\curses
SETARGV   = "d:\program files\devstudio\vc\lib\setargv.obj"
REGINA_REXXLIBS = e:\mhes\regina-0.08d\vc\regina.lib
REGINA_REXXINC = -Ie:\mhes\regina-0.08d -DUSE_REGINA
OREXX_REXXLIBS = e:\mhes\objrexx\api\rexx.lib e:\mhes\objrexx\api\rexxapi.lib
OREXX_REXXINC = -Ie:\mhes\objrexx\api -DUSE_OREXX
WINREXX_REXXLIBS = e:\mhes\winrexx\api\rxrexx.lib
WINREXX_REXXINC = -Ie:\mhes\winrexx\api -DUSE_WINREXX
QUERCUS_REXXLIBS = e:\mhes\quercus\api\wrexx32.lib
QUERCUS_REXXINC = -Ie:\mhes\quercus\api -DUSE_QUERCUS
UNIREXX_REXXLIBS = c:\unirexx\rxx.lib
UNIREXX_REXXINC = -Ic:\unirexx -DUSE_UNIREXX
!endif
#########################################################################
# MS VC++ compiler on Win32
#########################################################################
PROJ      = the.exe
OBJ       = obj
CC        = cl

!if "$(INT)" == "REGINA"
REXXLIB = $(REGINA_REXXLIBS)
REXXINC =  $(REGINA_REXXINC)
!elseif "$(INT)" == "OREXX"
REXXLIB = $(OREXX_REXXLIBS)
REXXINC =  $(OREXX_REXXINC)
!elseif "$(INT)" == "WINREXX"
REXXLIB = $(WINREXX_REXXLIBS)
REXXINC =  $(WINREXX_REXXINC)
!elseif "$(INT)" == "QUERCUS"
REXXLIB = $(QUERCUS_REXXLIBS)
REXXINC =  $(QUERCUS_REXXINC)
!elseif "$(INT)" == "UNIREXX"
REXXLIB = $(UNIREXX_REXXLIBS)
REXXINC =  $(UNIREXX_REXXINC)
!elseif "$(INT)" == "REXXTRANS"
REXXLIB = $(REXXTRANS_REXXLIBS)
REXXINC =  $(REXXTRANS_REXXINC)
!else
!message Rexx Interpreter NOT specified via INT macro
!message Valid values are: REGINA OREXX WINREXX QUERCUS UNIREXX
!error Make aborted!
!endif

!ifdef DEBUG
CFLAGS    = -c -Od -Zi -FR -DWIN32 -DSTDC_HEADERS -DHAVE_PROTO -I$(SRC) $(CURSINC) $(REXXINC) -Fo$@
LDEBUG     = -debug
!else
CFLAGS    = -c -O2gityb1 -DWIN32 -DSTDC_HEADERS -DHAVE_PROTO -I$(SRC) $(CURSINC) $(REXXINC) -Fo$@
LDEBUG     = -release
!endif

LD        = link
XTRAOBJ   = getopt.obj
MAN       = manext.exe
MANLD     = link386 manext+getopt+wildargv,,,,ibm-man.def /NOE /NOI /EXEPACK /ALIGN:4;
THERC     = $(SRC)\thew32.rc
THERES    = thew32.res
THEW32OBJ = thew32.obj
docdir = doc
#########################################################################
#
#
# Object files
#
OBJ1 = box.$(OBJ) colour.$(OBJ) comm1.$(OBJ) comm2.$(OBJ) comm3.$(OBJ) comm4.$(OBJ) comm5.$(OBJ) \
	commset1.$(OBJ) commset2.$(OBJ) commsos.$(OBJ) cursor.$(OBJ) default.$(OBJ) \
	edit.$(OBJ) error.$(OBJ) execute.$(OBJ) linked.$(OBJ) column.obj mouse.obj memory.obj \
	nonansi.$(OBJ) prefix.$(OBJ) reserved.$(OBJ) scroll.$(OBJ) show.$(OBJ) sort.$(OBJ) \
	target.$(OBJ) the.$(OBJ) util.$(OBJ)
OBJ2 = commutil.$(OBJ) #trace.obj
OBJ3 = getch.$(OBJ)
OBJ4 = query.$(OBJ)
OBJ5 = fnmatch.$(OBJ)
OBJ6 = directry.$(OBJ) file.$(OBJ)
OBJ7 = rexx.$(OBJ)
OBJ8 = 
OBJX = $(XTRAOBJ)
OBJS = $(OBJ1) $(OBJ2) $(OBJ3) $(OBJ4) $(OBJ5) $(OBJ6) $(OBJ7) $(OBJ8) $(OBJX)
#########################################################################

COMM = $(SRC)\comm1.c $(SRC)\comm2.c $(SRC)\comm3.c $(SRC)\comm4.c $(SRC)\comm5.c \
	$(SRC)\commsos.c $(SRC)\commset1.c $(SRC)\commset2.c $(SRC)\query.c

APPENDIX = $(SRC)\appendix.1
GLOSSARY = $(SRC)\glossary

all: the.exe dist$(INT)
#
#########################################################################
the.exe:	$(OBJS) $(THERES) $(THEW32OBJ)
	$(LD) $(LDEBUG) $(LDFLAGS) $(OBJS) $(THEOBJ) $(THEW32OBJ) $(SETARGV) -out:the.exe $(CURSLIB) $(REXXLIB) user32.lib
#########################################################################
box.obj:	$(SRC)\box.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
colour.obj:	$(SRC)\colour.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
comm1.obj:	$(SRC)\comm1.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
comm2.obj:	$(SRC)\comm2.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
comm3.obj:	$(SRC)\comm3.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
comm4.obj:	$(SRC)\comm4.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
comm5.obj:	$(SRC)\comm5.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
commset1.obj:	$(SRC)\commset1.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
commset2.obj:	$(SRC)\commset2.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
commsos.obj:	$(SRC)\commsos.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
cursor.obj:	$(SRC)\cursor.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
default.obj:	$(SRC)\default.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
edit.obj:	$(SRC)\edit.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
error.obj:	$(SRC)\error.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
execute.obj:	$(SRC)\execute.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
linked.obj:	$(SRC)\linked.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
column.obj:	$(SRC)\column.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
mouse.obj:	$(SRC)\mouse.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
memory.obj:	$(SRC)\memory.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
nonansi.obj:	$(SRC)\nonansi.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
prefix.obj:	$(SRC)\prefix.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
reserved.obj:	$(SRC)\reserved.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
scroll.obj:	$(SRC)\scroll.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
show.obj:	$(SRC)\show.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
sort.obj:	$(SRC)\sort.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
target.obj:	$(SRC)\target.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
the.obj:	$(SRC)\the.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
util.obj:	$(SRC)\util.c $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
commutil.obj:	$(SRC)\commutil.c $(SRC)\the.h $(SRC)\command.h $(SRC)\defines.h $(SRC)\proto.h $(SRC)\getch.h $(SRC)\key.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
trace.obj:	$(SRC)\trace.c $(SRC)\the.h $(SRC)\command.h $(SRC)\defines.h $(SRC)\proto.h $(SRC)\getch.h $(SRC)\key.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
getch.obj:	$(SRC)\getch.c $(SRC)\getch.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
query.obj:	$(SRC)\query.c $(SRC)\query.h $(SRC)\the.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
fnmatch.obj:	$(SRC)\fnmatch.c $(SRC)\the.h $(SRC)\fnmatch.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
directry.obj:	$(SRC)\directry.c $(SRC)\the.h $(SRC)\directry.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
file.obj:	$(SRC)\file.c $(SRC)\the.h $(SRC)\directry.h $(SRC)\defines.h $(SRC)\proto.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
rexx.obj:	$(SRC)\rexx.c $(SRC)\the.h $(SRC)\therexx.h $(SRC)\proto.h $(SRC)\defines.h $(SRC)\query.h
	$(CC) $(CFLAGS) $(SRC)\$*.c
getopt.obj:	$(SRC)\getopt.c
	$(CC) $(CFLAGS) $(SRC)\$*.c

$(THERES) $(THEW32OBJ): $(THERC)
	copy $(SRC)\thewin.ico
	rc /r /fo$(THERES) /i$(SRC) $(THERC)
	cvtres /MACHINE:IX86 /NOLOGO /OUT:$(THEW32OBJ) $(THERES)
#
#########################################################################
manual:	$(MAN) $(SRC)\overview $(COMM) $(APPENDIX) $(GLOSSARY)
	manext $(SRC)\overview $(COMM) $(APPENDIX) $(GLOSSARY) > the.man
#
$(MAN):	$(XTRAOBJ) manext.$(OBJ)
	$(MANLD)
	$(CHMODMAN)


zip:
	zip thesrc$(VER) README INSTALL TODO COPYING HISTORY THE_Help.txt
	zip thesrc$(VER) overview appendix.1 appendix.2 appendix.3 glossary README.OS2
	zip thesrc$(VER) box.c colour.c comm*.c cursor.c default.c directry.c
	zip thesrc$(VER) edit.c error.c norexx.c scroll.c column.c execute.c
	zip thesrc$(VER) file.c fnmatch.c getch.c getopt.c linked.c mouse.c memory.c
	zip thesrc$(VER) nonansi.c os2eas.c prefix.c query.c reserved.c
	zip thesrc$(VER) rexx.c show.c sort.c target.c the.c trace.c util.c
	zip thesrc$(VER) command.h defines.h directry.h fnmatch.h getch.h
	zip thesrc$(VER) key.h query.h proto.h rexxfill.h therexx.h the.h makefile.dist $(docdir)/*.gif
	zip thesrc$(VER) manext.c *.rc *.rsp *.def *.diz files.rcs the*.xbm icons.zip the.res the.rc the.eas
	zip thesrc$(VER) append.the comm.the uncomm.the total.the match.the rm.the
	zip thesrc$(VER) words.the l.the compile.the spell.the demo.the demo.txt
	zip thesrc$(VER) Makefile.in configure config.h.in $(docdir)/THE_Help*
	zip thesrc$(VER) vcwin32.mak wccwin32.mak
	zip thesrc$(VER) config.guess config.sub install-sh
	zip thesrc$(VER) aclocal.m4 configure.in
	zip thesrc$(VER) man2html.rex
#

distREGINA:
	-mkdir tmp
	cd tmp
	copy ..\the.exe .
	copy $(SRC)\*.the .
	copy $(SRC)\README .
	copy $(SRC)\COPYING .
	copy $(SRC)\HISTORY .
	copy $(SRC)\TODO .
	copy $(CURSBIN)\curses.dll .
	copy $(REGINA_BIN)\regina.dll .
	copy $(SRC)\THE_Help.txt .
	copy $(SRC)\demo.txt .
	copy $(SRC)\win32.diz file_id.diz
	c:\bin\the -b -p $(SRC)\fix.diz -a "$(VER) $(VERDOT) R Regina" file_id.diz
	zip the$(VER)R_w32 *
	cd ..

distOREXX:
	-mkdir tmp
	cd tmp
	copy ..\the.exe .
	copy $(SRC)\*.the .
	copy $(SRC)\README .
	copy $(SRC)\COPYING .
	copy $(SRC)\HISTORY .
	copy $(SRC)\TODO .
	copy $(CURSBIN)\curses.dll .
	copy $(SRC)\THE_Help.txt .
	copy $(SRC)\demo.txt .
	copy $(SRC)\win32.diz file_id.diz
	c:\bin\the -b -p $(SRC)\fix.diz -a "$(VER) $(VERDOT) O IBM Object Rexx" file_id.diz
	zip the$(VER)O_w32 *
	cd ..

distWINREXX:
	-mkdir tmp
	cd tmp
	copy ..\the.exe .
	copy $(SRC)\*.the .
	copy $(SRC)\README .
	copy $(SRC)\COPYING .
	copy $(SRC)\HISTORY .
	copy $(SRC)\TODO .
	copy $(CURSBIN)\curses.dll .
	copy $(SRC)\THE_Help.txt .
	copy $(SRC)\demo.txt .
	copy $(SRC)\win32.diz file_id.diz
	c:\bin\the -b -p $(SRC)\fix.diz -a "$(VER) $(VERDOT) W Enterprise Rexx" file_id.diz
	zip the$(VER)W_w32 *
	cd ..

distQUERCUS:
	-mkdir tmp
	cd tmp
	copy ..\the.exe .
	copy $(SRC)\*.the .
	copy $(SRC)\README .
	copy $(SRC)\COPYING .
	copy $(SRC)\HISTORY .
	copy $(SRC)\TODO .
	copy $(CURSBIN)\curses.dll .
	copy $(SRC)\THE_Help.txt .
	copy $(SRC)\demo.txt .
	copy $(SRC)\win32.diz file_id.diz
	c:\bin\the -b -p $(SRC)\fix.diz -a "$(VER) $(VERDOT) Q Personal Rexx" file_id.diz
	zip the$(VER)Q_w32 *
	cd ..

distUNIREXX:
	-mkdir tmp
	cd tmp
	copy ..\the.exe .
	copy $(SRC)\*.the .
	copy $(SRC)\README .
	copy $(SRC)\COPYING .
	copy $(SRC)\HISTORY .
	copy $(SRC)\TODO .
	copy $(CURSBIN)\curses.dll .
	copy $(SRC)\THE_Help.txt .
	copy $(SRC)\demo.txt .
	copy $(SRC)\win32.diz file_id.diz
	c:\bin\the -b -p $(SRC)\fix.diz -a "$(VER) $(VERDOT) U Uni-REXX" file_id.diz
	zip the$(VER)U_w32 *
	cd ..
