//  Config.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "Config.h"
#include <stdio.h>
#include <stdlib.h>
#include <UCommon.h>

Config*		Config::lConfig = 0;
int		Config::instances = 0;
FontMap**	Config::fontMap=0;
int		Config::fontMapSize=0;
int		Config::fontMapArraySize=0;
TrueTypeFont**	Config::trueTypeFont=0;
int		Config::trueTypeFontSize=0;
int		Config::trueTypeFontArraySize=0;
XInputMap**	Config::xInputMap=0;
int		Config::xInputMapSize=0;
Language**	Config::languageMap=0;
int		Config::languageMapSize=0;
char*		Config::typeIndex=0;
static char*	trueTypeNames[UFreeType::WEIGHT_COUNT][UFreeType::SLANT_COUNT]=
			{
				{"Medium Roman", "Medium Italic"},
				{"Bold Roman", "Bold Italic"},
			};

char* 		Config::names[Config::CHECKLIST_MAX+1] = { 
		"Encoding", "Input", "XInput", "Font", 
		"Size", "Weight", "Slant",
		"Spacing", "Tab Size", "Background", "Foreground", 
		"Cursor", "Language", 0};

static char*	xInputNames[XInputMap::MAX+1] = {
	"Version", "Input Type", "Input Style", 
	"Encoding", "Font Map", "Text Type", 0 }; 

static char* 	languageMapNames[Language::MAX+1] = {
	"Short Name", 
	"Text Font", "Text Size", "Text Weight", "Text Slant", "Text Spacing",
	"Button Font", "Button Size", "Button Weight", "Button Slant", "Button Spacing", 0};
		

enum LanguageIndex {SHORT_NAME, TEXT_FONT, TEXT_SIZE, 
			TEXT_WEIGHT, TEXT_SLANT, TEXT_SPACING,
			BUTTON_FONT, BUTTON_SIZE, BUTTON_WEIGHT,
			BUTTON_SLANT, BUTTON_SPACING, MAX};

AString		Config::errors[Config::MODE_SIZE];

AStringList	Config::checkList[Config::CHECKLIST_MAX];
AStringList	Config::printerList;
AStringList	Config::printerCommands;

AString         Config::configPath;
AString         Config::configName;
AString         Config::path;

#define SHORT_STRING_SIZE 	256

Config::Config (const char* name) 
{
	if (instances != 0)
	{
		cerr << "warn: config file should be read only once.\n";
	}
	instances++;
	errors[REAL] =0;
	errors[TEST] =0;
	configName = name;
	defaultPrinter = 0;
	readConfig (name);
}

void
Config::readConfig (const char* name, Mode mode)
{
	const char*	item;
	char*		fontGroup;
	char*		inputGroup;
	char*		fontItem;
	char		fontString[SHORT_STRING_SIZE];
	AString		fontUnparsed;
	int		i;
	int		j;
	int		k;
	AString		str2;
	int		mapIndex;
	AString		testStr;
	AStringList	testArray[CHECKLIST_MAX];
	AStringList	xArray;
	int		xInputMissing;
	int		xLanguageMissing;
	int		index;
	AString		currentPrinter;

	FileConfig*	fileConfig;
	TrueTypeFont*	newTTF;
	AString		zeroTTF;

	if (mode==REAL) clear ();
	fileConfig = new FileConfig (name);
	errors[REAL]=0;
	errors[TEST]=0;

	if (!fileConfig->isOpen())
	{
		errors[mode] = "Error: can not find config '";
		errors[mode] += name;
		errors[mode] += "'.";
		delete fileConfig;
		return;
	}
	if (mode==REAL) configPath = (const char*) fileConfig->getConfigPath();
	fileConfig->setGroup ("Default");
	if (fileConfig->readEntry ("Path", (mode==TEST) ? testStr : path) ==0)
	{
		errors[mode] = "Error: config [Default] 'Path' is missing. "; 
		delete fileConfig;
		return;
	}
	if (mode==REAL) path+=USE_PATH;
	xInputMissing=0;
	xLanguageMissing=0;
	for (i=0; (item=names[i])!=0; i++)
	{
		if (fileConfig->readEntry (item, (mode==TEST) ? testStr :  checked[i]) ==0)
		{
			if (strcmp (item, "XInput") == 0)
			{
				xInputMissing=1;
				cerr << "warn: [Default] XInput is missing.\n";
				continue;
			}
			if (strcmp (item, "Language") == 0)
			{
				xLanguageMissing=1;
				cerr << "warn: [Default] Language is missing.\n";
				continue;
			}
			errors[mode] = "Error: config [Default] '";
			errors[mode] += item;
			errors[mode] += "' is missing. ";
			delete fileConfig;
			return;
		}
	}
	
	if (fileConfig->readEntry ("Printer", (mode==TEST) ? testStr : defaultPrinter)==0)
	{
		cerr << "warn: config file does not have [Default] Printer.\n";
	}
	
	fileConfig->setGroup ("Menu Item");
	if (fileConfig->readEntries ("Printer", xArray)==0)
	{
		cerr << "warn: no [Menu Item] 'Printer' in config file.\n";
	}
	else
	{
		for (i=0; i<xArray.getSize(); i++)
		{
			currentPrinter = (const char*) "Printer ";
			currentPrinter += xArray.at(i);
			fileConfig->setGroup ((const char*) currentPrinter);
			if (fileConfig->readEntry ("Command", testStr)!=0)
			{
				if (mode==TEST) continue;
				printerList.add (xArray.at(i));
				currentPrinter = "|";
				currentPrinter += (const char*) testStr;
				printerCommands.add (currentPrinter);
				continue;
			}
			if (fileConfig->readEntry ("File", testStr)!=0)
			{
				if (mode==TEST) continue;
				printerList.add (xArray.at(i));
				currentPrinter = (const char*) testStr;
				printerCommands.add (currentPrinter);
				continue;
			}
			cerr << "warn: Printer " 
				<< (const char*) currentPrinter
				<< " is not found in config file.\n";
		}
	}
	if (mode!=TEST)
	{
		if (defaultPrinter.isNull() && printerList.getSize() > 0)
		{
			defaultPrinter = (const char*) printerList.at(0);
		}
		if (!defaultPrinter.isNull() && printerList.getSize()>0)
		{
			if (getPrinterCommand ((const char*) defaultPrinter) ==0)
			{
				cerr << "warn: default '" 
				    << (const char*) defaultPrinter
				    << "' is not defined in [Printer...].\n";
				defaultPrinter = printerList.at(0);
			}
		}
	}

	fileConfig->setGroup ("Menu Item");
	for (i=0; ; i++)
	{
		item=names[i];
		if (item ==0) break;
		
		if (fileConfig->readEntries (item, 
			(mode==TEST) ? testArray[i] : checkList[i]) ==0)
		{
			if (strcmp (item, "XInput") == 0)
			{
				cerr << "warn: [Menu Item] XInput is missing.\n";
				continue;
			}
			if (strcmp (item, "Language") == 0)
			{
				cerr << "warn: [Menu Item] Language is missing.\n";
				continue;
			}
			
			errors[mode] = "Error: config [Menu Item] '";
			errors[mode] += item;
			errors[mode] += "' is missing. ";
			delete fileConfig;
			return;
		}
		if (strcmp (item, "XInput") == 0 && xInputMissing==1)
		{
			errors[mode] = "Error: config [Default] '";
			errors[mode] += item;
			errors[mode] += "' is missing. ";
			delete fileConfig;
			return;
		}
		if (strcmp (item, "Language") == 0 && xLanguageMissing==1)
		{
			errors[mode] = "Error: config [Default] '";
			errors[mode] += item;
			errors[mode] += "' is missing. ";
			delete fileConfig;
			return;
		}
	}
	// go through fonts and get them into fontMaps
	if (mode!=TEST)
	{
		trueTypeFont = new TrueTypeFont*[checkList[FONTNAME].getSize()];
		CHECKNULL (trueTypeFont); 
		memset (trueTypeFont, 0, checkList[FONTNAME].getSize() * sizeof (TrueTypeFont*));
	}

	trueTypeFontArraySize = (mode==TEST) ? testArray[FONTNAME].getSize() 
		: checkList[FONTNAME].getSize();

	if (typeIndex!=0) delete typeIndex;
	typeIndex = new char[trueTypeFontArraySize];
	CHECKNULL (typeIndex);
	memset (typeIndex, 0, trueTypeFontArraySize);

	// Try to load it as "Font TrueType"
	for (i=0, index=0; i<((mode==TEST) ? 
	   testArray[FONTNAME].getSize() : checkList[FONTNAME].getSize()); 
	   i++)
	{
		item = (mode==TEST) ? testArray[FONTNAME].at(i) 
			: checkList[FONTNAME].at(i);
		fontGroup = new char[strlen (item) + strlen ("Font TrueType ") + 1];
		CHECKNULL (fontGroup);
		strcpy (fontGroup, "Font TrueType ");
		strcat (fontGroup, item);
		// in case...
		errors[mode] = "Error: config [";
		errors[mode] += fontGroup;
		errors[mode] += "] is wrong.";
		fileConfig->setGroup (fontGroup);
		zeroTTF = (const char*) 0;
		for (j=0; j<UFreeType::WEIGHT_COUNT; j++)
		{
		 for (k=0; k<UFreeType::SLANT_COUNT; k++)
		 {
			if (fileConfig->readEntry (trueTypeNames[j][k], str2)
				==0)
			{
				continue;
			}
			if (zeroTTF.isNull()) zeroTTF = (const char*) str2;
			if (mode != TEST)
			{
				newTTF = trueTypeFont[index];
				if (newTTF==0)
				{
					newTTF = new TrueTypeFont(item);
					trueTypeFont[index] = newTTF;
					CHECKNULL (trueTypeFont[index]);
				}
				trueTypeFont[index]->fontFile[j][k] 
						= (const char*) str2;

			}
		 }
		}
		if (mode != TEST && !zeroTTF.isNull())
		{
			// Check for missing items.
			for (j=0; j<UFreeType::WEIGHT_COUNT; j++)
			 for (k=0; k<UFreeType::SLANT_COUNT; k++)
			{
				if (trueTypeFont[index]->fontFile[j][k].isNull())
				{
#if 0
					cerr << "warn: fontgroup '" << fontGroup
					 << "' does not have '" 
					 << trueTypeNames[j][k] << "' font.\n";
					cerr << "      using '" 
					 << (const char*) zeroTTF << "'.\n";
#endif
					trueTypeFont[index]->fontFile[j][k]
						= (const char*) zeroTTF;
				}
			}
		}
		delete fontGroup;
		if (!zeroTTF.isNull())
		{
			typeIndex[i] = 1;
			index++;
		}
	}
	
	if (mode!=TEST)
	{
		trueTypeFontSize = index;
		fontMap = new FontMap *[checkList[FONTNAME].getSize()-index];
		CHECKNULL (fontMap); 
		fontMapArraySize = checkList[FONTNAME].getSize()-index;
	}
	for (i=0, index=0; i<((mode==TEST) ? 
	   testArray[FONTNAME].getSize() : checkList[FONTNAME].getSize()); 
	   i++)
	{
		item = (mode==TEST) ? testArray[FONTNAME].at(i) 
			: checkList[FONTNAME].at(i);

		// if we already have it as TrueType font skip
		if (typeIndex[i]!=0) continue;


		fontGroup = new char[strlen (item) + strlen ("Font Map ") + 1];
		CHECKNULL (fontGroup);
		strcpy (fontGroup, "Font Map ");
		strcat (fontGroup, item);
		// in case...
		errors[mode] = "Error: config [";
		errors[mode] += fontGroup;
		errors[mode] += "] is missing or wrong.";
		fileConfig->setGroup (fontGroup);
		delete fontGroup;

		if (fileConfig->readEntry ("Font Count", str2)==0
			|| str2.toInt() <= 0)
		{
			errors[mode] += "\n\nMissing Entry: Font Count\n";
			errors[mode] += "Font not found in 'Font TrueType' either.";
			delete fileConfig;
			return;
		}
		if (mode != TEST)
		{
			fontMap[index] = new FontMap (item);
			CHECKNULL (fontMap[index]);
		}
		for (j=0; j<str2.toInt(); j++)
		{
			sprintf (fontString, "Font%d", j+1);
			if (fileConfig->readEntry (fontString, fontUnparsed)==0)
			{
				errors[mode] += "\n\nMissing Entry: ";
				errors[mode] += fontString;
				delete fileConfig;
				return;
			}
			for (item=(const char*) fontUnparsed, k=0; 
				item[k] != 0; k++)
			{
				if (item[k] == ':')
				{
					memcpy (fontString, item, k);
					fontString[k] = 0;
					if (mode==TEST) break;
					fontMap[index]->list[FontMap::UMAP].add (fontString);
					break;
				}
			}
			for (mapIndex=1; mapIndex < FontMap::MAX; mapIndex++)
			{
				if (k==0 || item[k]==0 || item[k+1] == 0) 
				{
					delete fileConfig;
					return;
				}
				item=&item[++k];
				for (k = 0; ; k++)
				{
					if (item[k] == '-' || item[k] == 0)
					{
						if (k==0) 
						{
							delete fileConfig;
							return;
						}
						memcpy (fontString, item, k);
						fontString[k] = 0;
						if (mode==TEST) break;
						fontMap[index]->list[mapIndex].add (fontString);
						break;
					}
				}
				if (item[k] == 0)
				{
					mapIndex++;
					break;
				}
			}
			if (mapIndex < FontMap::MAX)
			{
				errors[mode] += "\n\nnIncomplete Entry: ";
				errors[mode] += fontUnparsed;
				delete fileConfig;
				return;
			}
			if (mode != TEST) fontMap[index]->size++;
		}
		if (mode!=TEST) fontMapSize++;
		index++;
	}
	// go through XInputs and get them into xInputMap
	if (mode!=TEST && checkList[XINPUT].getSize() > 0)
	{
		xInputMap = new XInputMap *[checkList[XINPUT].getSize()];
		CHECKNULL (xInputMap); 
	}
	// Language
	if (mode!=TEST && checkList[LANGUAGE].getSize() > 0)
	{
		languageMap = new Language *[checkList[LANGUAGE].getSize()];
		CHECKNULL (languageMap); 
	}
	for (i=0; i<((mode==TEST) ? 
	   testArray[XINPUT].getSize() : checkList[XINPUT].getSize()); i++)
	{
		item = (mode==TEST) ? testArray[XINPUT].at(i) 
			: checkList[XINPUT].at(i);

		inputGroup = new char[strlen (item) + strlen ("XInput ") + 1];
		CHECKNULL (inputGroup);
		strcpy (inputGroup, "XInput ");
		strcat (inputGroup, item);
		// in case...
		errors[mode] = "Error: config [";
		errors[mode] += inputGroup;
		errors[mode] += "] is missing or wrong.";
		fileConfig->setGroup (inputGroup);
		delete inputGroup;

		if (mode != TEST)
		{
			xInputMap[i] = new XInputMap (item);
			CHECKNULL (xInputMap[i]);
		}

		// Read Atrributes
		for (j=0; j<XInputMap::MAX; j++)
		{
			if (fileConfig->readEntry (xInputNames[j], str2)==0)
			{
				errors[mode] += "\n\nMissing Entry: ";
				errors[mode] += xInputNames[j];
				delete fileConfig;
				return;
			}
			if (mode != TEST)
			{
				xInputMap[i]->list[j] = (const char*) str2;
				xInputMapSize++;
			}
		}
	}
	//
	// Load the languages 
	//
	for (i=0; i<((mode==TEST) ? 
	   testArray[LANGUAGE].getSize() : checkList[LANGUAGE].getSize()); i++)
	{
		item = (mode==TEST) ? testArray[LANGUAGE].at(i) 
			: checkList[LANGUAGE].at(i);

		inputGroup = new char[strlen (item) + strlen ("Language ") + 1];
		CHECKNULL (inputGroup);
		strcpy (inputGroup, "Language ");
		strcat (inputGroup, item);
		// in case...
		errors[mode] = "Error: config [";
		errors[mode] += inputGroup;
		errors[mode] += "] is missing or wrong.";
		fileConfig->setGroup (inputGroup);
		delete inputGroup;

		if (mode != TEST)
		{
			languageMap[i] = new Language (item);
			CHECKNULL (languageMap[i]);
		}

		// Read Atrributes
		for (j=0; j<Language::MAX; j++)
		{
			if (fileConfig->readEntry (languageMapNames[j], 
				str2)==0)
			{
				errors[mode] += "\n\nMissing Entry: ";
				errors[mode] += languageMapNames[j];
				delete fileConfig;
				return;
			}
			if (mode != TEST)
			{
				languageMap[i]->list[j] = (const char*) str2;
				languageMapSize++;
			}
		}
	}
	errors[mode] = 0;
	delete fileConfig;
//	cerr << "info: printer is '" << (const char*) defaultPrinter << "'\n";
	return;
}
//
// Make a copy of the current configuration
//
Config::Config (const Config& configIn)
{
	int	i;
	instances++;
	for (i=0; i<CHECKLIST_MAX; i++)
	{
		checked[i] = (const char*) configIn.checked[i];
	}
	defaultPrinter = configIn.getPrinter();
}

Config::~Config ()
{
	instances--;
	if (instances==0)
	{
		lConfig = 0;
		clear ();
	}
}

void
Config::clear ()
{
	int	i;
	for (i=0; i<fontMapSize; i++)
	{
		delete fontMap[i];
	}
	if (fontMap!=0) delete fontMap;
	fontMapSize=0;
	fontMap = 0;
}



const AStringList&
Config::getCheckList (const CheckList index) const
{
	return checkList[index];
}

const AString&
Config::getChecked (const CheckList index) const
{
	return checked [index];
}

const char*
Config::getPrinterCommand (const char* printerIn) const
{
	int	i;
	for (i=0;i<printerList.getSize(); i++)
	{
		if (strcmp (printerList.at (i), printerIn)==0)
		{
			return printerCommands.at (i);
		}
	}
	return 0;
}

int
Config::setChecked (const CheckList index, const char* value)
{
	checked[index] = value;
	return 0;
}

const FontMap*
Config::getFontMap(const char* name) const
{ 
	int	index;

	index = getFontMapIndex (name);
	if (index < 0) return 0;
	return fontMap[index]; 
}

const TrueTypeFont*
Config::getTrueTypeFont(const char* name) const
{ 
	int	index;

	index = getTrueTypeFontIndex (name);
	if (index < 0) return 0;
	return trueTypeFont[index]; 
}

const int
Config::getFontMapIndex (const char* name) const
{
	int		i;

	if (name == 0) return -1;

	for (i=0; i<fontMapSize; i++)
	{
		if (strcmp (name, (const char*) fontMap[i]->name)==0) return i;
	}
	return -1;
}

const int
Config::getTrueTypeFontIndex (const char* name) const
{
	int		i;

	if (name == 0) return -1;

	for (i=0; i<trueTypeFontSize; i++)
	{
		if (strcmp (name, (const char*) trueTypeFont[i]->name)==0) return i;
	}
	return -1;
}

const XInputMap*
Config::getXInputMap(const char* name) const
{ 
	int	index;

	index = getXInputMapIndex (name);
	if (index < 0) return 0;
	return xInputMap[index]; 
}

const Language*
Config::getLanguage(const char* name) const
{ 
	int	i;

	i = getLanguageMapIndex (name);
	if (i < 0) return 0;
	return languageMap[i]; 
}

const int
Config::getLanguageMapIndex (const char* name) const
{
	int		i;

	if (name == 0) return -1;

	for (i=0; i<languageMapSize; i++)
	{
		if (strcmp (name, (const char*) languageMap[i]->name)==0) return i;
	}
	return -1;
}

const int
Config::getXInputMapIndex (const char* name) const
{
	int		i;

	if (name == 0) return -1;

	for (i=0; i<xInputMapSize; i++)
	{
		if (strcmp (name, (const char*) xInputMap[i]->name)==0) return i;
	}
	return -1;
}

const AStringList&
Config::getPrinterList () const
{
	return printerList; 
}
const char *
Config::getPrinter() const
{
	const char * retvle;
	retvle = (const char*) defaultPrinter;
	 return retvle;
}

void
Config::setPrinter (const char* printerIn)
{
	defaultPrinter=printerIn; 
}

int
Config::copySysConfig (const char *name)
{
	ifstream*	ifile;
	ofstream*	ofile;
	char		charD;
	int		count;
	AString		home;
	AString		data;

	errors[REAL] = 0;
	home = (const char*) getenv ("HOME");
	if (home.isNull())
	{
		errors[REAL] += "HOME environment variable is not set.";
		return -1;
	}
	home += "/.";
	home += name;
	data = CONFIG_DIR;
	data += "/";
	data += name;
	ifile = new ifstream ((const char*) data);
#ifdef gnu_iostream 
	if (!ifile->is_open())
#else 
	if (ifile->rdbuf() == 0 || !ifile->rdbuf()->is_open())
#endif
	{
		errors[REAL] = "Can not find system config: '";
		errors[REAL] += data;
		errors[REAL] += "'.";
		return -1;
	}
	ofile = new ofstream ((const char*) home);
#ifdef gnu_iostream 
	if (!ofile->is_open())
#else 
	if (ofile->rdbuf() == 0 || !ofile->rdbuf()->is_open())
#endif
	{
		errors[REAL] = "Can not write : '";
		errors[REAL] += home;
		errors[REAL] += "'.";
		return -1;
	}
	count = 0;
	while (ifile->get (charD))
	{
		if (!ofile->put (charD))
		{
			errors[REAL] = "Write failed: '";
			errors[REAL] += home;
			errors[REAL] += "'.";
			count = -1;
		}
	}
	delete ofile;
	delete ifile;
	return count;
}

FontMap::FontMap (const char* nameIn)
{
	size = 0;
	name = nameIn;
}

TrueTypeFont::TrueTypeFont (const char* nameIn)
{
	name = nameIn;
}

TrueTypeFont::~TrueTypeFont ()
{
}

FontMap::~FontMap ()
{
}

XInputMap::XInputMap (const char* nameIn)
{
	name = nameIn;
}

XInputMap::~XInputMap ()
{
}

Language::Language (const char* nameIn)
{
	name = nameIn;
}

Language::~Language ()
{
}
