//  Main.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#include <iostream.h>
#include <stdlib.h>

#include <UTop.h>
#include <Translate.h>
#include <Config.h>
#include <MainWidget.h>
#include <Yudit.h>
#include <UTextLabel.h>
#include <UTextButton.h>
#include <UTextDialog.h>

UTop		topLevel;
UFont*		defaultFont=0;
UFontMap*	defaultFontMap=0;

static Config*  lConfig;

static void info (const char* text, char* lang_=0);
static void warn (const char* text, char* lang_=0);

#ifdef __sun__
#ifndef __svr4__
extern "C" {
int getopt(int argc, char* const* argv, const char* optstring);
extern int optind;
extern char *optarg;
}
#endif
#else
#include <unistd.h>
#endif


int
main (int argc, char* argv[])
{
	MainWidget		*widget;
	int			i;
	int			j;
	int			k;
	const FontMap*		fontMap;
	const TrueTypeFont*	trueTypeFont;
	const char*		umap;
	const char*		foundry;
	const char*		family;
	const char*		registry;
	const char*		encoding;
	UFreeType*		xFreeType;
	const char*		xFileName;

	char*			xEncoding;
	int			option;

	AString			domainD;
	Config			mainConfig ("yuditrc");
	
	lConfig = &mainConfig;

	// It may dump if I miss it.
	//putenv ("LANG=");

	xEncoding = 0;
	while ((option=getopt (argc, argv, "e:")) != -1)
	{
		switch (option)
		{
		case 'e':
			xEncoding = optarg;
			break;
		default:
			cerr << "usage: yudit [-e encoding] [file1 [file2 ...]]\n";
			exit (1);
		}
	}

	if (topLevel.display == 0)
	{
		cerr << "error: can not open display.\n";
		exit (1);
	}


	// Now there is a chance that we can display something right.
	domainD = LOCALE_DIR;
	InitTranslate ("messages", (const char*) domainD);

	// add some fontmaps because we will have some english messages...
	foundry = "*";
	family = "*";
	registry = "iso8859";
	encoding = "1";
	umap = "8859_1";

	UAddFontMap ("//Default", foundry, family, registry, encoding, umap);
	defaultFontMap = UGetFontMap ("//Default");

	if (defaultFontMap==0)
	{
		cerr << "error: oops in main.\n";
		exit (1);
	}
		
	defaultFont = new UFontX11 (defaultFontMap, topLevel.display, 
		topLevel.screen);
	defaultFont->setPixel (16);

	// Now we can display something at leat in English..
	if (mainConfig.getConfigPath().isNull())
	{

		info (Translate ("Copying system config file."));

		mainConfig.copySysConfig("yuditrc");
		if (mainConfig.getErrors () != 0)
		{
			warn (mainConfig.getErrors ());
			exit (1);
		}
		mainConfig.readConfig ("yuditrc");
	}


	if (mainConfig.getErrors () != 0)
	{
		warn (mainConfig.getErrors());
		exit (0);
	}

	USetMapPath ((const char*) mainConfig.getPath ());
	//
	// Load the fontMaps
	//
	for (i=0; i<mainConfig.getCheckList (Config::FONTNAME).getSize(); i++)
	{
		fontMap = mainConfig.getFontMap (
			mainConfig.getCheckList (Config::FONTNAME).at(i));
		if (fontMap!=0) for (j=0; j<fontMap->size; j++)
		{
			foundry = fontMap->list[FontMap::FOUNDRY].at (j);
			family = fontMap->list[FontMap::FAMILY].at (j);
			registry = fontMap->list[FontMap::REGISTRY].at (j);
			encoding = fontMap->list[FontMap::ENCODING].at (j);
			umap = fontMap->list[FontMap::UMAP].at (j);
			
			UAddFontMap ((const char*) fontMap->name,
				foundry, family, registry, encoding, umap);
		}
		if (fontMap==0)
		{
			// It is checked in config load.
			trueTypeFont = mainConfig.getTrueTypeFont(
				mainConfig.getCheckList (Config::FONTNAME).at(i));
			if (trueTypeFont!=0)
			{
				UAddFreeType ((const char*)trueTypeFont->name);
				xFreeType = UGetFreeTypePrint (
					(const char*) trueTypeFont->name);
				if (xFreeType==0)
				{
					cerr << "error: count not add TrueType font '" 
					<< (const char*)trueTypeFont->name
					<< "'.\n";
					continue;
				}
				for (j=0; j<UFreeType::WEIGHT_COUNT; j++)
				{
				 for (k=0; k<UFreeType::SLANT_COUNT; k++)
				 {
					xFileName = (const char*)trueTypeFont->fontFile[j][k];
					xFreeType->setFontFile (
						xFileName,
						(UFreeType::UWeight) j,
						(UFreeType::USlant) k);
				 }
				}
			}
		}
	}


	widget = 0;

	for (i=optind; i<argc; i++)
	{
		widget = new MainWidget (mainConfig, argv[i], xEncoding);
		widget->show ();
	}

	if (widget==0)
	{
		if (xEncoding != 0)
		{
			mainConfig.setChecked (Config::ENCODING, xEncoding);
		}
		widget = new MainWidget (mainConfig,  0);
		widget->show ();
	}
	topLevel.eventLoop ();
	exit (0);
}

UTop*
GetTopLevel()
{
	return (&topLevel);
}

Config*
GetMainConfig()
{
	return (lConfig);
}

UFont*
GetDefaultFont()
{
	return (defaultFont);
}

static void
info (const char* text, char* lang_)
{
	UTextDialog*	dialog;
	if (lang_)
	{
		TranslateLocale (lang_);
	}
	dialog = new UTextDialog (&topLevel, UTextDialog::BCANCEL);
	dialog->setButtonFont (GetDefaultFont());
	dialog->setButtonText (UTextDialog::BCANCEL, Translate ("DISMISS"));

	dialog->setTextFont (GetDefaultFont());
	dialog->setText (text);
	dialog->setTitle (Translate ("Yudit: information"));
	dialog->getValue();
	delete dialog;
}

static void
warn (const char* text, char* lang_)
{
	UTextDialog*	dialog;
	if (lang_)
	{
		TranslateLocale (lang_);
	}
	dialog = new UTextDialog (&topLevel, UTextDialog::BCANCEL);
	dialog->setButtonFont (GetDefaultFont());
	dialog->setButtonText (UTextDialog::BCANCEL, Translate ("DISMISS"));

	dialog->setTextFont (GetDefaultFont());
	dialog->setText (text);
	dialog->setTitle (Translate ("Yudit: error"));
	dialog->getValue();
	delete dialog;
}
