//  UCommon.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
//
//

#ifndef __ucommon_h__
#define __ucommon_h__

// This is only for function exit()
#include <stdlib.h>
#include <iostream.h>

typedef unsigned short UCS2;
#define FONTCACHE_SIZE		128

const char* UGetMapPath ();
void  USetMapPath (const char* newPath);

const char* UWidgetVersion ();

void UInitUString();
void UDeinitUString();
void UTuneUString (int cacheSize=0, int batchSize=0);

void UInitUMap();
void UDeinitUMap();
void UTuneUMap (int cacheSize=0, int batchSize=0);

void UDeinitFontX11 ();
void UTuneFontX11 (int cacheSize=FONTCACHE_SIZE, int batchSize=0);

void UDeinitFontFreeType ();
void UTuneFontFreeType (int cacheSize=FONTCACHE_SIZE, int batchSize=0);

int UCS2Len (const UCS2* text, int* tabCount=0);
int UStrLen (const unsigned char* dchar);

// Free up ret yourself if not null. Term is '\n'
int USplit (UCS2* text, UCS2*** ret);

// get buffer
unsigned char* UReadBuffer (istream* is);

// negative on failure
int UWriteBuffer (ostream* os, const unsigned char *buffer);

UCS2* UCS2Dup (const UCS2* text, const int extraLen=0);
UCS2* UCS2Concat (const UCS2* text1, const UCS2* text2);
UCS2* UCS2Get (const unsigned char* in, int extraLen=0);


char* UFindFile (const char* path, const char *name);



#ifndef CHECKNULL
#define CHECKNULL(p) \
if (p==0) cerr << "error: not enough memory.\n";  if (p==0) exit(1)
#endif /* CHECKNULL */


#endif /* __ucommon_h__ */
