#include "xev.h"
#include "enemy.h"

PRIVATE Pixmap pixmap[4],pixmap_mask[4];
PRIVATE GC gc[4];

PRIVATE char *fn[] = {
      "grobd1.img",
      "grobd2.img",
      "grobd3.img",
      "grobd4.img"
};

void GrobdSetChar()
{
      int c_no;
      char img[CSIZE*CSIZE] , mask[128];
      
      XGCValues gcv;

      gcv.graphics_exposures = False;

      for(c_no = 0 ; c_no < 4 ; c_no++) {
            int x,y;
            
            sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no]);
            LoadChar(tpath,img , sizeof(img));

            pixmap[c_no] = XCreatePixmap(d,w,CSIZE,CSIZE,depth);
	    gc[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);

            bzero(mask , sizeof(mask));
            
            for(y = 0 ; y < CSIZE ; y++)
              for(x = 0 ; x < CSIZE ; x++) {
                    if(img[y*CSIZE+x] != 100) {
                          mask[y*4+x/8] |= (1<< (x%8));
                          XSetForeground(d,gc[c_no],
                                         pixel[img[y*CSIZE+x]]);
                          XDrawPoint(d,pixmap[c_no],gc[c_no],x,y);
                    }
              }
	    pixmap_mask[c_no] 
	      = XCreateBitmapFromData(d,w,mask,CSIZE,CSIZE);
            XSetClipMask(d,gc[c_no],pixmap_mask[c_no]);
      }
      
}

void GrobdFree()
{
      int i;
      
      for(i = 0 ; i > 4 ; i++) {
            XFreePixmap(d,pixmap[i]);
            XFreePixmap(d,pixmap_mask[i]);
	    XFreeGC(d,gc[i]);
      }
}

int Grobd(enemy_no)
     int enemy_no;
{
      int sx,sy;
      int gvy[2][GROBDDS+1] = {
	    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	    {0,0,0,0,0,0,0,2,0,2,2,2,2,2,2,2,-1,4}
      };
      int ganim[2][GROBDDS+1] = {
	    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	    {0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1}
      };
      int g_score[GROBDDS+1] = {
	    0,0,0,0,0,0,0,500,200,0,0,0,0,0,0,0,100,10000};

      
      sx = enemy_chijou[enemy_no].x.sht[UNION];
      sy = enemy_chijou[enemy_no].y.sht[UNION];
      
      enemy_chijou[enemy_no].y.dummy += enemy_chijou[enemy_no].vy;
      enemy_chijou[enemy_no].y.dummy 
	+= gvy[enemy_chijou[enemy_no].tmp2][enemy_chijou[enemy_no].enemy_no]*32768;

      SetSprite(sx,sy,pixmap[enemy_chijou[enemy_no].tmp1],
		gc[enemy_chijou[enemy_no].tmp1],
		CSIZE,CSIZE);

      enemy_chijou[enemy_no].tmp1 
	+= ganim[enemy_chijou[enemy_no].tmp2][enemy_chijou[enemy_no].enemy_no];
      enemy_chijou[enemy_no].tmp1 &= 3;

      if(sy > YSIZE) {
            enemy_chijou[enemy_no].enemy_no = 0;
      }
      if((jx.sht[UNION] - sx) > -20 &&
         (jx.sht[UNION] - sx) < 20 &&
         (jy.sht[UNION] - sy) > 192 &&
         (jy.sht[UNION] - sy) < 224) {
	    shojun_flag = 1;
	    enemy_chijou[enemy_no].tmp2 = 1;
      }

      if(shot_chi.z == 1) {
	    if((shot_chi.x.sht[UNION] - sx) > -10 &&
	       (shot_chi.x.sht[UNION] - sx) < 32 &&
	       (shot_chi.y.sht[UNION] - sy) > -10 &&
	       (shot_chi.y.sht[UNION] - sy) < 42) {
		  score += g_score[enemy_chijou[enemy_no].enemy_no];
		  BombCInit(enemy_no);
		  return 1;
	    }
      }else
        return 0;
}


