/*
 * Programm XBLAST V2.5.6 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * April 5th, 1997
 * started August 1993
 *
 * File: util.h
 * header file for util.h
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _UTIL_H
#define _UTIL_H

#include <stdio.h>

/*
 * generic file structure, suitable for files and pipes 
 */
typedef struct {
  FILE *fp;             /* file pointer */
#ifdef __STDC__
  int (*close)(FILE *); /* close function */
#else
  int (*close)();
#endif
} XBFile;

/*
 * function prototypes
 */
#ifdef _UTIL_C
#define _EXTERN
#else
#define _EXTERN extern
#endif

#ifdef __STDC__
_EXTERN int random_number (int max_val);
_EXTERN void seed_random (unsigned seed);
_EXTERN unsigned get_random_seed (void);
_EXTERN XBFile *open_file (char *path, char *name, char *ext);
_EXTERN unsigned char *read_pbm_file (char *path, char *file, int *width, 
				      int *height);
_EXTERN unsigned char *read_ppm_file (char *path, char *file, int *width, 
				      int *height);
_EXTERN unsigned char *read_epm_file (char *path, char *file, int *width, 
				      int *height, int  *depth);
#else
_EXTERN int random_number ();
_EXTERN void seed_random ();
_EXTERN unsigned get_random_seed ();
_EXTERN XBFile *open_file ();
_EXTERN unsigned char *read_pbm_file ();
_EXTERN unsigned char *read_ppm_file ();
_EXTERN unsigned char *read_epm_file ();
#endif

/*
 * macros
 */
#define close_file(a) a->close(a->fp)

#endif
/*
 * end of file util.h
 */
