/*
 * XSOLDIER, a video-oriented game
 * Copyright (C) 1997, Yuusuke HASHIMOTO
 *                     s945750@educ.info.kanagawa-u.ac.jp
 *
 * ܥץˤ copyleft ŬѤƤޤCONDITION ե򻲾Ȥ
 * Ƥ
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include "image.h"
#include "xsoldier.h"

#include "extern.h"

int ReadHiscore(PlayerData *p)
{
    FILE *fp;
    char buff[256];

    char name[32];
    int score;
    int loop;
    int stage;

    int rank = -1;
    int del = 10;
    int i;

    if ((fp=fopen(SCORE "/" SCOREFILE,"r")) == NULL)
    {
	int m;
	fprintf(stderr,"ReadHiscore: can not open score file\n");
	for (m=1; m<=10; m++)
	{/*** 顼Υ ***/
	    p->Rec[m].score = (11-m)*10000;
	    p->Rec[m].loop  = (11-m)/3;
	    p->Rec[m].stage = random()%8 + 1;
	    sprintf(p->Rec[m].name,"NoName");
	}
    }
    else
    {
	for (i=1; (fgets(buff,256,fp)!=NULL)&&i<=10; i++)
	{
	    sscanf(buff,"%d %d %d %s",&score,&loop,&stage,name);
	    p->Rec[i].score = score;
	    p->Rec[i].loop  = loop;
	    p->Rec[i].stage = stage;
	    strcpy(p->Rec[i].name,name);
	}
	fclose(fp);
    }

#ifndef DUPSCORE
    for (i=1; i<=10; i++)
    {/*** Ʊ̾ץ쥤䡼ϰĤ ***/
	if (strcmp(p->Rec[0].name,p->Rec[i].name) == 0)
	{
	    del = i;
	    break;
	}
    }
#endif

    for (i=1; i<=10; i++)
    {
	if (p->Rec[0].score > p->Rec[i].score)
	{
	    rank = i;
	    break;
	}
    }

    if (rank == -1 || rank > del)
    {
	return -1; /*** ⤷Ʊ̤̾ˤ ***/
    }
    else
    {
	for (i=del; i>rank; i--)
	{
#ifdef DEBUG
	    printf("rank[%d] <- rank[%d]\n",i,i-1);
#endif
	    p->Rec[i].score = p->Rec[i-1].score;
	    p->Rec[i].loop  = p->Rec[i-1].loop;
	    p->Rec[i].stage = p->Rec[i-1].stage;
	    strcpy(p->Rec[i].name,p->Rec[i-1].name);
	}
#ifdef DEBUG	
	printf("rank[%d] <- rank[0]\n",rank);
#endif
	p->Rec[rank].score = p->Rec[0].score;
	p->Rec[rank].loop  = p->Rec[0].loop;
	p->Rec[rank].stage = p->Rec[0].stage;
	strcpy(p->Rec[rank].name,p->Rec[0].name);

	return rank;
    }
}

void WriteHiscore(PlayerData *p)
{
    FILE *fp;
    char buff[256];
    int i;

    if ((fp=fopen(SCORE "/" SCOREFILE,"w")) == NULL)
    {
	fprintf(stderr,"WriteHiscore: can not open score file\n");
	return;
    }

    for (i=1; i<=10; i++)
    {
        sprintf(buff,"%d %d %d %s\n",p->Rec[i].score,p->Rec[i].loop,
		p->Rec[i].stage,p->Rec[i].name);
        fputs(buff,fp);
    }
    /*** Rec+1  Rec[1]-Rec[10]쥳ɳǼ ***/
    /*** Rec[0] ϻȤʤ ***/
    fclose(fp);
}
