/*****************             Electirc Eyes           ***********************/
/* This software is Copyright (C) 1998 but The Rasterman (Carsten Haitzler). */
/* This software falls under the GNU Public License. Please read the COPYING */
/* file for more information                                                 */
/*****************************************************************************/
#include "ee.h"

static error_t      parse(int key, char *arg, struct argp_state *state);

static gchar        set_root_and_quit = 0;
static gchar       *current_dir;
static gchar      **start_img_list = NULL;
static gint         start_img_list_num = 0;
static struct argp_option options[] =
{
    {"root", 'r', NULL, 0, N_("Set root window image and leave"), 0},
    {NULL, 0, NULL, 0, NULL, 0}
};
static struct argp  parser =
{
  options, parse,
  N_("[FILE ...]"),
  NULL, NULL, NULL, NULL
};

static GtkWidget   *drag = NULL, *drag_ok = NULL;

static              error_t
parse(int key, char *arg, struct argp_state *state)
{
  char               *s;
  
  switch (key)
    {
     case ARGP_KEY_ARG:
      if (*arg != '/')
        s = g_copy_strings(current_dir, "/", arg, NULL);
      else
        s = g_strdup(arg);
      start_img_list_num++;
      start_img_list = (gchar **)
        g_realloc(start_img_list, start_img_list_num * sizeof(gchar *));
      start_img_list[start_img_list_num - 1] = s;
      return 0;
      
     case 'r':
      set_root_and_quit = 1;
      return 0;
      
     default:
      return ARGP_ERR_UNKNOWN;
    }
  state = NULL;
}

static void
filenames_dropped(GtkWidget * widget, GdkEventDropDataAvailable * event)
{
  char               *p = event->data;
  GdkImlibImage *im;  

  im = gdk_imlib_load_image(p);
  if (im) 
    {
      ee_image_set_filename(image_display, p);
      ee_image_set_image(image_display, im);
      ee_list_add_filename(image_list, p); 
    }
  widget = NULL;
}

void
configure_drop_on_widget(GtkWidget * widget, GdkWindow * window)
{
  static char        *drop_types[] =
    {
      "url:ALL"
    };
  
  gdk_window_dnd_drop_set(window, TRUE, drop_types, 1, FALSE);
  gtk_signal_connect(GTK_OBJECT(widget), "drop_data_available_event",
		       GTK_SIGNAL_FUNC(filenames_dropped), NULL);
}

static void
gdk_dnd_drag_begin(GdkWindow * initial_window)
{
  GdkEventDragBegin   tev;
  
  tev.type = GDK_DRAG_BEGIN;
  tev.window = initial_window;
  tev.u.allflags = 0;
  tev.u.flags.protocol_version = DND_PROTOCOL_VERSION;
  
  gdk_event_put((GdkEvent *) & tev);
}

void
drag_begin(GtkWidget * widget, GdkEvent * event)
{
  GdkPoint            hotspot =
    {15, 15};
  
  if (drag && drag_ok)
    {
      gdk_dnd_set_drag_shape(drag->window, &hotspot,
			     drag_ok->window, &hotspot);
      gtk_widget_show(drag);
      gtk_widget_show(drag_ok);
    }
}

void
artificial_drag_start(GdkWindow * window, int x, int y)
{
  GdkWindowPrivate   *wp = (GdkWindowPrivate *) window;
  
  if (!wp->dnd_drag_enabled)
    return;
  if (!gdk_dnd.drag_perhaps)
    return;
  if (gdk_dnd.dnd_grabbed)
    return;
  if (gdk_dnd.drag_really)
    return;
  gdk_dnd_drag_addwindow(window);
  gdk_dnd_drag_begin(window);
  XGrabPointer(gdk_display, wp->xwindow, False,
	       ButtonMotionMask | ButtonPressMask | ButtonReleaseMask,
	       GrabModeAsync, GrabModeAsync, gdk_root_window,
	       None, CurrentTime);
  gdk_dnd.dnd_grabbed = TRUE;
  gdk_dnd.drag_really = 1;
  gdk_dnd_display_drag_cursor(x, y, FALSE, TRUE);
}

static void
window_motion_notify(void *unused, GdkEventMotion * event, GdkWindow * win)
{
  artificial_drag_start(win, event->x, event->y);
}

static void
window_drag_request(GtkWidget * widget, GdkEventDragRequest * event, GdkWindow * win)
{
  gchar *file;

  file = ee_image_get_filename(image_display);
  gdk_window_dnd_data_set(win, (GdkEvent *) event, file, strlen(file) + 1);
}

void
configure_drag_on_widget(GtkWidget * widget, GdkWindow * win)
{
  char               *drag_types[] =
    {"url:ALL"};
  
  gdk_window_dnd_drag_set(win, TRUE, drag_types, 1);  
  /* To simulate drags as soon as the user moves the mouse */
  gtk_signal_connect(GTK_OBJECT(widget), "motion_notify_event",
		     GTK_SIGNAL_FUNC(window_motion_notify), win);  
  /* To transfer the file name */
  gtk_signal_connect(GTK_OBJECT(widget), "drag_request_event",
		     GTK_SIGNAL_FUNC(window_drag_request), win);  
  /* To set the nice drag icons */
  gtk_signal_connect(GTK_OBJECT(widget), "drag_begin_event",
		     GTK_SIGNAL_FUNC(drag_begin), NULL);
}

int
main(int argc, char **argv)
{
  gint i;
  GdkImlibImage *im;
  GtkWidget *a;
  
  bindtextdomain(PACKAGE, GNOMELOCALEDIR);
  textdomain(PACKAGE);

  current_dir = cwd();
  gnome_init("ElectricEyes", &parser, argc, argv, 0, NULL);
  gdk_imlib_init();
  gtk_widget_push_visual(gdk_imlib_get_visual());
  gtk_widget_push_colormap(gdk_imlib_get_colormap());
  drag = gnome_stock_transparent_window(GNOME_STOCK_PIXMAP_NOT, NULL);
  drag_ok = gnome_stock_transparent_window(GNOME_STOCK_PIXMAP_NEW, NULL);
  ee_conf_load();
  
  ee_thumb_init_dirs();
  
  main_menu = ee_menu_new();
  
  image_display = ee_image_new();  
  image_list = ee_list_new();
  ee_list_freeze(image_list);
  if (start_img_list_num > 0)
    {
      im = gdk_imlib_load_image(start_img_list[0]);
      ee_image_set_image(image_display, im);
      ee_image_set_filename(image_display, g_strdup(start_img_list[0]));
       for (i = 0; i < start_img_list_num; i++)
        {
          ee_list_add_filename(image_list, start_img_list[i]);
          g_free(start_img_list[i]);
        }
      g_free(start_img_list);
    }
  else
    ee_image_set_image(image_display, NULL);
  ee_list_thaw(image_list);
  
  ee_image_set_popup_menu(image_display, main_menu);
  
  while (gtk_events_pending())
    gtk_main_iteration();

  if (start_img_list_num > 1)
    gtk_widget_show(image_list);
  gtk_widget_show(image_display);
  ee_conf_set_options();
  while (gtk_events_pending())
    gtk_main_iteration();
  ee_conf_set_options();

  configure_drop_on_widget(image_list, image_list->window);
  a =  (GtkWidget *)gtk_object_get_data(GTK_OBJECT(image_display), "view");
  if (a)
    {
      configure_drop_on_widget(image_display, a->window);
      configure_drag_on_widget(image_display, a->window);
    }
  gtk_main();
  return 0;
}
