////////////////////////////////////////////////////////
//
// GEM - Graphics Environment for Multimedia
//
// mdanks@cybermed.ucsd.edu
//
// Implementation file
//
//    Copyright (c) 1997-1998 Mark Danks.
//    For information on usage and redistribution, and for a DISCLAIMER OF ALL
//    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.
//
/////////////////////////////////////////////////////////

#include "text2d.h"

#include "FTFace.h"
#include "GLTTBitmapFont.h"

CPPEXTERN_NEW_WITH_GIMME(text2d)

/////////////////////////////////////////////////////////
//
// text2d
//
/////////////////////////////////////////////////////////
// Constructor
//
/////////////////////////////////////////////////////////
text2d :: text2d(int argc, t_atom *argv)
	    : TextBase(argc, argv), m_font(NULL), m_face(NULL)
{
	fontNameMess(DEFAULT_FONT);
}

/////////////////////////////////////////////////////////
// Destructor
//
/////////////////////////////////////////////////////////
text2d :: ~text2d()
{
    delete m_font;
	delete m_face;
}

/////////////////////////////////////////////////////////
// setFontSize
//
/////////////////////////////////////////////////////////
void text2d :: setFontSize(int size)
{
	m_fontSize = size;

	m_valid = makeFontFromFace();
	setModified();
}

/////////////////////////////////////////////////////////
// fontNameMess
//
/////////////////////////////////////////////////////////
void text2d :: fontNameMess(const char *filename)
{
	m_valid = 0;
	delete m_font;
	m_font = NULL;
	delete m_face;
	m_face = new FTFace;
    char buf[MAXPDSTRING];
    canvas_makefilename(getCanvas(), (char *)filename, buf, MAXPDSTRING);

	if( ! m_face->open(buf) )
	{
		error("GEM: text2d: unable to open font: %s", buf);
		return;
	}
	m_valid = makeFontFromFace();
    setModified();
}

/////////////////////////////////////////////////////////
// makeFontFromFace
//
/////////////////////////////////////////////////////////
int text2d :: makeFontFromFace()
{
	if (!m_face)
	{
		error("GEM: text2d: True type font doesn't exist");
		return(0);
	}

	delete m_font;
	m_font = new GLTTBitmapFont(m_face);
	if( ! m_font->create(m_fontSize) )
	{
		post("GEM: text2d: unable to create bitmap'ed font");
		return(0);
	}
	return(1);
}

/////////////////////////////////////////////////////////
// render
//
/////////////////////////////////////////////////////////
void text2d :: render(GemState *)
{
	if (m_valid)
	{
		// compute the offset due to the justification
		int width = 0;
		if (m_widthJus == LEFT)
			width = 0;
		else if (m_widthJus == RIGHT)
			width = m_font->getWidth(m_theString);
		else if (m_widthJus == CENTER)
			width = m_font->getWidth(m_theString) / 2;

		int height = 0;
		if (m_heightJus == BOTTOM)
			height = 0;
		else if (m_heightJus == TOP)
			height = m_font->getHeight();
		else if (m_heightJus == MIDDLE)
			height = m_font->getHeight() / 2;

		m_font->output(0, 0, m_theString);
	}
}

/////////////////////////////////////////////////////////
// static member function
//
/////////////////////////////////////////////////////////
void text2d :: obj_setupCallback(t_class *)
{ }
